/*******************************  LICENSE  *******************************


 Copyright 2007 European Centre for Medium-Range Weather Forecasts (ECMWF)
 
 Licensed under the Apache License, Version 2.0 (the "License"); 
 you may not use this file except in compliance with the License. 
 You may obtain a copy of the License at 
 
 	http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software 
 distributed under the License is distributed on an "AS IS" BASIS, 
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 See the License for the specific language governing permissions and 
 limitations under the License.


 *******************************  LICENSE  *******************************/

/*! \file FortranRootSceneNodeAttributes.h
    \brief Definition of FortranRootSceneNode Attributes class.
    \author Graphics Section, ECMWF

    This file is automatically generated.
    Do Not Edit!

    Generated: Thu Jun 16 12:02:57 2011
*/
   

#ifndef FortranRootSceneNodeAttributes_H
#define FortranRootSceneNodeAttributes_H

#include "magics.h"
#include "ParameterManager.h"
#include "Factory.h"


#include "Colour.h"

namespace magics {

class XmlNode;



class FortranRootSceneNodeAttributes 
{
public:
//  --  constructor
    FortranRootSceneNodeAttributes();
    
//  --  destructor
    virtual ~FortranRootSceneNodeAttributes();
    
    virtual void set(const std::map<string, string>&);
    virtual void set(const XmlNode&);
    virtual void copy(const FortranRootSceneNodeAttributes&);
    virtual bool accept(const string&);

    void setTag(const string& tag) { tag_ = tag; }

    void setXmlData(const string&)  {}
/*!
    Magics Information:
    \brief  Horizontal length of super page 
    \param width Setting super_page_x_length - default=29.7
*/
	void setWidth(double width) 
		{ width_ =  width; } 
	double getWidth() const 
		{ return width_; } 
        
/*!
    Magics Information:
    \brief  Vertical length of super page 
    \param height Setting super_page_y_length - default=21.0
*/
	void setHeight(double height) 
		{ height_ =  height; } 
	double getHeight() const 
		{ return height_; } 
        
/*!
    Magics Information:
    \brief  Plot frame around super page (ON/OFF) 
    \param frame Setting super_page_frame - default=off
*/
	void setFrame(bool frame) 
		{ frame_ =  frame; } 
	bool getFrame() const 
		{ return frame_; } 
        
/*!
    Magics Information:
    \brief  Colour of super page frame 
    \param colour Setting super_page_frame_colour - default=blue
*/
	void setColour(Colour* colour) 
		{ auto_ptr<Colour> tmp(colour); colour_ = tmp; } 
	const Colour&  getColour() const 
		{ return *colour_; }
/*!
    Magics Information:
    \brief  Style of super page frame (SOLID/DASH/DOT/CHAIN_DASH/CHAIN_DOT) 
    \param style Setting super_page_frame_line_style - default=solid
*/
	void setStyle(LineStyle style) 
		{ style_ =  style; } 
	LineStyle getStyle() const 
		{ return style_; } 
        
/*!
    Magics Information:
    \brief  Thickness of super page frame 
    \param thickness Setting super_page_frame_thickness - default=1
*/
	void setThickness(int thickness) 
		{ thickness_ =  thickness; } 
	int getThickness() const 
		{ return thickness_; } 
        
/*!
    Magics Information:
    \brief  Type of page layout (POSITIONAL/AUTOMATIC) 
    \param plot_layout Setting layout - default=automatic
*/
	void setPlot_layout(string plot_layout) 
		{ plot_layout_ =  plot_layout; } 
	string getPlot_layout() const 
		{ return plot_layout_; } 
        
/*!
    Magics Information:
    \brief  Position of first page plotted (BOTTOM/TOP) 
    \param plot_start Setting plot_start - default=bottom
*/
	void setPlot_start(string plot_start) 
		{ plot_start_ =  plot_start; } 
	string getPlot_start() const 
		{ return plot_start_; } 
        
/*!
    Magics Information:
    \brief  Direction of plotting (HORIZONTAL/VERTICAL) 
    \param plot_direction Setting plot_direction - default=vertical
*/
	void setPlot_direction(string plot_direction) 
		{ plot_direction_ =  plot_direction; } 
	string getPlot_direction() const 
		{ return plot_direction_; } 
        
/*!
    Magics Information:
    \brief  turn on/off the legend 
    \param legend Setting legend - default=off
*/
	void setLegend(bool legend) 
		{ legend_ =  legend; } 
	bool getLegend() const 
		{ return legend_; } 
        
	virtual void toxml(ostream& out, int tabs = 0) const { toxml(out, tag_, tabs); }

protected:
	//  --  method
	virtual void print(ostream&) const;
	virtual void toxml(ostream&, const string&, int tabs) const;

	//  --  members:
	string tag_;
	double width_;
	double height_;
	bool frame_;
	auto_ptr<Colour> colour_;
	LineStyle style_;
	int thickness_;
	string plot_layout_;
	string plot_start_;
	string plot_direction_;
	bool legend_;

private:
  
	friend ostream& operator<<(ostream& s,const FortranRootSceneNodeAttributes& p)
	{ p.print(s); return s; }
};

} // namespace magics

#endif
