'\" t
.\" Manual page created with latex2man on Thu Aug  5 10:00:52 CEST 2004
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_SET\\_REG" "3" "05 August 2004" "Programming Library " "Programming Library "
.SH NAME
unw_set_reg
\-\- set register contents 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_set_reg(unw_cursor_t *cp,
unw_regnum_t
reg,
unw_word_t
val);
.br
.PP
.SH DESCRIPTION

.PP
The unw_set_reg()
routine sets the value of register 
reg
in the stack frame identified by cursor cp
to the 
value passed in val\&.
.PP
The register numbering is target\-dependent and described in separate 
manual pages (e.g., libunwind\-ia64(3) for the IA\-64 target). 
Furthermore, the exact set of accessible registers may depend on the 
type of frame that cp
is referring to. For ordinary stack 
frames, it is normally possible to access only the preserved 
(``callee\-saved\&'') registers and frame\-related registers (such as the 
stack\-pointer). However, for signal frames (see 
unw_is_signal_frame(3)),
it is usually possible to access 
all registers. 
.PP
Note that unw_set_reg()
can only write the contents of 
registers whose values fit in a single word. See 
unw_set_fpreg(3)
for a way to write registers which do not 
fit this constraint. 
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_set_reg()
returns 0. 
Otherwise the negative value of one of the error\-codes below is 
returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_set_reg()
is thread\-safe as well as safe to use 
from a signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_EUNSPEC
 An unspecified error occurred. 
.TP
UNW_EBADREG
 An attempt was made to write a register 
that is either invalid or not accessible in the current frame. 
.TP
UNW_EREADONLY
 An attempt was made to write to a 
read\-only register. 
.PP
In addition, unw_set_reg()
may return any error returned by 
the access_mem(),
access_reg(),
and 
access_fpreg()
call\-backs (see 
unw_create_addr_space(3)).
.PP
.SH SEE ALSO

.PP
libunwind(3),
libunwind\-ia64(3),
unw_get_reg(3),
unw_is_signal_frame(3),
unw_set_fpreg(3)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br 
Hewlett\-Packard Labs
.br 
Palo\-Alto, CA 94304
.br 
Email: \fBdavidm@hpl.hp.com\fP
.br
WWW: \fBhttp://www.hpl.hp.com/research/linux/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
