/*
 * libSpiff - XSPF playlist handling library
 *
 * Copyright (C) 2007, Sebastian Pipping / Xiph.Org Foundation
 * All rights reserved.
 *
 * Redistribution  and use in source and binary forms, with or without
 * modification,  are permitted provided that the following conditions
 * are met:
 *
 *     * Redistributions   of  source  code  must  retain  the   above
 *       copyright  notice, this list of conditions and the  following
 *       disclaimer.
 *
 *     * Redistributions  in  binary  form must  reproduce  the  above
 *       copyright  notice, this list of conditions and the  following
 *       disclaimer   in  the  documentation  and/or  other  materials
 *       provided with the distribution.
 *
 *     * Neither  the name of the Xiph.Org Foundation nor the names of
 *       its  contributors may be used to endorse or promote  products
 *       derived  from  this software without specific  prior  written
 *       permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS  IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT  NOT
 * LIMITED  TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS
 * FOR  A  PARTICULAR  PURPOSE ARE DISCLAIMED. IN NO EVENT  SHALL  THE
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,    SPECIAL,   EXEMPLARY,   OR   CONSEQUENTIAL   DAMAGES
 * (INCLUDING,  BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES;  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT  LIABILITY,  OR  TORT (INCLUDING  NEGLIGENCE  OR  OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Sebastian Pipping, sping@xiph.org
 */

#include <spiff/Spiff.h>
#include <iostream>
using namespace Spiff;
using namespace std;



class VersionExtractor : public SpiffReaderCallback {

private:
	int version;

public:
	VersionExtractor() : version(-1) {

	}

	int getVersion() {
		return this->version;
	}

private:
	void setProps(SpiffProps * props) {
		this->version = props->getVersion();
		delete props;
	}

};



int printUsage() {
	cout << "USAGE: spiff_check (-|--version)" << endl << flush;
	return 1;
}



int printVersion() {
	cout << "spiff_check "
			<< SPIFF_VER_MAJOR << "."
			<< SPIFF_VER_MINOR << "."
			<< SPIFF_VER_RELEASE
			<< SPIFF_VER_SUFFIX
			<< endl << flush;
	return 0;
}



int checkStdin() {
	// Read until EOF
	stringbuf buffer;
	for (;;) {
		const char c = cin.get();
		if (c == -1) {
			break;
		}
		buffer.sputc(c);
	}

	// Convert to byte array
	const string input = buffer.str();
	const char * memory = input.c_str();
	const int numBytes = static_cast<int>(strlen(memory));

	// Valid XSPF?
	SpiffReader reader;
	VersionExtractor versionExtractor;
	const int res = reader.parseMemory(memory, numBytes, &versionExtractor);
	if (res != SPIFF_READER_SUCCESS) {
		cout << "Error " << res
				<< " at line " << reader.getErrorLine()
				<< ": '" << reader.getErrorText() << "'"
				<< endl << flush;
		return 1;
	} else {
		cout << "Valid XSPF-" << versionExtractor.getVersion() << "."
				<< endl << flush;
		return 0;
	}
}



int main(int argc, char ** argv) {
	switch (argc) {
	case 2:
		if (argv[1][0] != '-') {
			// Invalid parameter
			return printUsage();
		}

		if (argv[1][1] == '\0') {
			return checkStdin();
		} else if (!strcmp(argv[1] + 1, "-version")) {
			return printVersion();
		}
		return printUsage();

	case 1: // No params
	default:
		return printUsage();

	}
}
