/* This is an example of the console code for SDL
 * Garrett Banuk (mongoose@mongeese.org)
 */

#ifdef GL_DEMO
#include <GL/glut.h>
#endif /* GL_DEMO */

#include <stdlib.h>
#include <string.h>
#include "SDL.h"
#include "CON_console.h"
#include "DT_drawtext.h"
#include "ConsoleExample.h"


int MainProgram = 1;
int TextDemo = 0;
int LargeFont;



#define CONSOLE_N 3
ConsoleInformation *Consoles[CONSOLE_N];/* Pointers to all the consoles */
int ConsoleDisplay[CONSOLE_N];		/* Bools telling if the console is displayed */


int main(int argc, char **argv)
{
	SDL_Surface *Screen;
	int ticks = 0, oldticks = 0;
	int i;
	char framerate[30];
	SDL_Rect Con_rect;



	/* init the graphics */
	if(Init(&Screen, argc, argv))
		return 1;


	/* Init the consoles */
	Con_rect.x = Con_rect.y = 0;
	Con_rect.w = Con_rect.h = 300;
	if((Consoles[0] = CON_Init("ConsoleFont.png", Screen, 100, Con_rect)) == NULL)
		return 1;

	Con_rect.x = 350;
	Con_rect.y = 20;
	Con_rect.w = Con_rect.h = 200;
	if((Consoles[1] = CON_Init("ConsoleFont.png", Screen, 100, Con_rect)) == NULL)
		return 1;

	Con_rect.x = 340;
	Con_rect.y = 280;
	Con_rect.w = 300;
	Con_rect.h = 200;
	if((Consoles[2] = CON_Init("ConsoleFont.png", Screen, 100, Con_rect)) == NULL)
		return 1;


	/* Add some commands to the console */
	CON_AddCommand(&KillProgram, "quit");
	CON_AddCommand(&Echo, "echo");
	CON_AddCommand(&DrawTextDemo, "drawtextdemo");
	CON_AddCommand(&AlphaChange, "alpha");
	CON_AddCommand(&AddBackground, "background");
	CON_AddCommand(&Move, "move");
	CON_AddCommand(&Resize, "resize");
	CON_AddCommand(&ListCommands, "listcommands");
	CON_AddCommand(&SetPrompt, "prompt");

	CON_ListCommands(Consoles[0]);

	/* Heres another font for the text demo */
	LargeFont = DT_LoadFont("LargeFont.png", 0);

	/* Main execution loop */
	while(MainProgram)
	{
		ProcessEvents();

		/* wipe the screen clean with a blue fill and draw the console if its down */
#ifdef GL_DEMO
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		glMatrixMode(GL_MODELVIEW);
		glLoadIdentity();
		glTranslatef(0.0, 0.0, -5.0);
		glutSolidTeapot(2.0);
		glFlush();
#else
		SDL_FillRect(Screen, NULL, 255);
#endif /* GL_DEMO */

		if(TextDemo)
			RandText(Screen);

		for(i=0; i<CONSOLE_N; i++)
			if(ConsoleDisplay[i]) CON_DrawConsole(Consoles[i]);

		/* print the framerate */
		oldticks = ticks;
		ticks = SDL_GetTicks();
		sprintf(framerate, "%.2f FPS", 1000.0 / (ticks - oldticks));
		DT_DrawText(framerate, Screen, 1, 1, Screen->h - 40);

#ifdef GL_DEMO
		SDL_GL_SwapBuffers();
#else
		SDL_Flip(Screen);
#endif /* GL_DEMO */
	}

	for(i=0; i<CONSOLE_N; i++)
		CON_Destroy(Consoles[i]);

	return 0;
}

#ifdef GL_DEMO
/* SETUP_OPENGL -- initializes assorted OpenGL parameters */
void setup_opengl(int width, int height)
{
	float ratio = (float)width / (float)height;
	/* lighting init */
	GLfloat mat_diffuse[] = { 0.9, 0.9, 0.0, 1.0 };
	GLfloat mat_specular[] = { 1.0, 1.0, 1.0, 1.0 };
	GLfloat mat_shininess[] = { 50.0 };
	GLfloat light_position[] = { 1.0, 0.0, 5.0, 0.0 };
	GLfloat white_light[] = { 1.0, 1.0, 1.0, 1.0 };

	glMaterialfv(GL_FRONT, GL_DIFFUSE, mat_diffuse);
	glMaterialfv(GL_FRONT, GL_SPECULAR, mat_specular);
	glMaterialfv(GL_FRONT, GL_SHININESS, mat_shininess);
	glLightfv(GL_LIGHT0, GL_POSITION, light_position);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, white_light);
	glLightfv(GL_LIGHT0, GL_SPECULAR, white_light);

	glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_DEPTH_TEST);

	/* Set the clear color. */
	glClearColor(0.0, 0.0, 1.0, 1.0);

	/* Setup our viewport. */
	glViewport(0, 0, width, height);

	/* Change to the projection matrix and set our viewing volume. */
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(60.0, ratio, 1.0, 1024.0);
}
#endif /* GL_DEMO */

/* Initialise the graphics */
int Init(SDL_Surface **Screen, int argc, char **argv)
{
#ifdef GL_DEMO
	int SetVideoFlags = SDL_HWSURFACE | SDL_ASYNCBLIT | SDL_OPENGLBLIT;
	int width = 640, height = 480, depth = 24;
#else
	int SetVideoFlags = SDL_HWSURFACE | SDL_DOUBLEBUF;
	int width = 640, height = 480, depth = 16;
#endif /* GL_DEMO */
	int loop;

	for(loop = 1; loop < argc; loop++)
	{
		if(strcmp(argv[loop], "-fullscreen") == 0)
			SetVideoFlags |= SDL_FULLSCREEN;
		else if(strcmp(argv[loop], "-width") == 0)
			width = atoi(argv[++loop]);
		else if(strcmp(argv[loop], "-height") == 0)
			height = atoi(argv[++loop]);
		else if(strcmp(argv[loop], "-bpp") == 0)
			depth = atoi(argv[++loop]);
		else if(strcmp(argv[loop], "-sw") == 0)
			SetVideoFlags |= SDL_SWSURFACE;

	}

	if(SDL_Init(SDL_INIT_VIDEO) < 0)
	{
		fprintf(stderr, "*Error* Couldn't initialize SDL: %s\n", SDL_GetError());
		return 1;
	}

#ifdef GL_DEMO
	SDL_GL_SetAttribute(SDL_GL_RED_SIZE, 5);
	SDL_GL_SetAttribute(SDL_GL_GREEN_SIZE, 6);
	SDL_GL_SetAttribute(SDL_GL_BLUE_SIZE, 5);
	SDL_GL_SetAttribute(SDL_GL_DEPTH_SIZE, 16);
	SDL_GL_SetAttribute(SDL_GL_DOUBLEBUFFER, 1);
#endif /* GL_DEMO */

	if((*Screen = SDL_SetVideoMode(width, height, depth, SetVideoFlags)) == NULL)
	{
		fprintf(stderr, "*Error* Couldn't set %dx%dx%d video mode: %s\n", width, height, depth, SDL_GetError());
		SDL_Quit();
		return 1;
	}

#ifdef GL_DEMO
	setup_opengl(width, height);
#endif /* GL_DEMO */

	atexit(SDL_Quit);
	return 0;
}


/* Processes all the incoming events 
 */
void ProcessEvents()
{
	SDL_Event	event;
	static int	console_events = 0; /* True if the console can take the events */


	while(SDL_PollEvent(&event))
	{
		switch(event.type)
		{
			case SDL_KEYDOWN:
				switch(event.key.keysym.sym)
				{
					case SDLK_1:
					case SDLK_2:
					case SDLK_3:
					case SDLK_4:
						if(event.key.keysym.mod & KMOD_CTRL)
						{
							if(ConsoleDisplay[event.key.keysym.sym - SDLK_1])
								ConsoleDisplay[event.key.keysym.sym - SDLK_1] = 0;
							else
								ConsoleDisplay[event.key.keysym.sym - SDLK_1] = 1;
							break;
						}
						else if(event.key.keysym.mod & KMOD_ALT)
						{
							if((event.key.keysym.sym - SDLK_1) == CONSOLE_N)
							{
								CON_Topmost(NULL);
								console_events = 0;
								SDL_EnableUNICODE(0);
								SDL_EnableKeyRepeat(0,0);
							}
							else
							{
								CON_Topmost(Consoles[event.key.keysym.sym - SDLK_1]);
								console_events = 1;
								SDL_EnableUNICODE(1);
								SDL_EnableKeyRepeat(250,30);
							}
							break;
						}
					default:
						/* Send the event to the console */
						if(console_events)
							CON_Events(&event);
						break;
				}
				break;
			case SDL_QUIT:
				MainProgram = 0;
				break;
			default:
				break;
		}
	}
}

/* call this to end the main loop */
void KillProgram(ConsoleInformation *console, char *String)
{
	MainProgram = 0;
}

/* Prints the string you pass it into the console */
void Echo(ConsoleInformation *console, char *String)
{
	CON_Out(console, "%s", String);
}

/* This function toggles the draw text demo */
void DrawTextDemo(ConsoleInformation *console, char *String)
{
	if(TextDemo == 0)
		TextDemo = 1;
	else
		TextDemo = 0;
}

/* This function demonstrates the text drawing routines that
 * come with this console */
void RandText(SDL_Surface *Screen)
{
	DT_DrawText("This is an example of the DrawText routine", Screen, 0, 40, Screen->h - 20);
	DT_DrawText("This is an example of the DrawText routine", Screen, 0, 100, 300);
	DT_DrawText("This is an example of the DrawText routine", Screen, 0, 200, 400);
	DT_DrawText("This is an example of the DrawText routine", Screen, 0, 20, 20);
	DT_DrawText("This is an example of the DrawText routine", Screen, 0, 0, 0);
	DT_DrawText("This is an example of the DrawText routine", Screen, 0, 300, 5);
	DT_DrawText("This is an example of the DrawText routine", Screen, 0, 600, 90);

	/* Now show the large font */
	if(-1 != LargeFont)
	{
		DT_DrawText("Heres a large font (non-transparent)", Screen, LargeFont, 50, 60);
		DT_DrawText("Heres a large font (non-transparent)", Screen, LargeFont, 0, 170);
	}
}

/* lets the user change the alpha level */
void AlphaChange(ConsoleInformation *console, char *alpha)
{
	CON_Alpha(console, atoi(alpha));
	CON_Out(console, "Alpha set to %s.", alpha);
}


/* Adds a background image */
void AddBackground(ConsoleInformation *console, char *string)
{
	int x, y;


	if(2 != sscanf(string, "%d %d", &x, &y))
	{
		x = 0;
		y = 0;
	}

	if(x == -1 || y == -1)
		CON_Background(console, NULL, 0, 0);
	else
		CON_Background(console, "background.jpg", x, y);
}

/* Move the console, takes and x and a y */
void Move(ConsoleInformation *console, char *string)
{
	int x, y;


	if(2 != sscanf(string, "%d %d", &x, &y))
	{
		x = 0;
		y = 0;
	}

	CON_Position(console, x, y);
}

/* resizes the console window, takes and x and y, and a width and height */
void Resize(ConsoleInformation *console, char *string)
{
	int x, y, w, h;

	SDL_Rect rect;
	if(4 != sscanf(string, "%d %d %d %d", &x, &y, &w, &h))
	{
		CON_Out(console, "Usage: X Y Width Height");
		return;
	}
	rect.x = x;
	rect.y = y;
	rect.w = w;
	rect.h = h;
	CON_Resize(console, rect);

}

/* Lists all the commands. */
void ListCommands(ConsoleInformation *console, char *string)
{
	CON_ListCommands(console);
}

void SetPrompt(ConsoleInformation *console, char *string) {
    CON_SetPrompt(console, string);
}
