/* toAroundKing8Filte.h
 */
#ifndef _MOVE_TO_AROUND_KING8_FILTER_H
#define _MOVE_TO_AROUND_KING8_FILTER_H
#include "osl/square.h"
#include "osl/player.h"
#include "osl/ptype.h"
#include "osl/move_action/concept.h"
#include "osl/move_classifier/kingOpenMove.h"
#include "osl/centering3x3.h"

namespace osl
{
  namespace move_action
  {
    
    /**
     * 自玉の 8近傍への手
     * - includes the square where the King is, should rename to 9?
     * - if the king is on the edge, the area is centered.
     */
    template<Player P,class OrigAction>
    struct ToAroundKing8Filter : public MoveAction
    {
      BOOST_CLASS_REQUIRE(OrigAction,osl::move_action,Concept);
      const NumEffectState& state;
      OrigAction & action;
      Square position_king;

    public:
      ToAroundKing8Filter(const NumEffectState& s, OrigAction & action)
	:
	state(s), action(action),
	position_king(Centering3x3::adjustCenter(s.template kingSquare<P>()))
      {
      }

      bool isToAroundKing8Move(Square to)
      {
	return to == position_king ||
	  to + Board_Table.getOffsetForBlack(UL)== position_king ||
	  to + Board_Table.getOffsetForBlack(U)== position_king ||
	  to + Board_Table.getOffsetForBlack(UR)== position_king ||
	  to + Board_Table.getOffsetForBlack(L)== position_king ||
	  to + Board_Table.getOffsetForBlack(R)== position_king ||
	  to + Board_Table.getOffsetForBlack(DL)== position_king ||
	  to + Board_Table.getOffsetForBlack(D)== position_king ||
	  to + Board_Table.getOffsetForBlack(DR)== position_king;
      }
      void simpleMove(Square from,Square to,Ptype ptype, bool isPromote,Player p,Move m){
	assert(p == P);
	if(isToAroundKing8Move(to))
	  action.simpleMove(from,to,ptype,isPromote,P,m);
      
      }
      void unknownMove(Square from,Square to,Piece p1,Ptype ptype,bool isPromote,Player p,Move m){
	assert(p == P);
	if(isToAroundKing8Move(to))
	  action.unknownMove(from,to,p1,ptype,isPromote,P,m);
      }
      /**
       * dropMoveが自殺手になることはない
       */
      void dropMove(Square to,Ptype ptype,Player p,Move m){
	assert(p == P);
	if(isToAroundKing8Move(to))
	  action.dropMove(to,ptype,P,m);
      }
      // old interfaces
      void simpleMove(Square from,Square to,Ptype ptype, 
		      bool isPromote,Player p)
      {
	simpleMove(from,to,ptype,isPromote,p,
		   Move(from,to,ptype,PTYPE_EMPTY,isPromote,p));
      }
      void unknownMove(Square from,Square to,Piece captured,
		       Ptype ptype,bool isPromote,Player p)
      {
	unknownMove(from,to,captured,ptype,isPromote,p,
		    Move(from,to,ptype,captured.ptype(),isPromote,p));
      }
      void dropMove(Square to,Ptype ptype,Player p)
      {
	dropMove(to,ptype,p,
		 Move(to,ptype,p));
      }
    };
  } // namespace move_action
} // namespace osl

#endif /* _MOVE_TO_AROUND_KING8_FILTER_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
