/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.serialize;

import java.io.IOException;
import org.apache.xalan.serialize.CharInfo;
import org.apache.xalan.serialize.SerializerToXML;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SerializerToText
extends SerializerToXML {
    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        this.flushWriter();
    }

    public void startElement(String namespaceURI, String localName, String name, Attributes atts) throws SAXException {
    }

    public void endElement(String namespaceURI, String localName, String name) throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeNormalizedChars(ch, start, length, false);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        this.flushWriter();
    }

    public void charactersRaw(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeNormalizedChars(ch, start, length, false);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        this.flushWriter();
    }

    protected int writeUTF16Surrogate(char c, char[] ch, int i, int end) throws IOException, SAXException {
        int surrogateValue = this.getURF16SurrogateValue(c, ch, i, end);
        this.m_writer.write(surrogateValue);
        return ++i;
    }

    void writeNormalizedChars(char[] ch, int start, int length, boolean isCData) throws IOException, SAXException {
        int end = start + length;
        int i = start;
        while (i < end) {
            char c = ch[i];
            if (CharInfo.S_LINEFEED == c) {
                this.m_writer.write(this.m_lineSep, 0, this.m_lineSepLen);
            } else if (isCData && c > this.m_maxCharacter) {
                if (i != 0) {
                    this.m_writer.write("]]>");
                }
                if (SerializerToXML.isUTF16Surrogate(c)) {
                    i = this.writeUTF16Surrogate(c, ch, i, end);
                } else {
                    this.m_writer.write(c);
                }
                if (i != 0 && i < end - 1) {
                    this.m_writer.write("<![CDATA[");
                }
            } else if (isCData && i < end - 2 && ']' == c && ']' == ch[i + 1] && '>' == ch[i + 2]) {
                this.m_writer.write("]]]]><![CDATA[>");
                i += 2;
            } else if (c <= this.m_maxCharacter) {
                this.m_writer.write(c);
            } else if (SerializerToXML.isUTF16Surrogate(c)) {
                i = this.writeUTF16Surrogate(c, ch, i, end);
            } else {
                this.m_writer.write(c);
            }
            ++i;
        }
    }

    public void cdata(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeNormalizedChars(ch, start, length, false);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        this.flushWriter();
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        try {
            this.writeNormalizedChars(ch, start, length, false);
        }
        catch (IOException ioe) {
            throw new SAXException(ioe);
        }
        this.flushWriter();
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void comment(String data) throws SAXException {
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public void entityReference(String name) throws SAXException {
    }
}

