/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.BooleanList;

public class BooleanListTests
extends TestCase {
    static /* synthetic */ Class class$org$jfree$util$junit$BooleanListTests;

    public BooleanListTests(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$jfree$util$junit$BooleanListTests != null ? class$org$jfree$util$junit$BooleanListTests : (class$org$jfree$util$junit$BooleanListTests = BooleanListTests.class$("org.jfree.util.junit.BooleanListTests")));
    }

    public void testCloning() {
        BooleanList l1 = new BooleanList();
        l1.setBoolean(0, Boolean.TRUE);
        l1.setBoolean(1, Boolean.FALSE);
        l1.setBoolean(2, null);
        BooleanList l2 = null;
        try {
            l2 = (BooleanList)l1.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("BooleanListTests.testCloning: failed to clone.");
        }
        Assert.assertTrue((l1 != l2 ? 1 : 0) != 0);
        Assert.assertTrue((l1.getClass() == l2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)l1.equals(l2));
        l2.setBoolean(0, Boolean.FALSE);
        Assert.assertFalse((boolean)l1.equals(l2));
    }

    public void testEquals() {
        BooleanList l1 = new BooleanList();
        l1.setBoolean(0, Boolean.TRUE);
        l1.setBoolean(1, Boolean.FALSE);
        l1.setBoolean(2, null);
        BooleanList l2 = new BooleanList();
        l2.setBoolean(0, Boolean.TRUE);
        l2.setBoolean(1, Boolean.FALSE);
        l2.setBoolean(2, null);
        Assert.assertTrue((boolean)l1.equals(l2));
        Assert.assertTrue((boolean)l2.equals(l2));
    }

    public void testSerialization() {
        BooleanList l1 = new BooleanList();
        l1.setBoolean(0, Boolean.TRUE);
        l1.setBoolean(1, Boolean.FALSE);
        l1.setBoolean(2, null);
        BooleanList l2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(l1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            l2 = (BooleanList)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)l1, l2);
    }
}

