#ifndef __LIBJACKASYN_H__
#define __LIBJACKASYN_H__

#include <samplerate.h>

typedef struct _fifo {
  float* mem;
  int size;
  int maxsize;
  int readp;
  int writep;
  int framecount;
} fifo_t;


typedef struct _virdev {  
  jack_client_t* client;

  fifo_t  ofifo;
  fifo_t  ififo;

  int flags;
  char state;

  int ichans;
  int ochans;
  int jackrate;
  int rate;

  int fragnum;
  int fragsize;
  int adjustedfragsize;
  int underruns;

  jack_port_t*  in[48];
  jack_port_t*  out[48];

  pthread_mutex_t mutex;
  pthread_cond_t sem;
  SRC_STATE* converter[2];
  SRC_STATE* iconverter[2];
  int convert;
} virdev;

int fifo_empty(fifo_t* f);
int fifo_filled(fifo_t* f);
int fifo_setsize(fifo_t* f,int size);

virdev* virdev_connect(char* name,int i, int o);
int virdev_start(virdev* h);
void  virdev_reset(virdev* v);
int virdev_output16i(virdev* h,const char* buf,int len);
int virdev_input16i(virdev* h,char* buf,int len);
int virdev_shutdown(virdev* h);

#define JACK_INACTIVE 0
#define JACK_ACTIVE 1 

/*
 *  TODO: these should be really atomic for  SMP systems ...
 *  
 */ 

#define atomic_write(a,b) (a=b)
#define atomic_read(a) (a)


/*
 *   The native interface
 *
 */
typedef void* jackasyn_t;

jackasyn_t jackasyn_open(int iports, int oports);
int jackasyn_start(jackasyn_t h);
int jackasyn_stop(jackasyn_t h);

int jackasyn_outputs(jackasyn_t h,char* buf,int size);
int jackasyn_inputs(jackasyn_t h,char* buf,int size);
int jackasyn_outputf(jackasyn_t h,float* buf,int size);
int jackasyn_inputf(jackasyn_t h,float* buf,int size);

int jackasyn_close(jackasyn_t h);
extern int jack_running;
extern int debug;

#define DEBUGCOND debug
//#define DEBUGCOND 1


#ifdef WITH_DEBUG
#define DEBUG(x) if (DEBUGCOND) { x; }
#define DEBUGx(a,x) if (debug > a) { x; }
#else
#define DEBUG(x)
#define DEBUGx(a,x)
#endif

#endif
