/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: AbstractGroupMember.java,v 1.2 2006/02/26 00:59:04 pietschy Exp $
 */

package org.pietschy.command;

import javax.swing.*;
import java.awt.*;

/**
 * This class is used to manage the insertion of a single group member into a {@link java.awt.Container}.
 * @see GroupContainerManager
 */
public abstract class
AbstractGroupMember
implements GroupMember
{
   static final String _ID_ = "$Id: AbstractGroupMember.java,v 1.2 2006/02/26 00:59:04 pietschy Exp $";

   public void addSeparator(Container parent)
   {
      if (parent instanceof JMenu)
         ((JMenu) parent).addSeparator();
      else if (parent instanceof JPopupMenu)
         ((JPopupMenu) parent).addSeparator();
      else if (parent instanceof JToolBar)
         ((JToolBar) parent).addSeparator();
      else
         parent.add(new JSeparator());
   }

   public void addNotify(){};
   public void removeNotify(){};
}
