/*******************************************************************************************************************************************
 cfilechooserbutton.h
 
 CClass					CClass
 |--CSerialized				|--CSerialized
    |--CMetaModule			   |--CMetaModule
       |--CObject			      |--CObjectListener
          |--CComponent			         |
	     |--CControl		         |
	        |--CWidget		         |--CWidgetListener
		   |--CContainer	   	    |
		      |--CButton		    |--CButtonListener
			 |--CFileChooserButton	       |--CFileChooserButtonListener

 A button to launch a file selection dialog.
*******************************************************************************************************************************************/

#ifndef __CFILECHOOSERBUTTON_H__
#define __CFILECHOOSERBUTTON_H__

#include "cbutton.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// file chooser button xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <cfilechooserbutton>
//    ...
// </cfilechooserbutton>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_FILE_CHOOSER_BUTTON_ELEMENT		("cbutton");
static CString XML_FILE_CHOOSER_BUTTON_ATTR_		("");

//-----------------------------------------------------------------------------------------------------------------------------------------
// file chooser button listener
//-----------------------------------------------------------------------------------------------------------------------------------------
class CFileChooserButtonListener : public CButtonListener
{
	// instanciation section
	public :

		CFileChooserButtonListener		();
		virtual ~CFileChooserButtonListener	() =0;

	// specific listener api
	public :

		// metaclass assocation
		SECTION_GENERIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_GENERIC_METACLASS ('_fot', CFileChooserButtonListener, CButtonListener);

//-----------------------------------------------------------------------------------------------------------------------------------------
// file chooser button
//-----------------------------------------------------------------------------------------------------------------------------------------
class CFileChooserButton : public CButton
{
	// instanciation section
	public :
		
		CFileChooserButton			(CContainer *inOwner=NULL, const GtkFileChooserAction =GTK_FILE_CHOOSER_ACTION_OPEN,
							 const CFileChooserButtonListener *inListener=NULL);
		virtual ~CFileChooserButton		();

	// protected section
	protected :

		// gtk widget instanciation and initialization
		virtual GtkWidget *			PerformWidgetInstanciate	();
		virtual void				PerformWidgetInitialize		();

	// cobject redefinition
	protected :

		// expected CFileChooserButtonListener
		virtual const CMetaClass *		ListenerMustBe			() const;

	// cbutton redefinition
	public :

		// button associated dialog box title
		virtual void				SetCaption			(const CString &inCaption);
		virtual CString				GetCaption			() const;

	// file chooser button specifics
	public :





	// serialization
	public :

		// file chooser button xml serialization
		virtual void				Serialize			(CXMLElementNode *&ioXMLElementNode, 
											 const int inMode) THROWABLE;
	// protected section
	protected :

		// file chooser type
		GtkFileChooserAction			m_GtkFileChooserAction;

		// metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('fobn', CFileChooserButton, CButton);

#endif
