/*
 * @(#)IListAttributeUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.pmti.v1;

import java.util.Enumeration;
import net.sourceforge.groboutils.autodoc.v1.AutoDoc;
import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the IListAttribute interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @since     July 14, 2002
 * @version   $Date: 2003/02/10 22:52:01 $
 */
public class IListAttributeUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = IListAttributeUTestI.class;
    private static final AutoDoc DOC = new AutoDoc( THIS_CLASS );
    
    public IListAttributeUTestI( String name, ImplFactory f )
    {
        super( name, IListAttribute.class, f );
    }

    
    public IListAttribute createIListAttribute()
    {
        return (IListAttribute)createImplObject();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    
    public void testGetValues1()
    {
        IListAttribute la = createIListAttribute();
        Enumeration enum = la.getValues();
        assertNotNull(
            "Null enum.",
            enum );
    }
    
    
    public void testGetValues2()
    {
        IListAttribute la = createIListAttribute();
        Enumeration enum = la.getValues();
        int found = 0;
        for (; enum.hasMoreElements(); ++found)
        {
            Object o = enum.nextElement();
            /* can contain nulls!
            assertNotNull(
                "Element at index "+found+" is null.",
                o );
            */
        }
        assertEquals(
            "Number of returned elements does not match count.",
            found,
            la.getValueCount() );
    }
    
    
    public void testGetValueCount1()
    {
        IListAttribute la = createIListAttribute();
        int count = la.getValueCount();
        assertTrue(
            "Invalid value count ("+count+").",
            count >= 0 );
    }
    
    
    public void testContainsValue1()
    {
        IListAttribute la = createIListAttribute();
        Enumeration enum = la.getValues();
        while (enum.hasMoreElements())
        {
            Object o = enum.nextElement();
            assertTrue(
                "Does not contain value it returned in enumeration ("+o+").",
                la.containsValue( o ) );
        }
    }
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        suite.addInterfaceTestSuite( IAttributeUTestI.suite() );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

