/*
 * @(#)OutputXml.java
 *
 * Copyright (C) 2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.report;

import java.io.IOException;
import java.io.Writer;

import org.apache.tools.ant.util.DOMElementWriter;
import org.w3c.dom.Element;


/**
 * Writes the XML document to an output stream.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/04/15 05:48:26 $
 * @since     March 15, 2004
 */
public class OutputXml
{
    public static final String DEFAULT_ENCODING = "UTF-8";
    
    /**
     * Sends the XML document to <tt>out</tt> using the given module
     * and data set.
     *
     * @param rootEl the root element of the XML document.
     * @param out the output stream to send the XML document.
     *      The writer is not closed by this method.
     * @param encoding the output encoding of the given writer.  Defaults to
     *      UTF-8.
     * @return the root element generated.
     */
    public void write( Element rootEl, Writer out, String encoding )
            throws IOException
    {
        if (out == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        if (encoding == null)
        {
            encoding = DEFAULT_ENCODING;
        }
        
        out.write("<?xml version=\"1.0\" encoding=\""+encoding+"\" ?>\n");
        (new DOMElementWriter()).write(rootEl, out, 0, "  ");
        out.flush();
    }
}

