/**
 * @file libgalago-gtk/galago-gtk-account-combo-box.h Account ComboBox widget.
 *
 * @Copyright (C) 2004-2006 Christian Hammond.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _GALAGO_GTK_ACCOUNT_COMBO_BOX_H_
#define _GALAGO_GTK_ACCOUNT_COMBO_BOX_H_

#include <gtk/gtk.h>

typedef struct _GalagoGtkAccountComboBox      GalagoGtkAccountComboBox;
typedef struct _GalagoGtkAccountComboBoxClass GalagoGtkAccountComboBoxClass;
typedef struct _GalagoGtkAccountComboBoxPriv  GalagoGtkAccountComboBoxPriv;

#include <libgalago/galago.h>

#include <libgalago-gtk/galago-gtk-service-combo-box.h>

#define GALAGO_GTK_TYPE_ACCOUNT_COMBO_BOX (galago_gtk_account_combo_box_get_type())
#define GALAGO_GTK_ACCOUNT_COMBO_BOX(obj) \
		(G_TYPE_CHECK_INSTANCE_CAST((obj), GALAGO_GTK_TYPE_ACCOUNT_COMBO_BOX, GalagoGtkAccountComboBox))
#define GALAGO_GTK_ACCOUNT_COMBO_BOX_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_CAST((klass), GALAGO_GTK_TYPE_ACCOUNT_COMBO_BOX, GalagoGtkAccountComboBoxClass))
#define GALAGO_GTK_IS_ACCOUNT_COMBO_BOX(obj) \
		(G_TYPE_CHECK_INSTANCE_TYPE((obj), GALAGO_GTK_TYPE_ACCOUNT_COMBO_BOX))
#define GALAGO_GTK_IS_ACCOUNT_COMBO_BOX_CLASS(klass) \
		(G_TYPE_CHECK_CLASS_TYPE((klass), GALAGO_GTK_TYPE_ACCOUNT_COMBO_BOX))
#define GALAGO_GTK_ACCOUNT_COMBO_BOX_GET_CLASS(obj) \
		(G_TYPE_INSTANCE_GET_CLASS ((obj), GALAGO_GTK_TYPE_ACCOUNT_COMBO_BOX, GalagoGtkAccountComboBoxClass))

struct _GalagoGtkAccountComboBox
{
	GtkComboBox parent_object;

	GalagoGtkAccountComboBoxPriv *priv;

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

struct _GalagoGtkAccountComboBoxClass
{
	GtkComboBoxClass parent_class;

	/* Signals */
	void (*account_changed)(GalagoGtkAccountComboBox *combobox,
							GalagoAccount *account);

	void (*gtk_reserved1)(void);
	void (*gtk_reserved2)(void);
	void (*gtk_reserved3)(void);
	void (*gtk_reserved4)(void);
};

G_BEGIN_DECLS

GType galago_gtk_account_combo_box_get_type(void);

GtkWidget *galago_gtk_account_combo_box_new(gboolean me_accounts);

void galago_gtk_account_combo_box_set_person(
	GalagoGtkAccountComboBox *combobox, GalagoPerson *person);
GalagoPerson *galago_gtk_account_combo_box_get_person(
	const GalagoGtkAccountComboBox *combobox);
void galago_gtk_account_combo_box_set_service(
	GalagoGtkAccountComboBox *combobox, GalagoService *service);
GalagoService *galago_gtk_account_combo_box_get_service(
	const GalagoGtkAccountComboBox *combobox);

void galago_gtk_account_combo_box_set_account(
	GalagoGtkAccountComboBox *combobox, const GalagoAccount *account);
GalagoAccount *galago_gtk_account_combo_box_get_account(
	const GalagoGtkAccountComboBox *combobox);

void galago_gtk_account_combo_box_set_services_combo_box(
	GalagoGtkAccountComboBox *combobox, GtkWidget *service_combobox);
GtkWidget *galago_gtk_account_combo_box_get_services_combo_box(
	const GalagoGtkAccountComboBox *combobox);

G_END_DECLS

#endif /* _GALAGO_GTK_ACCOUNT_COMBO_BOX_H_ */
