/*  mkter.unx
    Copyright (C) Dr. Claudia Neumann

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU General Public License
  along with this software; see the file COPYING.   If not, write to
  the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
  Boston, MA 02111-1307 USA (or visit the web site http://www.gnu.org/).
 
   Contact: Dr. Claudia Neumann
                 Herderstr. 7
                 D - 26169 Friesoythe

                 dr. claudia.neumann@gmx.de

   This is a program to eliminate the card data on a mobil card reader on
   the serial port. 

   See documentations under http://www.kbv.de/ita/register_G.html and 
   http://www.gematik.de/upload/gematik_Qop_eGK_Spezifikation_Teil1_V1_1_0_Kommentare_4_1652.pdf 

   It works with:
     Kernel > 2.6.0
     tested on various card readers that are certified from the KBV with KVK.

   Report bugs or comments to:
        dr.claudia.neumann@gmx.de

   Known Bugs:
      none (hopefully) ;-)

*/

#include "ctapi.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>



int main(int argc, char **argv) {
  short rv;
  unsigned char resetct[] = {0x20, 0x11, 0x00, 0x00, 0x00};
  unsigned char erase[] = {0x00, 0x0E, 0x00, 0x00};
  unsigned char ejecticc[] = {0x20, 0x15, 0x01, 0x00, 0x00};
  unsigned char dad;
  unsigned char sad;
  unsigned char rbuf[300];
  unsigned short lenr;
  int x , y, z, nl, nm, npd, nvd1, nvd2, mobil, ncard, tst, nl2,ctn,pn;
  FILE *fz;

  tst=0;  // Alle Meldungen = 1

   if (argc<1) {
      fprintf(stdout,"richtiger Gebrauch: %s <Port-Nr.>\n", argv[0]);
      return 2;
  }

  ctn=atoi(argv[1]);
  pn=1; 

  rv=CT_init(ctn, pn);
  if (rv) {
    fprintf(stdout, "Unable to init device\n");
    return 2;
  }
  else {
    if (tst){
    fprintf(stdout, "Device-Initialisierung erfolgreich\n");
    }
    }


/***Erase Binary */
  dad=0;
  sad=2;
  if (tst) {
  printf("Erase Binary\n");
  printf("CMD: ");
  for(x=0;x<sizeof(erase);x++){
     printf("%02x ",erase[x]);
     }
    printf("\n");
  }
  lenr=sizeof(rbuf);
  rv=CT_data(0, &dad, &sad, sizeof(erase), erase, &lenr, rbuf);
  if (rv) {
    fprintf(stdout, "Error in command: Erase Binary (%d)\n", rv);
    return 2;
  }
  if (lenr<2) {
    fprintf(stdout, "Response too short: Erase Binary (%d)\n", lenr);
    return 2;
  }
  if (tst) {
  printf("RSP: ");
  for(x=0;x<lenr;x++){
    printf("%02x ",rbuf[x]);
   }
   printf("\n");
   }
   if ( (rbuf[lenr-3]==0x69) && (rbuf[lenr-2]==0x86) ) {
    fprintf(stdout, "No data selected\n");
    return 2;
    }
   if ( (rbuf[lenr-3]==0x65) && (rbuf[lenr-2]==0x00) ) {
    fprintf(stdout, "Erasure failed\n");
    return 2;
    }
   if ( (rbuf[lenr-3]==0x6B) && (rbuf[lenr-2]==0x00) ) {
    fprintf(stdout, "Wrong parameter\n");
    return 2;
    }
   if ( (rbuf[lenr-3]==0x90) && (rbuf[lenr-2]==0x00) ) {
          if (tst) {
           fprintf(stdout, "Command successful\n");
       }
       }
   else {
       fprintf(stdout, "Erase Binary misslungen\n");
       return 2;
       }


/***Eject ICC  */
  dad=1;
  sad=2;
  if (tst) {
  printf("Eject ICC\n");
  printf("CMD: ");
  for(x=0;x<5;x++){
     printf("%02x ",ejecticc[x]);
     }
  printf("\n");
  }
  lenr=sizeof(rbuf);
  rv=CT_data(0, &dad, &sad, 5, resetct, &lenr, rbuf);
  if (rv) {
    fprintf(stdout, "Error in command: Eject ICC (%d)\n", rv);
    return 2;
  }
  if (lenr<2) {
    fprintf(stdout, "Response too short: Eject ICC (%d)\n", lenr);
    return 2;
  }
  if (tst) {
  printf("RSP: ");
  for(x=0;x<lenr;x++){
    printf("%02x ",rbuf[x]);
     }
  printf("\n");
   }
  if ( ( (rbuf[lenr-2]==0x90) && (rbuf[lenr-1]==0x00) ) || ( (rbuf[lenr-2]==0x90) && (rbuf[lenr-1]==0x01) ) ) {
     if (tst) {
        fprintf(stdout, "Command successful\n");
     }
     } 

  rv=CT_close(0);
  if (rv) {
    fprintf(stdout, "Unable to close device\n");
    return 2;
  }

  return 0;
}




