/*====================================================================*
 -  Copyright (C) 2001 Leptonica.  All rights reserved.
 -  This software is distributed in the hope that it will be
 -  useful, but with NO WARRANTY OF ANY KIND.
 -  No author or distributor accepts responsibility to anyone for the
 -  consequences of using this software, or for whether it serves any
 -  particular purpose or works at all, unless he or she says so in
 -  writing.  Everyone is granted permission to copy, modify and
 -  redistribute this source code, for commercial or non-commercial
 -  purposes, with the following restrictions: (1) the origin of this
 -  source code must not be misrepresented; (2) modified versions must
 -  be plainly marked as such; and (3) this notice may not be removed
 -  or altered from any source or modified source distribution.
 *====================================================================*/

/*
 * fmorphautogen.c
 *
 *    This program is used to generate the two files.
 *    If filename is not given, the files are:
 *         fmorphgen.<n>.c
 *         fmorphgenlow.<n>.c
 *    where <n> is the input index.  Otherwise they are:
 *         <filename>.<n>.c
 *         <filename>low.<n>.c
 *    These two files, when compiled, implement dwa operations for
 *    all sels generated by selaAddBasic().
 *
 *    The library files fmorphgen.1.c and fmorphgenlow.1.c
 *    were made using index = 1.
 */

#include "allheaders.h"

main(int    argc,
     char **argv)
{
char        *filename;
l_int32      index;
SELA        *sela;
static char  mainName[] = "fmorphautogen";

    if (argc != 2 && argc != 3)
	exit(ERROR_INT(" Syntax:  fmorphautogen index <filename>",
                       mainName, 1));

    index = atoi(argv[1]);
    filename = NULL;
    if (argc == 3)
        filename = argv[2];

    sela = selaAddBasic(NULL);
    if (fmorphautogen(sela, index, filename))
        return 1;

    selaDestroy(&sela);
    return 0;
}

