/*
 *  Copyright 1994-2012 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include "webcam.h"

static struct v4l2_queryctrl queryctrl;
static struct v4l2_querymenu querymenu;


static void
enumerate_menu()
{
  memset(&querymenu, 0, sizeof(querymenu));
  querymenu.id = queryctrl.id;
  
  for (querymenu.index = queryctrl.minimum;
       querymenu.index <= (unsigned)queryctrl.maximum;
       querymenu.index++)
    if (0 == ioctl(fd, VIDIOC_QUERYMENU, &querymenu))
      printf ("[i]   - %s\n", querymenu.name);
    else
      xperror("VIDIOC_QUERYMENU");
}


static void
enumerate_base_cids()
{
  memset(&queryctrl, 0, sizeof(queryctrl));
  
  for (queryctrl.id = V4L2_CID_BASE;
       queryctrl.id < V4L2_CID_LASTP1;
       queryctrl.id++) {
    if (0 == ioctl(fd, VIDIOC_QUERYCTRL, &queryctrl)) {
      if (queryctrl.flags & V4L2_CTRL_FLAG_DISABLED)
	continue;
      
      printf("[i] * %s\n", queryctrl.name);
      
      if (queryctrl.type == V4L2_CTRL_TYPE_MENU)
	enumerate_menu();
    } else {
      if (errno == EINVAL)
	continue;
      else
	xperror("VIDIOC_QUERYCTRL");
    }
  }
}


static void
enumerate_private_cids()
{  
  memset(&queryctrl, 0, sizeof (queryctrl));
  
  for (queryctrl.id = V4L2_CID_PRIVATE_BASE;
       ;
       queryctrl.id++) {
    if (0 == ioctl(fd, VIDIOC_QUERYCTRL, &queryctrl)) {
      if (queryctrl.flags & V4L2_CTRL_FLAG_DISABLED)
	continue;
      
      printf ("[i] * %s\n", queryctrl.name);
      
      if (queryctrl.type == V4L2_CTRL_TYPE_MENU)
	enumerate_menu();
    } else {
      if (errno == EINVAL)
	break;
      else
	xperror("VIDIOC_QUERYCTRL");
    }
  }
}


void
enumerate_cids()
{
  printf("[i] Webcam controls:\n");
  enumerate_base_cids();
  enumerate_private_cids();
}
