/*
 *  Copyright 1994-2012 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include <arpa/inet.h>
#include "context.h"

/*
 * Protocol v6:
 * [ image data ] (RGB)   W*H*3 bytes (image, flipped)
 *
 */

extern int write_exact(const u_char *, const int);


void
v6(const Context_t *ctx)
{
  uint32_t proto = 6, proto2;
  uint32_t total, total2;
  Pixel_t *src;
  int ret;

  /* send packet size */
  total = sizeof(uint32_t)+BUFFSIZE*3*sizeof(u_char);
  total2 = htonl(total);
  ret = write_exact((const u_char *)&total2, sizeof(uint32_t));
  
  /* protocol version */
  proto2 = htonl(proto);
  ret = write_exact((const u_char *)&proto2, sizeof(uint32_t));
  
  /* send picture */
  src = export_RGB_active_buffer(ctx, 1);
  ret = write_exact((const u_char *)src, sizeof(u_char)*BUFFSIZE*3);
  xfree(src);
}


