/*
 *  Copyright 1994-2012 Olivier Girondel
 *
 *  This file is part of lebiniou.
 *
 *  lebiniou is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  lebiniou is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with lebiniou. If not, see <http://www.gnu.org/licenses/>.
 */

#include <arpa/inet.h>
#include <GL/gl.h>
#include "context.h"

/*
 * Protocol v4:
 * [ width ] "W"          2 bytes
 * [ height ] "H"         2 bytes
 * [ palette ]            256*4 bytes
 * [ image data ]         W*H bytes
 *
 */

extern FILE *out;
extern void xfwrite(const void *, size_t, size_t, FILE *);


void
v4(const Context_t *ctx)
{
  uint16_t width = WIDTH, width2;
  uint16_t height = HEIGHT, height2;
  uint32_t proto, proto2;
  uint32_t total, total2;
  Pixel_t *src;
  rgba_t *colors = ctx->cf->cur->colors;

  /* send packet size */
  total = sizeof(uint32_t)+2*sizeof(uint16_t)+256*sizeof(rgba_t)+BUFFSIZE*sizeof(u_char);
  total2 = htonl(total);
  xfwrite((const void *)&total2, sizeof(uint32_t), 1, out);
  
  /* protocol version */
  proto = 4;
  proto2 = htonl(proto);
  xfwrite((const void *)&proto2, sizeof(uint32_t), 1, out);

  /* send width, height */
  width2 = htons(width);
  height2 = htons(height);
  xfwrite((const void *)&width2, sizeof(uint16_t), 1, out);
  xfwrite((const void *)&height2, sizeof(uint16_t), 1, out);

  /* send colormap */
  //  for (i = 0; i < 256; i++)
  xfwrite((const void *)colors, sizeof(rgba_t), 256, out);

  /* send picture */
  src = active_buffer(ctx)->buffer;
  xfwrite((const void *)src, sizeof(u_char), BUFFSIZE, out);
  /*  xfree(src); */
}
