/**
 * \file script-redirects.c
 *
 * see script.h
 * see script_lua.c
 * see fetchnews.c::getarticle()
 * see store.c::store_stream()
 *
 * see script-test-store.c for testing all this.
 *
 * clemens fischer <ino-news@spotteswoode.dnsalias.org>
 */

#include "config.h"
#include "mastring.h"
#include "script.h"

#if defined(WITH_SCRIPT)

/*
 * the idea is to rename and call the various API functions for every
 * backend defined.  you would conditionally "#include header.h" first,
 * then enable specific backend functions within the API wrapper
 * function.
 *
 * currently, only lua-functions are defined.  if you need to chain
 * several backends, the pattern would be:
 *
 * <return-type> script_<api-fun>(args-declarations)
 * {
 *   <return-type> rc;
 *   rc = SCRIPT_NOERROR;
 * #if defined(<backend>)
 *   rc = script_<api-fun>_<backend>(args);
 *   rc = rc <some-op> script_<api-fun>_<backend>(args);
 * #endif
 *   ...
 * }
 *
 * i don't know if <some-op> should be "+" or "||" or some more complex
 * function.  NB:  this op determines how results of different backends
 * chain to form the end-result!
 *
 */

#if defined(WITH_SCRIPT_LUA)
#include "script-lua.h"
#endif

int
script_init_ready(int nu_wod)
{
#if defined(WITH_SCRIPT_LUA)
    return script_init_ready_lua(nu_wod);
#endif
}

script_return_t
script_ln_chk_grp_access(const char *cmd, const char *group)
{
#if defined(WITH_SCRIPT_LUA)
    return script_ln_chk_grp_access_lua(cmd, group);
#endif
}

int
script_ln_register_user(const char * user)
{
#if defined(WITH_SCRIPT_LUA)
    return script_ln_register_user_lua(user);
#endif
}

script_return_t
script_ln_init(void)
{
#if defined(WITH_SCRIPT_LUA)
    return script_ln_init_lua();
#endif
}

script_return_t
script_fn_init(void)
{
#if defined(WITH_SCRIPT_LUA)
    return script_fn_init_lua();
#endif
}

script_return_t
script_fn_init_article(void)
{
#if defined(WITH_SCRIPT_LUA)
    return script_fn_init_article_lua();
#endif
}

script_return_t
script_fn_init_group(char * groupname)
{
#if defined(WITH_SCRIPT_LUA)
    return script_fn_init_group_lua(groupname);
#endif
}

script_return_t
script_fn_finish_group(int code)
{
#if defined(WITH_SCRIPT_LUA)
    return script_fn_finish_group_lua(code);
#endif
}

script_result_t
script_fn_get_result(script_cmd_t script_cmd)
{
#if defined(WITH_SCRIPT_LUA)
    return script_fn_get_result_lua(script_cmd);
#endif
}

script_return_t
script_fn_add_header(script_data_t header)
{
#if defined(WITH_SCRIPT_LUA)
    return script_fn_add_header_lua(header);
#endif
}

script_return_t
script_fn_filter_header_table(void)
{
#if defined(WITH_SCRIPT_LUA)
    return script_fn_filter_header_table_lua();
#endif
}

script_return_t
script_fn_filter_header(script_data_t headers)
{
#if defined(WITH_SCRIPT_LUA)
    return script_fn_filter_header_lua(headers);
#endif
}

script_return_t
script_fn_filter_header_body(script_data_t headers, script_data_t body)
{
#if defined(WITH_SCRIPT_LUA)
    return script_fn_filter_header_body_lua(headers, body);
#endif
}

script_return_t
script_fn_add_body(script_data_t body)
{
#if defined(WITH_SCRIPT_LUA)
    return script_fn_add_body_lua(body);
#endif
}

script_return_t
script_fn_finish(int rc)
{
#if defined(WITH_SCRIPT_LUA)
    return script_fn_finish_lua(rc);
#endif
}

script_return_t
script_fn_finish_article(int rc)
{
#if defined(WITH_SCRIPT_LUA)
    return script_fn_finish_article_lua(rc);
#endif
}

unsigned long int
check_script_return(
        script_return_t rc,
        const char * script_name,
        const char * mid,
        script_cmd_t get_what,
        script_result_t * what)
{
#if defined(WITH_SCRIPT_LUA)
    return check_script_return_lua(rc, script_name, mid, get_what, what);
#endif
}

#else /* not WITH_SCRIPT */

/* put dummies here */

#endif /* not WITH_SCRIPT */

