//LabPlot : ImageListDialog.cc

#include <ktempfile.h>
#include "ImageListDialog.h"
#include "Plot2DSurface.h"
#include "manipulations.h"

using namespace std;

ImageListDialog::ImageListDialog(MainWin *m, const char *name)
	: ListDialog(m, name)
{
	setCaption(i18n("Image Manipulation Dialog"));
	KConfig *config = mw->Config();
	config->setGroup( "Image" );

	//QTabWidget *tw = new QTabWidget(vbox);
	//QVBox *tab1 = new QVBox(this);

	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n("Manipulation : "),hb);
	typecb = new KComboBox(hb);
	typecb->insertStrList(typeitems);
	QObject::connect(typecb,SIGNAL(activated (int)),SLOT(updateOptions(int)));
	typecb->setCurrentItem(config->readNumEntry("Type",0));

	hb = new QHBox(vbox);
	xlabel = new QLabel("",hb);
	xle = new KLineEdit(config->readEntry("Parameter1","0"),hb);
	xle->setValidator(new QDoubleValidator(xle));
	ylabel = new QLabel("",hb);
	yle = new KLineEdit(config->readEntry("Parameter2","0"),hb);
	yle->setValidator(new QDoubleValidator(yle));

	noisecb = new KComboBox(hb);
	QStringList noiselist;
	noiselist<<i18n("Uniform noise")<<i18n("Gaussian noise")<<i18n("Multiplicative Gaussian noise");
	noiselist<<i18n("Impulse noise")<<i18n("Laplacian noise")<<i18n("Poisson noise");
	noisecb->insertStringList(noiselist);
	noisecb->setCurrentItem(config->readNumEntry("Noise",0));

	kcb = new KColorButton(config->readColorEntry("Color",&Qt::blue),hb);

	zlabel = new QLabel("",hb);
	zle = new KLineEdit(config->readEntry("Parameter3","0"),hb);
	zle->setValidator(new QDoubleValidator(zle));

	// TODO : scale : aspect ratio ?

	updateOptions(0);

	if(p!=0) {
		//Style style;
		//Symbol symbol;
		//QVBox *styletab;
		// TODO : P3D needed for 3d plots ?
		//if(p->getPlot(p->getAPI())->getType() == PSURFACE)
		//	styletab = surfaceStyle(tw);
		//else
		//	styletab = simpleStyle(tw, &style, &symbol);

		// TODO : needed for GRAPHM data ?
		//tw->addTab(tab1,i18n("Parameter"));
		//tw->addTab(styletab,i18n("Style"));
	}
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(save,SIGNAL(clicked()),SLOT(saveSettings()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void ImageListDialog::saveSettings() {
	KConfig *config = mw->Config();
	config->setGroup( "Image" );

	config->writeEntry("Type",typecb->currentItem());
	config->writeEntry("Parameter1",xle->text());
	config->writeEntry("Parameter2",yle->text());
	config->writeEntry("Parameter3",zle->text());
	config->writeEntry("Noise",noisecb->currentItem());
	config->writeEntry("Color",kcb->color());
}

void ImageListDialog::updateOptions(int item) {
	int gitem = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());
	GraphList *gl =  p->getPlot(p->API())->getGraphList();
	GRAPHType st = gl->getType(gitem);
	QPixmap pm;
	if (st == GRAPHM) {
		GraphM *g = gl->getGraphM(gitem);
		pm = g->Pixmap();
	}
	else if (st == GRAPHIMAGE) {
		GraphIMAGE *g = gl->getGraphIMAGE(gitem);
		pm = g->Pixmap();
	}

	xlabel->hide();
	ylabel->hide();
	zlabel->hide();
	xle->hide();
	yle->hide();
	zle->hide();
	noisecb->hide();
	kcb->hide();

	switch(item) {
	case ADAPTIVETHRESHOLD:
	case SHAVE:
	case TRANSFORM:
	case CHOP:
		xlabel->show();
		ylabel->show();
		xlabel->setText(i18n("Width : "));
		ylabel->setText(i18n("Height : "));
		xle->show();
		yle->show();
		xle->setText("10");
		yle->setText("10");
		break;
	case ADDNOISE:
		xlabel->show();
		xlabel->setText(i18n("Noise type : "));
		noisecb->show();
		break;
	case BLUR:
	case CHARCOAL:
	case EMBOSS:
	case SHARPEN:
		xlabel->show();
		ylabel->show();
		xlabel->setText(i18n("Radius : "));
		ylabel->setText(i18n("Sigma : "));
		xle->show();
		yle->show();
		xle->setText("1");
		yle->setText("0.5");
		break;
	case BORDER:
		xlabel->show();
		ylabel->show();
		xlabel->setText(i18n("Width : "));
		ylabel->setText(i18n("Height : "));
		xle->show();
		yle->show();
		xle->setText("6");
		yle->setText("6");
		break;
	case COLORIZE:
		xlabel->show();
		xlabel->setText(i18n("Opacity : "));
		xle->show();
		xle->setText("0.5");
		kcb->show();
		break;
	case CONTRAST:
		xlabel->show();
		xlabel->setText(i18n("Sharpen : "));
		xle->show();
		xle->setText("1");
		break;
	case CYCLECOLORMAP:
		xlabel->show();
		xlabel->setText(i18n("Amount : "));
		xle->show();
		xle->setText("10");
		break;
	case EDGE:
	case MEDIANFILTER:
		xlabel->show();
		xlabel->setText(i18n("Radius : "));
		xle->show();
		xle->setText("0.0");
		break;
	case FLOODFILLCOLOR:
		xlabel->show();
		ylabel->show();
		xlabel->setText(i18n("X : "));
		ylabel->setText(i18n("Y : "));
		xle->show();
		yle->show();
		xle->setText("1");
		yle->setText("1");
		kcb->show();
		break;
	case MGAMMA:
		xlabel->show();
		xlabel->setText(i18n("Gamma : "));
		xle->show();
		xle->setText("1.0");
		break;
	case GAUSSIANBLUR:
		xlabel->show();
		ylabel->show();
		xlabel->setText(i18n("Width : "));
		ylabel->setText(i18n("Sigma : "));
		xle->show();
		yle->show();
		xle->setText("1");
		yle->setText("0.5");
		break;
	case IMPLODE:
		xlabel->show();
		xlabel->setText(i18n("Factor : "));
		xle->show();
		xle->setText("1");
		break;
	case MODULATE:
		xlabel->show();
		ylabel->show();
		zlabel->show();
		xlabel->setText(i18n("Brightness : "));
		ylabel->setText(i18n("Saturation : "));
		zlabel->setText(i18n("Hue : "));
		xle->show();
		yle->show();
		zle->show();
		xle->setText("0.5");
		yle->setText("0.5");
		zle->setText("0.5");
		break;
	case NEGATE:
		xlabel->show();
		xlabel->setText(i18n("Grayscale ? : "));
		xle->show();
		xle->setText("0");
		break;
	case OILPAINT:
		xlabel->show();
		xlabel->setText(i18n("Radius : "));
		xle->show();
		xle->setText("3");
		break;
	case OPACITY:
		xlabel->show();
		xlabel->setText(i18n("Opacity : "));
		xle->show();
		xle->setText("10");
		break;
	case QUANTIZE:
		xlabel->show();
		xlabel->setText(i18n("Measure error ? : "));
		xle->show();
		xle->setText("0");
		break;
	case RAISE:
		xlabel->show();
		ylabel->show();
		xlabel->setText(i18n("Width : "));
		ylabel->setText(i18n("Height : "));
		xle->show();
		yle->show();
		xle->setText("6");
		yle->setText("6");
		break;
	case REDUCENOISE:
		xlabel->show();
		xlabel->setText(i18n("Order : "));
		xle->show();
		xle->setText("1");
		break;
	case ROLL:
		xlabel->show();
		ylabel->show();
		xlabel->setText(i18n("Columns : "));
		ylabel->setText(i18n("Rows : "));
		xle->show();
		yle->show();
		xle->setText("1");
		yle->setText("0");
		break;
	case ROTATE:
		xlabel->show();
		xlabel->setText(i18n("Degree : "));
		xle->show();
		xle->setText("90");
		break;
	case SAMPLE:
	case SCALE:
	case ZOOM:
		xlabel->show();
		ylabel->show();
		xlabel->setText(i18n("Width : "));
		ylabel->setText(i18n("Height : "));
		xle->show();
		yle->show();
		xle->setText(QString::number(pm.width()));
		yle->setText(QString::number(pm.height()));
		break;
	case SEGMENT:
		xlabel->show();
		ylabel->show();
		xlabel->setText(i18n("Cluster threshold : "));
		ylabel->setText(i18n("Smoothing threshold : "));
		xle->show();
		yle->show();
		xle->setText("1.0");
		yle->setText("1.5");
		break;
	case SHADE:
		xlabel->show();
		ylabel->show();
		xlabel->setText(i18n("Azimuth : "));
		ylabel->setText(i18n("Elevation : "));
		xle->show();
		yle->show();
		xle->setText("30");
		yle->setText("30");
		break;
	case SHEAR:
		xlabel->show();
		ylabel->show();
		xlabel->setText(i18n("X shear angle : "));
		ylabel->setText(i18n("Y shear angle : "));
		xle->show();
		yle->show();
		xle->setText("1");
		yle->setText("1");
		break;
	case SOLARIZE:
		xlabel->show();
		xlabel->setText(i18n("Factor : "));
		xle->show();
		xle->setText("50.0");
		break;
	case SPREAD:
		xlabel->show();
		xlabel->setText(i18n("Amount : "));
		xle->show();
		xle->setText("3");
		break;
	case SWIRL:
		xlabel->show();
		xlabel->setText(i18n("Degree : "));
		xle->show();
		xle->setText("10");
		break;
	case THRESHOLD:
		xlabel->show();
		xlabel->setText(i18n("Threshold : "));
		xle->show();
		xle->setText("1.0");
		break;
	case TRANSPARENT:
		kcb->show();
		break;
	case WAVE:
		xlabel->show();
		ylabel->show();
		xlabel->setText(i18n("Amplitude : "));
		ylabel->setText(i18n("Wavelength : "));
		xle->show();
		yle->show();
		xle->setText("25.0");
		yle->setText("150.0");
		break;
	}
}

int ImageListDialog::apply_clicked() {
#ifdef HAVE_MAGICK
	// more selected graphs ???
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());

	GraphList *gl = p->getPlot(p->API())->getGraphList();
	GRAPHType st = gl->getType(item);

	QPixmap pm;
	if (st == GRAPHM) {
		GraphM *g = gl->getGraphM(item);
		pm = g->Pixmap();
	}
	else if (st == GRAPHIMAGE) {
		GraphIMAGE *g = gl->getGraphIMAGE(item);
		pm = g->Pixmap();
	}

	// save pixmap into file
	KTempFile *tmpfile = new KTempFile(QString::null,".bmp");
	tmpfile->setAutoDelete(true);
	QString filename = tmpfile->name();
	pm.save(filename,"BMP");

	// read image from file
	Image image;
	image.read(filename.latin1());

	double x = xle->text().toDouble();
	double y = yle->text().toDouble();
	double z = zle->text().toDouble();

	// apply methods to image
	switch(typecb->currentItem()) {
#if MagickLibVersion > 0x551
	case ADAPTIVETHRESHOLD: image.adaptiveThreshold((int)x,(int)y); break;
#endif
	case ADDNOISE: image.addNoise((NoiseType) (noisecb->currentItem()+1)); break;
	case BLUR: image.blur(x,y); break;
	case BORDER: image.border(Geometry((int)x,(int)y)); break;
	case CHARCOAL: image.charcoal(x,y);break;
	case CHOP: image.chop(Geometry((int)x,(int)y)); break;
	case COLORIZE: image.colorize((int)x,getColor(kcb->color())); break;
	case CONTRAST: image.contrast((int)x);break;
	case CYCLECOLORMAP: image.cycleColormap((int)x);break;
	case DESPECKLE: image.despeckle();break;
	case EDGE: image.edge(x);break;
	case EMBOSS: image.emboss(x,y);break;
	case ENHANCE: image.enhance();break;
	case EQUALIZE: image.equalize(); break;
	case ERASE: image.erase(); break;
	case FLIP: image.flip(); break;
	case FLOODFILLCOLOR: image.floodFillColor((int)x,(int)y,getColor(kcb->color())); break;
	case FLOP: image.flop(); break;
	case MGAMMA: image.gamma(x); break;
	case GAUSSIANBLUR: image.gaussianBlur(x,y); break;
	case IMPLODE : image.implode(x); break;
	case MAGNIFY: image.magnify(); break;
	case MEDIANFILTER: image.medianFilter(x); break;
	case MINIFY: image.minify(); break;
	case MODULATE: image.modulate(x,y,z); break;
	case NEGATE: image.negate((bool) x); break;
	case NORMALIZE: image.normalize(); break;
	case OILPAINT: image.oilPaint((int) x); break;
	case OPACITY: image.opacity((int) x); break;
	case QUANTIZE: image.quantize((bool) x); break;
	case RAISE: image.raise(Geometry((int)x,(int)y)); break;
	case REDUCENOISE: image.reduceNoise((int) x); break;
	case ROLL: image.roll((int) x,(int) y); break;
	case ROTATE: image.rotate(x); break;
	case SAMPLE: image.sample(Geometry((int)x,(int)y)); break;
	case SCALE: image.scale(Geometry((int)x,(int)y)); break;
	case SEGMENT: image.segment(x,y); break;
	case SHADE: image.shade(x,y); break;
	case SHARPEN: image.sharpen(x,y); break;
	case SHAVE: image.shave(Geometry((int)x,(int)y)); break;
	case SHEAR: image.shear(x,y); break;
	case SOLARIZE: image.solarize(x); break;
	case SPREAD: image.spread((int) x); break;
	case SWIRL: image.swirl(x); break;
	case THRESHOLD: image.threshold(x); break;
	case TRANSFORM: image.transform(Geometry((int)x,(int)y)); break;
	case TRANSPARENT: image.transparent(getColor(kcb->color())); break;
	case TRIM: image.trim(); break;
	case WAVE: image.wave(x,y); break;
	case ZOOM: image.zoom(Geometry((int)x,(int)y)); break;
	}

	// write changes to file
	image.write(filename.latin1());

	// load file into pixmap and set it
	pm.load(filename);

	if (st == GRAPHM) {
		GraphM *g = gl->getGraphM(item);
		g->setPixmap(pm);
		if(typecb->currentItem()==ZOOM || typecb->currentItem()==SAMPLE || typecb->currentItem()==SCALE) {
			g->setWidth((int)x);
			g->setHeight((int)y);
		LRange range[2];
		range[0]=g->Range(0);
		range[1]=g->Range(1);
		p->getPlot(p->API())->setActRanges(range);
		}
	}
	else if (st == GRAPHIMAGE) {
		GraphIMAGE *g = gl->getGraphIMAGE(item);
		g->setPixmap(pm);
		if(typecb->currentItem()==ZOOM || typecb->currentItem()==SAMPLE || typecb->currentItem()==SCALE) {
			g->setWidth((int)x);
			g->setHeight((int)y);
		}
		LRange range[2];
		range[0]=g->Range(0);
		range[1]=g->Range(1);
		p->getPlot(p->API())->setActRanges(range);
	}

	updateList();
	p->updatePixmap();
#else
	KMessageBox::warningContinueCancel(this,i18n("Sorry. Your Installation doesn't support ImageMagick!"));
#endif

	return 0;
}

#ifdef HAVE_MAGICK
//! convert QColor to Magick::Color
Color ImageListDialog::getColor(QColor c) {
	return Color(c.red(),c.green(),c.blue());
}
#endif
