/***************************************************************************
 *   Copyright (C) 2004-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KTRANSLATOR_H_
#define _KTRANSLATOR_H_

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kmainwindow.h>

class QVBox;
class QLineEdit;
class QTextBrowser;
class ktranslatorDock;
class KToggleAction;
class KConfigDialog;
class QString;
class KTranslatorDictionaryManager;
class QListBoxItem;

/**
 * @short Application Main Window
 * @author Raul Fernandes <rgfbr@yahoo.com.br>
 * @version 0.1
 */
class ktranslator : public KMainWindow
{
    Q_OBJECT
public:
    /**
     * Default Constructor
     */
    ktranslator();

    /**
     * Default Destructor
     */
    virtual ~ktranslator();
    QString searchIndex( QString &word );

    QString translate( const QString & );

public slots:
    void search( const QString & );

    void searchLineedit();

    void linkClicked( const QString & );

    /*!
        \fn ktranslator::speech()
        Slot to speech the word using Festival.
     */
    void speech();

    /*!
      \fn ktranslator::searchInInternet()
      Slot to search the word in some sites. Currently, they are Wikipedia, Wiktionary and Merriam-Webster.
    */
    void searchInInternet();

    void slotConfig();

    void updateConfig();

    void loadPlugins();

protected:
    bool queryClose();
    bool menuQuit;

    QLineEdit *lineedit;
    QVBox *vbox;
    QTextBrowser *main;
    ktranslatorDock *dock;
    QString indexFilePath;
    QString wordToTranslate;

    KTranslatorDictionaryManager *plugins;

    KConfigDialog *dialog;

protected slots:
    void slotQuit();

signals:
    void loadModifierKey();
};

#endif // _KTRANSLATOR_H_
