/***************************************************************************
 *   Copyright (C) 2005-2006 by Raul Fernandes                             *
 *   rgfbr@yahoo.com.br                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef KTRANSLATOR_UIPLUGIN_H
#define KTRANSLATOR_UIPLUGIN_H

#include <qobject.h>
#include <kxmlguiclient.h>

class QWidget;

/**
 *  Namespace for UI Plugin
 */
namespace KTranslator {

    /**
     * @short UI Plugin Abstract Class
     * @author Raul Fernandes <rgfbr@yahoo.com.br>
     * @version 0.1
     * This is the base class to make UI plugins for KTranslator.
     * The UI plugins are the piece of code that tells KTranslator when and what to translate.
     */
    class KDE_EXPORT UIPlugin : public QObject, public KXMLGUIClient
    {
    Q_OBJECT
    public:

        /**
         * Default constructor.
         */
        UIPlugin(QObject *parent, const char* name=0);

        /**
         * Destructs the plugin.
         */
        virtual ~UIPlugin();

        /**
         * Function used by plugins to emit the signal that starts the search.
         * @param word The word to translate.
         */
        void emitSearch( const QString &word ){ emit search( word ); }
    signals:

        /**
         * Signal that starts the search.
         */
        void search( const QString & );
    };
};


#endif /* KTRANSLATOR_UIPLUGIN_H */
