/***************************************************************************
 *   Copyright (C) 2004-2008 by Giovanni Venturi                           *
 *   giovanni@ksniffer.org                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02110-1301, USA.          *
 ***************************************************************************/

#include <qtextedit.h>
#include <qclipboard.h>
#include <qpushbutton.h>
#include <qfont.h>
#include <qfile.h>

#include <kuniqueapplication.h>
#include <kstdguiitem.h>
#include <ktempfile.h>
#include <kurl.h>
#include <kfiledialog.h>
#include <kio/netaccess.h>
#include <kmessagebox.h>
#include <klocale.h>

#include "displaydata.h"

DisplayData::DisplayData( QWidget *parent, const char *name )
 : DisplayDataBase( parent, name )
{
  // at startup there is nothing to save
  m_buttonSave->hide();

  // give default icon and text to 'Save' button
  m_buttonSave->setIconSet(KStdGuiItem::saveAs().iconSet());
  m_buttonSave->setText(KStdGuiItem::saveAs().text());
  connect(m_buttonSave, SIGNAL(clicked()), SLOT(saveText()));

  // give dafault icon and text to 'CancelOk' button
  m_buttonCancelOk->setIconSet(KStdGuiItem::stop().iconSet());
  m_buttonCancelOk->setText(KStdGuiItem::stop().text());

  // at startup the text area is empty than we don't need to copy
  m_buttonCopy->hide();
}


DisplayData::~DisplayData()
{
}

void DisplayData::setText( const QString& text )
{
  m_textArea->setFont( QFont( "Monospace", 9 ) );
  m_textArea->setText( text );

  // now there is text...
  m_buttonCopy->show();

  // if you click 'Copy' button than put text into the clipboard
  connect(m_buttonCopy, SIGNAL(clicked()), this, SLOT(copyIntoClipboard()));
}


void DisplayData::stopped()
{
  accept();
}


void DisplayData::showSave()
{
  // process ended, user could save text
  m_buttonSave->show();

  // process ended, no more "stop", but "ok"
  m_buttonCancelOk->setIconSet(KStdGuiItem::ok().iconSet());
  m_buttonCancelOk->setText(KStdGuiItem::ok().text());
}


void DisplayData::copyIntoClipboard()
{
  m_textArea->selectAll();
  QClipboard* cb = kapp->clipboard();
  cb->setText( m_textArea->text(), QClipboard::Clipboard );
}


void DisplayData::saveText()
{
  KTempFile *tmpFile = new KTempFile;
  tmpFile->setAutoDelete( true );
  if ( tmpFile->status() == 0 )
  {
    // temporary file created succesfully
    QFile file( tmpFile->name() );
    if ( file.open( IO_ReadWrite ) )
    {
      QTextStream stream( &file );
      stream << m_textArea->text();
      file.close();
      KURL dest = KFileDialog::getSaveURL();
      if (!dest.isEmpty())
      {
        if (dest.isValid())
        {
          if ( !KIO::NetAccess::upload( tmpFile->name(), dest, 0 ) )
          {
            KMessageBox::information( this, i18n( "%1 not saved!" ).arg(dest.url()), i18n( "Save Failed" ) );
          }
        }
        else
          KMessageBox::information( this, i18n( "%1 not saved!" ).arg(dest.url()), i18n( "Save Failed" ) );
      }
    }
  }
  if ( tmpFile )
    delete tmpFile;
}

#include "displaydata.moc"
