/***************************************************************************
 *   Copyright (C) 2005 by Daniel Stöckel                                  *
 *   the_docter@gmx.net                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifndef _KOMMANDO_H_
#define _KOMMANDO_H_

#include <qwidget.h>
#include <qptrlist.h>

#include <kpixmap.h>

#include "menu.h"

class Kommando : public QWidget
{
    Q_OBJECT

    public:
        Kommando();

        /*
        * The window needs to appear at the mousecursors current position
        * overriding QWidget::show() makes this easy, showEvent() does not
        * work properly though.
        */
        virtual void show();
        virtual void hide();
        virtual void toggle();
        virtual void execute();
        virtual void selectButton(int num);
        virtual void nextButton() { selectButton(actMenu->selectedButtonNum()+1); }
        virtual void previousButton() { selectButton(actMenu->selectedButtonNum()-1); }

        virtual void setActTopLevelMenu(const QString& appName);
        virtual void setActMenu(Menu* newmenu);
        virtual void setTopLevelMenus(const QPtrList<Menu>& newmenus);
        //virtual Menu* getMainMenu(){return mainMenu;}
        virtual const QPixmap* screenshot(){return &mScreenshot;}
        virtual void setNavButtonSize(unsigned short size);
        virtual void resize();

    public slots:
        //Slot for KGlobalAccel
        virtual void slotGlobAccel();

    protected:
        Menu* actMenu;
        QPtrList<Menu> mTopLevelMenus;
        RoundButton navbutton;
        int oldNavbuttonIconType;  //holds whether the icon should be changed
        KPixmap mScreenshot;

        //Some events
        virtual void paintEvent (QPaintEvent* evt);
        virtual void windowActivationChange ( bool oldActive );
        virtual void wheelEvent (QWheelEvent * evt);
        virtual void keyPressEvent(QKeyEvent* evt);


    protected slots:
        virtual void slotOnClick();
        virtual void slotNavClick();
        virtual void slotButtonSelected(int type);
};

#endif // _KOMMANDO_H_
