/***************************************************************************
                          preferences.cpp  -  description
                             -------------------
    begin                : Sat Jan 27 2001
    copyright            : (C) 2001 by Frank Schwanz
    email                : schwanz@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlistbox.h>
#include <qvalidator.h>
#include <qcheckbox.h>

#include <kfiledialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "options.h"

#include "preferences.h"

Preferences::Preferences (QWidget * parent, const char *name, Options * opt):
PrefDlg (parent, name, true)
{
  options = opt;
  init ();
  connect ((QObject *) btnCancel, SIGNAL (clicked ()), (QObject *) this,
	   SLOT (slotCancel ()));
  connect ((QObject *) btnOK, SIGNAL (clicked ()), (QObject *) this,
	   SLOT (slotOK ()));
  connect ((QObject *) btnApply, SIGNAL (clicked ()), (QObject *) this,
	   SLOT (savePreferences ()));

}

Preferences::~Preferences ()
{
}

void
Preferences::slotCancel ()
{
  done (0);
}

void
Preferences::init ()
{

  // TabIpRanges
  connect ((QObject *) btnIpDelete, SIGNAL (clicked ()), this,
	   SLOT (slotIpDelete_clicked ()));
  connect ((QObject *) btnIpAppend, SIGNAL (clicked ()), this,
	   SLOT (slotIpAppend_clicked ()));
  // slots for next if maxinput is reached
  connect ((QObject *) txtIpFrom_1, SIGNAL (textChanged (const QString &)),
	   this, SLOT (slotIpTextChanged (const QString &)));
  connect ((QObject *) txtIpFrom_2, SIGNAL (textChanged (const QString &)),
	   this, SLOT (slotIpTextChanged (const QString &)));
  connect ((QObject *) txtIpFrom_3, SIGNAL (textChanged (const QString &)),
	   this, SLOT (slotIpTextChanged (const QString &)));
  connect ((QObject *) txtIpFrom_4, SIGNAL (textChanged (const QString &)),
	   this, SLOT (slotIpTextChanged (const QString &)));
  connect ((QObject *) txtIpTo_4, SIGNAL (textChanged (const QString &)),
	   this, SLOT (slotIpTextChanged (const QString &)));
  QIntValidator *iv = new QIntValidator (0, 255, this);

  txtIpFrom_1->setValidator (iv);
  txtIpFrom_2->setValidator (iv);
  txtIpFrom_3->setValidator (iv);
  txtIpFrom_4->setValidator (iv);
  txtIpTo_4->setValidator (iv);

  // IP-Range-Listbox
  lstIP_Range->clear ();
  if (options->firstIpRange ())
    {
      do
	{
	  lstIP_Range->insertItem (options->currentIpRange ());
	}
      while (options->nextIpRange ());
    }
  // Tab - smbversion
  // init Sambaversion-Combobox
  cmbSmbVersion->insertItem ("2.0.5");
  cmbSmbVersion->insertItem ("2.0.6");
  cmbSmbVersion->insertItem ("2.0.7");
  int ver = options->smbMountVersion ();
  QString sver;
  QString aktver (sver.setNum (ver / 100) + QString ("."));
  ver = ver % 100;
  aktver.append (sver.setNum (ver / 10) + QString ("."));
  ver = ver % 10;
  aktver.append (sver.setNum (ver));
  for (int i = 0; i < cmbSmbVersion->count (); i++)
    {
      if (cmbSmbVersion->text (i).compare (aktver) == 0)
	{
	  cmbSmbVersion->setCurrentItem (i);
	  i = cmbSmbVersion->count ();
	}
    }
  // init Mountpath
  connect ((QObject *) btnMountPath, SIGNAL (clicked ()), this,
	   SLOT (choose_clicked ()));
  txtMountPath->setText (options->mountPath ());
  // CheckBoxes
  chkScanWorkgroup->setChecked (options->scanAllWorkgroups ());
  chkScanHost->setEnabled (options->scanAllWorkgroups ());
  chkScanHost->setChecked (options->scanAllHosts ());
  chkUnmount->setChecked (options->unmountAllOnExit ());
  chkRemount->setEnabled (options->unmountAllOnExit ());
  chkRemount->setChecked (options->mntLastSessionShares ());
  chkShowIpcShares->setChecked (options->showIpcShares ());
  chkShowDollarShares->setChecked (options->showDollarShares ());
  chkShowPrinter->setChecked (options->showPrinters ());
  chkSavePasswords->setChecked (options->savePasswords ());
  chkExplore->setChecked (options->exploreAfterMount ());
  chkNoPasswordDialog->setChecked (options->noPasswordDialog ());
  chkCleanup->setChecked (options->cleanupOnUnmount ());

  // Hosts

  connect ((QObject *) btnHostDelete, SIGNAL (clicked ()), this,
	   SLOT (slotHostsDelete_clicked ()));
  connect ((QObject *) btnHostAppend, SIGNAL (clicked ()), this,
	   SLOT (slotHostsAppend_clicked ()));
//      lstHosts->addColumn(i18n("Host"));
//      lstHosts->addColumn( i18n("Workgroup"));
  lstHosts->clear ();
  if (options->firstHost ())
    {
      do
	{
	  lstHosts->insertItem (options->currentHost ());
	}
      while (options->nextHost ());
    }

}



void
Preferences::slotOK ()
{
  savePreferences ();
  done (1);
}

////////////////////////////////////////////////////////////////////////////////////
//      Tab smbversion

void
Preferences::choose_clicked ()
{
  QString filename = KFileDialog::getExistingDirectory (txtMountPath->text (),
							this,
							i18n
							("Choose a prefered mountpath"));
  QFileInfo file (filename);
  if (filename != NULL)
    {
      if (filename.right (1) != "/")
	filename += "/";
      if (file.isDir ())
	txtMountPath->setText (filename);
      else
	KMessageBox::error (this,
			    i18n
			    ("You must select a path ! Please try again. "),
			    i18n ("Mountpath not correct"));
    }
}




///////////////////////////////////////////////////////////////////////////////////////
// Tab IP-Range
void
Preferences::slotIpDelete_clicked ()
{
  if (lstIP_Range->isSelected (lstIP_Range->currentItem ()))
    lstIP_Range->removeItem (lstIP_Range->currentItem ());
}

void
Preferences::slotIpAppend_clicked ()
{
  QString qstr_ip, qstr_num;
  u_long ipstart, ipstop;

  if ((txtIpFrom_1->text ().toInt () != 0)
      && (txtIpFrom_1->text ().toInt () <= 255)
      && (txtIpFrom_2->text ().toInt () <= 255)
      && (txtIpFrom_3->text ().toInt () <= 255)
      && (txtIpFrom_4->text ().toInt () <= 255))
    if ((txtIpTo_1->text ().toInt () != 0)
	&& (txtIpTo_1->text ().toInt () <= 255)
	&& (txtIpTo_2->text ().toInt () <= 255)
	&& (txtIpTo_3->text ().toInt () <= 255)
	&& (txtIpTo_4->text ().toInt () <= 255))
      {
	ipstart =
	  ((u_char) txtIpFrom_1->text ().toInt () << 24) +
	  ((u_char) txtIpFrom_2->text ().toInt () << 16) +
	  ((u_char) txtIpFrom_3->text ().toInt () << 8) +
	  ((u_char) txtIpFrom_4->text ().toInt ());
	ipstop =
	  ((u_char) txtIpTo_1->text ().toInt () << 24) +
	  ((u_char) txtIpTo_2->text ().toInt () << 16) +
	  ((u_char) txtIpTo_3->text ().toInt () << 8) +
	  ((u_char) txtIpTo_4->text ().toInt ());
	if (ipstart <= ipstop)
	  {
	    qstr_ip =
	      qstr_num.setNum (txtIpFrom_1->text ().toInt ()) + "." +
	      qstr_num.setNum (txtIpFrom_2->text ().toInt ()) + "." +
	      qstr_num.setNum (txtIpFrom_3->text ().toInt ()) + "." +
	      qstr_num.setNum (txtIpFrom_4->text ().toInt ());
	    qstr_ip +=
	      " - " + qstr_num.setNum (txtIpTo_1->text ().toInt ()) + "." +
	      qstr_num.setNum (txtIpTo_2->text ().toInt ()) + "." +
	      qstr_num.setNum (txtIpTo_3->text ().toInt ()) + "." +
	      qstr_num.setNum (txtIpTo_4->text ().toInt ());
	    lstIP_Range->insertItem (qstr_ip);
	  }
	else
	  {
	    KMessageBox::error (this,
				i18n
				("The from-IP is bigger than the to-IP."),
				i18n ("Not correct IP"));
	    txtIpTo_4->setFocus ();
	  }
      }
    else
      {
	KMessageBox::error (this,
			    i18n
			    ("This is'nt an IP-Address. Please try again. "),
			    i18n ("Not correct IP"));
	txtIpFrom_1->setFocus ();
      }
  else
    {
      KMessageBox::error (this,
			  i18n
			  ("This is'nt an IP-Address. Please try again. "),
			  i18n ("Not correct IP"));
      txtIpFrom_1->setFocus ();
    }
}

void
Preferences::slotIpTextChanged (const QString & s)
{
  if (s.length () == 3)
    focusNextPrevChild (true);
}

//////////////////////////////////////////////////////////////////////////////////////////
//      Hoststab
void
Preferences::slotHostsDelete_clicked ()
{
  if (lstHosts->isSelected (lstHosts->currentItem ()))
    lstHosts->removeItem (lstHosts->currentItem ());
}


void
Preferences::slotHostsAppend_clicked ()
{
  QString host, workgroup;
  host = txtHost->text ();
  workgroup = txtWorkgroup->text ();
  if (host.length () > 0)
    if (workgroup.length () > 0)
      {
	lstHosts->insertItem (host + (QString) "\t" + workgroup);
	txtHost->setText ("");
	txtWorkgroup->setText ("");
	txtHost->setFocus ();
      }
    else
      {
	KMessageBox::error (this,
			    i18n ("You must set the workgroup."),
			    i18n ("No Workgroup"));
	txtWorkgroup->setFocus ();
      }
  else
    {
      KMessageBox::error (this,
			  i18n ("You must set the host."), i18n ("No host"));
      txtHost->setFocus ();
    }
}

void
Preferences::savePreferences ()
{
  uint i;
  int idx;
  QString count;
  QString s;
  // IP-Ranges
  idx = lstIP_Range->topItem ();
  options->clearIpRanges ();
  for (i = lstIP_Range->count (); i > 0; i--)
    {
      count = "IP" + count.setNum (idx);
      options->appendIpRange (lstIP_Range->text (idx));
      idx++;
    }

  //Hosts
  idx = lstHosts->topItem ();
  options->clearHosts ();
  for (i = lstHosts->count (); i > 0; i--)
    {
      count = "HOST" + count.setNum (idx);
      options->appendHost (lstHosts->text (idx));
      idx++;
    }

  // MountPath AND ROOTPASSWORD
  s = txtMountPath->text ();
  s = s.stripWhiteSpace ();
  if (s.right (1) != "/")
    s += "/";
  options->setMountPath (s);
  //OTHERS
  options->setScanAllWorkgroups (chkScanWorkgroup->isChecked ());
  options->setScanAllHosts (chkScanHost->isChecked ());

  options->setUnmountAllOnExit (chkUnmount->isChecked ());
  options->setMntLastSessionShares (chkRemount->isChecked ());

  options->setHideIpcShares (!chkShowIpcShares->isChecked ());
  options->setHideDollarShares (!chkShowDollarShares->isChecked ());
  options->setHidePrinters (!chkShowPrinter->isChecked ());
  options->setSavePasswords (chkSavePasswords->isChecked ());
  options->setExploreAfterMount (chkExplore->isChecked ());
  options->setNoPasswordDialog (chkNoPasswordDialog->isChecked ());
  options->setCleanupOnUnmount (chkCleanup->isChecked ());

  s = cmbSmbVersion->currentText ();
  s.replace (QRegExp ("\\."), "");

  options->setSmbMountVersion (s.toInt ());


  options->saveAll ();
}
