
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include "komba2.h"

static const char *description = I18N_NOOP ("Komba2");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE


static KCmdLineOptions options[] = {
  {"+[File]", I18N_NOOP ("file to open"), 0},
  {"m", I18N_NOOP ("remount all shares from last session"), 0},
  {"u", I18N_NOOP ("unmount all shares"), 0},
  {0, 0, 0}
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int
main (int argc, char *argv[])
{

  KAboutData aboutData ("komba2", I18N_NOOP ("Komba2"),
			VERSION, description, KAboutData::License_GPL,
			"(c) 2000, Frank Schwanz", "\n",
			"http://zeus.fh-brandenburg.de/~schwanz/php/komba.php3",
			"schwanz@fh-brandenburg.de");
  aboutData.addAuthor ("Frank Schwanz", 0, "schwanz@fh-brandenburg.de",
		       "http://zeus.fh-brandenburg.de/~schwanz/php/komba.php3");
  KCmdLineArgs::init (argc, argv, &aboutData);
  KCmdLineArgs::addCmdLineOptions (options);	// Add our own options.

  KApplication app;
  Komba2App *komba2;
  if (app.isRestored ())
    {
      RESTORE (Komba2App);
    }
  else
    {
      KCmdLineArgs *args = KCmdLineArgs::parsedArgs ();
      if (args->isSet ("m"))
	{
	  komba2 = new Komba2App (0, 0, "m");
	}
      else if (args->isSet ("u"))
	{
	  komba2 = new Komba2App (0, 0, "u");
	}
      else
	{
	  komba2 = new Komba2App ();
	  komba2->show ();
	  if (args->count ())
	    {
	      komba2->openDocumentFile (args->arg (0));
	    }
	  else
	    {
	      komba2->openDocumentFile ();
	    }
	}
      args->clear ();
    }
  return app.exec ();

}
