/*-
 * Copyright (c) 2006 Stephane E. Potvin <sepotvin@videotron.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: src/sys/dev/sound/pci/hda/hda_reg.h,v 1.2 2006/11/26 12:24:05 ariff Exp $
 */

#ifndef _HDA_REG_H_
#define _HDA_REG_H_

/****************************************************************************
 * HDA Device Verbs
 ****************************************************************************/

/* HDA Command */
#define HDA_CMD_VERB_MASK				0x000fffff
#define HDA_CMD_VERB_SHIFT				0
#define HDA_CMD_NID_MASK				0x0ff00000
#define HDA_CMD_NID_SHIFT				20
#define HDA_CMD_CAD_MASK				0xf0000000
#define HDA_CMD_CAD_SHIFT				28

#define HDA_CMD_VERB_4BIT_SHIFT				16
#define HDA_CMD_VERB_12BIT_SHIFT			8

#define HDA_CMD_VERB_4BIT(verb, payload)				\
    (((verb) << HDA_CMD_VERB_4BIT_SHIFT) | (payload))
#define HDA_CMD_4BIT(cad, nid, verb, payload)				\
    (((cad) << HDA_CMD_CAD_SHIFT) |					\
    ((nid) << HDA_CMD_NID_SHIFT) |					\
    (HDA_CMD_VERB_4BIT((verb), (payload))))

#define HDA_CMD_VERB_12BIT(verb, payload)				\
    (((verb) << HDA_CMD_VERB_12BIT_SHIFT) | (payload))
#define HDA_CMD_12BIT(cad, nid, verb, payload)				\
    (((cad) << HDA_CMD_CAD_SHIFT) |					\
    ((nid) << HDA_CMD_NID_SHIFT) |					\
    (HDA_CMD_VERB_12BIT((verb), (payload))))

/* Get Parameter */
#define HDA_CMD_VERB_GET_PARAMETER			0xf00

#define HDA_CMD_GET_PARAMETER(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_PARAMETER, (payload)))

/* Connection Select Control */
#define HDA_CMD_VERB_GET_CONN_SELECT_CONTROL		0xf01
#define HDA_CMD_VERB_SET_CONN_SELECT_CONTROL		0x701

#define HDA_CMD_GET_CONN_SELECT_CONTROL(cad, nid)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_CONN_SELECT_CONTROL, 0x0))
#define HDA_CMD_SET_CONNECTION_SELECT_CONTROL(cad, nid, payload)	\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_CONN_SELECT_CONTROL, (payload)))

/* Connection List Entry */
#define HDA_CMD_VERB_GET_CONN_LIST_ENTRY		0xf02

#define HDA_CMD_GET_CONN_LIST_ENTRY(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_CONN_LIST_ENTRY, (payload)))

#define HDA_CMD_GET_CONN_LIST_ENTRY_SIZE_SHORT		1
#define HDA_CMD_GET_CONN_LIST_ENTRY_SIZE_LONG		2

/* Processing State */
#define HDA_CMD_VERB_GET_PROCESSING_STATE		0xf03
#define HDA_CMD_VERB_SET_PROCESSING_STATE		0x703

#define HDA_CMD_GET_PROCESSING_STATE(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_PROCESSING_STATE, 0x0))
#define HDA_CMD_SET_PROCESSING_STATE(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_PROCESSING_STATE, (payload)))

#define HDA_CMD_GET_PROCESSING_STATE_STATE_OFF		0x00
#define HDA_CMD_GET_PROCESSING_STATE_STATE_ON		0x01
#define HDA_CMD_GET_PROCESSING_STATE_STATE_BENIGN	0x02

/* Coefficient Index */
#define HDA_CMD_VERB_GET_COEFF_INDEX			0xd
#define HDA_CMD_VERB_SET_COEFF_INDEX			0x5

#define HDA_CMD_GET_COEFF_INDEX(cad, nid)				\
    (HDA_CMD_4BIT((cad), (nid),						\
    HDA_CMD_VERB_GET_COEFF_INDEX, 0x0))
#define HDA_CMD_SET_COEFF_INDEX(cad, nid, payload)			\
    (HDA_CMD_4BIT((cad), (nid),						\
    HDA_CMD_VERB_SET_COEFF_INDEX, (payload)))

/* Processing Coefficient */
#define HDA_CMD_VERB_GET_PROCESSING_COEFF		0xc
#define HDA_CMD_VERB_SET_PROCESSING_COEFF		0x4

#define HDA_CMD_GET_PROCESSING_COEFF(cad, nid)				\
    (HDA_CMD_4BIT((cad), (nid),						\
    HDA_CMD_VERB_GET_PROCESSING_COEFF, 0x0))
#define HDA_CMD_SET_PROCESSING_COEFF(cad, nid, payload)			\
    (HDA_CMD_4BIT((cad), (nid),						\
    HDA_CMD_VERB_SET_PROCESSING_COEFF, (payload)))

/* Amplifier Gain/Mute */
#define HDA_CMD_VERB_GET_AMP_GAIN_MUTE			0xb
#define HDA_CMD_VERB_SET_AMP_GAIN_MUTE			0x3

#define HDA_CMD_GET_AMP_GAIN_MUTE(cad, nid, payload)			\
    (HDA_CMD_4BIT((cad), (nid),						\
    HDA_CMD_VERB_GET_AMP_GAIN_MUTE, (payload)))
#define HDA_CMD_SET_AMP_GAIN_MUTE(cad, nid, payload)			\
    (HDA_CMD_4BIT((cad), (nid),						\
    HDA_CMD_VERB_SET_AMP_GAIN_MUTE, (payload)))

#define HDA_CMD_GET_AMP_GAIN_MUTE_INPUT		0x0000
#define HDA_CMD_GET_AMP_GAIN_MUTE_OUTPUT	0x8000
#define HDA_CMD_GET_AMP_GAIN_MUTE_RIGHT		0x0000
#define HDA_CMD_GET_AMP_GAIN_MUTE_LEFT		0x2000

#define HDA_CMD_GET_AMP_GAIN_MUTE_MUTE_MASK	0x00000008
#define HDA_CMD_GET_AMP_GAIN_MUTE_MUTE_SHIFT	7
#define HDA_CMD_GET_AMP_GAIN_MUTE_GAIN_MASK	0x00000007
#define HDA_CMD_GET_AMP_GAIN_MUTE_GAIN_SHIFT	0

#define HDA_CMD_GET_AMP_GAIN_MUTE_MUTE(rsp)				\
    (((rsp) & HDA_CMD_GET_AMP_GAIN_MUTE_MUTE_MASK) >>			\
    HDA_CMD_GET_AMP_GAIN_MUTE_MUTE_SHIFT)
#define HDA_CMD_GET_AMP_GAIN_MUTE_GAIN(rsp)				\
    (((rsp) & HDA_CMD_GET_AMP_GAIN_MUTE_GAIN_MASK) >>			\
    HDA_CMD_GET_AMP_GAIN_MUTE_GAIN_SHIFT)

#define HDA_CMD_SET_AMP_GAIN_MUTE_OUTPUT	0x8000
#define HDA_CMD_SET_AMP_GAIN_MUTE_INPUT		0x4000
#define HDA_CMD_SET_AMP_GAIN_MUTE_LEFT		0x2000
#define HDA_CMD_SET_AMP_GAIN_MUTE_RIGHT		0x1000
#define HDA_CMD_SET_AMP_GAIN_MUTE_INDEX_MASK	0x0f00
#define HDA_CMD_SET_AMP_GAIN_MUTE_INDEX_SHIFT	8
#define HDA_CMD_SET_AMP_GAIN_MUTE_MUTE		0x0080
#define HDA_CMD_SET_AMP_GAIN_MUTE_GAIN_MASK	0x0007
#define HDA_CMD_SET_AMP_GAIN_MUTE_GAIN_SHIFT	0

#define HDA_CMD_SET_AMP_GAIN_MUTE_INDEX(index)				\
    (((index) << HDA_CMD_SET_AMP_GAIN_MUTE_INDEX_SHIFT) &		\
    HDA_CMD_SET_AMP_GAIN_MUTE_INDEX_MASK)
#define HDA_CMD_SET_AMP_GAIN_MUTE_GAIN(index)				\
    (((index) << HDA_CMD_SET_AMP_GAIN_MUTE_GAIN_SHIFT) &		\
    HDA_CMD_SET_AMP_GAIN_MUTE_GAIN_MASK)

/* Converter format */
#define HDA_CMD_VERB_GET_CONV_FMT			0xa
#define HDA_CMD_VERB_SET_CONV_FMT			0x2

#define HDA_CMD_GET_CONV_FMT(cad, nid)					\
    (HDA_CMD_4BIT((cad), (nid),						\
    HDA_CMD_VERB_GET_CONV_FMT, 0x0))
#define HDA_CMD_SET_CONV_FMT(cad, nid, payload)				\
    (HDA_CMD_4BIT((cad), (nid),						\
    HDA_CMD_VERB_SET_CONV_FMT, (payload)))

/* Digital Converter Control */
#define HDA_CMD_VERB_GET_DIGITAL_CONV_FMT		0xf0d
#define HDA_CMD_VERB_SET_DIGITAL_CONV_FMT1		0x70d
#define HDA_CMD_VERB_SET_DIGITAL_CONV_FMT2		0x70e

#define HDA_CMD_GET_DIGITAL_CONV_FMT(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_DIGITAL_CONV_FMTT, 0x0))
#define HDA_CMD_SET_DIGITAL_CONV_FMT1(cad, nid, payload)		\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_DIGITAL_CONV_FMT1, (payload)))
#define HDA_CMD_SET_DIGITAL_CONV_FMT2(cad, nid, payload)		\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_DIGITAL_CONV_FMT2, (payload)))

#define HDA_CMD_GET_DIGITAL_CONV_FMT_CC_MASK		0x7f00
#define HDA_CMD_GET_DIGITAL_CONV_FMT_CC_SHIFT		8
#define HDA_CMD_GET_DIGITAL_CONV_FMT_L_MASK		0x0080
#define HDA_CMD_GET_DIGITAL_CONV_FMT_L_SHIFT		7
#define HDA_CMD_GET_DIGITAL_CONV_FMT_PRO_MASK		0x0040
#define HDA_CMD_GET_DIGITAL_CONV_FMT_PRO_SHIFT		6
#define HDA_CMD_GET_DIGITAL_CONV_FMT_NAUDIO_MASK	0x0020
#define HDA_CMD_GET_DIGITAL_CONV_FMT_NAUDIO_SHIFT	5
#define HDA_CMD_GET_DIGITAL_CONV_FMT_COPY_MASK		0x0010
#define HDA_CMD_GET_DIGITAL_CONV_FMT_COPY_SHIFT		4
#define HDA_CMD_GET_DIGITAL_CONV_FMT_PRE_MASK		0x0008
#define HDA_CMD_GET_DIGITAL_CONV_FMT_PRE_SHIFT		3
#define HDA_CMD_GET_DIGITAL_CONV_FMT_VCFG_MASK		0x0004
#define HDA_CMD_GET_DIGITAL_CONV_FMT_VCFG_SHIFT		2
#define HDA_CMD_GET_DIGITAL_CONV_FMT_V_MASK		0x0002
#define HDA_CMD_GET_DIGITAL_CONV_FMT_V_SHIFT		1
#define HDA_CMD_GET_DIGITAL_CONV_FMT_DIGEN_MASK		0x0001
#define HDA_CMD_GET_DIGITAL_CONV_FMT_DIGEN_SHIFT	0

#define HDA_CMD_GET_DIGITAL_CONV_FMT_CC(rsp)				\
    (((rsp) & HDA_CMD_GET_DIGITAL_CONV_FMT_CC_MASK) >>			\
    HDA_CMD_GET_DIGITAL_CONV_FMT_CC_SHIFT)
#define HDA_CMD_GET_DIGITAL_CONV_FMT_L(rsp)				\
    (((rsp) & HDA_CMD_GET_DIGITAL_CONV_FMT_L_MASK) >>			\
    HDA_CMD_GET_DIGITAL_CONV_FMT_L_SHIFT)
#define HDA_CMD_GET_DIGITAL_CONV_FMT_PRO(rsp)				\
    (((rsp) & HDA_CMD_GET_DIGITAL_CONV_FMT_PRO_MASK) >>			\
    HDA_CMD_GET_DIGITAL_CONV_FMT_PRO_SHIFT)
#define HDA_CMD_GET_DIGITAL_CONV_FMT_NAUDIO(rsp)			\
    (((rsp) & HDA_CMD_GET_DIGITAL_CONV_FMT_NAUDIO_MASK) >>		\
    HDA_CMD_GET_DIGITAL_CONV_FMT_NAUDIO_SHIFT)
#define HDA_CMD_GET_DIGITAL_CONV_FMT_COPY(rsp)				\
    (((rsp) & HDA_CMD_GET_DIGITAL_CONV_FMT_COPY_MASK) >>		\
    HDA_CMD_GET_DIGITAL_CONV_FMT_COPY_SHIFT)
#define HDA_CMD_GET_DIGITAL_CONV_FMT_PRE(rsp)				\
    (((rsp) & HDA_CMD_GET_DIGITAL_CONV_FMT_PRE_MASK) >>			\
    HDA_CMD_GET_DIGITAL_CONV_FMT_PRE_SHIFT)
#define HDA_CMD_GET_DIGITAL_CONV_FMT_VCFG(rsp)				\
    (((rsp) & HDA_CMD_GET_DIGITAL_CONV_FMT_VCFG_MASK) >>		\
    HDA_CMD_GET_DIGITAL_CONV_FMT_VCFG_SHIFT)
#define HDA_CMD_GET_DIGITAL_CONV_FMT_V(rsp)				\
    (((rsp) & HDA_CMD_GET_DIGITAL_CONV_FMT_V_MASK) >>			\
    HDA_CMD_GET_DIGITAL_CONV_FMT_V_SHIFT)
#define HDA_CMD_GET_DIGITAL_CONV_FMT_DIGEN(rsp)				\
    (((rsp) & HDA_CMD_GET_DIGITAL_CONV_FMT_DIGEN_MASK) >>		\
    HDA_CMD_GET_DIGITAL_CONV_FMT_DIGEN_SHIFT)

#define HDA_CMD_SET_DIGITAL_CONV_FMT1_L			0x80
#define HDA_CMD_SET_DIGITAL_CONV_FMT1_PRO		0x40
#define HDA_CMD_SET_DIGITAL_CONV_FMT1_NAUDIO		0x20
#define HDA_CMD_SET_DIGITAL_CONV_FMT1_COPY		0x10
#define HDA_CMD_SET_DIGITAL_CONV_FMT1_PRE		0x08
#define HDA_CMD_SET_DIGITAL_CONV_FMT1_VCFG		0x04
#define HDA_CMD_SET_DIGITAL_CONV_FMT1_V			0x02
#define HDA_CMD_SET_DIGITAL_CONV_FMT1_DIGEN		0x01

/* Power State */
#define HDA_CMD_VERB_GET_POWER_STATE			0xf05
#define HDA_CMD_VERB_SET_POWER_STATE			0x705

#define HDA_CMD_GET_POWER_STATE(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_POWER_STATE, 0x0))
#define HDA_CMD_SET_POWER_STATE(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_POWER_STATE, (payload)))

#define HDA_CMD_POWER_STATE_D0				0x00
#define HDA_CMD_POWER_STATE_D1				0x01
#define HDA_CMD_POWER_STATE_D2				0x02
#define HDA_CMD_POWER_STATE_D3				0x03

#define HDA_CMD_POWER_STATE_ACT_MASK			0x000000f0
#define HDA_CMD_POWER_STATE_ACT_SHIFT			4
#define HDA_CMD_POWER_STATE_SET_MASK			0x0000000f
#define HDA_CMD_POWER_STATE_SET_SHIFT			0

#define HDA_CMD_GET_POWER_STATE_ACT(rsp)				\
    (((rsp) & HDA_CMD_POWER_STATE_ACT_MASK) >>				\
    HDA_CMD_POWER_STATE_ACT_SHIFT)
#define HDA_CMD_GET_POWER_STATE_SET(rsp)				\
    (((rsp) & HDA_CMD_POWER_STATE_SET_MASK) >>				\
    HDA_CMD_POWER_STATE_SET_SHIFT)

#define HDA_CMD_SET_POWER_STATE_ACT(ps)					\
    (((ps) << HDA_CMD_POWER_STATE_ACT_SHIFT) &				\
    HDA_CMD_POWER_STATE_ACT_MASK)
#define HDA_CMD_SET_POWER_STATE_SET(ps)					\
    (((ps) << HDA_CMD_POWER_STATE_SET_SHIFT) &				\
    HDA_CMD_POWER_STATE_ACT_MASK)

/* Converter Stream, Channel */
#define HDA_CMD_VERB_GET_CONV_STREAM_CHAN		0xf06
#define HDA_CMD_VERB_SET_CONV_STREAM_CHAN		0x706

#define HDA_CMD_GET_CONV_STREAM_CHAN(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_CONV_STREAM_CHAN, 0x0))
#define HDA_CMD_SET_CONV_STREAM_CHAN(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_CONV_STREAM_CHAN, (payload)))

#define HDA_CMD_CONV_STREAM_CHAN_STREAM_MASK		0x000000f0
#define HDA_CMD_CONV_STREAM_CHAN_STREAM_SHIFT		4
#define HDA_CMD_CONV_STREAM_CHAN_CHAN_MASK		0x0000000f
#define HDA_CMD_CONV_STREAM_CHAN_CHAN_SHIFT		0

#define HDA_CMD_GET_CONV_STREAM_CHAN_STREAM(rsp)			\
    (((rsp) & HDA_CMD_CONV_STREAM_CHAN_STREAM_MASK) >>			\
    HDA_CMD_CONV_STREAM_CHAN_STREAM_SHIFT)
#define HDA_CMD_GET_CONV_STREAM_CHAN_CHAN(rsp)				\
    (((rsp) & HDA_CMD_CONV_STREAM_CHAN_CHAN_MASK) >>			\
    HDA_CMD_CONV_STREAM_CHAN_CHAN_SHIFT)

#define HDA_CMD_SET_CONV_STREAM_CHAN_STREAM(param)			\
    (((param) << HDA_CMD_CONV_STREAM_CHAN_STREAM_SHIFT) &		\
    HDA_CMD_CONV_STREAM_CHAN_STREAM_MASK)
#define HDA_CMD_SET_CONV_STREAM_CHAN_CHAN(param)			\
    (((param) << HDA_CMD_CONV_STREAM_CHAN_CHAN_SHIFT) &			\
    HDA_CMD_CONV_STREAM_CHAN_CHAN_MASK)

/* Input Converter SDI Select */
#define HDA_CMD_VERB_GET_INPUT_CONVERTER_SDI_SELECT	0xf04
#define HDA_CMD_VERB_SET_INPUT_CONVERTER_SDI_SELECT	0x704

#define HDA_CMD_GET_INPUT_CONVERTER_SDI_SELECT(cad, nid)		\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_INPUT_CONVERTER_SDI_SELECT, 0x0))
#define HDA_CMD_SET_INPUT_CONVERTER_SDI_SELECT(cad, nid, payload)	\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_INPUT_CONVERTER_SDI_SELECT, (payload)))

/* Pin Widget Control */
#define HDA_CMD_VERB_GET_PIN_WIDGET_CTRL		0xf07
#define HDA_CMD_VERB_SET_PIN_WIDGET_CTRL		0x707

#define HDA_CMD_GET_PIN_WIDGET_CTRL(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_PIN_WIDGET_CTRL, 0x0))
#define HDA_CMD_SET_PIN_WIDGET_CTRL(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_PIN_WIDGET_CTRL, (payload)))

#define HDA_CMD_GET_PIN_WIDGET_CTRL_HPHN_ENABLE_MASK	0x00000080
#define HDA_CMD_GET_PIN_WIDGET_CTRL_HPHN_ENABLE_SHIFT	7
#define HDA_CMD_GET_PIN_WIDGET_CTRL_OUT_ENABLE_MASK	0x00000040
#define HDA_CMD_GET_PIN_WIDGET_CTRL_OUT_ENABLE_SHIFT	6
#define HDA_CMD_GET_PIN_WIDGET_CTRL_IN_ENABLE_MASK	0x00000020
#define HDA_CMD_GET_PIN_WIDGET_CTRL_IN_ENABLE_SHIFT	5
#define HDA_CMD_GET_PIN_WIDGET_CTRL_VREF_ENABLE_MASK	0x00000007
#define HDA_CMD_GET_PIN_WIDGET_CTRL_VREF_ENABLE_SHIFT	0

#define HDA_CMD_GET_PIN_WIDGET_CTRL_HPHN_ENABLE(rsp)			\
    (((rsp) & HDA_CMD_GET_PIN_WIDGET_CTRL_HPHN_ENABLE_MASK) >>		\
    HDA_CMD_GET_PIN_WIDGET_CTRL_HPHN_ENABLE_SHIFT)
#define HDA_CMD_GET_PIN_WIDGET_CTRL_OUT_ENABLE(rsp)			\
    (((rsp) & HDA_CMD_GET_PIN_WIDGET_CTRL_OUT_ENABLE_MASK) >>		\
    HDA_GET_CMD_PIN_WIDGET_CTRL_OUT_ENABLE_SHIFT)
#define HDA_CMD_GET_PIN_WIDGET_CTRL_IN_ENABLE(rsp)			\
    (((rsp) & HDA_CMD_GET_PIN_WIDGET_CTRL_IN_ENABLE_MASK) >>		\
    HDA_CMD_GET_PIN_WIDGET_CTRL_IN_ENABLE_SHIFT)
#define HDA_CMD_GET_PIN_WIDGET_CTRL_VREF_ENABLE(rsp)			\
    (((rsp) & HDA_CMD_GET_PIN_WIDGET_CTRL_VREF_ENABLE_MASK) >>		\
    HDA_CMD_GET_PIN_WIDGET_CTRL_VREF_ENABLE_SHIFT)

#define HDA_CMD_SET_PIN_WIDGET_CTRL_HPHN_ENABLE		0x80
#define HDA_CMD_SET_PIN_WIDGET_CTRL_OUT_ENABLE		0x40
#define HDA_CMD_SET_PIN_WIDGET_CTRL_IN_ENABLE		0x20
#define HDA_CMD_SET_PIN_WIDGET_CTRL_VREF_ENABLE_MASK	0x07
#define HDA_CMD_SET_PIN_WIDGET_CTRL_VREF_ENABLE_SHIFT	0

#define HDA_CMD_SET_PIN_WIDGET_CTRL_VREF_ENABLE(param)			\
    (((param) << HDA_CMD_SET_PIN_WIDGET_CTRL_VREF_ENABLE_SHIFT) &	\
    HDA_CMD_SET_PIN_WIDGET_CTRL_VREF_ENABLE_MASK)

#define HDA_CMD_PIN_WIDGET_CTRL_VREF_ENABLE_HIZ		0
#define HDA_CMD_PIN_WIDGET_CTRL_VREF_ENABLE_50		1
#define HDA_CMD_PIN_WIDGET_CTRL_VREF_ENABLE_GROUND	2
#define HDA_CMD_PIN_WIDGET_CTRL_VREF_ENABLE_80		4
#define HDA_CMD_PIN_WIDGET_CTRL_VREF_ENABLE_100		5

/* Unsolicited Response */
#define HDA_CMD_VERB_GET_UNSOLICITED_RESPONSE		0xf08
#define HDA_CMD_VERB_SET_UNSOLICITED_RESPONSE		0x708

#define HDA_CMD_GET_UNSOLICITED_RESPONSE(cad, nid)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_UNSOLICITED_RESPONSE, 0x0))
#define HDA_CMD_SET_UNSOLICITED_RESPONSE(cad, nid, payload)		\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_UNSOLICITED_RESPONSE, (payload)))

#define HDA_CMD_GET_UNSOLICITED_RESPONSE_ENABLE_MASK	0x00000080
#define HDA_CMD_GET_UNSOLICITED_RESPONSE_ENABLE_SHIFT	7
#define HDA_CMD_GET_UNSOLICITED_RESPONSE_TAG_MASK	0x0000001f
#define HDA_CMD_GET_UNSOLICITED_RESPONSE_TAG_SHIFT	0

#define HDA_CMD_GET_UNSOLICITED_RESPONSE_ENABLE(rsp)			\
    (((rsp) & HDA_CMD_GET_UNSOLICITED_RESPONSE_ENABLE_MASK) >>		\
    HDA_CMD_GET_UNSOLICITED_RESPONSE_ENABLE_SHIFT)
#define HDA_CMD_GET_UNSOLICITED_RESPONSE_TAG(rsp)			\
    (((rsp) & HDA_CMD_GET_UNSOLICITED_RESPONSE_TAG_MASK) >>		\
    HDA_CMD_GET_UNSOLICITED_RESPONSE_TAG_SHIFT)

#define HDA_CMD_SET_UNSOLICITED_RESPONSE_ENABLE		0x80
#define HDA_CMD_SET_UNSOLICITED_RESPONSE_TAG_MASK	0x1f
#define HDA_CMD_SET_UNSOLICITED_RESPONSE_TAG_SHIFT	0

#define HDA_CMD_SET_UNSOLICITED_RESPONSE_TAG(param)			\
    (((param) << HDA_CMD_SET_UNSOLICITED_RESPONSE_TAG_SHIFT) &		\
    HDA_CMD_SET_UNSOLICITED_RESPONSE_TAG_MASK)

/* Pin Sense */
#define HDA_CMD_VERB_GET_PIN_SENSE			0xf09
#define HDA_CMD_VERB_SET_PIN_SENSE			0x709

#define HDA_CMD_GET_PIN_SENSE(cad, nid)					\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_PIN_SENSE, 0x0))
#define HDA_CMD_SET_PIN_SENSE(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_PIN_SENSE, (payload)))

#define HDA_CMD_GET_PIN_SENSE_PRESENCE_DETECT_MASK	0x80000000
#define HDA_CMD_GET_PIN_SENSE_PRESENCE_DETECT_SHIFT	31
#define HDA_CMD_GET_PIN_SENSE_IMP_SENSE_MASK		0x7fffffff
#define HDA_CMD_GET_PIN_SENSE_IMP_SENSE_SHIFT		0

#define HDA_CMD_GET_PIN_SENSE_PRESENCE_DETECT(rsp)			\
    (((rsp) & HDA_CMD_GET_PIN_SENSE_PRESENCE_DETECT_MASK) >>		\
    HDA_CMD_GET_PIN_SENSE_PRESENCE_DETECT_SHIFT)
#define HDA_CMD_GET_PIN_SENSE_IMP_SENSE(rsp)				\
    (((rsp) & HDA_CMD_GET_PIN_SENSE_IMP_SENSE_MASK) >>			\
    HDA_CMD_GET_PIN_SENSE_IMP_SENSE_SHIFT)

#define HDA_CMD_GET_PIN_SENSE_IMP_SENSE_INVALID		0x7fffffff

#define HDA_CMD_SET_PIN_SENSE_LEFT_CHANNEL		0x00
#define HDA_CMD_SET_PIN_SENSE_RIGHT_CHANNEL		0x01

/* EAPD/BTL Enable */
#define HDA_CMD_VERB_GET_EAPD_BTL_ENABLE		0xf0c
#define HDA_CMD_VERB_SET_EAPD_BTL_ENABLE		0x70c

#define HDA_CMD_GET_EAPD_BTL_ENABLE(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_EAPD_BTL_ENABLE, 0x0))
#define HDA_CMD_SET_EAPD_BTL_ENABLE(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_EAPD_BTL_ENABLE, (payload)))

#define HDA_CMD_GET_EAPD_BTL_ENABLE_LR_SWAP_MASK	0x00000004
#define HDA_CMD_GET_EAPD_BTL_ENABLE_LR_SWAP_SHIFT	2
#define HDA_CMD_GET_EAPD_BTL_ENABLE_EAPD_MASK		0x00000002
#define HDA_CMD_GET_EAPD_BTL_ENABLE_EAPD_SHIFT		1
#define HDA_CMD_GET_EAPD_BTL_ENABLE_BTL_MASK		0x00000001
#define HDA_CMD_GET_EAPD_BTL_ENABLE_BTL_SHIFT		0

#define HDA_CMD_GET_EAPD_BTL_ENABLE_LR_SWAP(rsp)			\
    (((rsp) & HDA_CMD_GET_EAPD_BTL_ENABLE_LR_SWAP_MASK) >>		\
    HDA_CMD_GET_EAPD_BTL_ENABLE_LR_SWAP_SHIFT)
#define HDA_CMD_GET_EAPD_BTL_ENABLE_EAPD(rsp)				\
    (((rsp) & HDA_CMD_GET_EAPD_BTL_ENABLE_EAPD_MASK) >>			\
    HDA_CMD_GET_EAPD_BTL_ENABLE_EAPD_SHIFT)
#define HDA_CMD_GET_EAPD_BTL_ENABLE_BTL(rsp)				\
    (((rsp) & HDA_CMD_GET_EAPD_BTL_ENABLE_BTL_MASK) >>			\
    HDA_CMD_GET_EAPD_BTL_ENABLE_BTL_SHIFT)

#define HDA_CMD_SET_EAPD_BTL_ENABLE_LR_SWAP		0x04
#define HDA_CMD_SET_EAPD_BTL_ENABLE_EAPD		0x02
#define HDA_CMD_SET_EAPD_BTL_ENABLE_BTL			0x01

/* GPI Data */
#define HDA_CMD_VERB_GET_GPI_DATA			0xf10
#define HDA_CMD_VERB_SET_GPI_DATA			0x710

#define HDA_CMD_GET_GPI_DATA(cad, nid)					\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_GPI_DATA, 0x0))
#define HDA_CMD_SET_GPI_DATA(cad, nid)					\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_GPI_DATA, (payload)))

/* GPI Wake Enable Mask */
#define HDA_CMD_VERB_GET_GPI_WAKE_ENABLE_MASK		0xf11
#define HDA_CMD_VERB_SET_GPI_WAKE_ENABLE_MASK		0x711

#define HDA_CMD_GET_GPI_WAKE_ENABLE_MASK(cad, nid)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_GPI_WAKE_ENABLE_MASK, 0x0))
#define HDA_CMD_SET_GPI_WAKE_ENABLE_MASK(cad, nid, payload)		\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_GPI_WAKE_ENABLE_MASK, (payload)))

/* GPI Unsolicited Enable Mask */
#define HDA_CMD_VERB_GET_GPI_UNSOLICITED_ENABLE_MASK	0xf12
#define HDA_CMD_VERB_SET_GPI_UNSOLICITED_ENABLE_MASK	0x712

#define HDA_CMD_GET_GPI_UNSOLICITED_ENABLE_MASK(cad, nid)		\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_GPI_UNSOLICITED_ENABLE_MASK, 0x0))
#define HDA_CMD_SET_GPI_UNSOLICITED_ENABLE_MASK(cad, nid, payload)	\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_GPI_UNSOLICITED_ENABLE_MASK, (payload)))

/* GPI Sticky Mask */
#define HDA_CMD_VERB_GET_GPI_STICKY_MASK		0xf13
#define HDA_CMD_VERB_SET_GPI_STICKY_MASK		0x713

#define HDA_CMD_GET_GPI_STICKY_MASK(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_GPI_STICKY_MASK, 0x0))
#define HDA_CMD_SET_GPI_STICKY_MASK(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_GPI_STICKY_MASK, (payload)))

/* GPO Data */
#define HDA_CMD_VERB_GET_GPO_DATA			0xf14
#define HDA_CMD_VERB_SET_GPO_DATA			0x714

#define HDA_CMD_GET_GPO_DATA(cad, nid)					\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_GPO_DATA, 0x0))
#define HDA_CMD_SET_GPO_DATA(cad, nid, payload)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_GPO_DATA, (payload)))

/* GPIO Data */
#define HDA_CMD_VERB_GET_GPIO_DATA			0xf15
#define HDA_CMD_VERB_SET_GPIO_DATA			0x715

#define HDA_CMD_GET_GPIO_DATA(cad, nid)					\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_GPIO_DATA, 0x0))
#define HDA_CMD_SET_GPIO_DATA(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_GPIO_DATA, (payload)))

/* GPIO Enable Mask */
#define HDA_CMD_VERB_GET_GPIO_ENABLE_MASK		0xf16
#define HDA_CMD_VERB_SET_GPIO_ENABLE_MASK		0x716

#define HDA_CMD_GET_GPIO_ENABLE_MASK(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_GPIO_ENABLE_MASK, 0x0))
#define HDA_CMD_SET_GPIO_ENABLE_MASK(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_GPIO_ENABLE_MASK, (payload)))

/* GPIO Direction */
#define HDA_CMD_VERB_GET_GPIO_DIRECTION			0xf17
#define HDA_CMD_VERB_SET_GPIO_DIRECTION			0x717

#define HDA_CMD_GET_GPIO_DIRECTION(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_GPIO_DIRECTION, 0x0))
#define HDA_CMD_SET_GPIO_DIRECTION(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_GPIO_DIRECTION, (payload)))

/* GPIO Wake Enable Mask */
#define HDA_CMD_VERB_GET_GPIO_WAKE_ENABLE_MASK		0xf18
#define HDA_CMD_VERB_SET_GPIO_WAKE_ENABLE_MASK		0x718

#define HDA_CMD_GET_GPIO_WAKE_ENABLE_MASK(cad, nid)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_GPIO_WAKE_ENABLE_MASK, 0x0))
#define HDA_CMD_SET_GPIO_WAKE_ENABLE_MASK(cad, nid, payload)		\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_GPIO_WAKE_ENABLE_MASK, (payload)))

/* GPIO Unsolicited Enable Mask */
#define HDA_CMD_VERB_GET_GPIO_UNSOLICITED_ENABLE_MASK	0xf19
#define HDA_CMD_VERB_SET_GPIO_UNSOLICITED_ENABLE_MASK	0x719

#define HDA_CMD_GET_GPIO_UNSOLICITED_ENABLE_MASK(cad, nid)		\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_GPIO_UNSOLICITED_ENABLE_MASK, 0x0))
#define HDA_CMD_SET_GPIO_UNSOLICITED_ENABLE_MASK(cad, nid, payload)	\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_GPIO_UNSOLICITED_ENABLE_MASK, (payload)))

/* GPIO_STICKY_MASK */
#define HDA_CMD_VERB_GET_GPIO_STICKY_MASK		0xf1a
#define HDA_CMD_VERB_SET_GPIO_STICKY_MASK		0x71a

#define HDA_CMD_GET_GPIO_STICKY_MASK(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_GPIO_STICKY_MASK, 0x0))
#define HDA_CMD_SET_GPIO_STICKY_MASK(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_GPIO_STICKY_MASK, (payload)))

/* Beep Generation */
#define HDA_CMD_VERB_GET_BEEP_GENERATION		0xf0a
#define HDA_CMD_VERB_SET_BEEP_GENERATION		0x70a

#define HDA_CMD_GET_BEEP_GENERATION(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_BEEP_GENERATION, 0x0))
#define HDA_CMD_SET_BEEP_GENERATION(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_BEEP_GENERATION, (payload)))

/* Volume Knob */
#define HDA_CMD_VERB_GET_VOLUME_KNOB			0xf0f
#define HDA_CMD_VERB_SET_VOLUME_KNOB			0x70f

#define HDA_CMD_GET_VOLUME_KNOB(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_VOLUME_KNOB, 0x0))
#define HDA_CMD_SET_VOLUME_KNOB(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_VOLUME_KNOB, (payload)))

/* Subsystem ID */
#define HDA_CMD_VERB_GET_SUBSYSTEM_ID			0xf20
#define HDA_CMD_VERB_SET_SUSBYSTEM_ID1			0x720
#define HDA_CMD_VERB_SET_SUBSYSTEM_ID2			0x721
#define HDA_CMD_VERB_SET_SUBSYSTEM_ID3			0x722
#define HDA_CMD_VERB_SET_SUBSYSTEM_ID4			0x723

#define HDA_CMD_GET_SUBSYSTEM_ID(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_SUBSYSTEM_ID, 0x0))
#define HDA_CMD_SET_SUBSYSTEM_ID1(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_SUSBYSTEM_ID1, (payload)))
#define HDA_CMD_SET_SUBSYSTEM_ID2(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_SUSBYSTEM_ID2, (payload)))
#define HDA_CMD_SET_SUBSYSTEM_ID3(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_SUSBYSTEM_ID3, (payload)))
#define HDA_CMD_SET_SUBSYSTEM_ID4(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_SUSBYSTEM_ID4, (payload)))

/* Configuration Default */
#define HDA_CMD_VERB_GET_CONFIGURATION_DEFAULT		0xf1c
#define HDA_CMD_VERB_SET_CONFIGURATION_DEFAULT1		0x71c
#define HDA_CMD_VERB_SET_CONFIGURATION_DEFAULT2		0x71d
#define HDA_CMD_VERB_SET_CONFIGURATION_DEFAULT3		0x71e
#define HDA_CMD_VERB_SET_CONFIGURATION_DEFAULT4		0x71f

#define HDA_CMD_GET_CONFIGURATION_DEFAULT(cad, nid)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_CONFIGURATION_DEFAULT, 0x0))
#define HDA_CMD_SET_CONFIGURATION_DEFAULT1(cad, nid, payload)		\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_CONFIGURATION_DEFAULT1, (payload)))
#define HDA_CMD_SET_CONFIGURATION_DEFAULT2(cad, nid, payload)		\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_CONFIGURATION_DEFAULT2, (payload)))
#define HDA_CMD_SET_CONFIGURATION_DEFAULT3(cad, nid, payload)		\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_CONFIGURATION_DEFAULT3, (payload)))
#define HDA_CMD_SET_CONFIGURATION_DEFAULT4(cad, nid, payload)		\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_CONFIGURATION_DEFAULT4, (payload)))

/* Stripe Control */
#define HDA_CMD_VERB_GET_STRIPE_CONTROL			0xf24
#define HDA_CMD_VERB_SET_STRIPE_CONTROL			0x724

#define HDA_CMD_SET_STRIPE_CONTROL(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_GET_STRIPE_CONTROL, 0x0))
#define HDA_CMD_GET_STRIPE_CONTROL(cad, nid, payload)			\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_SET_STRIPE_CONTROL, (payload)))

/* Function Reset */
#define HDA_CMD_VERB_FUNCTION_RESET			0x7ff

#define HDA_CMD_FUNCTION_RESET(cad, nid)				\
    (HDA_CMD_12BIT((cad), (nid),					\
    HDA_CMD_VERB_FUNCTION_RESET, 0x0))


/****************************************************************************
 * HDA Device Parameters
 ****************************************************************************/

/* Vendor ID */
#define HDA_PARAM_VENDOR_ID				0x00

#define HDA_PARAM_VENDOR_ID_VENDOR_ID_MASK		0xffff0000
#define HDA_PARAM_VENDOR_ID_VENDOR_ID_SHIFT		16
#define HDA_PARAM_VENDOR_ID_DEVICE_ID_MASK		0x0000ffff
#define HDA_PARAM_VENDOR_ID_DEVICE_ID_SHIFT		0

#define HDA_PARAM_VENDOR_ID_VENDOR_ID(param)				\
    (((param) & HDA_PARAM_VENDOR_ID_VENDOR_ID_MASK) >>			\
    HDA_PARAM_VENDOR_ID_VENDOR_ID_SHIFT)
#define HDA_PARAM_VENDOR_ID_DEVICE_ID(param)				\
    (((param) & HDA_PARAM_VENDOR_ID_DEVICE_ID_MASK) >>			\
    HDA_PARAM_VENDOR_ID_DEVICE_ID_SHIFT)

/* Revision ID */
#define HDA_PARAM_REVISION_ID				0x02

#define HDA_PARAM_REVISION_ID_MAJREV_MASK		0x00f00000
#define HDA_PARAM_REVISION_ID_MAJREV_SHIFT		20
#define HDA_PARAM_REVISION_ID_MINREV_MASK		0x000f0000
#define HDA_PARAM_REVISION_ID_MINREV_SHIFT		16
#define HDA_PARAM_REVISION_ID_REVISION_ID_MASK		0x0000ff00
#define HDA_PARAM_REVISION_ID_REVISION_ID_SHIFT		8
#define HDA_PARAM_REVISION_ID_STEPPING_ID_MASK		0x000000ff
#define HDA_PARAM_REVISION_ID_STEPPING_ID_SHIFT		0

#define HDA_PARAM_REVISION_ID_MAJREV(param)				\
    (((param) & HDA_PARAM_REVISION_ID_MAJREV_MASK) >>			\
    HDA_PARAM_REVISION_ID_MAJREV_SHIFT)
#define HDA_PARAM_REVISION_ID_MINREV(param)				\
    (((param) & HDA_PARAM_REVISION_ID_MINREV_MASK) >>			\
    HDA_PARAM_REVISION_ID_MINREV_SHIFT)
#define HDA_PARAM_REVISION_ID_REVISION_ID(param)			\
    (((param) & HDA_PARAM_REVISION_ID_REVISION_ID_MASK) >>		\
    HDA_PARAM_REVISION_ID_REVISION_ID_SHIFT)
#define HDA_PARAM_REVISION_ID_STEPPING_ID(param)			\
    (((param) & HDA_PARAM_REVISION_ID_STEPPING_ID_MASK) >>		\
    HDA_PARAM_REVISION_ID_STEPPING_ID_SHIFT)

/* Subordinate Node Cound */
#define HDA_PARAM_SUB_NODE_COUNT			0x04

#define HDA_PARAM_SUB_NODE_COUNT_START_MASK		0x00ff0000
#define HDA_PARAM_SUB_NODE_COUNT_START_SHIFT		16
#define HDA_PARAM_SUB_NODE_COUNT_TOTAL_MASK		0x000000ff
#define HDA_PARAM_SUB_NODE_COUNT_TOTAL_SHIFT		0

#define HDA_PARAM_SUB_NODE_COUNT_START(param)				\
    (((param) & HDA_PARAM_SUB_NODE_COUNT_START_MASK) >>			\
    HDA_PARAM_SUB_NODE_COUNT_START_SHIFT)
#define HDA_PARAM_SUB_NODE_COUNT_TOTAL(param)				\
    (((param) & HDA_PARAM_SUB_NODE_COUNT_TOTAL_MASK) >>			\
    HDA_PARAM_SUB_NODE_COUNT_TOTAL_SHIFT)

/* Function Group Type */
#define HDA_PARAM_FCT_GRP_TYPE				0x05

#define HDA_PARAM_FCT_GRP_TYPE_UNSOL_MASK		0x00000100
#define HDA_PARAM_FCT_GRP_TYPE_UNSOL_SHIFT		8
#define HDA_PARAM_FCT_GRP_TYPE_NODE_TYPE_MASK		0x000000ff
#define HDA_PARAM_FCT_GRP_TYPE_NODE_TYPE_SHIFT	0

#define HDA_PARAM_FCT_GRP_TYPE_UNSOL(param)				\
    (((param) & HDA_PARAM_FCT_GRP_TYPE_UNSOL_MASK) >>			\
    HDA_PARAM_FCT_GROUP_TYPE_UNSOL_SHIFT)
#define HDA_PARAM_FCT_GRP_TYPE_NODE_TYPE(param)				\
    (((param) & HDA_PARAM_FCT_GRP_TYPE_NODE_TYPE_MASK) >>		\
    HDA_PARAM_FCT_GRP_TYPE_NODE_TYPE_SHIFT)

#define HDA_PARAM_FCT_GRP_TYPE_NODE_TYPE_AUDIO		0x01
#define HDA_PARAM_FCT_GRP_TYPE_NODE_TYPE_MODEM		0x02

/* Audio Function Group Capabilities */
#define HDA_PARAM_AUDIO_FCT_GRP_CAP			0x08

#define HDA_PARAM_AUDIO_FCT_GRP_CAP_BEEP_GEN_MASK	0x00010000
#define HDA_PARAM_AUDIO_FCT_GRP_CAP_BEEP_GEN_SHIFT	16
#define HDA_PARAM_AUDIO_FCT_GRP_CAP_INPUT_DELAY_MASK	0x00000f00
#define HDA_PARAM_AUDIO_FCT_GRP_CAP_INPUT_DELAY_SHIFT	8
#define HDA_PARAM_AUDIO_FCT_GRP_CAP_OUTPUT_DELAY_MASK	0x0000000f
#define HDA_PARAM_AUDIO_FCT_GRP_CAP_OUTPUT_DELAY_SHIFT	0

#define HDA_PARAM_AUDIO_FCT_GRP_CAP_BEEP_GEN(param)			\
    (((param) & HDA_PARAM_AUDIO_FCT_GRP_CAP_BEEP_GEN_MASK) >>		\
    HDA_PARAM_AUDIO_FCT_GRP_CAP_BEEP_GEN_SHIFT)
#define HDA_PARAM_AUDIO_FCT_GRP_CAP_INPUT_DELAY(param)			\
    (((param) & HDA_PARAM_AUDIO_FCT_GRP_CAP_INPUT_DELAY_MASK) >>	\
    HDA_PARAM_AUDIO_FCT_GRP_CAP_INPUT_DELAY_SHIFT)
#define HDA_PARAM_AUDIO_FCT_GRP_CAP_OUTPUT_DELAY(param)			\
    (((param) & HDA_PARAM_AUDIO_FCT_GRP_CAP_OUTPUT_DELAY_MASK) >>	\
    HDA_PARAM_AUDIO_FCT_GRP_CAP_OUTPUT_DELAY_SHIFT)

/* Audio Widget Capabilities */
#define HDA_PARAM_AUDIO_WIDGET_CAP			0x09

#define HDA_PARAM_AUDIO_WIDGET_CAP_TYPE_MASK		0x00f00000
#define HDA_PARAM_AUDIO_WIDGET_CAP_TYPE_SHIFT		20
#define HDA_PARAM_AUDIO_WIDGET_CAP_DELAY_MASK		0x000f0000
#define HDA_PARAM_AUDIO_WIDGET_CAP_DELAY_SHIFT		16
#define HDA_PARAM_AUDIO_WIDGET_CAP_LR_SWAP_MASK		0x00000800
#define HDA_PARAM_AUDIO_WIDGET_CAP_LR_SWAP_SHIFT	11
#define HDA_PARAM_AUDIO_WIDGET_CAP_POWER_CTRL_MASK	0x00000400
#define HDA_PARAM_AUDIO_WIDGET_CAP_POWER_CTRL_SHIFT	10
#define HDA_PARAM_AUDIO_WIDGET_CAP_DIGITAL_MASK		0x00000200
#define HDA_PARAM_AUDIO_WIDGET_CAP_DIGITAL_SHIFT	9
#define HDA_PARAM_AUDIO_WIDGET_CAP_CONN_LIST_MASK	0x00000100
#define HDA_PARAM_AUDIO_WIDGET_CAP_CONN_LIST_SHIFT	8
#define HDA_PARAM_AUDIO_WIDGET_CAP_UNSOL_CAP_MASK	0x00000080
#define HDA_PARAM_AUDIO_WIDGET_CAP_UNSOL_CAP_SHIFT	7
#define HDA_PARAM_AUDIO_WIDGET_CAP_PROC_WIDGET_MASK	0x00000040
#define HDA_PARAM_AUDIO_WIDGET_CAP_PROC_WIDGET_SHIFT	6
#define HDA_PARAM_AUDIO_WIDGET_CAP_STRIPE_MASK		0x00000020
#define HDA_PARAM_AUDIO_WIDGET_CAP_STRIPE_SHIFT		5
#define HDA_PARAM_AUDIO_WIDGET_CAP_FORMAT_OVR_MASK	0x00000010
#define HDA_PARAM_AUDIO_WIDGET_CAP_FORMAT_OVR_SHIFT	4
#define HDA_PARAM_AUDIO_WIDGET_CAP_AMP_OVR_MASK		0x00000008
#define HDA_PARAM_AUDIO_WIDGET_CAP_AMP_OVR_SHIFT	3
#define HDA_PARAM_AUDIO_WIDGET_CAP_OUT_AMP_MASK		0x00000004
#define HDA_PARAM_AUDIO_WIDGET_CAP_OUT_AMP_SHIFT	2
#define HDA_PARAM_AUDIO_WIDGET_CAP_IN_AMP_MASK		0x00000002
#define HDA_PARAM_AUDIO_WIDGET_CAP_IN_AMP_SHIFT		1
#define HDA_PARAM_AUDIO_WIDGET_CAP_STEREO_MASK		0x00000001
#define HDA_PARAM_AUDIO_WIDGET_CAP_STEREO_SHIFT		0

#define HDA_PARAM_AUDIO_WIDGET_CAP_TYPE(param)				\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_TYPE_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_TYPE_SHIFT)
#define HDA_PARAM_AUDIO_WIDGET_CAP_DELAY(param)				\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_DELAY_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_DELAY_SHIFT)
#define HDA_PARAM_AUDIO_WIDGET_CAP_LR_SWAP(param)			\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_LR_SWAP_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_LR_SWAP_SHIFT)
#define HDA_PARAM_AUDIO_WIDGET_CAP_POWER_CTRL(param)			\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_POWER_CTRL_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_POWER_CTRL_SHIFT)
#define HDA_PARAM_AUDIO_WIDGET_CAP_DIGITAL(param)			\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_DIGITAL_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_DIGITAL_SHIFT)
#define HDA_PARAM_AUDIO_WIDGET_CAP_CONN_LIST(param)			\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_CONN_LIST_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_CONN_LIST_SHIFT)
#define HDA_PARAM_AUDIO_WIDGET_CAP_UNSOL_CAP(param)			\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_UNSOL_CAP_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_UNSOL_CAP_SHIFT)
#define HDA_PARAM_AUDIO_WIDGET_CAP_PROC_WIDGET(param)			\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_PROC_WIDGET_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_PROC_WIDGET_SHIFT)
#define HDA_PARAM_AUDIO_WIDGET_CAP_STRIPE(param)			\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_STRIPE_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_STRIPE_SHIFT)
#define HDA_PARAM_AUDIO_WIDGET_CAP_FORMAT_OVR(param)			\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_FORMAT_OVR_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_FORMAT_OVR_SHIFT)
#define HDA_PARAM_AUDIO_WIDGET_CAP_AMP_OVR(param)			\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_AMP_OVR_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_AMP_OVR_SHIFT)
#define HDA_PARAM_AUDIO_WIDGET_CAP_OUT_AMP(param)			\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_OUT_AMP_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_OUT_AMP_SHIFT)
#define HDA_PARAM_AUDIO_WIDGET_CAP_IN_AMP(param)			\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_IN_AMP_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_IN_AMP_SHIFT)
#define HDA_PARAM_AUDIO_WIDGET_CAP_STEREO(param)			\
    (((param) & HDA_PARAM_AUDIO_WIDGET_CAP_STEREO_MASK) >>		\
    HDA_PARAM_AUDIO_WIDGET_CAP_STEREO_SHIFT)

#define HDA_PARAM_AUDIO_WIDGET_CAP_TYPE_AUDIO_OUTPUT	0x0
#define HDA_PARAM_AUDIO_WIDGET_CAP_TYPE_AUDIO_INPUT	0x1
#define HDA_PARAM_AUDIO_WIDGET_CAP_TYPE_AUDIO_MIXER	0x2
#define HDA_PARAM_AUDIO_WIDGET_CAP_TYPE_AUDIO_SELECTOR	0x3
#define HDA_PARAM_AUDIO_WIDGET_CAP_TYPE_PIN_COMPLEX	0x4
#define HDA_PARAM_AUDIO_WIDGET_CAP_TYPE_POWER_WIDGET	0x5
#define HDA_PARAM_AUDIO_WIDGET_CAP_TYPE_VOLUME_WIDGET	0x6
#define HDA_PARAM_AUDIO_WIDGET_CAP_TYPE_BEEP_WIDGET	0x7
#define HDA_PARAM_AUDIO_WIDGET_CAP_TYPE_VENDOR_WIDGET	0xf

/* Supported PCM Size, Rates */

#define HDA_PARAM_SUPP_PCM_SIZE_RATE			0x0a

#define HDA_PARAM_SUPP_PCM_SIZE_RATE_32BIT_MASK		0x00100000
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_32BIT_SHIFT	20
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_24BIT_MASK		0x00080000
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_24BIT_SHIFT	19
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_20BIT_MASK		0x00040000
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_20BIT_SHIFT	18
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_16BIT_MASK		0x00020000
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_16BIT_SHIFT	17
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_8BIT_MASK		0x00010000
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_8BIT_SHIFT		16
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_8KHZ_MASK		0x00000001
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_8KHZ_SHIFT		0
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_11KHZ_MASK		0x00000002
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_11KHZ_SHIFT	1
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_16KHZ_MASK		0x00000004
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_16KHZ_SHIFT	2
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_22KHZ_MASK		0x00000008
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_22KHZ_SHIFT	3
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_32KHZ_MASK		0x00000010
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_32KHZ_SHIFT	4
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_44KHZ_MASK		0x00000020
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_44KHZ_SHIFT	5
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_48KHZ_MASK		0x00000040
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_48KHZ_SHIFT	6
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_88KHZ_MASK		0x00000080
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_88KHZ_SHIFT	7
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_96KHZ_MASK		0x00000100
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_96KHZ_SHIFT	8
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_176KHZ_MASK	0x00000200
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_176KHZ_SHIFT	9
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_192KHZ_MASK	0x00000400
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_192KHZ_SHIFT	10
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_384KHZ_MASK	0x00000800
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_384KHZ_SHIFT	11

#define HDA_PARAM_SUPP_PCM_SIZE_RATE_32BIT(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_32BIT_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_32BIT_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_24BIT(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_24BIT_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_24BIT_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_20BIT(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_20BIT_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_20BIT_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_16BIT(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_16BIT_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_16BIT_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_8BIT(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_8BIT_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_8BIT_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_8KHZ(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_8KHZ_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_8KHZ_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_11KHZ(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_11KHZ_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_11KHZ_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_16KHZ(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_16KHZ_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_16KHZ_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_22KHZ(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_22KHZ_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_22KHZ_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_32KHZ(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_32KHZ_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_32KHZ_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_44KHZ(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_44KHZ_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_44KHZ_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_48KHZ(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_48KHZ_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_48KHZ_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_88KHZ(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_88KHZ_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_88KHZ_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_96KHZ(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_96KHZ_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_96KHZ_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_176KHZ(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_176KHZ_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_176KHZ_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_192KHZ(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_192KHZ_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_192KHZ_SHIFT)
#define HDA_PARAM_SUPP_PCM_SIZE_RATE_384KHZ(param)			\
    (((param) & HDA_PARAM_SUPP_PCM_SIZE_RATE_384KHZ_MASK) >>		\
    HDA_PARAM_SUPP_PCM_SIZE_RATE_384KHZ_SHIFT)

/* Supported Stream Formats */
#define HDA_PARAM_SUPP_STREAM_FORMATS			0x0b

#define HDA_PARAM_SUPP_STREAM_FORMATS_AC3_MASK		0x00000004
#define HDA_PARAM_SUPP_STREAM_FORMATS_AC3_SHIFT		2
#define HDA_PARAM_SUPP_STREAM_FORMATS_FLOAT32_MASK	0x00000002
#define HDA_PARAM_SUPP_STREAM_FORMATS_FLOAT32_SHIFT	1
#define HDA_PARAM_SUPP_STREAM_FORMATS_PCM_MASK		0x00000001
#define HDA_PARAM_SUPP_STREAM_FORMATS_PCM_SHIFT		0

#define HDA_PARAM_SUPP_STREAM_FORMATS_AC3(param)			\
    (((param) & HDA_PARAM_SUPP_STREAM_FORMATS_AC3_MASK) >>		\
    HDA_PARAM_SUPP_STREAM_FORMATS_AC3_SHIFT)
#define HDA_PARAM_SUPP_STREAM_FORMATS_FLOAT32(param)			\
    (((param) & HDA_PARAM_SUPP_STREAM_FORMATS_FLOAT32_MASK) >>		\
    HDA_PARAM_SUPP_STREAM_FORMATS_FLOAT32_SHIFT)
#define HDA_PARAM_SUPP_STREAM_FORMATS_PCM(param)			\
    (((param) & HDA_PARAM_SUPP_STREAM_FORMATS_PCM_MASK) >>		\
    HDA_PARAM_SUPP_STREAM_FORMATS_PCM_SHIFT)

/* Pin Capabilities */
#define HDA_PARAM_PIN_CAP				0x0c

#define HDA_PARAM_PIN_CAP_EAPD_CAP_MASK			0x00010000
#define HDA_PARAM_PIN_CAP_EAPD_CAP_SHIFT		16
#define HDA_PARAM_PIN_CAP_VREF_CTRL_MASK		0x0000ff00
#define HDA_PARAM_PIN_CAP_VREF_CTRL_SHIFT		8
#define HDA_PARAM_PIN_CAP_VREF_CTRL_100_MASK		0x00002000
#define HDA_PARAM_PIN_CAP_VREF_CTRL_100_SHIFT		13
#define HDA_PARAM_PIN_CAP_VREF_CTRL_80_MASK		0x00001000
#define HDA_PARAM_PIN_CAP_VREF_CTRL_80_SHIFT		12
#define HDA_PARAM_PIN_CAP_VREF_CTRL_GROUND_MASK		0x00000400
#define HDA_PARAM_PIN_CAP_VREF_CTRL_GROUND_SHIFT	10
#define HDA_PARAM_PIN_CAP_VREF_CTRL_50_MASK		0x00000200
#define HDA_PARAM_PIN_CAP_VREF_CTRL_50_SHIFT		9
#define HDA_PARAM_PIN_CAP_VREF_CTRL_HIZ_MASK		0x00000100
#define HDA_PARAM_PIN_CAP_VREF_CTRL_HIZ_SHIFT		8
#define HDA_PARAM_PIN_CAP_BALANCED_IO_PINS_MASK		0x00000040
#define HDA_PARAM_PIN_CAP_BALANCED_IO_PINS_SHIFT	6
#define HDA_PARAM_PIN_CAP_INPUT_CAP_MASK		0x00000020
#define HDA_PARAM_PIN_CAP_INPUT_CAP_SHIFT		5
#define HDA_PARAM_PIN_CAP_OUTPUT_CAP_MASK		0x00000010
#define HDA_PARAM_PIN_CAP_OUTPUT_CAP_SHIFT		4
#define HDA_PARAM_PIN_CAP_HEADPHONE_CAP_MASK		0x00000008
#define HDA_PARAM_PIN_CAP_HEADPHONE_CAP_SHIFT		3
#define HDA_PARAM_PIN_CAP_PRESENCE_DETECT_CAP_MASK	0x00000004
#define HDA_PARAM_PIN_CAP_PRESENCE_DETECT_CAP_SHIFT	2
#define HDA_PARAM_PIN_CAP_TRIGGER_REQD_MASK		0x00000002
#define HDA_PARAM_PIN_CAP_TRIGGER_REQD_SHIFT		1
#define HDA_PARAM_PIN_CAP_IMP_SENSE_CAP_MASK		0x00000001
#define HDA_PARAM_PIN_CAP_IMP_SENSE_CAP_SHIFT		0

#define HDA_PARAM_PIN_CAP_EAPD_CAP(param)				\
    (((param) & HDA_PARAM_PIN_CAP_EAPD_CAP_MASK) >>			\
    HDA_PARAM_PIN_CAP_EAPD_CAP_SHIFT)
#define HDA_PARAM_PIN_CAP_VREF_CTRL(param)				\
    (((param) & HDA_PARAM_PIN_CAP_VREF_CTRL_MASK) >>			\
    HDA_PARAM_PIN_CAP_VREF_CTRL_SHIFT)
#define HDA_PARAM_PIN_CAP_VREF_CTRL_100(param)				\
    (((param) & HDA_PARAM_PIN_CAP_VREF_CTRL_100_MASK) >>		\
    HDA_PARAM_PIN_CAP_VREF_CTRL_100_SHIFT)
#define HDA_PARAM_PIN_CAP_VREF_CTRL_80(param)				\
    (((param) & HDA_PARAM_PIN_CAP_VREF_CTRL_80_MASK) >>			\
    HDA_PARAM_PIN_CAP_VREF_CTRL_80_SHIFT)
#define HDA_PARAM_PIN_CAP_VREF_CTRL_GROUND(param)			\
    (((param) & HDA_PARAM_PIN_CAP_VREF_CTRL_GROUND_MASK) >>		\
    HDA_PARAM_PIN_CAP_VREF_CTRL_GROUND_SHIFT)
#define HDA_PARAM_PIN_CAP_VREF_CTRL_50(param)				\
    (((param) & HDA_PARAM_PIN_CAP_VREF_CTRL_50_MASK) >>			\
    HDA_PARAM_PIN_CAP_VREF_CTRL_50_SHIFT)
#define HDA_PARAM_PIN_CAP_VREF_CTRL_HIZ(param)				\
    (((param) & HDA_PARAM_PIN_CAP_VREF_CTRL_HIZ_MASK) >>		\
    HDA_PARAM_PIN_CAP_VREF_CTRL_HIZ_SHIFT)
#define HDA_PARAM_PIN_CAP_BALANCED_IO_PINS(param)			\
    (((param) & HDA_PARAM_PIN_CAP_BALANCED_IO_PINS_MASK) >>		\
    HDA_PARAM_PIN_CAP_BALANCED_IO_PINS_SHIFT)
#define HDA_PARAM_PIN_CAP_INPUT_CAP(param)				\
    (((param) & HDA_PARAM_PIN_CAP_INPUT_CAP_MASK) >>			\
    HDA_PARAM_PIN_CAP_INPUT_CAP_SHIFT)
#define HDA_PARAM_PIN_CAP_OUTPUT_CAP(param)				\
    (((param) & HDA_PARAM_PIN_CAP_OUTPUT_CAP_MASK) >>			\
    HDA_PARAM_PIN_CAP_OUTPUT_CAP_SHIFT)
#define HDA_PARAM_PIN_CAP_HEADPHONE_CAP(param)				\
    (((param) & HDA_PARAM_PIN_CAP_HEADPHONE_CAP_MASK) >>		\
    HDA_PARAM_PIN_CAP_HEADPHONE_CAP_SHIFT)
#define HDA_PARAM_PIN_CAP_PRESENCE_DETECT_CAP(param)			\
    (((param) & HDA_PARAM_PIN_CAP_PRESENCE_DETECT_CAP_MASK) >>		\
    HDA_PARAM_PIN_CAP_PRESENCE_DETECT_CAP_MASK)
#define HDA_PARAM_PIN_CAP_TRIGGER_REQD(param)				\
    (((param) & HDA_PARAM_PIN_CAP_TRIGGER_REQD_MASK) >>			\
    HDA_PARAM_PIN_CAP_TRIGGER_REQD_SHIFT)
#define HDA_PARAM_PIN_CAP_IMP_SENSE_CAP(param)				\
    (((param) & HDA_PARAM_PIN_CAP_IMP_SENSE_CAP_MASK) >>		\
    HDA_PARAM_PIN_CAP_IMP_SENSE_CAP_SHIFT)

/* Input Amplifier Capabilities */
#define HDA_PARAM_INPUT_AMP_CAP				0x0d

#define HDA_PARAM_INPUT_AMP_CAP_MUTE_CAP_MASK		0x80000000
#define HDA_PARAM_INPUT_AMP_CAP_MUTE_CAP_SHIFT		31
#define HDA_PARAM_INPUT_AMP_CAP_STEPSIZE_MASK		0x007f0000
#define HDA_PARAM_INPUT_AMP_CAP_STEPSIZE_SHIFT		16
#define HDA_PARAM_INPUT_AMP_CAP_NUMSTEPS_MASK		0x00007f00
#define HDA_PARAM_INPUT_AMP_CAP_NUMSTEPS_SHIFT		8
#define HDA_PARAM_INPUT_AMP_CAP_OFFSET_MASK		0x0000007f
#define HDA_PARAM_INPUT_AMP_CAP_OFFSET_SHIFT		0

#define HDA_PARAM_INPUT_AMP_CAP_MUTE_CAP(param)				\
    (((param) & HDA_PARAM_INPUT_AMP_CAP_MUTE_CAP_MASK) >>		\
    HDA_PARAM_INPUT_AMP_CAP_MUTE_CAP_SHIFT)
#define HDA_PARAM_INPUT_AMP_CAP_STEPSIZE(param)				\
    (((param) & HDA_PARAM_INPUT_AMP_CAP_STEPSIZE_MASK) >>		\
    HDA_PARAM_INPUT_AMP_CAP_STEPSIZE_SHIFT)
#define HDA_PARAM_INPUT_AMP_CAP_NUMSTEPS(param)				\
    (((param) & HDA_PARAM_INPUT_AMP_CAP_NUMSTEPS_MASK) >>		\
    HDA_PARAM_INPUT_AMP_CAP_NUMSTEPS_SHIFT)
#define HDA_PARAM_INPUT_AMP_CAP_OFFSET(param)				\
    (((param) & HDA_PARAM_INPUT_AMP_CAP_OFFSET_MASK) >>			\
    HDA_PARAM_INPUT_AMP_CAP_OFFSET_SHIFT)

/* Output Amplifier Capabilities */
#define HDA_PARAM_OUTPUT_AMP_CAP			0x12

#define HDA_PARAM_OUTPUT_AMP_CAP_MUTE_CAP_MASK		0x80000000
#define HDA_PARAM_OUTPUT_AMP_CAP_MUTE_CAP_SHIFT		31
#define HDA_PARAM_OUTPUT_AMP_CAP_STEPSIZE_MASK		0x007f0000
#define HDA_PARAM_OUTPUT_AMP_CAP_STEPSIZE_SHIFT		16
#define HDA_PARAM_OUTPUT_AMP_CAP_NUMSTEPS_MASK		0x00007f00
#define HDA_PARAM_OUTPUT_AMP_CAP_NUMSTEPS_SHIFT		8
#define HDA_PARAM_OUTPUT_AMP_CAP_OFFSET_MASK		0x0000007f
#define HDA_PARAM_OUTPUT_AMP_CAP_OFFSET_SHIFT		0

#define HDA_PARAM_OUTPUT_AMP_CAP_MUTE_CAP(param)			\
    (((param) & HDA_PARAM_OUTPUT_AMP_CAP_MUTE_CAP_MASK) >>		\
    HDA_PARAM_OUTPUT_AMP_CAP_MUTE_CAP_SHIFT)
#define HDA_PARAM_OUTPUT_AMP_CAP_STEPSIZE(param)			\
    (((param) & HDA_PARAM_OUTPUT_AMP_CAP_STEPSIZE_MASK) >>		\
    HDA_PARAM_OUTPUT_AMP_CAP_STEPSIZE_SHIFT)
#define HDA_PARAM_OUTPUT_AMP_CAP_NUMSTEPS(param)			\
    (((param) & HDA_PARAM_OUTPUT_AMP_CAP_NUMSTEPS_MASK) >>		\
    HDA_PARAM_OUTPUT_AMP_CAP_NUMSTEPS_SHIFT)
#define HDA_PARAM_OUTPUT_AMP_CAP_OFFSET(param)				\
    (((param) & HDA_PARAM_OUTPUT_AMP_CAP_OFFSET_MASK) >>		\
    HDA_PARAM_OUTPUT_AMP_CAP_OFFSET_SHIFT)

/* Connection List Length */
#define HDA_PARAM_CONN_LIST_LENGTH			0x0e

#define HDA_PARAM_CONN_LIST_LENGTH_LONG_FORM_MASK	0x00000080
#define HDA_PARAM_CONN_LIST_LENGTH_LONG_FORM_SHIFT	7
#define HDA_PARAM_CONN_LIST_LENGTH_LIST_LENGTH_MASK	0x0000007f
#define HDA_PARAM_CONN_LIST_LENGTH_LIST_LENGTH_SHIFT	0

#define HDA_PARAM_CONN_LIST_LENGTH_LONG_FORM(param)			\
    (((param) & HDA_PARAM_CONN_LIST_LENGTH_LONG_FORM_MASK) >>		\
    HDA_PARAM_CONN_LIST_LENGTH_LONG_FORM_SHIFT)
#define HDA_PARAM_CONN_LIST_LENGTH_LIST_LENGTH(param)			\
    (((param) & HDA_PARAM_CONN_LIST_LENGTH_LIST_LENGTH_MASK) >>		\
    HDA_PARAM_CONN_LIST_LENGTH_LIST_LENGTH_SHIFT)

/* Supported Power States */
#define HDA_PARAM_SUPP_POWER_STATES			0x0f

#define HDA_PARAM_SUPP_POWER_STATES_D3_MASK		0x00000008
#define HDA_PARAM_SUPP_POWER_STATES_D3_SHIFT		3
#define HDA_PARAM_SUPP_POWER_STATES_D2_MASK		0x00000004
#define HDA_PARAM_SUPP_POWER_STATES_D2_SHIFT		2
#define HDA_PARAM_SUPP_POWER_STATES_D1_MASK		0x00000002
#define HDA_PARAM_SUPP_POWER_STATES_D1_SHIFT		1
#define HDA_PARAM_SUPP_POWER_STATES_D0_MASK		0x00000001
#define HDA_PARAM_SUPP_POWER_STATES_D0_SHIFT		0

#define HDA_PARAM_SUPP_POWER_STATES_D3(param)				\
    (((param) & HDA_PARAM_SUPP_POWER_STATES_D3_MASK) >>			\
    HDA_PARAM_SUPP_POWER_STATES_D3_SHIFT)
#define HDA_PARAM_SUPP_POWER_STATES_D2(param)				\
    (((param) & HDA_PARAM_SUPP_POWER_STATES_D2_MASK) >>			\
    HDA_PARAM_SUPP_POWER_STATES_D2_SHIFT)
#define HDA_PARAM_SUPP_POWER_STATES_D1(param)				\
    (((param) & HDA_PARAM_SUPP_POWER_STATES_D1_MASK) >>			\
    HDA_PARAM_SUPP_POWER_STATES_D1_SHIFT)
#define HDA_PARAM_SUPP_POWER_STATES_D0(param)				\
    (((param) & HDA_PARAM_SUPP_POWER_STATES_D0_MASK) >>			\
    HDA_PARAM_SUPP_POWER_STATES_D0_SHIFT)

/* Processing Capabilities */
#define HDA_PARAM_PROCESSING_CAP			0x10

#define HDA_PARAM_PROCESSING_CAP_NUMCOEFF_MASK		0x0000ff00
#define HDA_PARAM_PROCESSING_CAP_NUMCOEFF_SHIFT		8
#define HDA_PARAM_PROCESSING_CAP_BENIGN_MASK		0x00000001
#define HDA_PARAM_PROCESSING_CAP_BENIGN_SHIFT		0

#define HDA_PARAM_PROCESSING_CAP_NUMCOEFF(param)			\
    (((param) & HDA_PARAM_PROCESSING_CAP_NUMCOEFF_MASK) >>		\
    HDA_PARAM_PROCESSING_CAP_NUMCOEFF_SHIFT)
#define HDA_PARAM_PROCESSING_CAP_BENIGN(param)				\
    (((param) & HDA_PARAM_PROCESSING_CAP_BENIGN_MASK) >>		\
    HDA_PARAM_PROCESSING_CAP_BENIGN_SHIFT)

/* GPIO Count */
#define HDA_PARAM_GPIO_COUNT				0x11

#define HDA_PARAM_GPIO_COUNT_GPI_WAKE_MASK		0x80000000
#define HDA_PARAM_GPIO_COUNT_GPI_WAKE_SHIFT		31
#define HDA_PARAM_GPIO_COUNT_GPI_UNSOL_MASK		0x40000000
#define HDA_PARAM_GPIO_COUNT_GPI_UNSOL_SHIFT		30
#define HDA_PARAM_GPIO_COUNT_NUM_GPI_MASK		0x00ff0000
#define HDA_PARAM_GPIO_COUNT_NUM_GPI_SHIFT		16
#define HDA_PARAM_GPIO_COUNT_NUM_GPO_MASK		0x0000ff00
#define HDA_PARAM_GPIO_COUNT_NUM_GPO_SHIFT		8
#define HDA_PARAM_GPIO_COUNT_NUM_GPIO_MASK		0x000000ff
#define HDA_PARAM_GPIO_COUNT_NUM_GPIO_SHIFT		0

#define HDA_PARAM_GPIO_COUNT_GPI_WAKE(param)				\
    (((param) & HDA_PARAM_GPIO_COUNT_GPI_WAKE_MASK) >>			\
    HDA_PARAM_GPIO_COUNT_GPI_WAKE_SHIFT)
#define HDA_PARAM_GPIO_COUNT_GPI_UNSOL(param)				\
    (((param) & HDA_PARAM_GPIO_COUNT_GPI_UNSOL_MASK) >>			\
    HDA_PARAM_GPIO_COUNT_GPI_UNSOL_SHIFT)
#define HDA_PARAM_GPIO_COUNT_NUM_GPI(param)				\
    (((param) & HDA_PARAM_GPIO_COUNT_NUM_GPI_MASK) >>			\
    HDA_PARAM_GPIO_COUNT_NUM_GPI_SHIFT)
#define HDA_PARAM_GPIO_COUNT_NUM_GPO(param)				\
    (((param) & HDA_PARAM_GPIO_COUNT_NUM_GPO_MASK) >>			\
    HDA_PARAM_GPIO_COUNT_NUM_GPO_SHIFT)
#define HDA_PARAM_GPIO_COUNT_NUM_GPIO(param)				\
    (((param) & HDA_PARAM_GPIO_COUNT_NUM_GPIO_MASK) >>			\
    HDA_PARAM_GPIO_COUNT_NUM_GPIO_SHIFT)

/* Volume Knob Capabilities */
#define HDA_PARAM_VOLUME_KNOB_CAP			0x13

#define HDA_PARAM_VOLUME_KNOB_CAP_DELTA_MASK		0x00000080
#define HDA_PARAM_VOLUME_KNOB_CAP_DELTA_SHIFT		7
#define HDA_PARAM_VOLUME_KNOB_CAP_NUM_STEPS_MASK	0x0000007f
#define HDA_PARAM_VOLUME_KNOB_CAP_NUM_STEPS_SHIFT	0

#define HDA_PARAM_VOLUME_KNOB_CAP_DELTA(param)				\
    (((param) & HDA_PARAM_VOLUME_KNOB_CAP_DELTA_MASK) >>		\
    HDA_PARAM_VOLUME_KNOB_CAP_DELTA_SHIFT)
#define HDA_PARAM_VOLUME_KNOB_CAP_NUM_STEPS(param)			\
    (((param) & HDA_PARAM_VOLUME_KNOB_CAP_NUM_STEPS_MASK) >>		\
    HDA_PARAM_VOLUME_KNOB_CAP_NUM_STEPS_SHIFT)


#define HDA_CONFIG_DEFAULTCONF_SEQUENCE_MASK		0x00000000f
#define HDA_CONFIG_DEFAULTCONF_ASSOCIATION_MASK		0x0000000f0
#define HDA_CONFIG_DEFAULTCONF_MISC_MASK			0x000000f00
#define HDA_CONFIG_DEFAULTCONF_COLOR_MASK			0x00000f000
#define HDA_CONFIG_DEFAULTCONF_CONNECTION_TYPE_MASK		0x000f00000
#define HDA_CONFIG_DEFAULTCONF_DEVICE_MASK			0x000f00000
#define HDA_CONFIG_DEFAULTCONF_LOCATION_MASK		0x03f000000
#define HDA_CONFIG_DEFAULTCONF_CONNECTIVITY_MASK		0x0c0000000

#define HDA_CONFIG_DEFAULTCONF_CONNECTIVITY_JACK		(0<<30)
#define HDA_CONFIG_DEFAULTCONF_CONNECTIVITY_NONE		(1<<30)
#define HDA_CONFIG_DEFAULTCONF_CONNECTIVITY_FIXED		(2<<30)
#define HDA_CONFIG_DEFAULTCONF_CONNECTIVITY_BOTH		(3<<30)

#define HDA_CONFIG_DEFAULTCONF_DEVICE_LINE_OUT			(0<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_SPEAKER			(1<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_HP_OUT			(2<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_CD			(3<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_SPDIF_OUT			(4<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_DIGITAL_OTHER_OUT		(5<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_MODEM_LINE		(6<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_MODEM_HANDSET		(7<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_LINE_IN			(8<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_AUX			(9<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_MIC_IN			(10<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_TELEPHONY			(11<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_SPDIF_IN			(12<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_DIGITAL_OTHER_IN		(13<<20)
#define HDA_CONFIG_DEFAULTCONF_DEVICE_OTHER			(15<<20)

#endif
