/*---------------------------------------------------------------------------------
Name               : callbacks.c
Author             : Marvin Raaijmakers
Description        : Handles the callbacks of the GUI
Date of last change: 13-Jul-2007
History            : 13-Jul-2007 Added on_keyboard_treeview_selection()
                     28-Jun-2007 Fixed compiler warnings
                     24-Jun-2006 on_keyboard_import_button_clicked() now shows why
                                 importing the keyboard file failed.
                     10-Jan-2006 on_keyboard_import_button_clicked() now checks if
                                 there is a newer version of the keyboard file
                                 available on the system

    Copyright (C) 2005-2007 Marvin Raaijmakers

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

    You can contact me at: marvinr(at)users(dot)sf(dot)net
    (replace (at) by @ and (dot) by .)
-----------------------------------------------------------------------------------*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <gtk/gtk.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"

#include <mxml.h>
#include <keytouch-keyboard.h>
#include <set_data.h>


void
on_keyboard_import_button_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
	char		*file_name;
	KTKeyboardName	keyboard_name;
	struct tm	kbfile_date;
	KTKeyboardModel	*model;
	
	file_name = (char *) get_filename_from_user(_("Import keyboard"), 
	                                  GTK_WINDOW(gtk_widget_get_toplevel(GTK_WIDGET(button))));
	if (file_name != NULL)
	{
		if (read_keyboard (file_name, &keyboard_name, &kbfile_date))
		{
			/* If there is a newer version of the keyboard file
			 * available on the system
			 */
			if (old_keyboard_file(&keyboard_name, &keyboard_list, kbfile_date))
			{
				KTError (_("Cannot import '%s', because a newer version of "
				           "the keyboard file has already been installed."),
				         file_name);
			}
			else
			{
				if (copy_keyboard (file_name, &keyboard_name))
				{
					model = insert_keyboard (&keyboard_name, kbfile_date, &keyboard_list);
					reload_keyboard_treeview (KTGUI_keyboard_treeview(), &keyboard_list, model);
				}
			}
			XmlFree (keyboard_name.model);
			XmlFree (keyboard_name.manufacturer);
		}
		else
		{
			KTError (_("The keyboard file could not be imported because it is invalid:\n%s"), KTGetErrorMsg());
		}
	}
}


void
on_cancel_button_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_main_quit();
	exit (0);
}


void
on_ok_button_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
	GtkTreeView		*keyboard_treeview;
	GtkTreeSelection	*selection;
	GtkTreeModel		*tree_model;
	GtkTreeIter		model_iter, manu_iter;
	KTKeyboardName		keyboard_name;
	
	keyboard_treeview = KTGUI_keyboard_treeview();
	
	selection = gtk_tree_view_get_selection( GTK_TREE_VIEW(keyboard_treeview) );
	if ( gtk_tree_selection_get_selected(selection, &tree_model, &model_iter) ) /* If a keyboard was selected */
	{
		if (gtk_tree_model_iter_parent (tree_model, &manu_iter, &model_iter))
		{
			gtk_tree_model_get (tree_model, &manu_iter,
			                    0, &(keyboard_name.manufacturer),
			                    -1  );
			gtk_tree_model_get (tree_model, &model_iter,
			                    0, &(keyboard_name.model),
			                    -1  );
			if (write_current_keyboard(&keyboard_name))
			{
				/* The current keyboard file was successfully written */
				system ("keytouch-init");
			}
			free (keyboard_name.manufacturer);
			free (keyboard_name.model);
		}
	}
	gtk_main_quit();
	exit (0);
}

gboolean
on_keyboard_dialog_delete_event        (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
	gtk_main_quit();
	exit (0);
}



gboolean
on_keyboard_treeview_selection (GtkTreeSelection *selection,
                                GtkTreeModel     *model,
                                GtkTreePath      *path,
				gboolean         path_currently_selected,
				gpointer         userdata)
{
	GtkTreeIter model_iter, manu_iter;
	gboolean model_selected;
	
	if (gtk_tree_model_get_iter(model, &model_iter, path)) /* If a row was selected */
	{
		model_selected = gtk_tree_model_iter_parent (model, &manu_iter, &model_iter);
	}
	else
	{
		model_selected = FALSE;
	}
	
	return model_selected;
}
