/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2005 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmark-menu-item-list.h 3769 2009-03-16 22:57:11Z ikezoe $
 */

#ifndef __KZ_BOOKMARK_MENU_ITEM_LIST_H__
#define __KZ_BOOKMARK_MENU_ITEM_LIST_H__

#include <gtk/gtk.h>

#include "kz-bookmark-base-menu-item.h"

G_BEGIN_DECLS

#define KZ_TYPE_BOOKMARK_MENU_ITEM_LIST		(kz_bookmark_menu_item_list_get_type ())
#define KZ_BOOKMARK_MENU_ITEM_LIST(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BOOKMARK_MENU_ITEM_LIST, KzBookmarkMenuItemList))
#define KZ_BOOKMARK_MENU_ITEM_LIST_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  KZ_TYPE_BOOKMARK_MENU_ITEM_LIST, KzBookmarkMenuItemListClass))
#define KZ_IS_BOOKMARK_MENU_ITEM_LIST(obj)	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BOOKMARK_MENU_ITEM_LIST))
#define KZ_IS_BOOKMARK_MENU_ITEM_LIST_CLASS(klass)(G_TYPE_CHECK_CLASS_TYPE ((klass),  KZ_TYPE_BOOKMARK_MENU_ITEM_LIST))
#define KZ_BOOKMARK_MENU_ITEM_LIST_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  KZ_TYPE_BOOKMARK_MENU_ITEM_LIST, KzBookmarkMenuItemListClass))

typedef struct _KzBookmarkMenuItemList           KzBookmarkMenuItemList;
typedef struct _KzBookmarkMenuItemListClass      KzBookmarkMenuItemListClass;

struct _KzBookmarkMenuItemList
{
	GObject parent;

	GtkMenuShell *menu_shell;

	KzBookmarkFolder *folder;
	KzWindow   *kz;

	guint initial_children;
};

struct _KzBookmarkMenuItemListClass
{
	GObjectClass parent_class;
};

GType        kz_bookmark_menu_item_list_get_type (void) G_GNUC_CONST;
KzBookmarkMenuItemList *kz_bookmark_menu_item_list_new      (GtkMenuShell *menu_shell, KzWindow *kz, KzBookmark *bookmark);

G_END_DECLS

#endif /* __KZ_BOOKMARK_MENU_ITEM_LIST_H__ */
