/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Takuro Ashie
 *  Copyright (C) 2003-2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "kz-nsbookmark.h"

#include <string.h>
#include <utils.h>

static gboolean kz_nsbookmark_is_supported      (KzBookmarkFile *bookmark,
						 const gchar    *buffer);
static gboolean kz_nsbookmark_parse_from_string (KzBookmarkFile *bookmark,
						 const gchar    *buffer,
						 guint           length,
						 GError        **error);
static gchar   *kz_nsbookmark_parse_bookmark    (KzBookmark     *bookmark,
						 const gchar    *buffer);
/*
static void     kz_nsbookmark_init              (KzBookmark  *bookmark);
*/
static KzBookmarkFileType nsbookmark_file_type =
{
	/* .priority_hint = */ 0,
	/* .file_type     = */ "NSBOOKMARK",
	/* .init          = */ NULL,
	/* .is_supported  = */ kz_nsbookmark_is_supported,
	/* .from_string   = */ kz_nsbookmark_parse_from_string,
	/* .to_string     = */ NULL,
};


KzBookmarkFileType *
kz_nsbookmark_get_file_types (gint idx)
{
	if (idx == 0)
		return &nsbookmark_file_type;
	else
		return NULL;
}


static gboolean
kz_nsbookmark_is_supported(KzBookmarkFile *bookmark, const gchar *buf)
{
	g_return_val_if_fail(buf, FALSE);
	if (g_str_has_prefix(buf, "<!DOCTYPE NETSCAPE-Bookmark"))
		return TRUE;

	return FALSE;
}

/*
static void
kz_nsbookmark_init (KzBookmark *bookmark)
{
	bookmark->flags |= KZ_BOOKMARK_FILE_FLAG;
	g_object_set(G_OBJECT(bookmark),
		     "type", KZ_BOOKMARK_PURE_FOLDER,
		     NULL);
	g_signal_connect(G_OBJECT(bookmark), "notify",
			 G_CALLBACK(kz_nsbookmark_notify), NULL);
	g_signal_connect(G_OBJECT(bookmark), "insert-child",
			 G_CALLBACK(kz_nsbookmark_insert_child), NULL);
}
*/

static gboolean
kz_nsbookmark_parse_from_string (KzBookmarkFile *bookmark,
				 const gchar *buffer, guint length,
				 GError **error)
{
	g_return_val_if_fail(KZ_IS_BOOKMARK(bookmark), FALSE);
	g_return_val_if_fail(buffer, FALSE);

	kz_nsbookmark_parse_bookmark(KZ_BOOKMARK(bookmark), buffer);
	
	return TRUE;
}

static gchar *
kz_nsbookmark_parse_bookmark (KzBookmark *bookmark,
			      const gchar *buffer)
{
	guint len;
	gchar *pos;

	g_return_val_if_fail(KZ_IS_BOOKMARK(bookmark), FALSE);
	g_return_val_if_fail(buffer, FALSE);

	len = strlen(buffer);
	pos = strchr(buffer, '<');
	while (pos)
	{
		if (!strncasecmp(pos, "<H3", 3))
		{
			gchar *folder_title;
			KzBookmark *folder = kz_bookmark_pure_folder_new();

			/* folder title */
			folder_title = xml_get_content(pos);
			if (folder_title)
			{
				kz_bookmark_set_title(folder, folder_title);
				g_free(folder_title);
			}
			pos += 3;
			pos = kz_nsbookmark_parse_bookmark(folder, pos);

			kz_bookmark_append(bookmark, folder);
			g_object_unref(folder);
		}
		else if (!strncasecmp(pos, "<A HREF=", 8))
		{
			gchar *uri, *title;
			KzBookmark *child = kz_bookmark_new();
			uri = xml_get_attr(pos, "HREF");
			if (uri)
			{
				kz_bookmark_set_link(child, uri);
				g_free(uri);
			}
			title = xml_get_content(pos);
			if (title)
			{
				kz_bookmark_set_title(child, title);
				g_free(title);
			}

			kz_bookmark_append(bookmark, child);
			g_object_unref(child);
		}
		else if (!strncasecmp(pos, "<DL>", 4))
		{
			/* beginning of folder. Do nothing! */
		}
		else if (!strncasecmp(pos, "<HR>", 4))
		{
			/* separator */
			KzBookmark *separator = kz_bookmark_separator_new();

			kz_bookmark_append(bookmark, separator);
			g_object_unref(separator);
		}
		else if (!strncasecmp(pos, "</DL>", 4))
		{
			/* end of folder*/
			pos = strchr(pos + 1, '<');
			break;
		}
		pos = strchr(pos + 1, '<'); 
	}
	return pos;
}
