/*
 * %kadu copyright begin%
 * Copyright 2010, 2011 Piotr Dąbrowski (ultr@ultr.pl)
 * Copyright 2010 Piotr Galiszewski (piotr.galiszewski@kadu.im)
 * Copyright 2010 Rafał Malinowski (rafal.przemyslaw.malinowski@gmail.com)
 * %kadu copyright end%
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "accounts/account.h"
#include "avatars/avatar.h"
#include "buddies/buddy-preferred-manager.h"
#include "icons/kadu-icon.h"
#include "misc/path-conversion.h"
#include "parser/parser.h"
#include "protocols/protocol.h"
#include "status/status-type-manager.h"

#include "contact-parser-tags.h"

static QString getAvatarPath(BuddyOrContact buddyOrContact)
{
	Avatar avatar;
	if (BuddyOrContact::ItemBuddy == buddyOrContact.type())
		avatar = buddyOrContact.buddy().buddyAvatar();

	if (!avatar || avatar.pixmap().isNull())
		avatar = buddyOrContact.contact().contactAvatar();

	if (!avatar || avatar.pixmap().isNull())
		return QString();

	return webKitPath(avatar.filePath());
}

static QString getStatusIconPath(BuddyOrContact buddyOrContact)
{
	Buddy buddy = buddyOrContact.buddy();
	Contact contact = buddyOrContact.contact();

	if (buddy.isBlocked())
		return KaduIcon("kadu_icons", "16x16", "blocked").webKitPath();

	if (contact.isBlocking())
		return KaduIcon("kadu_icons", "16x16", "blocking").webKitPath();

	if (contact.contactAccount())
	{
		Protocol *protocol = contact.contactAccount().protocolHandler();
		if (protocol)
		{
			const Status &status = contact.currentStatus();
			return StatusTypeManager::instance()->statusIcon(
					protocol->statusPixmapPath(), status.type(), !status.description().isEmpty(), false).webKitPath();
		}
	}

	return QString();
}

void ContactParserTags::registerParserTags()
{
	Parser::registerTag("avatarPath", getAvatarPath);
	Parser::registerTag("statusIconPath", getStatusIconPath);
}

void ContactParserTags::unregisterParserTags()
{
	Parser::unregisterTag("avatarPath");
	Parser::unregisterTag("statusIconPath");
}
