/* IMSpector - Instant Messenger Transparent Proxy Service
 * http://www.imspector.org/
 * (c) Lawrence Manning <lawrence@aslak.net>, 2006
 *          
 * Released under the GPL v2. */

#include "imspector.h"

bool Options::readoptionsfile(std::string filename)
{
	FILE *hfile = NULL;
	char buffer[STRING_SIZE];
	char *equals;
	
	memset(buffer, 0, STRING_SIZE);
	
	if (!(hfile = fopen(filename.c_str(), "r")))
		return false;
		
	while (fgets(buffer, STRING_SIZE, hfile))
	{
		/* Remove the \n. */
		char *t = strchr(buffer, '\n');
        if (t) *t = '\0';		
        
		/* Ignore lines with no equal signs or comment lines. */
		if (buffer[0] == '#') continue;
		if (!(equals = strchr(buffer, '='))) continue;

		*equals = '\0';
		
		params[buffer] = equals + 1;
	}
	
	fclose(hfile);
	
	return true;
}

std::string Options::operator[](const char *key)
{
	return params[key];
}

std::vector<std::string> Options::getkeys(void)
{
	std::vector<std::string> keys;
	
	for (std::map<std::string, std::string>::iterator i = params.begin();
		i != params.end(); i++)
	{
		keys.push_back((*i).first);
	}
	
	return keys;
}
