module Hat.Data.IORef
  (IORef(),gnewIORef,anewIORef,hnewIORef,greadIORef,areadIORef,hreadIORef
    ,gwriteIORef,awriteIORef,hwriteIORef,gmodifyIORef,amodifyIORef
    ,hmodifyIORef) where

import qualified Hat.PreludeBasic 
import qualified Prelude 
import Hat.Hack 
import qualified Hat.Hat as T 
import Hat.Hat  (WrapVal(wrapVal))
import Hat.Prelude 
import Hat.Data.IORefBuiltin 
import Hat.PreludeBuiltinTypes 
import qualified Data.IORef 

gnewIORef :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun a (IO (IORef a)))

gnewIORef pnewIORef p = T.ufun1 anewIORef pnewIORef p hnewIORef

hnewIORef z1newIORef knewIORef =
  (T.fromIO (fromIORef T.fromId)) knewIORef
    (Data.IORef.newIORef (T.toId knewIORef z1newIORef))

greadIORef :: T.RefSrcPos -> T.RefExp -> T.R (T.Fun (IORef a) (IO a))

greadIORef preadIORef p = T.ufun1 areadIORef preadIORef p hreadIORef

hreadIORef z1readIORef kreadIORef =
  (T.fromIO T.fromId) kreadIORef
    (Data.IORef.readIORef ((toIORef T.toId) kreadIORef z1readIORef))

gwriteIORef ::
  T.RefSrcPos -> T.RefExp -> T.R (T.Fun (IORef a) (T.Fun a (IO T.Tuple0)))

gwriteIORef pwriteIORef p = T.ufun2 awriteIORef pwriteIORef p hwriteIORef

hwriteIORef z1writeIORef z2writeIORef kwriteIORef =
  (T.fromIO T.fromTuple0) kwriteIORef
    (Data.IORef.writeIORef ((toIORef T.toId) kwriteIORef z1writeIORef)
      (T.toId kwriteIORef z2writeIORef))

gmodifyIORef ::
  T.RefSrcPos ->
    T.RefExp -> T.R (T.Fun (IORef a) (T.Fun (T.Fun a a) (IO T.Tuple0)))

gmodifyIORef pmodifyIORef p = T.ufun2 amodifyIORef pmodifyIORef p hmodifyIORef

hmodifyIORef z1modifyIORef z2modifyIORef kmodifyIORef =
  (T.fromIO T.fromTuple0) kmodifyIORef
    (Data.IORef.modifyIORef ((toIORef T.toId) kmodifyIORef z1modifyIORef)
      ((toFun T.fromId T.toId) kmodifyIORef z2modifyIORef))

tData_IORef = T.mkModule "Data.IORef" "Data/IORef.hs" Prelude.False

anewIORef = T.mkVariable tData_IORef 180001 190034 3 1 "newIORef" Prelude.False

areadIORef =
  T.mkVariable tData_IORef 200001 210040 3 1 "readIORef" Prelude.False

awriteIORef =
  T.mkVariable tData_IORef 220001 230045 3 2 "writeIORef" Prelude.False

amodifyIORef =
  T.mkVariable tData_IORef 240001 250050 3 2 "modifyIORef" Prelude.False
