#include <bindings.dsl.h>
#include <zip.h>

-- | This module provides automatic low-level bindings to @libzip@ library.
-- See also:
--
--   * @libzip@ documention: <http://nih.at/libzip/libzip.html> and @zip.h@
--
--   * @bindings-DSL@ documentation:
--     <http://bitbucket.org/mauricio/bindings-dsl/wiki/Home>
--
-- Higher-level interface is provided by a separate LibZip package:
--
--   * <http://hackage.haskell.org/package/LibZip>
--

module Bindings.LibZip where
#strict_import

#opaque_t zip
#opaque_t zip_file
#opaque_t zip_source

-- flags for zip_open

#num ZIP_CREATE
#num ZIP_EXCL
#num ZIP_CHECKCONS

-- flags for zip_name_locate, zip_fopen, zip_stat, ...

#num ZIP_FL_NOCASE
#num ZIP_FL_NODIR
#num ZIP_FL_COMPRESSED
#num ZIP_FL_UNCHANGED
#num ZIP_FL_RECOMPRESS

-- archive global flags flags

#num ZIP_AFL_TORRENT

-- libzip error codes

#num ZIP_ER_OK
#num ZIP_ER_MULTIDISK
#num ZIP_ER_RENAME
#num ZIP_ER_CLOSE
#num ZIP_ER_SEEK
#num ZIP_ER_READ
#num ZIP_ER_WRITE
#num ZIP_ER_CRC
#num ZIP_ER_ZIPCLOSED
#num ZIP_ER_NOENT
#num ZIP_ER_EXISTS
#num ZIP_ER_OPEN
#num ZIP_ER_TMPOPEN
#num ZIP_ER_ZLIB
#num ZIP_ER_MEMORY
#num ZIP_ER_CHANGED
#num ZIP_ER_COMPNOTSUPP
#num ZIP_ER_EOF
#num ZIP_ER_INVAL
#num ZIP_ER_NOZIP
#num ZIP_ER_INTERNAL
#num ZIP_ER_INCONS
#num ZIP_ER_REMOVE
#num ZIP_ER_DELETED

-- type of system error value

#num ZIP_ET_NONE
#num ZIP_ET_SYS
#num ZIP_ET_ZLIB

-- compression methods

#num ZIP_CM_DEFAULT
#num ZIP_CM_STORE
#num ZIP_CM_SHRINK
#num ZIP_CM_REDUCE_1
#num ZIP_CM_REDUCE_2
#num ZIP_CM_REDUCE_3
#num ZIP_CM_REDUCE_4
#num ZIP_CM_IMPLODE
#num ZIP_CM_DEFLATE
#num ZIP_CM_DEFLATE64
#num ZIP_CM_PKWARE_IMPLODE
#num ZIP_CM_BZIP2
#num ZIP_CM_LZMA
#num ZIP_CM_TERSE
#num ZIP_CM_LZ77
#num ZIP_CM_WAVPACK
#num ZIP_CM_PPMD

-- encryption methods

#num ZIP_EM_NONE
#num ZIP_EM_TRAD_PKWARE
#num ZIP_EM_UNKNOWN

#integral_t enum zip_source_cmd
#num ZIP_SOURCE_OPEN
#num ZIP_SOURCE_READ
#num ZIP_SOURCE_CLOSE
#num ZIP_SOURCE_STAT
#num ZIP_SOURCE_ERROR
#num ZIP_SOURCE_FREE

-- typedef ssize_t (*zip_source_callback)(void *state, void *data,
--                                        size_t len, enum zip_source_cmd cmd);
#callback zip_source_callback , Ptr () -> Ptr () -> CSize -> <zip_source_cmd> -> IO CSize

#opaque_t time_t

#starttype struct zip_stat
#field name, Ptr CChar
#field index, CInt
#field crc, CUInt
#field mtime, CTime
#field size, CSize
#field comp_size, CSize
#field comp_method, CUShort
#field encryption_method, CUShort
#stoptype

-- int zip_add(struct zip *, const char *, struct zip_source *);
#ccall zip_add , Ptr <zip> -> CString -> Ptr <zip_source> -> IO CInt

-- int zip_add_dir(struct zip *, const char *);
#ccall zip_add_dir , Ptr <zip> -> CString -> IO CInt

-- int zip_close(struct zip *);
#ccall zip_close , Ptr <zip> -> IO CInt

-- int zip_delete(struct zip *, int);
#ccall zip_delete , Ptr <zip> -> CInt -> IO CInt

-- void zip_error_clear(struct zip *);
#ccall zip_error_clear , Ptr <zip> -> IO ()

-- void zip_error_get(struct zip *, int *, int *);
#ccall zip_error_get , Ptr <zip> -> Ptr CInt -> Ptr CInt -> IO ()

-- int zip_error_get_sys_type(int);
#ccall zip_error_get_sys_type , CInt -> IO CInt

-- int zip_error_to_str(char *, size_t, int, int);
#ccall zip_error_to_str , Ptr Char -> CSize -> CInt -> CInt -> IO CInt

-- int zip_fclose(struct zip_file *);
#ccall zip_fclose , Ptr <zip_file> -> IO CInt

-- void zip_file_error_clear(struct zip_file *);
#ccall zip_file_error_clear , Ptr <zip_file> -> IO ()

-- void zip_file_error_get(struct zip_file *, int *, int *);
#ccall zip_file_error_get , Ptr <zip_file> -> Ptr CInt -> Ptr CInt -> IO ()

-- const char *zip_file_strerror(struct zip_file *);
#ccall zip_file_strerror , Ptr <zip_file> -> IO CString

-- struct zip_file *zip_fopen(struct zip *, const char *, int);
#ccall zip_fopen , Ptr <zip> -> CString -> CInt -> IO (Ptr <zip_file>)

-- struct zip_file *zip_fopen_index(struct zip *, int, int);
#ccall zip_fopen_index , Ptr <zip> -> CInt -> CInt -> IO (Ptr <zip_file>)

-- ssize_t zip_fread(struct zip_file *, void *, size_t);
#ccall zip_fread , Ptr <zip_file> -> Ptr () -> CSize -> IO CSize

-- const char *zip_get_archive_comment(struct zip *, int *, int);
#ccall zip_get_archive_comment , Ptr <zip> -> Ptr CInt -> CInt -> IO CString

-- int zip_get_archive_flag(struct zip *, int, int);
#ccall zip_get_archive_flag , Ptr <zip> -> CInt -> CInt -> IO CInt

-- const char *zip_get_file_comment(struct zip *, int, int *, int);
#ccall zip_get_file_comment , Ptr <zip> -> CInt -> Ptr CInt -> CInt -> IO CString

-- const char *zip_get_name(struct zip *, int, int);
#ccall zip_get_name , Ptr <zip> -> CInt -> CInt -> IO CString

-- int zip_get_num_files(struct zip *);
#ccall zip_get_num_files , Ptr <zip> -> IO CInt

-- int zip_name_locate(struct zip *, const char *, int);
#ccall zip_name_locate , Ptr <zip> -> CString -> CInt -> IO CInt

-- struct zip *zip_open(const char *, int, int *);
#ccall zip_open , CString -> CInt -> Ptr CInt -> IO (Ptr <zip>)

-- int zip_rename(struct zip *, int, const char *);
#ccall zip_rename , Ptr <zip> -> CInt -> CString -> IO CInt

-- int zip_replace(struct zip *, int, struct zip_source *);
#ccall zip_replace , Ptr <zip> -> CInt -> Ptr <zip_source> -> IO CInt

-- int zip_set_archive_comment(struct zip *, const char *, int);
#ccall zip_set_archive_comment , Ptr <zip> -> CString -> CInt -> IO CInt

-- int zip_set_archive_flag(struct zip *, int, int);
#ccall zip_set_archive_flag , Ptr <zip> -> CInt -> CInt -> IO CInt

-- int zip_set_file_comment(struct zip *, int, const char *, int);
#ccall zip_set_file_comment , Ptr <zip> -> CInt -> CString -> CInt -> IO CInt

-- struct zip_source *zip_source_buffer(struct zip *, const void *, off_t, int);
#ccall zip_source_buffer , Ptr <zip> -> Ptr () -> CSize -> CInt -> IO (Ptr <zip_source>)

-- struct zip_source *zip_source_file(struct zip *, const char *, off_t, off_t);
#ccall zip_source_file , Ptr <zip> -> CString -> CSize -> CSize -> IO (Ptr <zip_source>)

-- struct zip_source *zip_source_filep(struct zip *, FILE *, off_t, off_t);
#ccall zip_source_filep , Ptr <zip> -> Ptr CFile -> CSize -> CSize -> IO (Ptr <zip_source>)

-- void zip_source_free(struct zip_source *);
#ccall zip_source_free , Ptr <zip_source> -> IO ()

-- struct zip_source *zip_source_function(struct zip *, zip_source_callback, void *);
#ccall zip_source_function , Ptr <zip> -> <zip_source_callback> -> Ptr () -> IO (Ptr <zip_source>)

-- struct zip_source *zip_source_zip(struct zip *, struct zip *, int, int, off_t, off_t);
#ccall zip_source_zip , Ptr <zip> -> Ptr <zip> -> CInt -> CInt -> CSize -> CSize -> IO (Ptr <zip_source>)

-- int zip_stat(struct zip *, const char *, int, struct zip_stat *);
#ccall zip_stat , Ptr <zip> -> CString -> CInt -> Ptr <zip_stat> -> IO CInt

-- int zip_stat_index(struct zip *, int, int, struct zip_stat *);
#ccall zip_stat_index , Ptr <zip> -> CInt -> CInt -> Ptr <zip_stat> -> IO CInt

-- void zip_stat_init(struct zip_stat *);
#ccall zip_stat_init , Ptr <zip_stat> -> IO ()

-- const char *zip_strerror(struct zip *);
#ccall zip_strerror , Ptr <zip> -> IO CString

-- int zip_unchange(struct zip *, int);
#ccall zip_unchange , Ptr <zip> -> CInt -> IO CInt

-- int zip_unchange_all(struct zip *);
#ccall zip_unchange_all , Ptr <zip> -> IO CInt

-- int zip_unchange_archive(struct zip *);
#ccall zip_unchange_archive , Ptr <zip> -> IO CInt

