;--------------------------------
;General
!define GPAC_VERSION	0.4.6-DEV
!include default.out

!define GPAC_ROOT ..\..\..\..

InstallDir "$PROGRAMFILES\GPAC"
InstallDirRegKey HKCU "SOFTWARE\GPAC" "InstallDir"

RequestExecutionLevel user


;--------------------------------
;Include Modern UI

  !include "MUI2.nsh"

WindowIcon on
Icon "..\..\..\..\doc\osmo4.ico"
UninstallIcon "..\..\..\..\doc\osmo4.ico"


;--------------------------------
;Interface Settings

  !define MUI_ABORTWARNING

Var DIALOG
Var Label
Var Confirm

LangString PAGE_TITLE ${LANG_ENGLISH} "Title"
LangString PAGE_SUBTITLE ${LANG_ENGLISH} "Subtitle"

Function EnableNext
  Pop $R1
  ${NSD_GetState} $Confirm $R1
	GetDlgItem $0 $HWNDPARENT 1
	${If} $R1 == ${BST_CHECKED}
   EnableWindow $0 1
  ${Else} 
   EnableWindow $0 0
  ${Endif} 
FunctionEnd

Function customPage
	!insertmacro MUI_HEADER_TEXT "Patents and Royalties" "Please read carefully the following clause."
	GetDlgItem $0 $HWNDPARENT 1
	EnableWindow $0 0
	nsDialogs::Create 1018
	Pop $DIALOG

  ${NSD_CreateLabel} 0 0 100% 120u "Multimedia technologies are often covered by various patents which are most of the time hard to identify. These patents may or may not apply in your local jurisdiction. By installing this software, you acknowledge that you may have to pay royaltee fees in order to legally use this software. Do not proceed with this setup if you do not understand or do not agree with these terms. In any case, the authors and/or distributors bears no liability for any infringing usage of this software, which is provided for educational or research purposes."
	Pop $Label

  ${NSD_CreateCheckBox} 0 -30 100% 12u "I understand and accept the conditions"
  Pop $Confirm
	GetFunctionAddress $0 EnableNext
	nsDialogs::OnClick $Confirm $0
  
  
  nsDialogs::Show
FunctionEnd

;--------------------------------
;Pages

  !insertmacro MUI_PAGE_WELCOME
  !insertmacro MUI_PAGE_LICENSE "${GPAC_ROOT}\COPYING" 
  Page custom customPage
  !insertmacro MUI_PAGE_COMPONENTS
  !insertmacro MUI_PAGE_DIRECTORY
    
  !insertmacro MUI_PAGE_INSTFILES
  !insertmacro MUI_PAGE_FINISH
  
  !insertmacro MUI_UNPAGE_CONFIRM
  !insertmacro MUI_UNPAGE_INSTFILES

  !insertmacro MUI_LANGUAGE "English"

ComponentText "This will install the GPAC Framework on your computer. Select which optional things you want installed."
DirText "This will install the GPAC Framework on your computer. Choose a directory"


Function FctWriteRegStrAuth
   ;local var
   Push $0
   Push $R0
   Push $R1
   Push $R2
   Push $R3
   ;pop function arguments
   Exch 5
   Pop $R3
   Exch 5
   Pop $R2
   Exch 5
   Pop $R1
   Exch 5
   Pop $R0

   ;test if calling HKCR
   StrCmp $R0 "HKCR" +1 +3
   WriteRegStr HKCR $R1 $R2 $R3
   goto lbl_end
   
   #has current user admin privileges?
   userInfo::getAccountType
   Pop $0
   StrCmp $0 "Admin" lbl_admin lbl_not_admin

   lbl_admin:
      WriteRegStr HKLM $R1 $R2 $R3
      goto lbl_end

   lbl_not_admin:
      WriteRegStr HKCU $R1 $R2 $R3

   lbl_end:
      Pop $R3
      Pop $R2
      Pop $R1
      Pop $R0
      Pop $0
FunctionEnd

!macro WriteRegStrAuth HKREG SUBREG ENTRY VALUESTR
    Push "${HKREG}"
    Push "${SUBREG}"
    Push "${ENTRY}"
    Push "${VALUESTR}"
    Call FctWriteRegStrAuth
!macroend
 
!define WriteRegStrAuth "!insertmacro WriteRegStrAuth"


Function un.FctDeleteRegKeyAuth
   ;local var
   Push $0
   Push $R0
   Push $R1
   ;pop function arguments
   Exch 3
   Pop $R1
   Exch 3
   Pop $R0

   ;test if calling HKCR
   StrCmp $R0 "HKCR" +1 +3
   DeleteRegKey HKCR $R1
   goto lbl_end
   
   #has current user admin privileges?
   userInfo::getAccountType
   Pop $0
   StrCmp $0 "Admin" lbl_admin lbl_not_admin
   
   lbl_admin:
      DeleteRegKey HKLM $R1
      goto lbl_end
   
   lbl_not_admin:
      DeleteRegKey HKCU $R1

   lbl_end:
      Pop $0
      Pop $R1
      Pop $R0
FunctionEnd

!macro DeleteRegKeyAuth HKREG SUBREG
    Push "${HKREG}"
    Push "${SUBREG}"
    Call un.FctDeleteRegKeyAuth
!macroend
 
!define DeleteRegKeyAuth "!insertmacro DeleteRegKeyAuth"


Function InsertGDIPLUS
   Push $R0
   Push $R1
   ReadRegStr $R0 HKLM "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion
   StrCmp $R0 "" 0 lbl_winnt

   ;NOT NT
   ReadRegStr $R0 HKLM SOFTWARE\Microsoft\Windows\CurrentVersion VersionNumber

   StrCpy $R1 $R0 1
   ; win95, NOT SUPPORTED
   StrCmp $R1 '4' 0 lbl_err_95
   StrCpy $R1 $R0 3
   StrCmp $R1 '4.0' lbl_err_95
   ;winME or 98 otherwise
   StrCmp $R1 '4.9' lbl_add lbl_add

lbl_err_nt:
   MessageBox MB_OK "Microsoft GDI+ cannot be installed on NT 3 Systems"
   Goto lbl_done

lbl_err_95:
   MessageBox MB_OK "Microsoft GDI+ cannot be installed on Windows 95 and older Systems"
   Goto lbl_done

lbl_winnt:
   StrCpy $R1 $R0 1
   StrCmp $R1 '3' lbl_err_nt
   StrCmp $R1 '4' lbl_add
   StrCpy $R1 $R0 3
   StrCmp $R1 '5.0' lbl_add	;2000
   StrCmp $R1 '5.1' lbl_xp	;XP
   StrCmp $R1 '5.2' lbl_done	;.NET server

lbl_add:
   File ".\Gdiplus.dll"

lbl_xp:
   File "..\gm_gdip_raster.dll"

lbl_done:
FunctionEnd


;osmo4 install
Section "Osmo4/GPAC Player" SecOsmo4
  SectionIn RO
  SetOutPath $INSTDIR

  File /oname=ReadMe.txt "${GPAC_ROOT}\README"
  File /oname=License.txt "${GPAC_ROOT}\COPYING"
  File /oname=Changelog.txt "${GPAC_ROOT}\Changelog"
  File "${GPAC_ROOT}\doc\configuration.html"
  File "${GPAC_ROOT}\doc\gpac.mp4"

  File "..\Osmo4.exe"
  File "..\..\..\..\doc\osmo4.ico"
  File "..\libgpac.dll"
  File "..\gm_dummy_in.dll"
  File "..\gm_dx_hw.dll"
  File "..\js32.dll"
  File "..\gm_gpac_js.dll"
  File "..\libeay32.dll"
  File "..\ssleay32.dll"
  File "..\gm_ismacryp.dll"

  ;create default cache
  SetOutPath $INSTDIR\cache


  ;copy GUI
  SetOutPath $INSTDIR\gui
  File "..\..\..\..\gui\gui.bt"
  File "..\..\..\..\gui\gui.js"
  File "..\..\..\..\gui\gwlib.js"
  File "..\..\..\..\gui\mpegu-core.js"
  SetOutPath $INSTDIR\gui\icons
  File /r /x .svn ..\..\..\..\gui\icons\*
  SetOutPath $INSTDIR\gui\extensions
  File /r /x .svn ..\..\..\..\gui\extensions\*

  SetOutPath $INSTDIR
  
  ${WriteRegStrAuth} HKCU "SOFTWARE\GPAC" "InstallDir" "$INSTDIR"
  ${WriteRegStrAuth} HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\Osmo4" "DisplayName" "Osmo4/GPAC (remove only)"
  ${WriteRegStrAuth} HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\Osmo4" "UninstallString" "$INSTDIR\uninstall.exe"
  WriteUninstaller "uninstall.exe"

SectionEnd

SubSection "GPAC Plugins" SecPlugins


;
;	2 install modes, normal one and full one

Section "MPEG-4 BIFS Decoder" SecBIFS
  SectionIn 1
  File "..\gm_bifs_dec.dll"
SectionEnd

Section "MPEG-4 ODF Decoder" SecODF
  SectionIn 1
  File "..\gm_odf_dec.dll"
SectionEnd

Section "MPEG-4 LASeR Decoder" SecLASeR
  SectionIn 1
  File "..\gm_laser_dec.dll"
SectionEnd

Section "MPEG-4 SAF Demultiplexer" SecSAF
  SectionIn 1
  File "..\gm_saf_in.dll"
SectionEnd

Section "Textual MPEG-4 Loader" SecTextLoad
  SectionIn 1
  File "..\gm_ctx_load.dll"
SectionEnd

Section "Image Package (PNG, JPEG, BMP)" SecIMG
  SectionIn 1
  File "..\gm_img_in.dll"
SectionEnd

Section "AAC Audio" SecAAC
  SectionIn 1
  File "..\gm_aac_in.dll"
SectionEnd

Section "MP3 Audio" SecMP3
  SectionIn 1
  File "..\gm_mp3_in.dll"
SectionEnd

Section "AC3 Audio" SecAC3
  SectionIn 1
  File "..\gm_ac3_in.dll"
SectionEnd

Section "FFMPEG" SecFFMPEG
  SectionIn 1
  File "..\gm_ffmpeg_in.dll"
  File "..\avcodec-*.dll"
  File "..\avformat-*.dll"
  File "..\avutil-*.dll"
  File "..\swscale-*.dll"
SectionEnd

Section "XviD Video Decoder" SecXVID
  SectionIn 1
  File "..\gm_xvid_dec.dll"
SectionEnd

;Section "AMR NB & WB" SecAMRFT
;  SectionIn 1
;  File "..\gm_amr_float_dec.dll"
;SectionEnd

Section "Subtitles" SecSUBS
  SectionIn 1
  File "..\gm_timedtext.dll"
SectionEnd

Section "ISO File Format" SecISOFF
  SectionIn 1
  File "..\gm_isom_in.dll"
SectionEnd

Section "MPEG-2 TS" SecM2TS
  SectionIn 1
  File "..\gm_mpegts_in.dll"
SectionEnd

Section "RTP/RTSP" SecRTP
  SectionIn 1
  File "..\gm_rtp_in.dll"
SectionEnd

Section "SVG" SecSVG
  SectionIn 1
  File "..\gm_svg_in.dll"
SectionEnd


Section "GDI+" SecGDIP
  SectionIn 1
  call InsertGDIPLUS
SectionEnd

Section "GPAC 2D Raster" SecG2DS
  SectionIn 1
  File "..\gm_soft_raster.dll"
SectionEnd

Section "FreeType" SecFT
  SectionIn 1
  File "..\gm_ft_font.dll"
SectionEnd

Section "Windows MME Audio" SecWAVE
  SectionIn 1
  File "..\gm_wav_out.dll"
SectionEnd

Section "Xiph" SecXIPH
  SectionIn 1
  File "..\gm_ogg.dll"
SectionEnd

Section "OpenSVC Decoder" SecOSVC
  SectionIn 1
  File "..\OpenSVCdecoder.plg"
  File "..\gm_opensvc_dec.dll"
SectionEnd

Section "MPEG DASH Suppport" SecDASH
  SectionIn 1
  File "..\gm_mpd_in.dll"
SectionEnd

Section "UPnP Support" SecUPnP
  SectionIn 1
  File "..\gm_platinum.dll"
SectionEnd

Section "Widget Manager" SecMPEGU
  SectionIn 1
  File "..\gm_widgetman.dll"
SectionEnd

;Section "MobileIP Framework" SecMobIP
;  SectionIn 1
;  File "..\gm_mobile_ip.dll"
;  File "..\MobileSession.dll"
;SectionEnd


;Section "OFFIS Audio compressor" SecOffisComp
;  SectionIn 1
;  ;copy GUI
;  File "..\gm_offis_compressor.dll"
;  File "..\QtCore4.dll"
;  File "..\QtGui4.dll"
;  SetOutPath $INSTDIR\gui\extensions
;  File /r /x .svn ..\..\..\..\gui\extensions\offis*
;  SetOutPath $INSTDIR
;SectionEnd

SubSectionEnd


Section "MP4Box" SecMP4B
  SectionIn 1
  SetOutPath $INSTDIR
  File "..\MP4Box.exe"
  File "..\MP42TS.exe"

  Push $INSTDIR
  Call AddToPath
SectionEnd


Section "GPAC SDK" SecSDK
  SectionIn 1
  SetOutPath $INSTDIR\sdk\include
  File /r /x CVS ..\..\..\..\include\*.h
  SetOutPath $INSTDIR\sdk\lib
  File ..\libgpac.lib
  File ..\..\..\..\extra_lib\lib\win32\release\js32.lib
SectionEnd


!define HK_MOZ "SOFTWARE\MozillaPlugins\@gpac/osmozilla,version=1.0"

Section "Osmozilla" SecZILLA
  SectionIn 1
  SetOutPath $INSTDIR
  File "..\nposmozilla.dll"
  File "..\nposmozilla.xpt"

  ${WriteRegStrAuth} HKCU "SOFTWARE\MozillaPlugins\@gpac/osmozilla,version=1.0" "Path" "$INSTDIR\nposmozilla.dll"
  ${WriteRegStrAuth} HKCU "SOFTWARE\MozillaPlugins\@gpac/osmozilla,version=1.0" "XPTPath" "$INSTDIR\nposmozilla.xpt"
  ${WriteRegStrAuth} HKCU "SOFTWARE\MozillaPlugins\@gpac/osmozilla,version=1.0" "Version" "${GPAC_VERSION}"
  ${WriteRegStrAuth} HKCU "SOFTWARE\MozillaPlugins\@gpac/osmozilla,version=1.0" "Vendor" "GPAC"
  ${WriteRegStrAuth} HKCU "SOFTWARE\MozillaPlugins\@gpac/osmozilla,version=1.0" "Description" "GPAC plugin"
  ${WriteRegStrAuth} HKCU "SOFTWARE\MozillaPlugins\@gpac/osmozilla,version=1.0" "ProductName" "Osmozilla"
SectionEnd


Section "GPAX" SecGPAX
  SectionIn 1
  SetOutPath $INSTDIR
  File "..\GPAX.dll"
  RegDLL "$INSTDIR\GPAX.dll"
SectionEnd


Section "MP4Client" SecMP4C
  SectionIn 1
  SetOutPath $INSTDIR
  File "..\MP4Client.exe"
SectionEnd   
                 
                 
                  
Section "Windows Runtime Libraries" SecMSVCRT
  SectionIn 1
  File "..\Microsoft.VC90.CRT.manifest"
  File "..\Microsoft.VC90.MFC.manifest"       
  File "..\msvcr90.dll"
  File "..\mfc90.dll"
SectionEnd




SubSection "Osmo4 Shortcuts"

Section "Add Start Menu Shortcuts"
  SectionIn 1
  #has current user admin privileges?
  userInfo::getAccountType
  Pop $0
  StrCmp $0 "Admin" +1 +2
  SetShellVarContext all
  CreateDirectory "$SMPROGRAMS\Osmo4"
  CreateShortCut "$SMPROGRAMS\Osmo4\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\Osmo4\Osmo4 (Classic UI).lnk" "$INSTDIR\Osmo4.exe" ""
  CreateShortCut "$SMPROGRAMS\Osmo4\Osmo4 (New UI).lnk" "$INSTDIR\MP4Client.exe" "-gui" 
  CreateShortCut "$SMPROGRAMS\Osmo4\Osmo4 (New UI With Console).lnk" "$INSTDIR\MP4Client.exe" ""
  CreateShortCut "$SMPROGRAMS\Osmo4\Readme.lnk" "$INSTDIR\ReadMe.txt"
  CreateShortCut "$SMPROGRAMS\Osmo4\License.lnk" "$INSTDIR\License.txt"
  CreateShortCut "$SMPROGRAMS\Osmo4\History.lnk" "$INSTDIR\changelog.txt"
  CreateShortCut "$SMPROGRAMS\Osmo4\Configuration Info.lnk" "$INSTDIR\configuration.html"
SectionEnd

Section "Add shortcut to QuickLaunch"
  SectionIn 1
  CreateShortCut "$QUICKLAUNCH\Osmo4.lnk" "$INSTDIR\Osmo4.exe" "" "$INSTDIR\Osmo4.exe" 0
SectionEnd

Section "Add shortcut to Desktop"
  SectionIn 1
  CreateShortCut "$DESKTOP\Osmo4.lnk" "$INSTDIR\Osmo4.exe" "" "$INSTDIR\Osmo4.exe" 0
SectionEnd

!define SHCNE_ASSOCCHANGED 0x08000000
!define SHCNF_IDLIST 0

Section "Make Osmo4 the default MPEG-4 Player"
  SectionIn 1
  ;write file association
  ${WriteRegStrAuth} HKCR GPAC\mp4\DefaultIcon "" "$INSTDIR\Osmo4.ico, 0"
  ${WriteRegStrAuth} HKCR GPAC\mp4\Shell\open\command "" "$INSTDIR\Osmo4.exe %L"
  ${WriteRegStrAuth} HKCR .mp4 "" "GPAC\mp4"
  !system 'shell32.dll::SHChangeNotify(i, i, i, i) v (${SHCNE_ASSOCCHANGED}, ${SHCNF_IDLIST}, 0, 0)'

SectionEnd

Section "Associate 3GPP files (3GP) with Osmo4"
  SectionIn 1
  ;write file association
  ${WriteRegStrAuth} HKCR GPAC\3gp\DefaultIcon "" "$INSTDIR\Osmo4.ico, 0"
  ${WriteRegStrAuth} HKCR GPAC\3gp\Shell\open\command "" "$INSTDIR\Osmo4.exe %L"
  ${WriteRegStrAuth} HKCR .3gp "" "GPAC\3gp"
  !system 'shell32.dll::SHChangeNotify(i, i, i, i) v (${SHCNE_ASSOCCHANGED}, ${SHCNF_IDLIST}, 0, 0)'
SectionEnd

Section "Associate 3GPP2 files (3G2) with Osmo4"
  SectionIn 1
  ;write file association
  ${WriteRegStrAuth} HKCR GPAC\3g2\DefaultIcon "" "$INSTDIR\Osmo4.ico, 0"
  ${WriteRegStrAuth} HKCR GPAC\3g2\Shell\open\command "" "$INSTDIR\Osmo4.exe %L"
  ${WriteRegStrAuth} HKCR .3g2 "" "GPAC\3g2"
  !system 'shell32.dll::SHChangeNotify(i, i, i, i) v (${SHCNE_ASSOCCHANGED}, ${SHCNF_IDLIST}, 0, 0)'
SectionEnd

SubSectionEnd



!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SecOsmo4} "Osmo4 player"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecPlugins} "GPAC Plugins"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecBIFS} "MPEG-4 BIFS Scene Decoder"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecODF} "MPEG-4 Object Descriptor Decoder"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecLASeR} "MPEG-4 LASeR Scene Decoder"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecTextLoad} "Support for uncompressed MPEG-4 (BT and XMT), VRML and X3D textual formats"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecSAF} "MPEG-4 SAF Demultiplexer"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecIMG} "Support for PNG, JPEG, BMP and JPEG2000 images"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecAAC} "Support for MPEG-4 Audio HE-AAC decoder and web radios"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecMP3} "Support for MPEG-1/2 Audio (inc. MP3) decoder and web radios"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecAC3} "Support for Dolby AC3 decoder and web radios"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecFFMPEG} "Support for FFMPEG libraries for various format decoding and demultiplexing"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecXVID} "Support for XVID library for MPEG-4 Video Part 2 decoding"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecAMRFT} "Support for AMR and AMR WideBand decoder and web radios"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecSUBS} "Subtitle support include SRT, SUB, 3GPP and MPEG-4 Text formats"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecISOFF} "Support for ISO-based file formats (3GP, MP4, MJ2K)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecM2TS} "Support for MPEG-2 Transport Stream"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecRTP} "Support for RTP and RTSP IP streaming"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecSVG} "Support for SVG including progressive loading"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecGDIP} "GDIPlus-based rasterizer"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecG2DS} "GPAC software rasterizer"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecFT} "FreeType font parsing"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecWAVE} "Windows MME Audio output support"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecXIPH} "Support for XIPP OGG, Vorbis and Theora media"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecOSVC} "Support for SVC decoding through OpenSVC Decoder"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecDASH} "HTTP Streaming using MPEG DASH"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecUPnP} "Support for UPnP based on Platinum"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecMPEGU} "Support for W3C and MPEG-U Widgets"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecMobIP} "UNIGE Mobile IP Framework"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecOffisComp} "OFFIS Audio Compressor"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecMP4B} "MP4Box command-line tool for various multimedia operations"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecSDK} "GPAC SDK: headers and library files needed to develop modules for GPAC or appllication based on GPAC"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecZILLA} "GPAC playback support NPAPI-based browsers (FireFox/Gecko, Safari/WebKit)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecGPAX} "GPAC playback support using ActiveX component (Internet Explorer)"
  !insertmacro MUI_DESCRIPTION_TEXT ${SecMP4C} "GPAC command-line player and AVI dumper"
  
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function .onInstSuccess
;  MessageBox MB_YESNO "GPAC Framework installation complete. Do you want to launch the Osmo4 player?" IDNO NoLaunch
;  Exec $INSTDIR\Osmo4.exe
;  NoLaunch:
FunctionEnd





; uninstall stuff

UninstallText "This will uninstall OSMO4/GPAC from your computer. Hit next to continue."

; special uninstall section.
Section "Uninstall"
  ; remove registry keys
  ${DeleteRegKeyAuth} HKCU "Software\Microsoft\Windows\CurrentVersion\Uninstall\Osmo4"
  ${DeleteRegKeyAuth} HKCU "SOFTWARE\GPAC"
  ${DeleteRegKeyAuth} HKCU "SOFTWARE\MozillaPlugins\@gpac/osmozilla,version=1.0"
  ${DeleteRegKeyAuth} HKCR GPAC\mp4\DefaultIcon
  ${DeleteRegKeyAuth} HKCR GPAC\mp4\shell\open\command
  ${DeleteRegKeyAuth} HKCR GPAC\mp4
  ${DeleteRegKeyAuth} HKCR .mp4
  ${DeleteRegKeyAuth} HKCR GPAC\3gp\DefaultIcon
  ${DeleteRegKeyAuth} HKCR GPAC\3gp\shell\open\command
  ${DeleteRegKeyAuth} HKCR GPAC\3gp
  ${DeleteRegKeyAuth} HKCR .3gp
  ${DeleteRegKeyAuth} HKCR GPAC\3g2\DefaultIcon
  ${DeleteRegKeyAuth} HKCR GPAC\3g2\shell\open\command
  ${DeleteRegKeyAuth} HKCR GPAC\3g2
  ${DeleteRegKeyAuth} HKCR .3g2
  ${DeleteRegKeyAuth} HKCR GPAC

  UnRegDLL "$INSTDIR\GPAX.dll"
  RMDir /r $INSTDIR
  Push $INSTDIR
  Call un.RemoveFromPath
  #has current user admin privileges?
  userInfo::getAccountType
  Pop $0
  StrCmp $0 "Admin" +1 +2
  SetShellVarContext all
  Delete "$SMPROGRAMS\Osmo4\*.*"
  RMDir "$SMPROGRAMS\Osmo4"
  Delete "$QUICKLAUNCH\Osmo4.lnk"
  Delete "$DESKTOP\Osmo4.lnk"

SectionEnd

;path modif functions
!verbose 3
!include "WinMessages.NSH"
!verbose 4

; AddToPath - Adds the given dir to the search path.
;        Input - head of the stack
;        Note - Win9x systems requires reboot

Function AddToPath
  Exch $0
  Push $1
  Push $2
  Push $3

  # don't add if the path doesn't exist
  IfFileExists $0 "" AddToPath_done

  ReadEnvStr $1 PATH
  Push "$1;"
  Push "$0;"
  Call StrStr
  Pop $2
  StrCmp $2 "" "" AddToPath_done
  Push "$1;"
  Push "$0\;"
  Call StrStr
  Pop $2
  StrCmp $2 "" "" AddToPath_done
  GetFullPathName /SHORT $3 $0
  Push "$1;"
  Push "$3;"
  Call StrStr
  Pop $2
  StrCmp $2 "" "" AddToPath_done
  Push "$1;"
  Push "$3\;"
  Call StrStr
  Pop $2
  StrCmp $2 "" "" AddToPath_done

  Call IsNT
  Pop $1
  StrCmp $1 1 AddToPath_NT
    ; Not on NT
    StrCpy $1 $WINDIR 2
    FileOpen $1 "$1\autoexec.bat" a
    FileSeek $1 -1 END
    FileReadByte $1 $2
    IntCmp $2 26 0 +2 +2 # DOS EOF
      FileSeek $1 -1 END # write over EOF
    FileWrite $1 "$\r$\nSET PATH=%PATH%;$3$\r$\n"
    FileClose $1
    SetRebootFlag true
    Goto AddToPath_done

  AddToPath_NT:
    ReadRegStr $1 HKLM "SYSTEM\CurrentControlSet\Control\Session Manager\Environment" "PATH"
    StrCpy $2 $1 1 -1 # copy last char
    StrCmp $2 ";" 0 +2 # if last char == ;
      StrCpy $1 $1 -1 # remove last char
    StrCmp $1 "" AddToPath_NTdoIt
      StrCpy $0 "$1;$0"
    AddToPath_NTdoIt:
      WriteRegExpandStr HKLM "SYSTEM\CurrentControlSet\Control\Session Manager\Environment" "PATH" $0

    ReadRegStr $1 HKCU "Environment" "PATH"
    StrCpy $2 $1 1 -1 # copy last char
    StrCmp $2 ";" 0 +2 # if last char == ;
      StrCpy $1 $1 -1 # remove last char
    StrCmp $1 "" AddToPath_NTdoIt2
      StrCpy $0 "$1;$0"
    AddToPath_NTdoIt2:
      WriteRegExpandStr HKCU "Environment" "PATH" $0
    SendMessage ${HWND_BROADCAST} ${WM_WININICHANGE} 0 "STR:Environment" /TIMEOUT=5000

  AddToPath_done:
    Pop $3
    Pop $2
    Pop $1
    Pop $0
FunctionEnd

; RemoveFromPath - Remove a given dir from the path
;     Input: head of the stack

Function un.RemoveFromPath
  Exch $0
  Push $1
  Push $2
  Push $3
  Push $4
  Push $5
  Push $6

  IntFmt $6 "%c" 26 # DOS EOF

  Call un.IsNT
  Pop $1
  StrCmp $1 1 unRemoveFromPath_NT
    ; Not on NT
    StrCpy $1 $WINDIR 2
    FileOpen $1 "$1\autoexec.bat" r
    GetTempFileName $4
    FileOpen $2 $4 w
    GetFullPathName /SHORT $0 $0
    StrCpy $0 "SET PATH=%PATH%;$0"
    Goto unRemoveFromPath_dosLoop

    unRemoveFromPath_dosLoop:
      FileRead $1 $3
      StrCpy $5 $3 1 -1 # read last char
      StrCmp $5 $6 0 +2 # if DOS EOF
        StrCpy $3 $3 -1 # remove DOS EOF so we can compare
      StrCmp $3 "$0$\r$\n" unRemoveFromPath_dosLoopRemoveLine
      StrCmp $3 "$0$\n" unRemoveFromPath_dosLoopRemoveLine
      StrCmp $3 "$0" unRemoveFromPath_dosLoopRemoveLine
      StrCmp $3 "" unRemoveFromPath_dosLoopEnd
      FileWrite $2 $3
      Goto unRemoveFromPath_dosLoop
      unRemoveFromPath_dosLoopRemoveLine:
        SetRebootFlag true
        Goto unRemoveFromPath_dosLoop

    unRemoveFromPath_dosLoopEnd:
      FileClose $2
      FileClose $1
      StrCpy $1 $WINDIR 2
      Delete "$1\autoexec.bat"
      CopyFiles /SILENT $4 "$1\autoexec.bat"
      Delete $4
      Goto unRemoveFromPath_done

  unRemoveFromPath_NT:
    ReadRegStr $1 HKCU "SYSTEM\CurrentControlSet\Control\Session Manager\Environment" "PATH"
    StrCpy $5 $1 1 -1 # copy last char
    StrCmp $5 ";" +2 # if last char != ;
      StrCpy $1 "$1;" # append ;
    Push $1
    Push "$0;"
    Call un.StrStr ; Find `$0;` in $1
    Pop $2 ; pos of our dir
    StrCmp $2 "" unRemoveFromPath_done
      ; else, it is in path
      # $0 - path to add
      # $1 - path var
      StrLen $3 "$0;"
      StrLen $4 $2
      StrCpy $5 $1 -$4 # $5 is now the part before the path to remove
      StrCpy $6 $2 "" $3 # $6 is now the part after the path to remove
      StrCpy $3 $5$6

      StrCpy $5 $3 1 -1 # copy last char
      StrCmp $5 ";" 0 +2 # if last char == ;
        StrCpy $3 $3 -1 # remove last char

      WriteRegExpandStr HKCU "SYSTEM\CurrentControlSet\Control\Session Manager\Environment" "PATH" $3
      SendMessage ${HWND_BROADCAST} ${WM_WININICHANGE} 0 "STR:Environment" /TIMEOUT=5000

  unRemoveFromPath_done:
    Pop $6
    Pop $5
    Pop $4
    Pop $3
    Pop $2
    Pop $1
    Pop $0
FunctionEnd

###########################################
#            Utility Functions            #
###########################################

; IsNT
; no input
; output, top of the stack = 1 if NT or 0 if not
;
; Usage:
;   Call IsNT
;   Pop $R0
;  ($R0 at this point is 1 or 0)

!macro IsNT un
Function ${un}IsNT
  Push $0
  ReadRegStr $0 HKLM "SOFTWARE\Microsoft\Windows NT\CurrentVersion" CurrentVersion
  StrCmp $0 "" 0 IsNT_yes
  ; we are not NT.
  Pop $0
  Push 0
  Return

  IsNT_yes:
    ; NT!!!
    Pop $0
    Push 1
FunctionEnd
!macroend
!insertmacro IsNT ""
!insertmacro IsNT "un."

; StrStr
; input, top of stack = string to search for
;        top of stack-1 = string to search in
; output, top of stack (replaces with the portion of the string remaining)
; modifies no other variables.
;
; Usage:
;   Push "this is a long ass string"
;   Push "ass"
;   Call StrStr
;   Pop $R0
;  ($R0 at this point is "ass string")

!macro StrStr un
Function ${un}StrStr
Exch $R1 ; st=haystack,old$R1, $R1=needle
  Exch    ; st=old$R1,haystack
  Exch $R2 ; st=old$R1,old$R2, $R2=haystack
  Push $R3
  Push $R4
  Push $R5
  StrLen $R3 $R1
  StrCpy $R4 0
  ; $R1=needle
  ; $R2=haystack
  ; $R3=len(needle)
  ; $R4=cnt
  ; $R5=tmp
  loop:
    StrCpy $R5 $R2 $R3 $R4
    StrCmp $R5 $R1 done
    StrCmp $R5 "" done
    IntOp $R4 $R4 + 1
    Goto loop
done:
  StrCpy $R1 $R2 "" $R4
  Pop $R5
  Pop $R4
  Pop $R3
  Pop $R2
  Exch $R1
FunctionEnd
!macroend
!insertmacro StrStr ""
!insertmacro StrStr "un."

