/*
 *  
 *  $Id: comandodicomizacionintegracion.h 4023 2011-07-19 13:01:58Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
//#define _GINKGO_TRACE
#include <api/globals.h>
#include <api/icomando.h>
#include <api/ientorno.h>
#include <api/icontroladoreventos.h>
#include <api/imodelointegracion.h>
#include "../dialogos/importacion/datospersistentesimportacion.h"

#include <wx/xml/xml.h>
#include <wx/thread.h>

class wxCriticalSectionLocker;
namespace GNKVisualizator {
	namespace GADAPI {
		class ComandoDicomizacionIntegracionParams : public GNC::GCS::IComandoParams {
		public:
			ComandoDicomizacionIntegracionParams(GnkPtr<GNKVisualizator::GUI::TipoWizardImportacion> pDatosPersistentes,GNC::GCS::IEntorno* pEntorno,const std::string& dirTemporal) ;

			ComandoDicomizacionIntegracionParams( const ComandoDicomizacionIntegracionParams& o);
			ComandoDicomizacionIntegracionParams& operator = (const ComandoDicomizacionIntegracionParams& o);

			virtual ~ComandoDicomizacionIntegracionParams() ;

			//indica si hay que enviar el mensaje hl7
			bool EnviarMensajeHL7();

		public:
			GnkPtr<GNKVisualizator::GUI::TipoWizardImportacion> m_pDatosPersistentes;
			GNC::GCS::IEntorno* m_pEntorno;
			std::string m_dirTemporal;

			std::list<std::string> m_ListaFicheros;
			std::string m_mensajeError;
			bool m_importacionCorrecta;
			bool m_copiadoCorrecto;
			bool m_subirCorrecto;
			wxSemaphore m_SemaforoEsperarComando;
			
			GNC::GCS::IComando*	m_pComandoEspera;
			GNC::GCS::IComandoParams*	m_pParamsEspera;
		};


		class ComandoDicomizacionIntegracion : public GNC::GCS::IComando, public GNC::GCS::IObservador {
		public:
			ComandoDicomizacionIntegracion(ComandoDicomizacionIntegracionParams* pParams);

			typedef struct {
						wxString campoLista;
						wxString loincCodigoCampo;
						wxString loincDescCampo;
						wxString valor;
			} tValoracion;

			typedef std::list<tValoracion> listaValoraciones;

		 protected:
			virtual void Execute();
			virtual void Update();

			  virtual void OnAbort();

			void LiberarRecursos();

		protected:
			void ResizeFiles();

			bool ImportarFicherosOriginales();

			bool CopiarDicom();

			bool SubirPACS();

			void LanzarYEsperar(GNC::GCS::IComando* pCmd, GNC::GCS::IComandoParams* pCmdParams);

			bool  BorrarArchivosTemporales(wxString dirPath);

			virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt) ;

			ComandoDicomizacionIntegracionParams* m_pIntegracionParams;
		};
	}
}
