/*
 *  
 *  $Id: wchroma.h 3535 2011-03-18 17:57:05Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once
#include <api/iwidgets.h>
#include <widgets/observers/iobservadorchroma.h>
#include <vector>

class vtkImageData;

namespace GNC {
	namespace GCS {
		namespace Widgets {

			//---------------------------------------------------------------------

			class WChromaBuilder : public GNC::GCS::Widgets::IWidgetBuilder, public GNC::GCS::Widgets::Notificadores::INotificadorChroma {
			public:
				WChromaBuilder(GNC::GCS::IWidgetsManager* pManager, long gid, GNC::GCS::Widgets::Observadores::IObservadorChroma* pObservador = NULL);

				~WChromaBuilder();

				virtual void OnMouseEvents(GNC::GCS::Eventos::EventoRaton&);

				virtual void OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&);

				virtual void Render(GNC::GCS::Contexto3D* c);

				virtual GNC::GCS::Widgets::TipoCursor GetCursor();


			protected:
				int                         m_NumMaxSemillas;
				GNC::GCS::Vector m_VerticesSeleccion[2];
				GNC::GCS::Nodo   m_Nodo;
				bool                      m_MouseDown;
				Estado                   m_Estado;
			};

			//---------------------------------------------------------------------

			class WChroma : public GNC::GCS::Widgets::IWidget {


			//region "Constructor y destructor"

			public:
				WChroma(IWidgetsManager* pManager, long vid, GNC::GCS::Nodo nodo, const char* nombre, long gid, bool oculto = false);

				~WChroma();

				//endregion

				//region "Interfaz especifica"

				virtual void OnMouseEvents(GNC::GCS::Eventos::EventoRaton&);

				virtual void OnKeyEvents(GNC::GCS::Eventos::EventoTeclado&);

				virtual bool HitTest(float x, float y, float umbralCuadrado);

				virtual bool HitTest(GNC::GCS::Vector* vertices, int numVertices);

				virtual void Render(GNC::GCS::Contexto3D* c);

				virtual bool SoportaAutoBorrado() const {
					return false;
				}

				virtual GNC::GCS::Nodo& GetNodo() {
					return m_Nodo;
				}

				virtual bool EsMarcador() const
				{
					return false;
				}

				virtual bool DelimitaArea() const
				{
					return false;
				}

				virtual void GetPosicion(GNC::GCS::Vector& posicion) const
				{
					posicion = m_Nodo;
				}

				virtual void Seleccionar(bool seleccionar)
				{
					SeleccionarNodo(m_Nodo, seleccionar);
				}

				virtual void Iluminar(bool iluminar)
				{
					if (iluminar != m_Nodo.EstaIluminado()) {
						IluminarNodo(m_Nodo, iluminar);
						m_Modificado = true;
					}
				}

				virtual void SeleccionarNodo(GNC::GCS::Nodo& nodo, bool seleccionar)
				{
					if(seleccionar != nodo.EstaSeleccionado()){
						nodo.Seleccionar(seleccionar);
						m_Modificado = true;
					}
				}

				virtual bool EstaSeleccionado() const
				{
					return m_Nodo.EstaSeleccionado();
				}

				virtual bool EstaIluminado() const
				{
					return m_Nodo.EstaIluminado();
				}

				//endregion

				//region "Estado interno"
			private:
				bool            m_MouseDown;
				//endregion

				//region "Propiedades geometricas"
			private:
				GNC::GCS::Nodo   m_Nodo;
				GNC::GCS::Vector m_PosAntigua;

			public:
				friend std::ostream& operator<<(std::ostream& out, const WChroma& w) {
					out << "[ P=" << w.m_Nodo << ", GID=" << w.m_GID << ", TID=" << w.m_TID << " UID=" << w.m_UID << " ]";
					return out;
				}

				friend std::ostream& operator<<(std::ostream& out, const WChroma* w) {
					if (w == NULL) {
						out << "[ NULL ]";
					}
					else {
						out << *w;
					}
					return out;
				}

			public:
				//endregion
			};
		}
	}
}
