/*
 *  
 *  $Id: herramientawindowlevel.h 3526 2011-03-16 19:56:19Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <export/iherramientawindowlevel.h>
#include <widgets/wwindowlevel.h>
#include <api/icontroladoreventos.h>
#include <api/api.h>

#include <map>

namespace GNC {

	class EXTAPI HerramientaWindowLevel : public GNC::GCS::IHerramientaWindowLevel, public GNC::GCS::Widgets::Observadores::IObservadorWindowLevel, public GNC::GCS::IObservador {

	public:
		typedef std::map<TContratoWidgets*, GNC::GCS::IContratoWindowLevel::WindowLevel> ListaWindowLevelsIniciales;

		HerramientaWindowLevel();
		virtual ~HerramientaWindowLevel();

		//region "Realización de la interfaz IHerramienta"

		// Setup de paneles
		virtual void CrearPaneles( wxPanel* panel );
		//endregion

		virtual void ConectarContratoFalso(bool activar);
		virtual void SetVistaActiva(GNC::GCS::IVista* pVista);
		virtual void ConectarContratos(bool activar);

		virtual void ProcesarEvento(GNC::GCS::Eventos::IEvento *evt);

		//region "Realización de la interfaz IHerramienta"
		virtual void OnStart();
		virtual void OnAjuste(TVector& start, TVector& stop);
		virtual void OnEnd();
		//endregion

		//region "metodos propios de la herramienta window/level"
		virtual void ClampWindowLevel(double window, double level, double& clampedWindow, double& clampedLevel);

		virtual void SetWindowLevel(const GNC::GCS::IContratoWindowLevel::WindowLevel& wl);
		void Resetear();
		//endregion

	protected:
		GNC::GCS::Widgets::WWindowLevelBuilder*  m_pWindowLevelBuilder;
		ListaWindowLevelsIniciales m_WindowLevelInicial;

	};
}
