/*
 *  
 *  $Id: wxwizardexportacionginkgo.cpp 3830 2011-05-06 13:30:18Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#include <wx/filename.h>
#include <sstream>
#include <wx/file.h>
#include <wx/dir.h>
#include <wx/mstream.h>
#include <wx/busyinfo.h>
#include <wx/image.h>
#include <wx/ginkgostyle/ginkgostyle.h>


#include "parametrosprincipales.h"
#include "wxwizardexportacionginkgo.h"

#include <vector>

#include <export/icontratoscore.h>
#include <main/entorno.h>
#include <api/icontextoestudio.h>

namespace GNC {
	namespace GUI {
		wxWidzardExportacionGinkgo::wxWidzardExportacionGinkgo(wxWindow* pParent, GNC::GCS::IVista* pVista) : wxWizardGinkgoBase(pParent)
		{
			SetTitle(_("Image Export Wizard"));

			m_pVista = pVista;

			m_OK = false;

			m_pDatosPersistentes = GnkPtr<TipoWizardExportacion>(new TipoWizardExportacion());
			m_pDatosPersistentes->m_pVista = m_pVista;

			//se pillan los pasos
			IPasoWizard* pPaso=NULL;

			pPaso = new ParametrosPrincipales(m_pPanelPrincipal, this, m_pDatosPersistentes, GNC::Entorno::Instance());
			m_ListaPasos.push_back(pPaso);
			//

			m_pBAnterior->Show(false);

			m_currentPasoIndex=0;
			CargarCurrent();
		}

		wxWidzardExportacionGinkgo::~wxWidzardExportacionGinkgo()
		{
			m_ListaPasos.clear();
		}


		void wxWidzardExportacionGinkgo::OnCancelarClick(wxCommandEvent& )
		{
			Close();
		}

		void wxWidzardExportacionGinkgo::OnSiguienteClick(wxCommandEvent& )
		{
			IPasoWizard* currentPaso = m_ListaPasos[m_currentPasoIndex];
			if(currentPaso->Validar()){
				currentPaso->Detach(m_pSizerPrincipal);
				++m_currentPasoIndex;
				if(m_currentPasoIndex >= m_ListaPasos.size()) {
					Close();
					return;
				} else {
					CargarCurrent();
				}
			}
		}

		void wxWidzardExportacionGinkgo::OnAnteriorClick(wxCommandEvent &)
		{
			if(m_currentPasoIndex!=0){
				m_ListaPasos[m_currentPasoIndex]->Detach(m_pSizerPrincipal);
				switch(m_currentPasoIndex){
					case 1:
						--m_currentPasoIndex;
						break;
					case 2:
						m_currentPasoIndex=0;
						break;
					case 3:
						if(m_pDatosPersistentes->m_formatoDestino == DICOM){
							m_currentPasoIndex =1;
						}else{
							m_currentPasoIndex =2;
						}
				}

				CargarCurrent();
			}
		}

		bool wxWidzardExportacionGinkgo::IsOK()
		{
			return m_OK;
		}

		void wxWidzardExportacionGinkgo::CargarCurrent(){
			IPasoWizard* currentPaso = m_ListaPasos[m_currentPasoIndex];
			currentPaso->Attach(m_pSizerPrincipal);


			m_pHeader->SetTitle(wxString::FromUTF8(currentPaso->GetTitle().c_str()));
			m_pHeader->SetSubtitle(wxString::FromUTF8(currentPaso->GetSubTitle().c_str()));
			m_pBSiguiente->Enable(currentPaso->Siguiente());
			m_pBAnterior->Enable(currentPaso->Anterior());
			m_pBCerrar->Enable(currentPaso->Cancelar());
			if(m_currentPasoIndex==m_ListaPasos.size()-1){
				m_pBSiguiente->SetLabel(_("&Accept"));
			}else{
				m_pBSiguiente->SetLabel(_("&Next >"));
			}
			Layout();
		}
	};
}
