/*
*  
*  $Id: updateavailable.h 3698 2011-04-14 12:38:49Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once

namespace GNC {
	namespace GCS {
		namespace Eventos {

			class EXTAPI EventoUpdateAvailable : public GNC::GCS::Eventos::IEvento
			{
			private:
				int m_Version;
				int m_SubVersion;
				int m_Release;
				int m_Build;
				std::string m_VersionString;
				std::string m_VersionCheck;
				std::string m_Description;
				std::string m_URL;
				bool        m_Informar;

			public:
				EventoUpdateAvailable() : GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_UpdateAvailable, 0, 100, NULL)
				{
					m_Nombre = "UpdateAvailable";					
				}

				EventoUpdateAvailable(int version, int subversion, int release, int build, const std::string& versionString, const std::string& versionCheck, const std::string& description, const std::string& url, bool informar): GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_UpdateAvailable, 0, 100, NULL){
					m_Nombre        = "UpdateAvailable";
					m_Version       = version;
					m_SubVersion    = subversion;
					m_Release       = release;
					m_Build         = build;
					m_VersionString = versionString;
					m_VersionCheck  = versionCheck;
					m_Description   = description;
					m_URL           = url;
					m_Informar      = informar;
				}

				~EventoUpdateAvailable()
				{
				}

				const std::string& GetURL() {
					return m_URL;
				}

				bool Informar() {
					return m_Informar;
				}

				int GetVersion() {
					return m_Version;
				}

				int GetSubVersion() {
					return m_SubVersion;
				}

				int GetRelease() {
					return m_Release;
				}

				int GetBuild() {
					return m_Build;
				}

				const std::string& GetVersionString() {
					return m_VersionString;
				}

				const std::string& GetVersionCheck() {
					return m_VersionCheck;
				}

				const std::string& GetDescription() {
					return m_Description;
				}

				virtual void pushInfo(std::ostream& out) const {
					out << "UpdateAvailable (" << m_Version << ") from " << m_URL;
				}
			};
		}
	}
}
