/*
*  
*  $Id: comandoavisarficheros.cpp 3839 2011-05-11 08:47:59Z tovar $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
//#define _GINKGO_TRACE
//#define DUMP_IMAGENES
#include <api/globals.h>
#include "comandoavisarficheros.h"
#include <main/controllers/controladoreventos.h>
#include <eventos/eventosginkgo.h>

#define IDC_COMANDO_AVISAR_FICHEROS           113

// Singleton de persistencia
namespace GADAPI {
	ComandoAvisarFicherosParams::ComandoAvisarFicherosParams(const TipoListaFicheros& listaFicheros, bool openAfter)
	{
		m_listaFicheros = listaFicheros;
		m_openAfter = openAfter;
	}

	ComandoAvisarFicheros::ComandoAvisarFicheros(ComandoAvisarFicherosParams* pParams):IComando(pParams)
	{
		SetId(IDC_COMANDO_AVISAR_FICHEROS);
		m_pAvisarParams = pParams;
	}

	void ComandoAvisarFicheros::Execute()
	{
	}

	void ComandoAvisarFicheros::Update()
	{
		//se avisa
		GNC::GCS::Eventos::EventoAddFicheroHistorial::ListaRutas listaRutas;
		for(ComandoAvisarFicherosParams::TipoListaFicheros::iterator it=m_pAvisarParams->m_listaFicheros.begin(); it!=m_pAvisarParams->m_listaFicheros.end(); it++) {
			listaRutas.push_back((*it));
		}
		GNC::GCS::ControladorEventos::Instance()->ProcesarEvento(new GNC::GCS::Eventos::EventoAddFicheroHistorial(listaRutas,m_pAvisarParams->m_openAfter));
	}

	void ComandoAvisarFicheros::LiberarRecursos()
	{
	}

}


