/*
 *  
 *  $Id: iherramienta.h 4051 2011-08-01 09:41:38Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <api/api.h>
#include "globals.h"
#include <stddef.h>
#include <wx/window.h>
#include <wx/bitmap.h>
#include <iostream>

class wxXmlNode;
class wxPanel;

class wxAuiToolBar;

namespace GNC {
	namespace GCS {
		class IVista;
		class IHerramienta;
	}
}

namespace GNC {

	namespace GCS {

		//---------------------------------------------------------------------------

		class EXTAPI HerramientaException : public std::exception {
		public:

			HerramientaException(std::string& mensaje)
			{
				m_Mensaje = mensaje;
			}

			HerramientaException(std::string mensaje)
			{
				m_Mensaje = mensaje;
			}

			~HerramientaException() throw ()
			{
			}

			std::string& getCause()
			{
				return m_Mensaje;
			}

		protected:
			std::string m_Mensaje;
		};

		//---------------------------------------------------------------------------

		/* Interfaz de solicitación de cambio de herramienta. A usar por las herramientas concretas al hacer click sobre su botón de
		 activación */
		class ISolicitadorCambioHerramienta {
		public:

			ISolicitadorCambioHerramienta()
			{
			}

			~ISolicitadorCambioHerramienta()
			{
			}

//region "Interfaz de ISolicitadorCambioHerramienta"

			virtual void SolicitarActivacion(IHerramienta* herramienta) = 0;

//endregion
		};

		//---------------------------------------------------------------------------

		/* Interfaz genérica de herramientas. Necesariamente, cada especialización de IHerramienta es responsable de la creación de sus
		 * paneles, y deberían mantener punteros específicos a ellos por duplicado para el acceso a los paneles concretos. */
		class EXTAPI IHerramienta {
		public:
			typedef enum {
				TFamiliaVisualizacion,
				TFamiliaMedicion,
				TFamiliaAnotacion,
				TFamiliaChroma,
				TFamiliaVision,
				TMenuEdicion,
				TMenuVer,
				TMenuImagen,
				TMenu3D,
				TMenuHerramientas
			} TFamiliasHerramientas;

			typedef unsigned int UID;

			IHerramienta(const IHerramienta::UID& uid, const IHerramienta::TFamiliasHerramientas& uidFamilia, const std::string& nombre = "", const int subFamilia = 0xFFFFFFFF, const int& prioridad = 0, bool isMenu = false, int accelerator = -1);

			~IHerramienta();

//region "Interfaz concreta de IHerramienta"

			/* Metodo de adaptacion para la creacion de paneles de la herramienta */
			virtual void DoCrearPaneles( wxPanel* panel , wxSizer* pSizer);

			/* Método específico de creación del paneles de la herramienta. Debe implementarse en cada especialización de IHerramienta */
			virtual void CrearPaneles( wxPanel* pParent ) = 0;

			virtual bool ValidaContratos(GNC::GCS::IVista* pVista) = 0;

			/* Activa el contrato falso de la herramienta (Modo de herramienta activa que no hace nada util) */
			virtual void ConectarContratoFalso(bool conectar) = 0;

			/* Conecta el contrato de la herramienta */
			virtual void ConectarContratos(bool conectar) = 0;

			/* Establece la vista activa de la herramienta */
			virtual void SetVistaActiva(GNC::GCS::IVista* pVista) = 0;

			virtual wxXmlNode* Serializar(GNC::GCS::IVista* ,long, const std::string /*nombreMedicoGuarda*/ )
			{
				return NULL;
			}

			virtual void Deserializar(GNC::GCS::IVista* , long , wxXmlNode* ) {}

//endregion

//region "Interfaz común de IHerramienta"

			/* Aviso: Este metodo debe ser invocado por el "solicitador de cambio de herramienta" para registrarse a si mismo. */
			virtual void SetSolicitadorCambioHerramienta(ISolicitadorCambioHerramienta* pSolicitador);

			/* Este metodo debe ser invocado por las implementaciones concretas de las herramientas para que el controlador de
			 * herramientas las active de manera consistente con las demas */
			virtual void SolicitarActivacion();

			/* Devuelve un puntero generico al panel de opciones de la herramienta */
			virtual wxAuiToolBar* GetPanelHerramientaOpciones();

			/* Activa/Desactiva la herramienta.
			 * Aviso: Las herramientas no deben activarse o desactivarse por si mismas. Debe ser el controlador de herramientas quien lo haga por ellas */
			virtual void Activar(bool activa);

			/* Devuelve verdadero si la herramienta esta activada */
			virtual bool Activada();

			/* Habilita/Deshabilita la herramienta.
			 * Aviso: Las herramientas no deben habilitarse o deshabilitarse por si mismas. Debe ser el controlador de herramientas quien lo haga por ellas */
			virtual void Habilitar(bool habilitada);

			/* Devuelve verdadero si la herramienta esta habilitada */
			virtual bool Habilitada();

			/* Muestra/Oculta la herramienta
			 * Aviso: Las herramientas no deben mostrarse u ocultarse por si mismas. Debe ser el controlador de herramientas quien lo haga por ellas */
			virtual void Mostrar(bool mostrada);

			/* Devuelve verdadero si la herramienta esta mostrada */
			virtual bool Mostrada();

			/* Conecta/desconecta los contratos o el modo dehabilitado de la herramienta de manera inteligente, dependiendo de si esta habilitada
			 * Aviso: Las herramientas no deben conectarse o desconectarse por si mismas. Debe ser el controlador de herramientas quien lo haga por ellas */
			virtual void Conectar(bool conectar);

			/* Devuelve verdadero si la herramienta tiene sus contratos conectados */
			virtual bool Conectada();

			/* Devuelve el icono de la herramienta*/
			virtual wxBitmap GetIcono();

			/* Devuelve la descripcion de la herramienta*/
			virtual std::string GetDescripcion();

			/*Devuelve si es herramienta de barra o de menu*/
			virtual bool IsMenu()
			{
				return m_IsMenu;
			}

			/*Devuelve el menu, en caso de que sea menu*/
			virtual bool AppendInMenu(wxWindow* /*pParent*/, wxMenu* /*pMenuParent*/)
			{
				return false;
			}
			/*crea un menu y lo devuelve, se trata de un nuevo menu que puede hacerse popup*/
			virtual wxMenu* GetMenu(wxWindow* /*pParent*/) {
				return NULL;
			}

			virtual int GetAcceleratorCode()
			{
				return m_AcceleratorCode;
			}
//endregion

		protected:
			int m_AcceleratorCode;
			wxAuiToolBar* m_pAbstractPanelHerramientaOpciones;
			bool m_IsMenu;
			wxBitmap m_Icono;
			std::string m_Descripcion;

			bool m_Activa;

			bool m_Habilitada;

			bool m_Mostrada;

			bool m_ConectadaConContratos;
			bool m_ConectadaConContratoFalso;

		private:
			bool m_PanelAsociado;
			bool m_PanelOpcionesAsociado;

		private:
			ISolicitadorCambioHerramienta* m_pSolicitadorCambioHerramientas;

		public:
			IHerramienta::UID ID;
			TFamiliasHerramientas IDFamilia;
			//sirve para meter separadores en los menus dentro de la misma familia
			int	IDSubFamilia;
			int Prioridad;
			std::string Nombre;


//region "Helpers"
		private:

//endregion
//region "Debug helpers"
		public:

			friend std::ostream & operator <<(std::ostream& out, IHerramienta& h)
			{
				out << "IHerramienta [ activada = " << h.Activada() << ", habilitada = " << h.Habilitada() <<
				", mostrada = " << h.Mostrada() << " ] Nombre = " << h.Nombre.c_str() << ", ID = " << h.ID;
				return out;
			}

			friend std::ostream & operator <<(std::ostream& out, IHerramienta* pH)
			{
				if (pH == NULL) {
					out << "IHerramienta [NULL] Nombre = NULL, ID = NULL";
				}
				else {
					out << *pH;
				}
				return out;
			}
//endregion

		};
	}
}
