/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang;

public class Long_ {
    public static final int SIZE = 64;

    private Long_() {
    }

    public static long highestOneBit(long lng) {
        lng |= lng >> 1;
        lng |= lng >> 2;
        lng |= lng >> 4;
        lng |= lng >> 8;
        lng |= lng >> 16;
        lng |= lng >> 32;
        return lng & (lng >>> 1 ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long lowestOneBit(long lng) {
        return lng & -lng;
    }

    public static int numberOfLeadingZeros(long lng) {
        lng |= lng >> 1;
        lng |= lng >> 2;
        lng |= lng >> 4;
        lng |= lng >> 8;
        lng |= lng >> 16;
        lng |= lng >> 32;
        return Long_.bitCount(lng ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static int numberOfTrailingZeros(long lng) {
        return Long_.bitCount((lng & -lng) - 1L);
    }

    public static int bitCount(long lng) {
        lng = (lng & 0x5555555555555555L) + (lng >> 1 & 0x5555555555555555L);
        lng = (lng & 0x3333333333333333L) + (lng >> 2 & 0x3333333333333333L);
        int i = (int)((lng >>> 32) + lng);
        i = (i & 0xF0F0F0F) + (i >> 4 & 0xF0F0F0F);
        i = (i & 0xFF00FF) + (i >> 8 & 0xFF00FF);
        i = (i & 0xFFFF) + (i >> 16 & 0xFFFF);
        return i;
    }

    public static long rotateLeft(long lng, int distance) {
        if (distance == 0) {
            return lng;
        }
        return lng << distance | lng >>> -distance;
    }

    public static long rotateRight(long lng, int distance) {
        if (distance == 0) {
            return lng;
        }
        return lng >>> distance | lng << -distance;
    }

    public static long reverseBytes(long lng) {
        long b7 = lng >>> 56;
        long b6 = lng >>> 40 & 0xFF00L;
        long b5 = lng >>> 24 & 0xFF0000L;
        long b4 = lng >>> 8 & 0xFF000000L;
        long b3 = (lng & 0xFF000000L) << 8;
        long b2 = (lng & 0xFF0000L) << 24;
        long b1 = (lng & 0xFF00L) << 40;
        long b0 = lng << 56;
        return b0 | b1 | b2 | b3 | b4 | b5 | b6 | b7;
    }

    public static long reverse(long lng) {
        lng = (lng & 0x5555555555555555L) << 1 | lng >> 1 & 0x5555555555555555L;
        lng = (lng & 0x3333333333333333L) << 2 | lng >> 2 & 0x3333333333333333L;
        lng = (lng & 0xF0F0F0F0F0F0F0FL) << 4 | lng >> 4 & 0xF0F0F0F0F0F0F0FL;
        return Long_.reverseBytes(lng);
    }

    public static int signum(long lng) {
        return lng == 0L ? 0 : (lng < 0L ? -1 : 1);
    }

    public static Long valueOf(long lng) {
        if (lng < -128L || lng > 127L) {
            return new Long(lng);
        }
        return valueOfCache.CACHE[128 + (int)lng];
    }

    static class valueOfCache {
        static final Long[] CACHE = new Long[256];

        valueOfCache() {
        }

        static {
            for (int i = -128; i <= 127; ++i) {
                valueOfCache.CACHE[i + 128] = new Long(i);
            }
        }
    }
}

