/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.optimizer;

import org.objectweb.asm.ClassWriter;

public class Constant {
    char type;
    int intVal;
    long longVal;
    float floatVal;
    double doubleVal;
    String strVal1;
    String strVal2;
    String strVal3;
    int hashCode;

    public Constant() {
    }

    public Constant(Constant i) {
        this.type = i.type;
        this.intVal = i.intVal;
        this.longVal = i.longVal;
        this.floatVal = i.floatVal;
        this.doubleVal = i.doubleVal;
        this.strVal1 = i.strVal1;
        this.strVal2 = i.strVal2;
        this.strVal3 = i.strVal3;
        this.hashCode = i.hashCode;
    }

    void set(int intVal) {
        this.type = (char)73;
        this.intVal = intVal;
        this.hashCode = Integer.MAX_VALUE & this.type + intVal;
    }

    void set(long longVal) {
        this.type = (char)74;
        this.longVal = longVal;
        this.hashCode = Integer.MAX_VALUE & this.type + (int)longVal;
    }

    void set(float floatVal) {
        this.type = (char)70;
        this.floatVal = floatVal;
        this.hashCode = Integer.MAX_VALUE & this.type + (int)floatVal;
    }

    void set(double doubleVal) {
        this.type = (char)68;
        this.doubleVal = doubleVal;
        this.hashCode = Integer.MAX_VALUE & this.type + (int)doubleVal;
    }

    void set(char type, String strVal1, String strVal2, String strVal3) {
        this.type = type;
        this.strVal1 = strVal1;
        this.strVal2 = strVal2;
        this.strVal3 = strVal3;
        switch (type) {
            case 'C': 
            case 'S': 
            case 's': {
                this.hashCode = Integer.MAX_VALUE & type + strVal1.hashCode();
                return;
            }
            case 'T': {
                this.hashCode = Integer.MAX_VALUE & type + strVal1.hashCode() * strVal2.hashCode();
                return;
            }
        }
        this.hashCode = Integer.MAX_VALUE & type + strVal1.hashCode() * strVal2.hashCode() * strVal3.hashCode();
    }

    public void write(ClassWriter cw) {
        switch (this.type) {
            case 'I': {
                cw.newConst((Object)new Integer(this.intVal));
                break;
            }
            case 'J': {
                cw.newConst((Object)new Long(this.longVal));
                break;
            }
            case 'F': {
                cw.newConst((Object)new Float(this.floatVal));
                break;
            }
            case 'D': {
                cw.newConst((Object)new Double(this.doubleVal));
                break;
            }
            case 'S': {
                cw.newConst((Object)this.strVal1);
                break;
            }
            case 's': {
                cw.newUTF8(this.strVal1);
                break;
            }
            case 'C': {
                cw.newClass(this.strVal1);
                break;
            }
            case 'T': {
                cw.newNameType(this.strVal1, this.strVal2);
                break;
            }
            case 'G': {
                cw.newField(this.strVal1, this.strVal2, this.strVal3);
                break;
            }
            case 'M': {
                cw.newMethod(this.strVal1, this.strVal2, this.strVal3, false);
                break;
            }
            case 'N': {
                cw.newMethod(this.strVal1, this.strVal2, this.strVal3, true);
            }
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof Constant)) {
            return false;
        }
        Constant c = (Constant)o;
        if (c.type == this.type) {
            switch (this.type) {
                case 'I': {
                    return c.intVal == this.intVal;
                }
                case 'J': {
                    return c.longVal == this.longVal;
                }
                case 'F': {
                    return c.floatVal == this.floatVal;
                }
                case 'D': {
                    return c.doubleVal == this.doubleVal;
                }
                case 'C': 
                case 'S': 
                case 's': {
                    return c.strVal1.equals(this.strVal1);
                }
                case 'T': {
                    return c.strVal1.equals(this.strVal1) && c.strVal2.equals(this.strVal2);
                }
            }
            return c.strVal1.equals(this.strVal1) && c.strVal2.equals(this.strVal2) && c.strVal3.equals(this.strVal3);
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }
}

