/* inspect.c generated by valac 0.14.0.50-58097f, the Vala compiler
 * generated from inspect.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdio.h>
#include <readline/readline.h>
#include <readline/history.h>
#include <gobject/gvaluecollector.h>


#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;
typedef struct _FolksInspectClientPrivate FolksInspectClientPrivate;

#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;

#define FOLKS_INSPECT_TYPE_SIGNAL_MANAGER (folks_inspect_signal_manager_get_type ())
#define FOLKS_INSPECT_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManager))
#define FOLKS_INSPECT_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_IS_SIGNAL_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER))
#define FOLKS_INSPECT_SIGNAL_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, FolksInspectSignalManagerClass))

typedef struct _FolksInspectSignalManager FolksInspectSignalManager;
typedef struct _FolksInspectSignalManagerClass FolksInspectSignalManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define FOLKS_INSPECT_COMMANDS_TYPE_QUIT (folks_inspect_commands_quit_get_type ())
#define FOLKS_INSPECT_COMMANDS_QUIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_QUIT, FolksInspectCommandsQuit))
#define FOLKS_INSPECT_COMMANDS_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_QUIT, FolksInspectCommandsQuitClass))
#define FOLKS_INSPECT_COMMANDS_IS_QUIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_QUIT))
#define FOLKS_INSPECT_COMMANDS_IS_QUIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_QUIT))
#define FOLKS_INSPECT_COMMANDS_QUIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_QUIT, FolksInspectCommandsQuitClass))

typedef struct _FolksInspectCommandsQuit FolksInspectCommandsQuit;
typedef struct _FolksInspectCommandsQuitClass FolksInspectCommandsQuitClass;
#define _folks_inspect_command_unref0(var) ((var == NULL) ? NULL : (var = (folks_inspect_command_unref (var), NULL)))

#define FOLKS_INSPECT_COMMANDS_TYPE_HELP (folks_inspect_commands_help_get_type ())
#define FOLKS_INSPECT_COMMANDS_HELP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_HELP, FolksInspectCommandsHelp))
#define FOLKS_INSPECT_COMMANDS_HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_HELP, FolksInspectCommandsHelpClass))
#define FOLKS_INSPECT_COMMANDS_IS_HELP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_HELP))
#define FOLKS_INSPECT_COMMANDS_IS_HELP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_HELP))
#define FOLKS_INSPECT_COMMANDS_HELP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_HELP, FolksInspectCommandsHelpClass))

typedef struct _FolksInspectCommandsHelp FolksInspectCommandsHelp;
typedef struct _FolksInspectCommandsHelpClass FolksInspectCommandsHelpClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_INDIVIDUALS (folks_inspect_commands_individuals_get_type ())
#define FOLKS_INSPECT_COMMANDS_INDIVIDUALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_INDIVIDUALS, FolksInspectCommandsIndividuals))
#define FOLKS_INSPECT_COMMANDS_INDIVIDUALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_INDIVIDUALS, FolksInspectCommandsIndividualsClass))
#define FOLKS_INSPECT_COMMANDS_IS_INDIVIDUALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_INDIVIDUALS))
#define FOLKS_INSPECT_COMMANDS_IS_INDIVIDUALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_INDIVIDUALS))
#define FOLKS_INSPECT_COMMANDS_INDIVIDUALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_INDIVIDUALS, FolksInspectCommandsIndividualsClass))

typedef struct _FolksInspectCommandsIndividuals FolksInspectCommandsIndividuals;
typedef struct _FolksInspectCommandsIndividualsClass FolksInspectCommandsIndividualsClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_LINKING (folks_inspect_commands_linking_get_type ())
#define FOLKS_INSPECT_COMMANDS_LINKING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinking))
#define FOLKS_INSPECT_COMMANDS_LINKING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinkingClass))
#define FOLKS_INSPECT_COMMANDS_IS_LINKING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING))
#define FOLKS_INSPECT_COMMANDS_IS_LINKING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_LINKING))
#define FOLKS_INSPECT_COMMANDS_LINKING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_LINKING, FolksInspectCommandsLinkingClass))

typedef struct _FolksInspectCommandsLinking FolksInspectCommandsLinking;
typedef struct _FolksInspectCommandsLinkingClass FolksInspectCommandsLinkingClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS (folks_inspect_commands_personas_get_type ())
#define FOLKS_INSPECT_COMMANDS_PERSONAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS, FolksInspectCommandsPersonas))
#define FOLKS_INSPECT_COMMANDS_PERSONAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS, FolksInspectCommandsPersonasClass))
#define FOLKS_INSPECT_COMMANDS_IS_PERSONAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS))
#define FOLKS_INSPECT_COMMANDS_IS_PERSONAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS))
#define FOLKS_INSPECT_COMMANDS_PERSONAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONAS, FolksInspectCommandsPersonasClass))

typedef struct _FolksInspectCommandsPersonas FolksInspectCommandsPersonas;
typedef struct _FolksInspectCommandsPersonasClass FolksInspectCommandsPersonasClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS (folks_inspect_commands_backends_get_type ())
#define FOLKS_INSPECT_COMMANDS_BACKENDS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, FolksInspectCommandsBackends))
#define FOLKS_INSPECT_COMMANDS_BACKENDS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, FolksInspectCommandsBackendsClass))
#define FOLKS_INSPECT_COMMANDS_IS_BACKENDS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS))
#define FOLKS_INSPECT_COMMANDS_IS_BACKENDS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS))
#define FOLKS_INSPECT_COMMANDS_BACKENDS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_BACKENDS, FolksInspectCommandsBackendsClass))

typedef struct _FolksInspectCommandsBackends FolksInspectCommandsBackends;
typedef struct _FolksInspectCommandsBackendsClass FolksInspectCommandsBackendsClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_PERSONA_STORES (folks_inspect_commands_persona_stores_get_type ())
#define FOLKS_INSPECT_COMMANDS_PERSONA_STORES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONA_STORES, FolksInspectCommandsPersonaStores))
#define FOLKS_INSPECT_COMMANDS_PERSONA_STORES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_PERSONA_STORES, FolksInspectCommandsPersonaStoresClass))
#define FOLKS_INSPECT_COMMANDS_IS_PERSONA_STORES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONA_STORES))
#define FOLKS_INSPECT_COMMANDS_IS_PERSONA_STORES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_PERSONA_STORES))
#define FOLKS_INSPECT_COMMANDS_PERSONA_STORES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_PERSONA_STORES, FolksInspectCommandsPersonaStoresClass))

typedef struct _FolksInspectCommandsPersonaStores FolksInspectCommandsPersonaStores;
typedef struct _FolksInspectCommandsPersonaStoresClass FolksInspectCommandsPersonaStoresClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS (folks_inspect_commands_signals_get_type ())
#define FOLKS_INSPECT_COMMANDS_SIGNALS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignals))
#define FOLKS_INSPECT_COMMANDS_SIGNALS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignalsClass))
#define FOLKS_INSPECT_COMMANDS_IS_SIGNALS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS))
#define FOLKS_INSPECT_COMMANDS_IS_SIGNALS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS))
#define FOLKS_INSPECT_COMMANDS_SIGNALS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_SIGNALS, FolksInspectCommandsSignalsClass))

typedef struct _FolksInspectCommandsSignals FolksInspectCommandsSignals;
typedef struct _FolksInspectCommandsSignalsClass FolksInspectCommandsSignalsClass;

#define FOLKS_INSPECT_COMMANDS_TYPE_DEBUG (folks_inspect_commands_debug_get_type ())
#define FOLKS_INSPECT_COMMANDS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_COMMANDS_TYPE_DEBUG, FolksInspectCommandsDebug))
#define FOLKS_INSPECT_COMMANDS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_COMMANDS_TYPE_DEBUG, FolksInspectCommandsDebugClass))
#define FOLKS_INSPECT_COMMANDS_IS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_COMMANDS_TYPE_DEBUG))
#define FOLKS_INSPECT_COMMANDS_IS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_COMMANDS_TYPE_DEBUG))
#define FOLKS_INSPECT_COMMANDS_DEBUG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_COMMANDS_TYPE_DEBUG, FolksInspectCommandsDebugClass))

typedef struct _FolksInspectCommandsDebug FolksInspectCommandsDebug;
typedef struct _FolksInspectCommandsDebugClass FolksInspectCommandsDebugClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FolksInspectCommandPrivate FolksInspectCommandPrivate;
typedef struct _FolksInspectParamSpecCommand FolksInspectParamSpecCommand;

struct _FolksInspectClient {
	GObject parent_instance;
	FolksInspectClientPrivate * priv;
	GeeHashMap* commands;
};

struct _FolksInspectClientClass {
	GObjectClass parent_class;
};

struct _FolksInspectClientPrivate {
	GMainLoop* main_loop;
	GThread* folks_thread;
	FolksIndividualAggregator* _aggregator;
	FolksBackendStore* _backend_store;
	FolksInspectSignalManager* _signal_manager;
};

struct _Block3Data {
	int _ref_count_;
	FolksInspectClient * self;
	FolksBackend* backend;
};

struct _FolksInspectCommand {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectCommandPrivate * priv;
	FolksInspectClient* client;
};

struct _FolksInspectCommandClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectCommand *self);
	void (*run) (FolksInspectCommand* self, const gchar* command_string);
	gchar** (*complete_subcommand) (FolksInspectCommand* self, const gchar* subcommand, int* result_length1);
	const gchar* (*get_name) (FolksInspectCommand* self);
	const gchar* (*get_description) (FolksInspectCommand* self);
	const gchar* (*get_help) (FolksInspectCommand* self);
};

struct _FolksInspectParamSpecCommand {
	GParamSpec parent_instance;
};


extern FolksInspectClient* main_client;
FolksInspectClient* main_client = NULL;
static gpointer folks_inspect_client_parent_class = NULL;
static gpointer folks_inspect_command_parent_class = NULL;

GType folks_inspect_client_get_type (void) G_GNUC_CONST;
gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
GType folks_inspect_signal_manager_get_type (void) G_GNUC_CONST;
#define FOLKS_INSPECT_CLIENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientPrivate))
enum  {
	FOLKS_INSPECT_CLIENT_DUMMY_PROPERTY,
	FOLKS_INSPECT_CLIENT_AGGREGATOR,
	FOLKS_INSPECT_CLIENT_BACKEND_STORE,
	FOLKS_INSPECT_CLIENT_SIGNAL_MANAGER
};
gint folks_inspect_client_main (gchar** args, int args_length1);
FolksInspectClient* folks_inspect_client_new (void);
FolksInspectClient* folks_inspect_client_construct (GType object_type);
void folks_inspect_client_run_interactive (FolksInspectClient* self);
static void* folks_inspect_client_folks_thread_main (FolksInspectClient* self);
FolksInspectSignalManager* folks_inspect_signal_manager_new (void);
FolksInspectSignalManager* folks_inspect_signal_manager_construct (GType object_type);
static void folks_inspect_client_set_signal_manager (FolksInspectClient* self, FolksInspectSignalManager* value);
static void folks_inspect_client_set_aggregator (FolksInspectClient* self, FolksIndividualAggregator* value);
FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
static void folks_inspect_client_set_backend_store (FolksInspectClient* self, FolksBackendStore* value);
FolksBackendStore* folks_inspect_client_get_backend_store (FolksInspectClient* self);
static void __lambda2_ (FolksInspectClient* self, FolksBackendStore* bs, FolksBackend* b);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void __lambda3_ (Block3Data* _data3_, GObject* obj, GAsyncResult* _result_);
static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void ___lambda2__folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self);
void folks_inspect_utils_init (void);
FolksInspectCommandsQuit* folks_inspect_commands_quit_new (FolksInspectClient* client);
FolksInspectCommandsQuit* folks_inspect_commands_quit_construct (GType object_type, FolksInspectClient* client);
GType folks_inspect_commands_quit_get_type (void) G_GNUC_CONST;
FolksInspectCommandsHelp* folks_inspect_commands_help_new (FolksInspectClient* client);
FolksInspectCommandsHelp* folks_inspect_commands_help_construct (GType object_type, FolksInspectClient* client);
GType folks_inspect_commands_help_get_type (void) G_GNUC_CONST;
FolksInspectCommandsIndividuals* folks_inspect_commands_individuals_new (FolksInspectClient* client);
FolksInspectCommandsIndividuals* folks_inspect_commands_individuals_construct (GType object_type, FolksInspectClient* client);
GType folks_inspect_commands_individuals_get_type (void) G_GNUC_CONST;
FolksInspectCommandsLinking* folks_inspect_commands_linking_new (FolksInspectClient* client);
FolksInspectCommandsLinking* folks_inspect_commands_linking_construct (GType object_type, FolksInspectClient* client);
GType folks_inspect_commands_linking_get_type (void) G_GNUC_CONST;
FolksInspectCommandsPersonas* folks_inspect_commands_personas_new (FolksInspectClient* client);
FolksInspectCommandsPersonas* folks_inspect_commands_personas_construct (GType object_type, FolksInspectClient* client);
GType folks_inspect_commands_personas_get_type (void) G_GNUC_CONST;
FolksInspectCommandsBackends* folks_inspect_commands_backends_new (FolksInspectClient* client);
FolksInspectCommandsBackends* folks_inspect_commands_backends_construct (GType object_type, FolksInspectClient* client);
GType folks_inspect_commands_backends_get_type (void) G_GNUC_CONST;
FolksInspectCommandsPersonaStores* folks_inspect_commands_persona_stores_new (FolksInspectClient* client);
FolksInspectCommandsPersonaStores* folks_inspect_commands_persona_stores_construct (GType object_type, FolksInspectClient* client);
GType folks_inspect_commands_persona_stores_get_type (void) G_GNUC_CONST;
FolksInspectCommandsSignals* folks_inspect_commands_signals_new (FolksInspectClient* client);
FolksInspectCommandsSignals* folks_inspect_commands_signals_construct (GType object_type, FolksInspectClient* client);
GType folks_inspect_commands_signals_get_type (void) G_GNUC_CONST;
FolksInspectCommandsDebug* folks_inspect_commands_debug_new (FolksInspectClient* client);
FolksInspectCommandsDebug* folks_inspect_commands_debug_construct (GType object_type, FolksInspectClient* client);
GType folks_inspect_commands_debug_get_type (void) G_GNUC_CONST;
static gpointer _folks_inspect_client_folks_thread_main_gthread_func (gpointer self);
static gchar** folks_inspect_client_completion_cb (const gchar* word, gint start, gint end);
static gchar** _folks_inspect_client_completion_cb_rl_completion_func_t (const gchar* str, gint a, gint b);
static FolksInspectCommand* folks_inspect_client_parse_command_line (const gchar* command_line, gchar** command_name, gchar** subcommand);
void folks_inspect_command_run (FolksInspectCommand* self, const gchar* command_string);
gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word, gint state);
static gchar* _folks_inspect_utils_command_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a);
static gchar** _vala_array_dup11 (gchar** self, int length);
gchar** folks_inspect_command_complete_subcommand (FolksInspectCommand* self, const gchar* subcommand, int* result_length1);
FolksInspectSignalManager* folks_inspect_client_get_signal_manager (FolksInspectClient* self);
static void folks_inspect_client_finalize (GObject* obj);
static void _vala_folks_inspect_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_inspect_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
enum  {
	FOLKS_INSPECT_COMMAND_DUMMY_PROPERTY
};
FolksInspectCommand* folks_inspect_command_construct (GType object_type, FolksInspectClient* client);
static void folks_inspect_command_real_run (FolksInspectCommand* self, const gchar* command_string);
static gchar** folks_inspect_command_real_complete_subcommand (FolksInspectCommand* self, const gchar* subcommand, int* result_length1);
const gchar* folks_inspect_command_get_name (FolksInspectCommand* self);
const gchar* folks_inspect_command_get_description (FolksInspectCommand* self);
const gchar* folks_inspect_command_get_help (FolksInspectCommand* self);
static void folks_inspect_command_finalize (FolksInspectCommand* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


gint folks_inspect_client_main (gchar** args, int args_length1) {
	gint result = 0;
	FolksInspectClient* _tmp0_;
	FolksInspectClient* _tmp1_;
	_tmp0_ = folks_inspect_client_new ();
	_g_object_unref0 (main_client);
	main_client = _tmp0_;
	_tmp1_ = main_client;
	folks_inspect_client_run_interactive (_tmp1_);
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return folks_inspect_client_main (argv, argc);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->backend);
		g_slice_free (Block3Data, _data3_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda3_ (Block3Data* _data3_, GObject* obj, GAsyncResult* _result_) {
	FolksInspectClient * self;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	g_return_if_fail (_result_ != NULL);
	{
		GAsyncResult* _tmp0_;
		_tmp0_ = _result_;
		folks_backend_prepare_finish (_data3_->backend, _tmp0_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp1_ = folks_backend_get_name (_data3_->backend);
		_tmp2_ = _tmp1_;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("inspect.vala:70: Error preparing Backend '%s': %s", _tmp2_, _tmp4_);
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ___lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda3_ (self, source_object, res);
	block3_data_unref (self);
}


static void __lambda2_ (FolksInspectClient* self, FolksBackendStore* bs, FolksBackend* b) {
	Block3Data* _data3_;
	FolksBackend* _tmp0_;
	FolksBackend* _tmp1_;
	g_return_if_fail (bs != NULL);
	g_return_if_fail (b != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = b;
	_tmp1_ = _g_object_ref0 (FOLKS_BACKEND (_tmp0_));
	_data3_->backend = _tmp1_;
	folks_backend_prepare (_data3_->backend, ___lambda3__gasync_ready_callback, block3_data_ref (_data3_));
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void ___lambda2__folks_backend_store_backend_available (FolksBackendStore* _sender, FolksBackend* backend, gpointer self) {
	__lambda2_ (self, _sender, backend);
}


static void* folks_inspect_client_folks_thread_main (FolksInspectClient* self) {
	void* result = NULL;
	GMainLoop* _tmp0_;
	FolksInspectSignalManager* _tmp1_;
	FolksInspectSignalManager* _tmp2_;
	FolksIndividualAggregator* _tmp3_;
	FolksIndividualAggregator* _tmp4_;
	FolksIndividualAggregator* _tmp5_;
	FolksBackendStore* _tmp6_ = NULL;
	FolksBackendStore* _tmp7_;
	FolksBackendStore* _tmp8_;
	FolksBackendStore* _tmp9_;
	GMainLoop* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_g_main_loop_unref0 (self->priv->main_loop);
	self->priv->main_loop = _tmp0_;
	_tmp1_ = folks_inspect_signal_manager_new ();
	_tmp2_ = _tmp1_;
	folks_inspect_client_set_signal_manager (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = folks_individual_aggregator_new ();
	_tmp4_ = _tmp3_;
	folks_inspect_client_set_aggregator (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_aggregator;
	folks_individual_aggregator_prepare (_tmp5_, NULL, NULL);
	_tmp6_ = folks_backend_store_dup ();
	_tmp7_ = _tmp6_;
	folks_inspect_client_set_backend_store (self, _tmp7_);
	_g_object_unref0 (_tmp7_);
	_tmp8_ = self->priv->_backend_store;
	g_signal_connect_object (_tmp8_, "backend-available", (GCallback) ___lambda2__folks_backend_store_backend_available, self, 0);
	_tmp9_ = self->priv->_backend_store;
	folks_backend_store_load_backends (_tmp9_, NULL, NULL);
	_tmp10_ = self->priv->main_loop;
	g_main_loop_run (_tmp10_);
	result = NULL;
	return result;
}


static gpointer _folks_inspect_client_folks_thread_main_gthread_func (gpointer self) {
	gpointer result;
	result = folks_inspect_client_folks_thread_main (self);
	return result;
}


FolksInspectClient* folks_inspect_client_construct (GType object_type) {
	FolksInspectClient * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	FolksInspectCommandsQuit* _tmp4_;
	FolksInspectCommandsQuit* _tmp5_;
	GeeHashMap* _tmp6_;
	FolksInspectCommandsHelp* _tmp7_;
	FolksInspectCommandsHelp* _tmp8_;
	GeeHashMap* _tmp9_;
	FolksInspectCommandsIndividuals* _tmp10_;
	FolksInspectCommandsIndividuals* _tmp11_;
	GeeHashMap* _tmp12_;
	FolksInspectCommandsLinking* _tmp13_;
	FolksInspectCommandsLinking* _tmp14_;
	GeeHashMap* _tmp15_;
	FolksInspectCommandsPersonas* _tmp16_;
	FolksInspectCommandsPersonas* _tmp17_;
	GeeHashMap* _tmp18_;
	FolksInspectCommandsBackends* _tmp19_;
	FolksInspectCommandsBackends* _tmp20_;
	GeeHashMap* _tmp21_;
	FolksInspectCommandsPersonaStores* _tmp22_;
	FolksInspectCommandsPersonaStores* _tmp23_;
	GeeHashMap* _tmp24_;
	FolksInspectCommandsSignals* _tmp25_;
	FolksInspectCommandsSignals* _tmp26_;
	GeeHashMap* _tmp27_;
	FolksInspectCommandsDebug* _tmp28_;
	FolksInspectCommandsDebug* _tmp29_;
	GError * _inner_error_ = NULL;
	self = (FolksInspectClient*) g_object_new (object_type, NULL);
	folks_inspect_utils_init ();
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_INSPECT_TYPE_COMMAND, (GBoxedCopyFunc) folks_inspect_command_ref, folks_inspect_command_unref, _tmp0_, _tmp1_, NULL);
	_g_object_unref0 (self->commands);
	self->commands = _tmp2_;
	_tmp3_ = self->commands;
	_tmp4_ = folks_inspect_commands_quit_new (self);
	_tmp5_ = _tmp4_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, "quit", (FolksInspectCommand*) _tmp5_);
	_folks_inspect_command_unref0 (_tmp5_);
	_tmp6_ = self->commands;
	_tmp7_ = folks_inspect_commands_help_new (self);
	_tmp8_ = _tmp7_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, "help", (FolksInspectCommand*) _tmp8_);
	_folks_inspect_command_unref0 (_tmp8_);
	_tmp9_ = self->commands;
	_tmp10_ = folks_inspect_commands_individuals_new (self);
	_tmp11_ = _tmp10_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp9_, "individuals", (FolksInspectCommand*) _tmp11_);
	_folks_inspect_command_unref0 (_tmp11_);
	_tmp12_ = self->commands;
	_tmp13_ = folks_inspect_commands_linking_new (self);
	_tmp14_ = _tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, "linking", (FolksInspectCommand*) _tmp14_);
	_folks_inspect_command_unref0 (_tmp14_);
	_tmp15_ = self->commands;
	_tmp16_ = folks_inspect_commands_personas_new (self);
	_tmp17_ = _tmp16_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp15_, "personas", (FolksInspectCommand*) _tmp17_);
	_folks_inspect_command_unref0 (_tmp17_);
	_tmp18_ = self->commands;
	_tmp19_ = folks_inspect_commands_backends_new (self);
	_tmp20_ = _tmp19_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, "backends", (FolksInspectCommand*) _tmp20_);
	_folks_inspect_command_unref0 (_tmp20_);
	_tmp21_ = self->commands;
	_tmp22_ = folks_inspect_commands_persona_stores_new (self);
	_tmp23_ = _tmp22_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp21_, "persona-stores", (FolksInspectCommand*) _tmp23_);
	_folks_inspect_command_unref0 (_tmp23_);
	_tmp24_ = self->commands;
	_tmp25_ = folks_inspect_commands_signals_new (self);
	_tmp26_ = _tmp25_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp24_, "signals", (FolksInspectCommand*) _tmp26_);
	_folks_inspect_command_unref0 (_tmp26_);
	_tmp27_ = self->commands;
	_tmp28_ = folks_inspect_commands_debug_new (self);
	_tmp29_ = _tmp28_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, "debug", (FolksInspectCommand*) _tmp29_);
	_folks_inspect_command_unref0 (_tmp29_);
	{
		GThread* _tmp30_ = NULL;
		GThread* _tmp31_;
		_tmp30_ = g_thread_create (_folks_inspect_client_folks_thread_main_gthread_func, self, TRUE, &_inner_error_);
		_tmp31_ = _tmp30_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_THREAD_ERROR) {
				goto __catch3_g_thread_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		self->priv->folks_thread = _tmp31_;
	}
	goto __finally3;
	__catch3_g_thread_error:
	{
		GError* e = NULL;
		FILE* _tmp32_;
		const gchar* _tmp33_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp32_ = stdout;
		_tmp33_ = e->message;
		fprintf (_tmp32_, "Couldn't create aggregator thread: %s", _tmp33_);
		exit (1);
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


FolksInspectClient* folks_inspect_client_new (void) {
	return folks_inspect_client_construct (FOLKS_INSPECT_TYPE_CLIENT);
}


static gchar** _folks_inspect_client_completion_cb_rl_completion_func_t (const gchar* str, gint a, gint b) {
	gchar** result;
	result = folks_inspect_client_completion_cb (str, a, b);
	return result;
}


static gchar* __readline (const gchar* prompt) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	void* _tmp1_ = NULL;
	void* cstr;
	void* _tmp2_;
	void* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* str;
	void* _tmp5_;
	_tmp0_ = prompt;
	_tmp1_ = readline (_tmp0_);
	cstr = _tmp1_;
	_tmp2_ = cstr;
	if (_tmp2_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp3_ = cstr;
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
	str = _tmp4_;
	_tmp5_ = cstr;
	free (_tmp5_);
	result = str;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


void folks_inspect_client_run_interactive (FolksInspectClient* self) {
	g_return_if_fail (self != NULL);
	rl_readline_name = "folks-inspect";
	rl_attempted_completion_function = _folks_inspect_client_completion_cb_rl_completion_func_t;
	while (TRUE) {
		gchar* _tmp0_ = NULL;
		gchar* command_line;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		const gchar* _tmp4_;
		gchar* subcommand = NULL;
		gchar* command_name = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		FolksInspectCommand* _tmp8_ = NULL;
		FolksInspectCommand* command;
		FolksInspectCommand* _tmp9_;
		const gchar* _tmp14_;
		_tmp0_ = __readline ("> ");
		command_line = _tmp0_;
		_tmp1_ = command_line;
		if (_tmp1_ == NULL) {
			_g_free0 (command_line);
			continue;
		}
		_tmp2_ = command_line;
		_tmp3_ = string_strip (_tmp2_);
		_g_free0 (command_line);
		command_line = _tmp3_;
		_tmp4_ = command_line;
		if (g_strcmp0 (_tmp4_, "") == 0) {
			_g_free0 (command_line);
			continue;
		}
		_tmp5_ = command_line;
		_tmp8_ = folks_inspect_client_parse_command_line (_tmp5_, &_tmp6_, &_tmp7_);
		_g_free0 (command_name);
		command_name = _tmp6_;
		_g_free0 (subcommand);
		subcommand = _tmp7_;
		command = _tmp8_;
		_tmp9_ = command;
		if (_tmp9_ != NULL) {
			FolksInspectCommand* _tmp10_;
			const gchar* _tmp11_;
			_tmp10_ = command;
			_tmp11_ = subcommand;
			folks_inspect_command_run (_tmp10_, _tmp11_);
		} else {
			FILE* _tmp12_;
			const gchar* _tmp13_;
			_tmp12_ = stdout;
			_tmp13_ = command_name;
			fprintf (_tmp12_, "Unrecognised command '%s'.\n", _tmp13_);
		}
		_tmp14_ = command_line;
		add_history (_tmp14_);
		_folks_inspect_command_unref0 (command);
		_g_free0 (command_name);
		_g_free0 (subcommand);
		_g_free0 (command_line);
	}
}


static FolksInspectCommand* folks_inspect_client_parse_command_line (const gchar* command_line, gchar** command_name, gchar** subcommand) {
	gchar* _vala_command_name = NULL;
	gchar* _vala_subcommand = NULL;
	FolksInspectCommand* result = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** parts;
	gint parts_length1;
	gint _parts_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gboolean _tmp12_;
	FolksInspectClient* _tmp16_;
	GeeHashMap* _tmp17_;
	gchar** _tmp18_;
	gint _tmp18__length1;
	const gchar* _tmp19_;
	gpointer _tmp20_ = NULL;
	g_return_val_if_fail (command_line != NULL, NULL);
	_tmp0_ = g_strdup ("");
	_g_free0 (_vala_command_name);
	_vala_command_name = _tmp0_;
	_g_free0 (_vala_subcommand);
	_vala_subcommand = NULL;
	_tmp1_ = command_line;
	_tmp3_ = _tmp2_ = g_strsplit (_tmp1_, " ", 2);
	parts = _tmp3_;
	parts_length1 = _vala_array_length (_tmp2_);
	_parts_size_ = parts_length1;
	_tmp4_ = parts;
	_tmp4__length1 = parts_length1;
	if (_tmp4__length1 < 1) {
		result = NULL;
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
		if (command_name) {
			*command_name = _vala_command_name;
		} else {
			_g_free0 (_vala_command_name);
		}
		if (subcommand) {
			*subcommand = _vala_subcommand;
		} else {
			_g_free0 (_vala_subcommand);
		}
		return result;
	}
	_tmp5_ = parts;
	_tmp5__length1 = parts_length1;
	_tmp6_ = _tmp5_[0];
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (_vala_command_name);
	_vala_command_name = _tmp7_;
	_tmp9_ = parts;
	_tmp9__length1 = parts_length1;
	if (_tmp9__length1 == 2) {
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		_tmp10_ = parts;
		_tmp10__length1 = parts_length1;
		_tmp11_ = _tmp10_[1];
		_tmp8_ = g_strcmp0 (_tmp11_, "") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	if (_tmp12_) {
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp13_ = parts;
		_tmp13__length1 = parts_length1;
		_tmp14_ = _tmp13_[1];
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (_vala_subcommand);
		_vala_subcommand = _tmp15_;
	} else {
		_g_free0 (_vala_subcommand);
		_vala_subcommand = NULL;
	}
	_tmp16_ = main_client;
	_tmp17_ = _tmp16_->commands;
	_tmp18_ = parts;
	_tmp18__length1 = parts_length1;
	_tmp19_ = _tmp18_[0];
	_tmp20_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, _tmp19_);
	result = (FolksInspectCommand*) _tmp20_;
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	if (command_name) {
		*command_name = _vala_command_name;
	} else {
		_g_free0 (_vala_command_name);
	}
	if (subcommand) {
		*subcommand = _vala_subcommand;
	} else {
		_g_free0 (_vala_subcommand);
	}
	return result;
}


static gchar* _folks_inspect_utils_command_name_completion_cb_rl_compentry_func_t (const gchar* str, gint a) {
	gchar* result;
	result = folks_inspect_utils_command_name_completion_cb (str, a);
	return result;
}


static gchar** _vala_array_dup11 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar** folks_inspect_client_completion_cb (const gchar* word, gint start, gint end) {
	gchar** result = NULL;
	gint _tmp0_;
	gchar* command_name = NULL;
	gchar* subcommand = NULL;
	const gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	FolksInspectCommand* _tmp8_ = NULL;
	FolksInspectCommand* command;
	FolksInspectCommand* _tmp9_;
	g_return_val_if_fail (word != NULL, NULL);
	_tmp0_ = start;
	if (_tmp0_ == 0) {
		const gchar* _tmp1_;
		gchar** _tmp2_;
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp1_ = word;
		_tmp3_ = _tmp2_ = rl_completion_matches (_tmp1_, _folks_inspect_utils_command_name_completion_cb_rl_compentry_func_t);
		_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup11 (_tmp3_, _vala_array_length (_tmp2_)) : ((gpointer) _tmp3_);
		_tmp4__length1 = _vala_array_length (_tmp2_);
		result = _tmp4_;
		return result;
	}
	_tmp5_ = rl_line_buffer;
	_tmp8_ = folks_inspect_client_parse_command_line (_tmp5_, &_tmp6_, &_tmp7_);
	_g_free0 (command_name);
	command_name = _tmp6_;
	_g_free0 (subcommand);
	subcommand = _tmp7_;
	command = _tmp8_;
	_tmp9_ = command;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		FolksInspectCommand* _tmp12_;
		const gchar* _tmp13_;
		gint _tmp14_ = 0;
		gchar** _tmp15_ = NULL;
		_tmp10_ = subcommand;
		if (_tmp10_ == NULL) {
			gchar* _tmp11_;
			_tmp11_ = g_strdup ("");
			_g_free0 (subcommand);
			subcommand = _tmp11_;
		}
		_tmp12_ = command;
		_tmp13_ = subcommand;
		_tmp15_ = folks_inspect_command_complete_subcommand (_tmp12_, _tmp13_, &_tmp14_);
		result = _tmp15_;
		_folks_inspect_command_unref0 (command);
		_g_free0 (subcommand);
		_g_free0 (command_name);
		return result;
	}
	result = NULL;
	_folks_inspect_command_unref0 (command);
	_g_free0 (subcommand);
	_g_free0 (command_name);
	return result;
}


FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self) {
	FolksIndividualAggregator* result;
	FolksIndividualAggregator* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_aggregator;
	result = _tmp0_;
	return result;
}


static void folks_inspect_client_set_aggregator (FolksInspectClient* self, FolksIndividualAggregator* value) {
	FolksIndividualAggregator* _tmp0_;
	FolksIndividualAggregator* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_aggregator);
	self->priv->_aggregator = _tmp1_;
	g_object_notify ((GObject *) self, "aggregator");
}


FolksBackendStore* folks_inspect_client_get_backend_store (FolksInspectClient* self) {
	FolksBackendStore* result;
	FolksBackendStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_backend_store;
	result = _tmp0_;
	return result;
}


static void folks_inspect_client_set_backend_store (FolksInspectClient* self, FolksBackendStore* value) {
	FolksBackendStore* _tmp0_;
	FolksBackendStore* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_backend_store);
	self->priv->_backend_store = _tmp1_;
	g_object_notify ((GObject *) self, "backend-store");
}


FolksInspectSignalManager* folks_inspect_client_get_signal_manager (FolksInspectClient* self) {
	FolksInspectSignalManager* result;
	FolksInspectSignalManager* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_manager;
	result = _tmp0_;
	return result;
}


static void folks_inspect_client_set_signal_manager (FolksInspectClient* self, FolksInspectSignalManager* value) {
	FolksInspectSignalManager* _tmp0_;
	FolksInspectSignalManager* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_signal_manager);
	self->priv->_signal_manager = _tmp1_;
	g_object_notify ((GObject *) self, "signal-manager");
}


static void folks_inspect_client_class_init (FolksInspectClientClass * klass) {
	folks_inspect_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksInspectClientPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_inspect_client_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_inspect_client_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_inspect_client_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INSPECT_CLIENT_AGGREGATOR, g_param_spec_object ("aggregator", "aggregator", "aggregator", FOLKS_TYPE_INDIVIDUAL_AGGREGATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INSPECT_CLIENT_BACKEND_STORE, g_param_spec_object ("backend-store", "backend-store", "backend-store", FOLKS_TYPE_BACKEND_STORE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INSPECT_CLIENT_SIGNAL_MANAGER, g_param_spec_object ("signal-manager", "signal-manager", "signal-manager", FOLKS_INSPECT_TYPE_SIGNAL_MANAGER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void folks_inspect_client_instance_init (FolksInspectClient * self) {
	self->priv = FOLKS_INSPECT_CLIENT_GET_PRIVATE (self);
}


static void folks_inspect_client_finalize (GObject* obj) {
	FolksInspectClient * self;
	self = FOLKS_INSPECT_CLIENT (obj);
	_g_object_unref0 (self->commands);
	_g_main_loop_unref0 (self->priv->main_loop);
	_g_object_unref0 (self->priv->_aggregator);
	_g_object_unref0 (self->priv->_backend_store);
	_g_object_unref0 (self->priv->_signal_manager);
	G_OBJECT_CLASS (folks_inspect_client_parent_class)->finalize (obj);
}


GType folks_inspect_client_get_type (void) {
	static volatile gsize folks_inspect_client_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectClient), 0, (GInstanceInitFunc) folks_inspect_client_instance_init, NULL };
		GType folks_inspect_client_type_id;
		folks_inspect_client_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksInspectClient", &g_define_type_info, 0);
		g_once_init_leave (&folks_inspect_client_type_id__volatile, folks_inspect_client_type_id);
	}
	return folks_inspect_client_type_id__volatile;
}


static void _vala_folks_inspect_client_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksInspectClient * self;
	self = FOLKS_INSPECT_CLIENT (object);
	switch (property_id) {
		case FOLKS_INSPECT_CLIENT_AGGREGATOR:
		g_value_set_object (value, folks_inspect_client_get_aggregator (self));
		break;
		case FOLKS_INSPECT_CLIENT_BACKEND_STORE:
		g_value_set_object (value, folks_inspect_client_get_backend_store (self));
		break;
		case FOLKS_INSPECT_CLIENT_SIGNAL_MANAGER:
		g_value_set_object (value, folks_inspect_client_get_signal_manager (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_inspect_client_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksInspectClient * self;
	self = FOLKS_INSPECT_CLIENT (object);
	switch (property_id) {
		case FOLKS_INSPECT_CLIENT_AGGREGATOR:
		folks_inspect_client_set_aggregator (self, g_value_get_object (value));
		break;
		case FOLKS_INSPECT_CLIENT_BACKEND_STORE:
		folks_inspect_client_set_backend_store (self, g_value_get_object (value));
		break;
		case FOLKS_INSPECT_CLIENT_SIGNAL_MANAGER:
		folks_inspect_client_set_signal_manager (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


FolksInspectCommand* folks_inspect_command_construct (GType object_type, FolksInspectClient* client) {
	FolksInspectCommand* self = NULL;
	FolksInspectClient* _tmp0_;
	FolksInspectClient* _tmp1_;
	g_return_val_if_fail (client != NULL, NULL);
	self = (FolksInspectCommand*) g_type_create_instance (object_type);
	_tmp0_ = client;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->client);
	self->client = _tmp1_;
	return self;
}


static void folks_inspect_command_real_run (FolksInspectCommand* self, const gchar* command_string) {
	g_critical ("Type `%s' does not implement abstract method `folks_inspect_command_run'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}


void folks_inspect_command_run (FolksInspectCommand* self, const gchar* command_string) {
	g_return_if_fail (self != NULL);
	FOLKS_INSPECT_COMMAND_GET_CLASS (self)->run (self, command_string);
}


static gchar** folks_inspect_command_real_complete_subcommand (FolksInspectCommand* self, const gchar* subcommand, int* result_length1) {
	gchar** result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	g_return_val_if_fail (subcommand != NULL, NULL);
	_tmp0_ = NULL;
	_tmp0__length1 = 0;
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


gchar** folks_inspect_command_complete_subcommand (FolksInspectCommand* self, const gchar* subcommand, int* result_length1) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_INSPECT_COMMAND_GET_CLASS (self)->complete_subcommand (self, subcommand, result_length1);
}


const gchar* folks_inspect_command_get_name (FolksInspectCommand* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_INSPECT_COMMAND_GET_CLASS (self)->get_name (self);
}


const gchar* folks_inspect_command_get_description (FolksInspectCommand* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_INSPECT_COMMAND_GET_CLASS (self)->get_description (self);
}


const gchar* folks_inspect_command_get_help (FolksInspectCommand* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_INSPECT_COMMAND_GET_CLASS (self)->get_help (self);
}


static void folks_inspect_value_command_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void folks_inspect_value_command_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		folks_inspect_command_unref (value->data[0].v_pointer);
	}
}


static void folks_inspect_value_command_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = folks_inspect_command_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer folks_inspect_value_command_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* folks_inspect_value_command_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FolksInspectCommand* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = folks_inspect_command_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* folks_inspect_value_command_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FolksInspectCommand** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = folks_inspect_command_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FolksInspectParamSpecCommand* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FOLKS_INSPECT_TYPE_COMMAND), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer folks_inspect_value_get_command (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_COMMAND), NULL);
	return value->data[0].v_pointer;
}


void folks_inspect_value_set_command (GValue* value, gpointer v_object) {
	FolksInspectCommand* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_COMMAND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_COMMAND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		folks_inspect_command_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_command_unref (old);
	}
}


void folks_inspect_value_take_command (GValue* value, gpointer v_object) {
	FolksInspectCommand* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_COMMAND));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_COMMAND));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_command_unref (old);
	}
}


static void folks_inspect_command_class_init (FolksInspectCommandClass * klass) {
	folks_inspect_command_parent_class = g_type_class_peek_parent (klass);
	FOLKS_INSPECT_COMMAND_CLASS (klass)->finalize = folks_inspect_command_finalize;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->run = folks_inspect_command_real_run;
	FOLKS_INSPECT_COMMAND_CLASS (klass)->complete_subcommand = folks_inspect_command_real_complete_subcommand;
}


static void folks_inspect_command_instance_init (FolksInspectCommand * self) {
	self->ref_count = 1;
}


static void folks_inspect_command_finalize (FolksInspectCommand* obj) {
	FolksInspectCommand * self;
	self = FOLKS_INSPECT_COMMAND (obj);
	_g_object_unref0 (self->client);
}


GType folks_inspect_command_get_type (void) {
	static volatile gsize folks_inspect_command_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_command_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { folks_inspect_value_command_init, folks_inspect_value_command_free_value, folks_inspect_value_command_copy_value, folks_inspect_value_command_peek_pointer, "p", folks_inspect_value_command_collect_value, "p", folks_inspect_value_command_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectCommandClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_command_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectCommand), 0, (GInstanceInitFunc) folks_inspect_command_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType folks_inspect_command_type_id;
		folks_inspect_command_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FolksInspectCommand", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&folks_inspect_command_type_id__volatile, folks_inspect_command_type_id);
	}
	return folks_inspect_command_type_id__volatile;
}


gpointer folks_inspect_command_ref (gpointer instance) {
	FolksInspectCommand* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void folks_inspect_command_unref (gpointer instance) {
	FolksInspectCommand* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FOLKS_INSPECT_COMMAND_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



