/* aggregation.c generated by valac 0.13.1.106-1068, the Vala compiler
 * generated from aggregation.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Alban Crequy <alban.crequy@collabora.co.uk>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <libsocialweb-test.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>
#include <folks/folks.h>
#include <gee.h>


#define TYPE_AGGREGATION_TESTS (aggregation_tests_get_type ())
#define AGGREGATION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AGGREGATION_TESTS, AggregationTests))
#define AGGREGATION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AGGREGATION_TESTS, AggregationTestsClass))
#define IS_AGGREGATION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AGGREGATION_TESTS))
#define IS_AGGREGATION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AGGREGATION_TESTS))
#define AGGREGATION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AGGREGATION_TESTS, AggregationTestsClass))

typedef struct _AggregationTests AggregationTests;
typedef struct _AggregationTestsClass AggregationTestsClass;
typedef struct _AggregationTestsPrivate AggregationTestsPrivate;
#define _libsocialweb_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (libsocialweb_test_backend_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

struct _AggregationTests {
	FolksTestCase parent_instance;
	AggregationTestsPrivate * priv;
};

struct _AggregationTestsClass {
	FolksTestCaseClass parent_class;
};

struct _AggregationTestsPrivate {
	LibsocialwebTestBackend* _lsw_backend;
};

struct _Block1Data {
	int _ref_count_;
	AggregationTests * self;
	GMainLoop* main_loop;
	LibsocialwebTestLibsocialwebServiceTest* mysocialnetwork1;
	LibsocialwebTestLibsocialwebServiceTest* mysocialnetwork2;
	FolksIndividualAggregator* aggregator;
	FolksIndividual** individual_gathered;
	gint individual_gathered_length1;
	gint _individual_gathered_size_;
	GeeHashSet* personas;
};

struct _Block2Data {
	int _ref_count_;
	AggregationTests * self;
	gchar* path;
};

struct _Block3Data {
	int _ref_count_;
	AggregationTests * self;
	gchar* path;
};


static gpointer aggregation_tests_parent_class = NULL;

GType aggregation_tests_get_type (void) G_GNUC_CONST;
#define AGGREGATION_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AGGREGATION_TESTS, AggregationTestsPrivate))
enum  {
	AGGREGATION_TESTS_DUMMY_PROPERTY
};
#define AGGREGATION_TESTS_STORE_FILE_PATH "folks-test-libsocialweb-aggregation-store.ini"
#define AGGREGATION_TESTS_KF_RELATIONSHIPS_FILE_PATH "folks-test-libsocialweb-aggregation-relationships.ini"
AggregationTests* aggregation_tests_new (void);
AggregationTests* aggregation_tests_construct (GType object_type);
void aggregation_tests_test_aggregation_libsocialweb (AggregationTests* self);
static void _aggregation_tests_test_aggregation_libsocialweb_folks_test_case_test_method (gpointer self);
static void aggregation_tests_real_set_up (FolksTestCase* base);
static void aggregation_tests_real_tear_down (FolksTestCase* base);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void _lambda0_ (Block1Data* _data1_);
static void __lambda0__libsocialweb_test_backend_ready (LibsocialwebTestBackend* _sender, gpointer self);
static gboolean _lambda1_ (AggregationTests* self);
static gboolean __lambda1__gsource_func (gpointer self);
static void _lambda2_ (const gchar* query, GHashTable* p, const gchar* path, Block1Data* _data1_);
static void _lambda3_ (const gchar* path, AggregationTests* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _lambda4_ (Block2Data* _data2_);
static gboolean __lambda4__gsource_func (gpointer self);
static void __lambda3__libsocialweb_test_libsocialweb_contact_view_test_start_called (LibsocialwebTestLibsocialwebContactViewTest* _sender, const gchar* path, gpointer self);
static void __lambda2__libsocialweb_test_libsocialweb_service_test_open_view_called (LibsocialwebTestLibsocialwebServiceTest* _sender, const gchar* query, GHashTable* p, const gchar* path, gpointer self);
static void _lambda5_ (const gchar* query, GHashTable* p, const gchar* path, Block1Data* _data1_);
static void _lambda6_ (const gchar* path, AggregationTests* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean _lambda7_ (Block3Data* _data3_);
static gboolean __lambda7__gsource_func (gpointer self);
static void __lambda6__libsocialweb_test_libsocialweb_contact_view_test_start_called (LibsocialwebTestLibsocialwebContactViewTest* _sender, const gchar* path, gpointer self);
static void __lambda5__libsocialweb_test_libsocialweb_service_test_open_view_called (LibsocialwebTestLibsocialwebServiceTest* _sender, const gchar* query, GHashTable* p, const gchar* path, gpointer self);
static void _lambda8_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block1Data* _data1_);
static void _vala_array_add1 (FolksIndividual*** array, int* length, int* size, FolksIndividual* value);
static void __lambda8__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda9_ (AggregationTests* self);
static gboolean __lambda9__gsource_func (gpointer self);
static void _lambda10_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block1Data* _data1_);
static void __lambda10__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self);
static gboolean _lambda11_ (Block1Data* _data1_);
static gboolean __lambda11__gsource_func (gpointer self);
static gboolean _lambda12_ (AggregationTests* self);
static gboolean __lambda12__gsource_func (gpointer self);
static void aggregation_tests_finalize (GObject* obj);
gint _vala_main (gchar** args, int args_length1);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _aggregation_tests_test_aggregation_libsocialweb_folks_test_case_test_method (gpointer self) {
	aggregation_tests_test_aggregation_libsocialweb (self);
}


AggregationTests* aggregation_tests_construct (GType object_type) {
	AggregationTests * self = NULL;
	LibsocialwebTestBackend* _tmp0_;
	self = (AggregationTests*) folks_test_case_construct (object_type, "Aggregation");
	_tmp0_ = libsocialweb_test_backend_new ();
	_libsocialweb_test_backend_unref0 (self->priv->_lsw_backend);
	self->priv->_lsw_backend = _tmp0_;
	folks_test_case_add_test ((FolksTestCase*) self, "libsocialweb aggregation", _aggregation_tests_test_aggregation_libsocialweb_folks_test_case_test_method, self);
	return self;
}


AggregationTests* aggregation_tests_new (void) {
	return aggregation_tests_construct (TYPE_AGGREGATION_TESTS);
}


static void aggregation_tests_real_set_up (FolksTestCase* base) {
	AggregationTests * self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* kf_relationships_path;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* kf_relationships_data;
	const gchar* _tmp4_;
	GFile* _tmp5_ = NULL;
	GFile* kf_relationships_f;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* kf_path;
	const gchar* _tmp16_;
	GKeyFile* _tmp17_;
	GKeyFile* kf;
	GKeyFile* _tmp18_;
	GKeyFile* _tmp19_;
	GKeyFile* _tmp20_;
	const gchar* _tmp33_;
	GError * _inner_error_ = NULL;
	self = (AggregationTests*) base;
	_tmp0_ = g_get_tmp_dir ();
	_tmp1_ = g_build_filename (_tmp0_, AGGREGATION_TESTS_KF_RELATIONSHIPS_FILE_PATH, NULL, NULL);
	kf_relationships_path = _tmp1_;
	_tmp2_ = kf_relationships_path;
	g_setenv ("FOLKS_BACKEND_KEY_FILE_PATH", _tmp2_, TRUE);
	_tmp3_ = g_strdup ("#\n");
	kf_relationships_data = _tmp3_;
	_tmp4_ = kf_relationships_path;
	_tmp5_ = g_file_new_for_path (_tmp4_);
	kf_relationships_f = _tmp5_;
	{
		GFile* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp6_ = kf_relationships_f;
		_tmp7_ = kf_relationships_data;
		_tmp8_ = kf_relationships_data;
		_tmp9_ = strlen (_tmp8_);
		_tmp10_ = _tmp9_;
		g_file_replace_contents (_tmp6_, _tmp7_, (gsize) _tmp10_, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = kf_relationships_path;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_error ("aggregation.vala:61: Could not write relationship file '%s': %s", _tmp11_, _tmp13_);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (kf_relationships_f);
		_g_free0 (kf_relationships_data);
		_g_free0 (kf_relationships_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = g_get_tmp_dir ();
	_tmp15_ = g_build_filename (_tmp14_, AGGREGATION_TESTS_STORE_FILE_PATH, NULL, NULL);
	kf_path = _tmp15_;
	_tmp16_ = kf_path;
	g_remove (_tmp16_);
	_tmp17_ = g_key_file_new ();
	kf = _tmp17_;
	_tmp18_ = kf;
	g_key_file_set_boolean (_tmp18_, "all-others", "enabled", FALSE);
	_tmp19_ = kf;
	g_key_file_set_boolean (_tmp19_, "libsocialweb", "enabled", TRUE);
	_tmp20_ = kf;
	g_key_file_set_boolean (_tmp20_, "key-file", "enabled", TRUE);
	{
		const gchar* _tmp21_;
		GFile* _tmp22_ = NULL;
		GFile* backend_f;
		GKeyFile* _tmp23_;
		gchar* _tmp24_ = NULL;
		gchar* data;
		GFile* _tmp25_;
		const gchar* _tmp26_;
		const gchar* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp21_ = kf_path;
		_tmp22_ = g_file_new_for_path (_tmp21_);
		backend_f = _tmp22_;
		_tmp23_ = kf;
		_tmp24_ = g_key_file_to_data (_tmp23_, NULL, NULL);
		data = _tmp24_;
		_tmp25_ = backend_f;
		_tmp26_ = data;
		_tmp27_ = data;
		_tmp28_ = strlen (_tmp27_);
		_tmp29_ = _tmp28_;
		g_file_replace_contents (_tmp25_, _tmp26_, (gsize) _tmp29_, NULL, FALSE, G_FILE_CREATE_PRIVATE, NULL, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (data);
			_g_object_unref0 (backend_f);
			goto __catch1_g_error;
		}
		_g_free0 (data);
		_g_object_unref0 (backend_f);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp30_;
		GError* _tmp31_;
		const gchar* _tmp32_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp30_ = kf_path;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		g_error ("aggregation.vala:86: Could not write updated backend key file '%s': %s", _tmp30_, _tmp32_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_key_file_free0 (kf);
		_g_free0 (kf_path);
		_g_object_unref0 (kf_relationships_f);
		_g_free0 (kf_relationships_data);
		_g_free0 (kf_relationships_path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp33_ = kf_path;
	g_setenv ("FOLKS_BACKEND_STORE_KEY_FILE_PATH", _tmp33_, TRUE);
	_g_key_file_free0 (kf);
	_g_free0 (kf_path);
	_g_object_unref0 (kf_relationships_f);
	_g_free0 (kf_relationships_data);
	_g_free0 (kf_relationships_path);
}


static void aggregation_tests_real_tear_down (FolksTestCase* base) {
	AggregationTests * self;
	self = (AggregationTests*) base;
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_object_unref0 (_data1_->personas);
		_data1_->individual_gathered = (_vala_array_free (_data1_->individual_gathered, _data1_->individual_gathered_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_object_unref0 (_data1_->aggregator);
		_g_object_unref0 (_data1_->mysocialnetwork2);
		_g_object_unref0 (_data1_->mysocialnetwork1);
		_g_main_loop_unref0 (_data1_->main_loop);
		g_slice_free (Block1Data, _data1_);
	}
}


static void _lambda0_ (Block1Data* _data1_) {
	AggregationTests * self;
	GMainLoop* _tmp0_;
	self = _data1_->self;
	_tmp0_ = _data1_->main_loop;
	g_main_loop_quit (_tmp0_);
}


static void __lambda0__libsocialweb_test_backend_ready (LibsocialwebTestBackend* _sender, gpointer self) {
	_lambda0_ (self);
}


static gboolean _lambda1_ (AggregationTests* self) {
	gboolean result = FALSE;
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda1_ (self);
	return result;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_free0 (_data2_->path);
		g_slice_free (Block2Data, _data2_);
	}
}


static gboolean _lambda4_ (Block2Data* _data2_) {
	AggregationTests * self;
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* text;
	const gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* v;
	GError * _inner_error_ = NULL;
	self = _data2_->self;
	_tmp0_ = g_strdup ("([('mysocialnetwork1', 'garg', %x, " "{'id': ['garg'], 'name': ['Gargantua']})],)");
	text = _tmp0_;
	_tmp1_ = text;
	_tmp2_ = g_variant_new_parsed (_tmp1_, 1300792578, NULL);
	_tmp3_ = g_variant_ref_sink (_tmp2_);
	v = _tmp3_;
	{
		GDBusConnection* _tmp4_ = NULL;
		GDBusConnection* conn;
		GDBusConnection* _tmp5_;
		const gchar* _tmp6_;
		GVariant* _tmp7_;
		_tmp4_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		conn = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			goto __catch2_g_error;
		}
		_tmp5_ = conn;
		_tmp6_ = _data2_->path;
		_tmp7_ = v;
		g_dbus_connection_emit_signal (_tmp5_, NULL, _tmp6_, "com.meego.libsocialweb.ContactView", "ContactsAdded", _tmp7_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (conn);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			goto __catch2_g_error;
		}
		_g_object_unref0 (conn);
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_variant_unref0 (v);
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	_g_variant_unref0 (v);
	_g_free0 (text);
	return result;
}


static gboolean __lambda4__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda4_ (self);
	return result;
}


static void _lambda3_ (const gchar* path, AggregationTests* self) {
	Block2Data* _data2_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (path != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_tmp0_ = path;
	_tmp1_ = g_strdup (_tmp0_);
	_data2_->path = _tmp1_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda4__gsource_func, block2_data_ref (_data2_), block2_data_unref);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void __lambda3__libsocialweb_test_libsocialweb_contact_view_test_start_called (LibsocialwebTestLibsocialwebContactViewTest* _sender, const gchar* path, gpointer self) {
	_lambda3_ (path, self);
}


static void _lambda2_ (const gchar* query, GHashTable* p, const gchar* path, Block1Data* _data1_) {
	AggregationTests * self;
	LibsocialwebTestLibsocialwebServiceTest* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_ = NULL;
	LibsocialwebTestLibsocialwebContactViewTest* _tmp4_;
	self = _data1_->self;
	g_return_if_fail (query != NULL);
	g_return_if_fail (p != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = _data1_->mysocialnetwork1;
	_tmp1_ = _tmp0_->contact_views;
	_tmp2_ = path;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
	_tmp4_ = (LibsocialwebTestLibsocialwebContactViewTest*) _tmp3_;
	g_signal_connect_object (_tmp4_, "start-called", (GCallback) __lambda3__libsocialweb_test_libsocialweb_contact_view_test_start_called, self, 0);
	_g_object_unref0 (_tmp4_);
}


static void __lambda2__libsocialweb_test_libsocialweb_service_test_open_view_called (LibsocialwebTestLibsocialwebServiceTest* _sender, const gchar* query, GHashTable* p, const gchar* path, gpointer self) {
	_lambda2_ (query, p, path, self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_free0 (_data3_->path);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean _lambda7_ (Block3Data* _data3_) {
	AggregationTests * self;
	gboolean result = FALSE;
	gchar* _tmp0_;
	gchar* text;
	const gchar* _tmp1_;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* v;
	GError * _inner_error_ = NULL;
	self = _data3_->self;
	_tmp0_ = g_strdup ("([('mysocialnetwork2', 'panta', %x, " "{'id': ['panta'], 'name': ['Pantagruel']})],)");
	text = _tmp0_;
	_tmp1_ = text;
	_tmp2_ = g_variant_new_parsed (_tmp1_, 1300792579, NULL);
	_tmp3_ = g_variant_ref_sink (_tmp2_);
	v = _tmp3_;
	{
		GDBusConnection* _tmp4_ = NULL;
		GDBusConnection* conn;
		GDBusConnection* _tmp5_;
		const gchar* _tmp6_;
		GVariant* _tmp7_;
		_tmp4_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		conn = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			goto __catch3_g_error;
		}
		_tmp5_ = conn;
		_tmp6_ = _data3_->path;
		_tmp7_ = v;
		g_dbus_connection_emit_signal (_tmp5_, NULL, _tmp6_, "com.meego.libsocialweb.ContactView", "ContactsAdded", _tmp7_, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (conn);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch3_g_io_error;
			}
			goto __catch3_g_error;
		}
		_g_object_unref0 (conn);
	}
	goto __finally3;
	__catch3_g_io_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally3:
	if (_inner_error_ != NULL) {
		_g_variant_unref0 (v);
		_g_free0 (text);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	_g_variant_unref0 (v);
	_g_free0 (text);
	return result;
}


static gboolean __lambda7__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda7_ (self);
	return result;
}


static void _lambda6_ (const gchar* path, AggregationTests* self) {
	Block3Data* _data3_;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (path != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = path;
	_tmp1_ = g_strdup (_tmp0_);
	_data3_->path = _tmp1_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda7__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}


static void __lambda6__libsocialweb_test_libsocialweb_contact_view_test_start_called (LibsocialwebTestLibsocialwebContactViewTest* _sender, const gchar* path, gpointer self) {
	_lambda6_ (path, self);
}


static void _lambda5_ (const gchar* query, GHashTable* p, const gchar* path, Block1Data* _data1_) {
	AggregationTests * self;
	LibsocialwebTestLibsocialwebServiceTest* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_ = NULL;
	LibsocialwebTestLibsocialwebContactViewTest* _tmp4_;
	self = _data1_->self;
	g_return_if_fail (query != NULL);
	g_return_if_fail (p != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = _data1_->mysocialnetwork2;
	_tmp1_ = _tmp0_->contact_views;
	_tmp2_ = path;
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
	_tmp4_ = (LibsocialwebTestLibsocialwebContactViewTest*) _tmp3_;
	g_signal_connect_object (_tmp4_, "start-called", (GCallback) __lambda6__libsocialweb_test_libsocialweb_contact_view_test_start_called, self, 0);
	_g_object_unref0 (_tmp4_);
}


static void __lambda5__libsocialweb_test_libsocialweb_service_test_open_view_called (LibsocialwebTestLibsocialwebServiceTest* _sender, const gchar* query, GHashTable* p, const gchar* path, gpointer self) {
	_lambda5_ (query, p, path, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _vala_array_add1 (FolksIndividual*** array, int* length, int* size, FolksIndividual* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (FolksIndividual*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _lambda8_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block1Data* _data1_) {
	AggregationTests * self;
	FolksIndividual** _tmp9_;
	gint _tmp9__length1;
	self = _data1_->self;
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_debug ("aggregation.vala:181: initial individuals_changed");
	{
		GeeSet* _tmp0_;
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _i_it;
		_tmp0_ = added;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) _tmp0_);
		_i_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gboolean _tmp3_ = FALSE;
			GeeIterator* _tmp4_;
			gpointer _tmp5_ = NULL;
			FolksIndividual* i;
			FolksIndividual** _tmp6_;
			gint _tmp6__length1;
			FolksIndividual* _tmp7_;
			FolksIndividual* _tmp8_;
			_tmp2_ = _i_it;
			_tmp3_ = gee_iterator_next (_tmp2_);
			if (!_tmp3_) {
				break;
			}
			_tmp4_ = _i_it;
			_tmp5_ = gee_iterator_get (_tmp4_);
			i = (FolksIndividual*) _tmp5_;
			_tmp6_ = _data1_->individual_gathered;
			_tmp6__length1 = _data1_->individual_gathered_length1;
			_tmp7_ = i;
			_tmp8_ = _g_object_ref0 (_tmp7_);
			_vala_array_add1 (&_data1_->individual_gathered, &_data1_->individual_gathered_length1, &_data1_->_individual_gathered_size_, _tmp8_);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_tmp9_ = _data1_->individual_gathered;
	_tmp9__length1 = _data1_->individual_gathered_length1;
	if (_tmp9__length1 >= 2) {
		GMainLoop* _tmp10_;
		_tmp10_ = _data1_->main_loop;
		g_main_loop_quit (_tmp10_);
	}
}


static void __lambda8__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda8_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda9_ (AggregationTests* self) {
	gboolean result = FALSE;
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda9_ (self);
	return result;
}


static void _lambda10_ (GeeSet* added, GeeSet* removed, const gchar* m, FolksPersona* a, FolksGroupDetailsChangeReason r, Block1Data* _data1_) {
	AggregationTests * self;
	GeeSet* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeSet* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	GeeSet* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GeeSet* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GMainLoop* _tmp28_;
	self = _data1_->self;
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	_tmp0_ = added;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = removed;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	g_debug ("aggregation.vala:209: individuals_changed after link: added:%u removed" \
":%u", (guint) _tmp2_, (guint) _tmp5_);
	_tmp6_ = added;
	_tmp7_ = gee_collection_get_size ((GeeCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_assert (_tmp8_ == 1);
	_tmp9_ = removed;
	_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
	_tmp11_ = _tmp10_;
	g_assert (_tmp11_ == 2);
	{
		GeeSet* _tmp12_;
		GeeIterator* _tmp13_ = NULL;
		GeeIterator* _i_it;
		_tmp12_ = added;
		_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
		_i_it = _tmp13_;
		while (TRUE) {
			GeeIterator* _tmp14_;
			gboolean _tmp15_ = FALSE;
			GeeIterator* _tmp16_;
			gpointer _tmp17_ = NULL;
			FolksIndividual* i;
			FolksIndividual* _tmp18_;
			GeeSet* _tmp19_;
			GeeSet* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			FolksIndividual* _tmp23_;
			GeeSet* _tmp24_;
			GeeSet* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			_tmp14_ = _i_it;
			_tmp15_ = gee_iterator_next (_tmp14_);
			if (!_tmp15_) {
				break;
			}
			_tmp16_ = _i_it;
			_tmp17_ = gee_iterator_get (_tmp16_);
			i = (FolksIndividual*) _tmp17_;
			_tmp18_ = i;
			_tmp19_ = folks_individual_get_personas (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = gee_collection_get_size ((GeeCollection*) _tmp20_);
			_tmp22_ = _tmp21_;
			g_assert (_tmp22_ == 3);
			_tmp23_ = i;
			_tmp24_ = folks_individual_get_personas (_tmp23_);
			_tmp25_ = _tmp24_;
			_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
			_tmp27_ = _tmp26_;
			g_debug ("aggregation.vala:217: individuals_changed: 1 individual containing %u " \
"personas", (guint) _tmp27_);
			_g_object_unref0 (i);
		}
		_g_object_unref0 (_i_it);
	}
	_tmp28_ = _data1_->main_loop;
	g_main_loop_quit (_tmp28_);
}


static void __lambda10__folks_individual_aggregator_individuals_changed (FolksIndividualAggregator* _sender, GeeSet* added, GeeSet* removed, const gchar* message, FolksPersona* actor, FolksGroupDetailsChangeReason reason, gpointer self) {
	_lambda10_ (added, removed, message, actor, reason, self);
}


static gboolean _lambda11_ (Block1Data* _data1_) {
	AggregationTests * self;
	gboolean result = FALSE;
	FolksIndividualAggregator* _tmp0_;
	GeeHashSet* _tmp1_;
	self = _data1_->self;
	_tmp0_ = _data1_->aggregator;
	_tmp1_ = _data1_->personas;
	folks_individual_aggregator_link_personas (_tmp0_, (GeeSet*) _tmp1_, NULL, NULL);
	result = FALSE;
	return result;
}


static gboolean __lambda11__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda11_ (self);
	return result;
}


static gboolean _lambda12_ (AggregationTests* self) {
	gboolean result = FALSE;
	g_assert_not_reached ();
	return result;
}


static gboolean __lambda12__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda12_ (self);
	return result;
}


void aggregation_tests_test_aggregation_libsocialweb (AggregationTests* self) {
	Block1Data* _data1_;
	GMainLoop* _tmp0_;
	LibsocialwebTestBackend* _tmp1_;
	guint _tmp2_ = 0U;
	guint timer_id;
	LibsocialwebTestBackend* _tmp3_;
	GMainLoop* _tmp4_;
	guint _tmp5_;
	LibsocialwebTestBackend* _tmp6_;
	LibsocialwebTestLibsocialwebServiceTest* _tmp7_ = NULL;
	LibsocialwebTestBackend* _tmp8_;
	LibsocialwebTestLibsocialwebServiceTest* _tmp9_ = NULL;
	LibsocialwebTestLibsocialwebServiceTest* _tmp10_;
	LibsocialwebTestLibsocialwebServiceTest* _tmp11_;
	FolksIndividualAggregator* _tmp12_;
	FolksIndividual** _tmp13_ = NULL;
	FolksIndividualAggregator* _tmp14_;
	gulong _tmp15_ = 0UL;
	gulong handler_id;
	FolksIndividualAggregator* _tmp16_;
	guint _tmp17_ = 0U;
	GMainLoop* _tmp18_;
	guint _tmp19_;
	FolksIndividualAggregator* _tmp20_;
	gulong _tmp21_;
	FolksIndividual** _tmp22_;
	gint _tmp22__length1;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	FolksIndividual** _tmp25_;
	gint _tmp25__length1;
	FolksIndividual* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gboolean _tmp33_;
	gboolean _tmp44_;
	FolksIndividualAggregator* _tmp45_;
	GeeHashSet* _tmp46_;
	GList* personas1;
	GList* personas2;
	GeeHashSet* _tmp71_;
	gint _tmp72_;
	gint _tmp73_;
	guint _tmp74_ = 0U;
	GMainLoop* _tmp75_;
	guint _tmp76_;
	LibsocialwebTestBackend* _tmp77_;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_main_loop_new (NULL, FALSE);
	_data1_->main_loop = _tmp0_;
	_tmp1_ = self->priv->_lsw_backend;
	g_signal_connect_data (_tmp1_, "ready", (GCallback) __lambda0__libsocialweb_test_backend_ready, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda1__gsource_func, g_object_ref (self), g_object_unref);
	timer_id = _tmp2_;
	_tmp3_ = self->priv->_lsw_backend;
	libsocialweb_test_backend_set_up (_tmp3_);
	_tmp4_ = _data1_->main_loop;
	g_main_loop_run (_tmp4_);
	_tmp5_ = timer_id;
	g_source_remove (_tmp5_);
	_tmp6_ = self->priv->_lsw_backend;
	_tmp7_ = libsocialweb_test_backend_add_service (_tmp6_, "mysocialnetwork1");
	_data1_->mysocialnetwork1 = _tmp7_;
	_tmp8_ = self->priv->_lsw_backend;
	_tmp9_ = libsocialweb_test_backend_add_service (_tmp8_, "mysocialnetwork2");
	_data1_->mysocialnetwork2 = _tmp9_;
	_tmp10_ = _data1_->mysocialnetwork1;
	g_signal_connect_data (_tmp10_, "open-view-called", (GCallback) __lambda2__libsocialweb_test_libsocialweb_service_test_open_view_called, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp11_ = _data1_->mysocialnetwork2;
	g_signal_connect_data (_tmp11_, "open-view-called", (GCallback) __lambda5__libsocialweb_test_libsocialweb_service_test_open_view_called, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp12_ = folks_individual_aggregator_new ();
	_data1_->aggregator = _tmp12_;
	_tmp13_ = g_new0 (FolksIndividual*, 0 + 1);
	_data1_->individual_gathered = _tmp13_;
	_data1_->individual_gathered_length1 = 0;
	_data1_->_individual_gathered_size_ = _data1_->individual_gathered_length1;
	_tmp14_ = _data1_->aggregator;
	_tmp15_ = g_signal_connect_data (_tmp14_, "individuals-changed", (GCallback) __lambda8__folks_individual_aggregator_individuals_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	handler_id = _tmp15_;
	_tmp16_ = _data1_->aggregator;
	folks_individual_aggregator_prepare (_tmp16_, NULL, NULL);
	_tmp17_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda9__gsource_func, g_object_ref (self), g_object_unref);
	timer_id = _tmp17_;
	_tmp18_ = _data1_->main_loop;
	g_main_loop_run (_tmp18_);
	_tmp19_ = timer_id;
	g_source_remove (_tmp19_);
	_tmp20_ = _data1_->aggregator;
	_tmp21_ = handler_id;
	g_signal_handler_disconnect ((GObject*) _tmp20_, _tmp21_);
	_tmp22_ = _data1_->individual_gathered;
	_tmp22__length1 = _data1_->individual_gathered_length1;
	g_assert (_tmp22__length1 == 2);
	_tmp25_ = _data1_->individual_gathered;
	_tmp25__length1 = _data1_->individual_gathered_length1;
	_tmp26_ = _tmp25_[0];
	_tmp27_ = folks_name_details_get_nickname (FOLKS_NAME_DETAILS (_tmp26_));
	_tmp28_ = _tmp27_;
	if (g_strcmp0 (_tmp28_, "Gargantua") == 0) {
		FolksIndividual** _tmp29_;
		gint _tmp29__length1;
		FolksIndividual* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		_tmp29_ = _data1_->individual_gathered;
		_tmp29__length1 = _data1_->individual_gathered_length1;
		_tmp30_ = _tmp29_[1];
		_tmp31_ = folks_name_details_get_nickname (FOLKS_NAME_DETAILS (_tmp30_));
		_tmp32_ = _tmp31_;
		_tmp24_ = g_strcmp0 (_tmp32_, "Pantagruel") == 0;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp33_ = _tmp24_;
	if (_tmp33_) {
		_tmp23_ = TRUE;
	} else {
		gboolean _tmp34_ = FALSE;
		FolksIndividual** _tmp35_;
		gint _tmp35__length1;
		FolksIndividual* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		gboolean _tmp43_;
		_tmp35_ = _data1_->individual_gathered;
		_tmp35__length1 = _data1_->individual_gathered_length1;
		_tmp36_ = _tmp35_[0];
		_tmp37_ = folks_name_details_get_nickname (FOLKS_NAME_DETAILS (_tmp36_));
		_tmp38_ = _tmp37_;
		if (g_strcmp0 (_tmp38_, "Pantagruel") == 0) {
			FolksIndividual** _tmp39_;
			gint _tmp39__length1;
			FolksIndividual* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			_tmp39_ = _data1_->individual_gathered;
			_tmp39__length1 = _data1_->individual_gathered_length1;
			_tmp40_ = _tmp39_[1];
			_tmp41_ = folks_name_details_get_nickname (FOLKS_NAME_DETAILS (_tmp40_));
			_tmp42_ = _tmp41_;
			_tmp34_ = g_strcmp0 (_tmp42_, "Gargantua") == 0;
		} else {
			_tmp34_ = FALSE;
		}
		_tmp43_ = _tmp34_;
		_tmp23_ = _tmp43_;
	}
	_tmp44_ = _tmp23_;
	g_assert (_tmp44_);
	_tmp45_ = _data1_->aggregator;
	g_signal_connect_data (_tmp45_, "individuals-changed", (GCallback) __lambda10__folks_individual_aggregator_individuals_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp46_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_data1_->personas = _tmp46_;
	personas1 = NULL;
	{
		FolksIndividual** _tmp47_;
		gint _tmp47__length1;
		FolksIndividual* _tmp48_;
		GeeSet* _tmp49_;
		GeeSet* _tmp50_;
		GeeIterator* _tmp51_ = NULL;
		GeeIterator* _p1_it;
		_tmp47_ = _data1_->individual_gathered;
		_tmp47__length1 = _data1_->individual_gathered_length1;
		_tmp48_ = _tmp47_[0];
		_tmp49_ = folks_individual_get_personas (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = gee_iterable_iterator ((GeeIterable*) _tmp50_);
		_p1_it = _tmp51_;
		while (TRUE) {
			GeeIterator* _tmp52_;
			gboolean _tmp53_ = FALSE;
			GeeIterator* _tmp54_;
			gpointer _tmp55_ = NULL;
			FolksPersona* p1;
			GeeHashSet* _tmp56_;
			FolksPersona* _tmp57_;
			FolksPersona* _tmp58_;
			_tmp52_ = _p1_it;
			_tmp53_ = gee_iterator_next (_tmp52_);
			if (!_tmp53_) {
				break;
			}
			_tmp54_ = _p1_it;
			_tmp55_ = gee_iterator_get (_tmp54_);
			p1 = (FolksPersona*) _tmp55_;
			_tmp56_ = _data1_->personas;
			_tmp57_ = p1;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp56_, _tmp57_);
			_tmp58_ = p1;
			personas1 = g_list_append (personas1, _tmp58_);
			_g_object_unref0 (p1);
		}
		_g_object_unref0 (_p1_it);
	}
	personas2 = NULL;
	{
		FolksIndividual** _tmp59_;
		gint _tmp59__length1;
		FolksIndividual* _tmp60_;
		GeeSet* _tmp61_;
		GeeSet* _tmp62_;
		GeeIterator* _tmp63_ = NULL;
		GeeIterator* _p2_it;
		_tmp59_ = _data1_->individual_gathered;
		_tmp59__length1 = _data1_->individual_gathered_length1;
		_tmp60_ = _tmp59_[1];
		_tmp61_ = folks_individual_get_personas (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = gee_iterable_iterator ((GeeIterable*) _tmp62_);
		_p2_it = _tmp63_;
		while (TRUE) {
			GeeIterator* _tmp64_;
			gboolean _tmp65_ = FALSE;
			GeeIterator* _tmp66_;
			gpointer _tmp67_ = NULL;
			FolksPersona* p2;
			GeeHashSet* _tmp68_;
			FolksPersona* _tmp69_;
			FolksPersona* _tmp70_;
			_tmp64_ = _p2_it;
			_tmp65_ = gee_iterator_next (_tmp64_);
			if (!_tmp65_) {
				break;
			}
			_tmp66_ = _p2_it;
			_tmp67_ = gee_iterator_get (_tmp66_);
			p2 = (FolksPersona*) _tmp67_;
			_tmp68_ = _data1_->personas;
			_tmp69_ = p2;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp68_, _tmp69_);
			_tmp70_ = p2;
			personas2 = g_list_append (personas2, _tmp70_);
			_g_object_unref0 (p2);
		}
		_g_object_unref0 (_p2_it);
	}
	_tmp71_ = _data1_->personas;
	_tmp72_ = gee_collection_get_size ((GeeCollection*) _tmp71_);
	_tmp73_ = _tmp72_;
	g_assert (_tmp73_ == 2);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, __lambda11__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	_tmp74_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 5, __lambda12__gsource_func, g_object_ref (self), g_object_unref);
	timer_id = _tmp74_;
	_tmp75_ = _data1_->main_loop;
	g_main_loop_run (_tmp75_);
	_tmp76_ = timer_id;
	g_source_remove (_tmp76_);
	_tmp77_ = self->priv->_lsw_backend;
	libsocialweb_test_backend_tear_down (_tmp77_);
	_g_list_free0 (personas2);
	_g_list_free0 (personas1);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


static void aggregation_tests_class_init (AggregationTestsClass * klass) {
	aggregation_tests_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AggregationTestsPrivate));
	FOLKS_TEST_CASE_CLASS (klass)->set_up = aggregation_tests_real_set_up;
	FOLKS_TEST_CASE_CLASS (klass)->tear_down = aggregation_tests_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = aggregation_tests_finalize;
}


static void aggregation_tests_instance_init (AggregationTests * self) {
	self->priv = AGGREGATION_TESTS_GET_PRIVATE (self);
}


static void aggregation_tests_finalize (GObject* obj) {
	AggregationTests * self;
	self = AGGREGATION_TESTS (obj);
	_libsocialweb_test_backend_unref0 (self->priv->_lsw_backend);
	G_OBJECT_CLASS (aggregation_tests_parent_class)->finalize (obj);
}


GType aggregation_tests_get_type (void) {
	static volatile gsize aggregation_tests_type_id__volatile = 0;
	if (g_once_init_enter (&aggregation_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AggregationTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) aggregation_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AggregationTests), 0, (GInstanceInitFunc) aggregation_tests_instance_init, NULL };
		GType aggregation_tests_type_id;
		aggregation_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "AggregationTests", &g_define_type_info, 0);
		g_once_init_leave (&aggregation_tests_type_id__volatile, aggregation_tests_type_id);
	}
	return aggregation_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	GTestSuite* _tmp0_ = NULL;
	GTestSuite* root;
	GTestSuite* _tmp1_;
	AggregationTests* _tmp2_;
	AggregationTests* _tmp3_;
	GTestSuite* _tmp4_ = NULL;
	g_test_init (&args_length1, &args, NULL);
	_tmp0_ = g_test_get_root ();
	root = _tmp0_;
	_tmp1_ = root;
	_tmp2_ = aggregation_tests_new ();
	_tmp3_ = _tmp2_;
	_tmp4_ = folks_test_case_get_suite ((FolksTestCase*) _tmp3_);
	g_test_suite_add_suite (_tmp1_, _tmp4_);
	_g_object_unref0 (_tmp3_);
	g_test_run ();
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main (argv, argc);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



