/*
 * Copyright (c) 2003, 2007-11 Matteo Frigo
 * Copyright (c) 2003, 2007-11 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Feb 21 19:02:56 EST 2012 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2c.native -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -n 32 -dit -name hc2cf_32 -include hc2cf.h */

/*
 * This function contains 434 FP additions, 260 FP multiplications,
 * (or, 236 additions, 62 multiplications, 198 fused multiply/add),
 * 135 stack variables, 7 constants, and 128 memory accesses
 */
#include "hc2cf.h"

static void hc2cf_32(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP198912367, +0.198912367379658006911597622644676228597850501);
     DK(KP668178637, +0.668178637919298919997757686523080761552472251);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP414213562, +0.414213562373095048801688724209698078569671875);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 62, MAKE_VOLATILE_STRIDE(rs)) {
	       E T90, T8Z;
	       {
		    E T8x, T87, T8, T3w, T83, T3B, T8y, Tl, T6F, Tz, T3J, T5T, T6G, TM, T3Q;
		    E T5U, T3Z, T5Y, T7D, T6L, T5X, T46, T6M, T1f, T4e, T61, T7E, T6R, T6O, T1G;
		    E T60, T4l, T54, T6c, T79, T7N, T32, T7b, T6f, T5r, T4v, T65, T6X, T7I, T29;
		    E T70, T68, T4S, T5s, T5b, T7O, T7e, T76, T3t, T5t, T5i, T4H, T2y, T4B, T71;
		    E T2m, T4w, T4F, T2s;
		    {
			 E T3X, T1d, T44, T6J, T11, T3T, T3V, T17, T5h, T5c;
			 {
			      E Ta, Td, Tg, T3x, Tb, Tj, Tf, Tc, Ti;
			      {
				   E T1, T86, T3, T6, T2, T5;
				   T1 = Rp[0];
				   T86 = Rm[0];
				   T3 = Rp[WS(rs, 8)];
				   T6 = Rm[WS(rs, 8)];
				   T2 = W[30];
				   T5 = W[31];
				   {
					E T84, T4, T9, T85, T7;
					Ta = Rp[WS(rs, 4)];
					Td = Rm[WS(rs, 4)];
					T84 = T2 * T6;
					T4 = T2 * T3;
					T9 = W[14];
					Tg = Rp[WS(rs, 12)];
					T85 = FNMS(T5, T3, T84);
					T7 = FMA(T5, T6, T4);
					T3x = T9 * Td;
					Tb = T9 * Ta;
					T8x = T86 - T85;
					T87 = T85 + T86;
					T8 = T1 + T7;
					T3w = T1 - T7;
					Tj = Rm[WS(rs, 12)];
					Tf = W[46];
				   }
				   Tc = W[15];
				   Ti = W[47];
			      }
			      {
				   E Tu, Tx, T3F, Ts, Tw, T3G, Tv;
				   {
					E To, Tr, Tp, T3E, Tq, Tt;
					{
					     E T3y, Te, T3A, Tk, T3z, Th, Tn;
					     To = Rp[WS(rs, 2)];
					     T3z = Tf * Tj;
					     Th = Tf * Tg;
					     T3y = FNMS(Tc, Ta, T3x);
					     Te = FMA(Tc, Td, Tb);
					     T3A = FNMS(Ti, Tg, T3z);
					     Tk = FMA(Ti, Tj, Th);
					     Tr = Rm[WS(rs, 2)];
					     Tn = W[6];
					     T83 = T3y + T3A;
					     T3B = T3y - T3A;
					     T8y = Te - Tk;
					     Tl = Te + Tk;
					     Tp = Tn * To;
					     T3E = Tn * Tr;
					}
					Tq = W[7];
					Tu = Rp[WS(rs, 10)];
					Tx = Rm[WS(rs, 10)];
					Tt = W[38];
					T3F = FNMS(Tq, To, T3E);
					Ts = FMA(Tq, Tr, Tp);
					Tw = W[39];
					T3G = Tt * Tx;
					Tv = Tt * Tu;
				   }
				   {
					E T3M, TF, TH, TK, TG, TJ, TE, TD, TC;
					{
					     E TB, T3H, Ty, TA, T3I, T3D, T3L;
					     TB = Rp[WS(rs, 14)];
					     TE = Rm[WS(rs, 14)];
					     T3H = FNMS(Tw, Tu, T3G);
					     Ty = FMA(Tw, Tx, Tv);
					     TA = W[54];
					     TD = W[55];
					     T6F = T3F + T3H;
					     T3I = T3F - T3H;
					     Tz = Ts + Ty;
					     T3D = Ts - Ty;
					     T3L = TA * TE;
					     TC = TA * TB;
					     T3J = T3D + T3I;
					     T5T = T3I - T3D;
					     T3M = FNMS(TD, TB, T3L);
					}
					TF = FMA(TD, TE, TC);
					TH = Rp[WS(rs, 6)];
					TK = Rm[WS(rs, 6)];
					TG = W[22];
					TJ = W[23];
					{
					     E TU, T41, T13, T16, T43, T10, T12, T15, T3U, T14;
					     {
						  E T19, T1c, T18, T1b, T3P, T3K;
						  {
						       E TQ, TT, T3N, TI, TP, TS;
						       TQ = Rp[WS(rs, 1)];
						       TT = Rm[WS(rs, 1)];
						       T3N = TG * TK;
						       TI = TG * TH;
						       TP = W[2];
						       TS = W[3];
						       {
							    E T3O, TL, T40, TR;
							    T3O = FNMS(TJ, TH, T3N);
							    TL = FMA(TJ, TK, TI);
							    T40 = TP * TT;
							    TR = TP * TQ;
							    T6G = T3M + T3O;
							    T3P = T3M - T3O;
							    TM = TF + TL;
							    T3K = TF - TL;
							    TU = FMA(TS, TT, TR);
							    T41 = FNMS(TS, TQ, T40);
						       }
						  }
						  T3Q = T3K - T3P;
						  T5U = T3K + T3P;
						  T19 = Rp[WS(rs, 13)];
						  T1c = Rm[WS(rs, 13)];
						  T18 = W[50];
						  T1b = W[51];
						  {
						       E TW, TZ, TY, T42, TX, T3W, T1a, TV;
						       TW = Rp[WS(rs, 9)];
						       TZ = Rm[WS(rs, 9)];
						       T3W = T18 * T1c;
						       T1a = T18 * T19;
						       TV = W[34];
						       TY = W[35];
						       T3X = FNMS(T1b, T19, T3W);
						       T1d = FMA(T1b, T1c, T1a);
						       T42 = TV * TZ;
						       TX = TV * TW;
						       T13 = Rp[WS(rs, 5)];
						       T16 = Rm[WS(rs, 5)];
						       T43 = FNMS(TY, TW, T42);
						       T10 = FMA(TY, TZ, TX);
						       T12 = W[18];
						       T15 = W[19];
						  }
					     }
					     T44 = T41 - T43;
					     T6J = T41 + T43;
					     T11 = TU + T10;
					     T3T = TU - T10;
					     T3U = T12 * T16;
					     T14 = T12 * T13;
					     T3V = FNMS(T15, T13, T3U);
					     T17 = FMA(T15, T16, T14);
					}
				   }
			      }
			 }
			 {
			      E T4g, T1l, T4c, T1E, T1u, T1x, T1w, T4i, T1r, T49, T1v;
			      {
				   E T1A, T1D, T1C, T4b, T1B;
				   {
					E T1h, T1k, T1g, T1j, T4f, T1i, T1z;
					T1h = Rp[WS(rs, 15)];
					T1k = Rm[WS(rs, 15)];
					{
					     E T6K, T3Y, T1e, T45;
					     T6K = T3V + T3X;
					     T3Y = T3V - T3X;
					     T1e = T17 + T1d;
					     T45 = T17 - T1d;
					     T3Z = T3T + T3Y;
					     T5Y = T3T - T3Y;
					     T7D = T6J + T6K;
					     T6L = T6J - T6K;
					     T5X = T44 + T45;
					     T46 = T44 - T45;
					     T6M = T11 - T1e;
					     T1f = T11 + T1e;
					     T1g = W[58];
					}
					T1j = W[59];
					T1A = Rp[WS(rs, 11)];
					T1D = Rm[WS(rs, 11)];
					T4f = T1g * T1k;
					T1i = T1g * T1h;
					T1z = W[42];
					T1C = W[43];
					T4g = FNMS(T1j, T1h, T4f);
					T1l = FMA(T1j, T1k, T1i);
					T4b = T1z * T1D;
					T1B = T1z * T1A;
				   }
				   {
					E T1n, T1q, T1m, T1p, T4h, T1o, T1t;
					T1n = Rp[WS(rs, 7)];
					T1q = Rm[WS(rs, 7)];
					T4c = FNMS(T1C, T1A, T4b);
					T1E = FMA(T1C, T1D, T1B);
					T1m = W[26];
					T1p = W[27];
					T1u = Rp[WS(rs, 3)];
					T1x = Rm[WS(rs, 3)];
					T4h = T1m * T1q;
					T1o = T1m * T1n;
					T1t = W[10];
					T1w = W[11];
					T4i = FNMS(T1p, T1n, T4h);
					T1r = FMA(T1p, T1q, T1o);
					T49 = T1t * T1x;
					T1v = T1t * T1u;
				   }
			      }
			      {
				   E T4j, T6P, T1s, T48, T4a, T1y;
				   T4j = T4g - T4i;
				   T6P = T4g + T4i;
				   T1s = T1l + T1r;
				   T48 = T1l - T1r;
				   T4a = FNMS(T1w, T1u, T49);
				   T1y = FMA(T1w, T1x, T1v);
				   {
					E T6Q, T4d, T4k, T1F;
					T6Q = T4a + T4c;
					T4d = T4a - T4c;
					T4k = T1y - T1E;
					T1F = T1y + T1E;
					T4e = T48 + T4d;
					T61 = T48 - T4d;
					T7E = T6P + T6Q;
					T6R = T6P - T6Q;
					T6O = T1s - T1F;
					T1G = T1s + T1F;
					T60 = T4j + T4k;
					T4l = T4j - T4k;
				   }
			      }
			 }
			 {
			      E T5m, T2H, T52, T30, T2Q, T2T, T2S, T5o, T2N, T4Z, T2R;
			      {
				   E T2W, T2Z, T2Y, T51, T2X;
				   {
					E T2D, T2G, T2C, T2F, T5l, T2E, T2V;
					T2D = Ip[WS(rs, 15)];
					T2G = Im[WS(rs, 15)];
					T2C = W[60];
					T2F = W[61];
					T2W = Ip[WS(rs, 11)];
					T2Z = Im[WS(rs, 11)];
					T5l = T2C * T2G;
					T2E = T2C * T2D;
					T2V = W[44];
					T2Y = W[45];
					T5m = FNMS(T2F, T2D, T5l);
					T2H = FMA(T2F, T2G, T2E);
					T51 = T2V * T2Z;
					T2X = T2V * T2W;
				   }
				   {
					E T2J, T2M, T2I, T2L, T5n, T2K, T2P;
					T2J = Ip[WS(rs, 7)];
					T2M = Im[WS(rs, 7)];
					T52 = FNMS(T2Y, T2W, T51);
					T30 = FMA(T2Y, T2Z, T2X);
					T2I = W[28];
					T2L = W[29];
					T2Q = Ip[WS(rs, 3)];
					T2T = Im[WS(rs, 3)];
					T5n = T2I * T2M;
					T2K = T2I * T2J;
					T2P = W[12];
					T2S = W[13];
					T5o = FNMS(T2L, T2J, T5n);
					T2N = FMA(T2L, T2M, T2K);
					T4Z = T2P * T2T;
					T2R = T2P * T2Q;
				   }
			      }
			      {
				   E T5p, T77, T2O, T4Y, T50, T2U;
				   T5p = T5m - T5o;
				   T77 = T5m + T5o;
				   T2O = T2H + T2N;
				   T4Y = T2H - T2N;
				   T50 = FNMS(T2S, T2Q, T4Z);
				   T2U = FMA(T2S, T2T, T2R);
				   {
					E T78, T53, T5q, T31;
					T78 = T50 + T52;
					T53 = T50 - T52;
					T5q = T30 - T2U;
					T31 = T2U + T30;
					T54 = T4Y + T53;
					T6c = T4Y - T53;
					T79 = T77 - T78;
					T7N = T77 + T78;
					T32 = T2O + T31;
					T7b = T2O - T31;
					T6f = T5q - T5p;
					T5r = T5p + T5q;
				   }
			      }
			 }
			 {
			      E T4N, T1O, T4t, T27, T1X, T20, T1Z, T4P, T1U, T4q, T1Y;
			      {
				   E T23, T26, T25, T4s, T24;
				   {
					E T1K, T1N, T1J, T1M, T4M, T1L, T22;
					T1K = Ip[0];
					T1N = Im[0];
					T1J = W[0];
					T1M = W[1];
					T23 = Ip[WS(rs, 12)];
					T26 = Im[WS(rs, 12)];
					T4M = T1J * T1N;
					T1L = T1J * T1K;
					T22 = W[48];
					T25 = W[49];
					T4N = FNMS(T1M, T1K, T4M);
					T1O = FMA(T1M, T1N, T1L);
					T4s = T22 * T26;
					T24 = T22 * T23;
				   }
				   {
					E T1Q, T1T, T1P, T1S, T4O, T1R, T1W;
					T1Q = Ip[WS(rs, 8)];
					T1T = Im[WS(rs, 8)];
					T4t = FNMS(T25, T23, T4s);
					T27 = FMA(T25, T26, T24);
					T1P = W[32];
					T1S = W[33];
					T1X = Ip[WS(rs, 4)];
					T20 = Im[WS(rs, 4)];
					T4O = T1P * T1T;
					T1R = T1P * T1Q;
					T1W = W[16];
					T1Z = W[17];
					T4P = FNMS(T1S, T1Q, T4O);
					T1U = FMA(T1S, T1T, T1R);
					T4q = T1W * T20;
					T1Y = T1W * T1X;
				   }
			      }
			      {
				   E T4Q, T6V, T1V, T4p, T4r, T21;
				   T4Q = T4N - T4P;
				   T6V = T4N + T4P;
				   T1V = T1O + T1U;
				   T4p = T1O - T1U;
				   T4r = FNMS(T1Z, T1X, T4q);
				   T21 = FMA(T1Z, T20, T1Y);
				   {
					E T6W, T4u, T4R, T28;
					T6W = T4r + T4t;
					T4u = T4r - T4t;
					T4R = T21 - T27;
					T28 = T21 + T27;
					T4v = T4p + T4u;
					T65 = T4p - T4u;
					T6X = T6V - T6W;
					T7I = T6V + T6W;
					T29 = T1V + T28;
					T70 = T1V - T28;
					T68 = T4Q + T4R;
					T4S = T4Q - T4R;
				   }
			      }
			 }
			 {
			      E T57, T38, T5g, T3r, T3h, T3k, T3j, T59, T3e, T5d, T3i;
			      {
				   E T3n, T3q, T3p, T5f, T3o;
				   {
					E T34, T37, T33, T36, T56, T35, T3m;
					T34 = Ip[WS(rs, 1)];
					T37 = Im[WS(rs, 1)];
					T33 = W[4];
					T36 = W[5];
					T3n = Ip[WS(rs, 5)];
					T3q = Im[WS(rs, 5)];
					T56 = T33 * T37;
					T35 = T33 * T34;
					T3m = W[20];
					T3p = W[21];
					T57 = FNMS(T36, T34, T56);
					T38 = FMA(T36, T37, T35);
					T5f = T3m * T3q;
					T3o = T3m * T3n;
				   }
				   {
					E T3a, T3d, T39, T3c, T58, T3b, T3g;
					T3a = Ip[WS(rs, 9)];
					T3d = Im[WS(rs, 9)];
					T5g = FNMS(T3p, T3n, T5f);
					T3r = FMA(T3p, T3q, T3o);
					T39 = W[36];
					T3c = W[37];
					T3h = Ip[WS(rs, 13)];
					T3k = Im[WS(rs, 13)];
					T58 = T39 * T3d;
					T3b = T39 * T3a;
					T3g = W[52];
					T3j = W[53];
					T59 = FNMS(T3c, T3a, T58);
					T3e = FMA(T3c, T3d, T3b);
					T5d = T3g * T3k;
					T3i = T3g * T3h;
				   }
			      }
			      {
				   E T5a, T7c, T3f, T55, T5e, T3l, T7d, T3s;
				   T5a = T57 - T59;
				   T7c = T57 + T59;
				   T3f = T38 + T3e;
				   T55 = T38 - T3e;
				   T5e = FNMS(T3j, T3h, T5d);
				   T3l = FMA(T3j, T3k, T3i);
				   T5h = T5e - T5g;
				   T7d = T5e + T5g;
				   T3s = T3l + T3r;
				   T5c = T3l - T3r;
				   T5s = T5a - T55;
				   T5b = T55 + T5a;
				   T7O = T7c + T7d;
				   T7e = T7c - T7d;
				   T76 = T3s - T3f;
				   T3t = T3f + T3s;
			      }
			 }
			 {
			      E T4y, T2f, T2o, T2r, T4A, T2l, T2n, T2q, T4E, T2p;
			      {
				   E T2u, T2x, T2t, T2w;
				   {
					E T2b, T2e, T2d, T4x, T2c, T2a;
					T2b = Ip[WS(rs, 2)];
					T2e = Im[WS(rs, 2)];
					T2a = W[8];
					T5t = T5c + T5h;
					T5i = T5c - T5h;
					T2d = W[9];
					T4x = T2a * T2e;
					T2c = T2a * T2b;
					T2u = Ip[WS(rs, 6)];
					T2x = Im[WS(rs, 6)];
					T4y = FNMS(T2d, T2b, T4x);
					T2f = FMA(T2d, T2e, T2c);
					T2t = W[24];
					T2w = W[25];
				   }
				   {
					E T2h, T2k, T2j, T4z, T2i, T4G, T2v, T2g;
					T2h = Ip[WS(rs, 10)];
					T2k = Im[WS(rs, 10)];
					T4G = T2t * T2x;
					T2v = T2t * T2u;
					T2g = W[40];
					T2j = W[41];
					T4H = FNMS(T2w, T2u, T4G);
					T2y = FMA(T2w, T2x, T2v);
					T4z = T2g * T2k;
					T2i = T2g * T2h;
					T2o = Ip[WS(rs, 14)];
					T2r = Im[WS(rs, 14)];
					T4A = FNMS(T2j, T2h, T4z);
					T2l = FMA(T2j, T2k, T2i);
					T2n = W[56];
					T2q = W[57];
				   }
			      }
			      T4B = T4y - T4A;
			      T71 = T4y + T4A;
			      T2m = T2f + T2l;
			      T4w = T2f - T2l;
			      T4E = T2n * T2r;
			      T2p = T2n * T2o;
			      T4F = FNMS(T2q, T2o, T4E);
			      T2s = FMA(T2q, T2r, T2p);
			 }
		    }
		    {
			 E T4T, T4C, T4J, T4U, T7y, T8q, T8p, T7B;
			 {
			      E T6E, T8j, T73, T6Y, T6H, T8k, T8i, T8h;
			      {
				   E T7C, TO, T80, T7Z, T8e, T89, T8d, T1H, T8b, T3v, T7T, T7L, T7U, T7Q, T2A;
				   E T7K, T7P, T7W, T1I;
				   {
					E T7X, T7Y, T7J, T82, T88;
					{
					     E Tm, T4I, T72, T4D, T2z, TN;
					     T6E = T8 - Tl;
					     Tm = T8 + Tl;
					     T4T = T4B - T4w;
					     T4C = T4w + T4B;
					     T4I = T4F - T4H;
					     T72 = T4F + T4H;
					     T4D = T2s - T2y;
					     T2z = T2s + T2y;
					     TN = Tz + TM;
					     T8j = TM - Tz;
					     T73 = T71 - T72;
					     T7J = T71 + T72;
					     T4J = T4D - T4I;
					     T4U = T4D + T4I;
					     T2A = T2m + T2z;
					     T6Y = T2z - T2m;
					     T7C = Tm - TN;
					     TO = Tm + TN;
					}
					T7K = T7I - T7J;
					T7X = T7I + T7J;
					T7Y = T7N + T7O;
					T7P = T7N - T7O;
					T6H = T6F - T6G;
					T82 = T6F + T6G;
					T88 = T83 + T87;
					T8k = T87 - T83;
					T80 = T7X + T7Y;
					T7Z = T7X - T7Y;
					T8e = T88 - T82;
					T89 = T82 + T88;
				   }
				   {
					E T7H, T7M, T2B, T3u;
					T7H = T29 - T2A;
					T2B = T29 + T2A;
					T3u = T32 + T3t;
					T7M = T32 - T3t;
					T8d = T1G - T1f;
					T1H = T1f + T1G;
					T8b = T3u - T2B;
					T3v = T2B + T3u;
					T7T = T7K - T7H;
					T7L = T7H + T7K;
					T7U = T7M + T7P;
					T7Q = T7M - T7P;
				   }
				   T7W = TO - T1H;
				   T1I = TO + T1H;
				   {
					E T7S, T8f, T8g, T7V;
					{
					     E T7R, T8c, T8a, T7G, T81, T7F;
					     T8i = T7Q - T7L;
					     T7R = T7L + T7Q;
					     T81 = T7D + T7E;
					     T7F = T7D - T7E;
					     Rp[0] = T1I + T3v;
					     Rm[WS(rs, 15)] = T1I - T3v;
					     Rp[WS(rs, 8)] = T7W + T7Z;
					     Rm[WS(rs, 7)] = T7W - T7Z;
					     T8c = T89 - T81;
					     T8a = T81 + T89;
					     T7G = T7C + T7F;
					     T7S = T7C - T7F;
					     T8h = T8e - T8d;
					     T8f = T8d + T8e;
					     Ip[WS(rs, 8)] = T8b + T8c;
					     Im[WS(rs, 7)] = T8b - T8c;
					     Ip[0] = T80 + T8a;
					     Im[WS(rs, 15)] = T80 - T8a;
					     Rp[WS(rs, 4)] = FMA(KP707106781, T7R, T7G);
					     Rm[WS(rs, 11)] = FNMS(KP707106781, T7R, T7G);
					     T8g = T7T + T7U;
					     T7V = T7T - T7U;
					}
					Ip[WS(rs, 4)] = FMA(KP707106781, T8g, T8f);
					Im[WS(rs, 11)] = FMS(KP707106781, T8g, T8f);
					Rp[WS(rs, 12)] = FMA(KP707106781, T7V, T7S);
					Rm[WS(rs, 3)] = FNMS(KP707106781, T7V, T7S);
				   }
			      }
			      {
				   E T7f, T7m, T6I, T7a, T7A, T7w, T8r, T8l, T8m, T6T, T7j, T75, T8s, T7p, T7z;
				   E T7t;
				   {
					E T7n, T6N, T6S, T7o, T7u, T7v;
					T7f = T7b - T7e;
					T7u = T7b + T7e;
					Ip[WS(rs, 12)] = FMA(KP707106781, T8i, T8h);
					Im[WS(rs, 3)] = FMS(KP707106781, T8i, T8h);
					T7m = T6E + T6H;
					T6I = T6E - T6H;
					T7v = T79 + T76;
					T7a = T76 - T79;
					T7n = T6M + T6L;
					T6N = T6L - T6M;
					T7A = FMA(KP414213562, T7u, T7v);
					T7w = FNMS(KP414213562, T7v, T7u);
					T8r = T8k - T8j;
					T8l = T8j + T8k;
					T6S = T6O + T6R;
					T7o = T6O - T6R;
					{
					     E T7s, T7r, T6Z, T74;
					     T7s = T6X + T6Y;
					     T6Z = T6X - T6Y;
					     T74 = T70 - T73;
					     T7r = T70 + T73;
					     T8m = T6N + T6S;
					     T6T = T6N - T6S;
					     T7j = FNMS(KP414213562, T6Z, T74);
					     T75 = FMA(KP414213562, T74, T6Z);
					     T8s = T7o - T7n;
					     T7p = T7n + T7o;
					     T7z = FNMS(KP414213562, T7r, T7s);
					     T7t = FMA(KP414213562, T7s, T7r);
					}
				   }
				   {
					E T7i, T6U, T8t, T8v, T7k, T7g;
					T7i = FNMS(KP707106781, T6T, T6I);
					T6U = FMA(KP707106781, T6T, T6I);
					T8t = FMA(KP707106781, T8s, T8r);
					T8v = FNMS(KP707106781, T8s, T8r);
					T7k = FNMS(KP414213562, T7a, T7f);
					T7g = FMA(KP414213562, T7f, T7a);
					{
					     E T7q, T7x, T8n, T8o;
					     T7y = FNMS(KP707106781, T7p, T7m);
					     T7q = FMA(KP707106781, T7p, T7m);
					     {
						  E T7l, T8u, T8w, T7h;
						  T7l = T7j + T7k;
						  T8u = T7k - T7j;
						  T8w = T7g - T75;
						  T7h = T75 + T7g;
						  Rm[WS(rs, 1)] = FMA(KP923879532, T7l, T7i);
						  Rp[WS(rs, 14)] = FNMS(KP923879532, T7l, T7i);
						  Ip[WS(rs, 6)] = FMA(KP923879532, T8u, T8t);
						  Im[WS(rs, 9)] = FMS(KP923879532, T8u, T8t);
						  Ip[WS(rs, 14)] = FMA(KP923879532, T8w, T8v);
						  Im[WS(rs, 1)] = FMS(KP923879532, T8w, T8v);
						  Rp[WS(rs, 6)] = FMA(KP923879532, T7h, T6U);
						  Rm[WS(rs, 9)] = FNMS(KP923879532, T7h, T6U);
						  T7x = T7t + T7w;
						  T8q = T7w - T7t;
					     }
					     T8p = FNMS(KP707106781, T8m, T8l);
					     T8n = FMA(KP707106781, T8m, T8l);
					     T8o = T7z + T7A;
					     T7B = T7z - T7A;
					     Rp[WS(rs, 2)] = FMA(KP923879532, T7x, T7q);
					     Rm[WS(rs, 13)] = FNMS(KP923879532, T7x, T7q);
					     Ip[WS(rs, 2)] = FMA(KP923879532, T8o, T8n);
					     Im[WS(rs, 13)] = FMS(KP923879532, T8o, T8n);
					}
				   }
			      }
			 }
			 {
			      E T5S, T8O, T8N, T5V, T6g, T6d, T69, T66, T8K, T8J;
			      {
				   E T5C, T3S, T8I, T4n, T8H, T8B, T8C, T5F, T5k, T5K, T5u, T4K, T4V;
				   {
					E T5D, T5E, T8z, T8A, T5j;
					{
					     E T3C, T3R, T47, T4m;
					     T5S = T3w - T3B;
					     T3C = T3w + T3B;
					     Rp[WS(rs, 10)] = FMA(KP923879532, T7B, T7y);
					     Rm[WS(rs, 5)] = FNMS(KP923879532, T7B, T7y);
					     Ip[WS(rs, 10)] = FMA(KP923879532, T8q, T8p);
					     Im[WS(rs, 5)] = FMS(KP923879532, T8q, T8p);
					     T3R = T3J + T3Q;
					     T8O = T3Q - T3J;
					     T5D = FNMS(KP414213562, T3Z, T46);
					     T47 = FMA(KP414213562, T46, T3Z);
					     T4m = FNMS(KP414213562, T4l, T4e);
					     T5E = FMA(KP414213562, T4e, T4l);
					     T8N = T8y + T8x;
					     T8z = T8x - T8y;
					     T5C = FNMS(KP707106781, T3R, T3C);
					     T3S = FMA(KP707106781, T3R, T3C);
					     T8I = T4m - T47;
					     T4n = T47 + T4m;
					     T8A = T5T + T5U;
					     T5V = T5T - T5U;
					}
					T6g = T5i - T5b;
					T5j = T5b + T5i;
					T8H = FNMS(KP707106781, T8A, T8z);
					T8B = FMA(KP707106781, T8A, T8z);
					T8C = T5D + T5E;
					T5F = T5D - T5E;
					T5k = FMA(KP707106781, T5j, T54);
					T5K = FNMS(KP707106781, T5j, T54);
					T5u = T5s + T5t;
					T6d = T5t - T5s;
					T69 = T4C - T4J;
					T4K = T4C + T4J;
					T4V = T4T + T4U;
					T66 = T4U - T4T;
				   }
				   {
					E T5M, T5Q, T5J, T5P, T8F, T8G;
					{
					     E T5y, T4o, T5A, T5w, T5z, T4X, T8D, T5L, T5v, T8E, T5B, T5x;
					     T5y = FNMS(KP923879532, T4n, T3S);
					     T4o = FMA(KP923879532, T4n, T3S);
					     T5L = FNMS(KP707106781, T5u, T5r);
					     T5v = FMA(KP707106781, T5u, T5r);
					     {
						  E T5H, T4L, T5I, T4W;
						  T5H = FNMS(KP707106781, T4K, T4v);
						  T4L = FMA(KP707106781, T4K, T4v);
						  T5I = FNMS(KP707106781, T4V, T4S);
						  T4W = FMA(KP707106781, T4V, T4S);
						  T5M = FMA(KP668178637, T5L, T5K);
						  T5Q = FNMS(KP668178637, T5K, T5L);
						  T5A = FMA(KP198912367, T5k, T5v);
						  T5w = FNMS(KP198912367, T5v, T5k);
						  T5J = FNMS(KP668178637, T5I, T5H);
						  T5P = FMA(KP668178637, T5H, T5I);
						  T5z = FNMS(KP198912367, T4L, T4W);
						  T4X = FMA(KP198912367, T4W, T4L);
					     }
					     T8D = FMA(KP923879532, T8C, T8B);
					     T8F = FNMS(KP923879532, T8C, T8B);
					     T8E = T5z + T5A;
					     T5B = T5z - T5A;
					     T8G = T5w - T4X;
					     T5x = T4X + T5w;
					     Ip[WS(rs, 1)] = FMA(KP980785280, T8E, T8D);
					     Im[WS(rs, 14)] = FMS(KP980785280, T8E, T8D);
					     Rp[WS(rs, 1)] = FMA(KP980785280, T5x, T4o);
					     Rm[WS(rs, 14)] = FNMS(KP980785280, T5x, T4o);
					     Rp[WS(rs, 9)] = FMA(KP980785280, T5B, T5y);
					     Rm[WS(rs, 6)] = FNMS(KP980785280, T5B, T5y);
					}
					{
					     E T5O, T8L, T8M, T5R, T5G, T5N;
					     T5O = FMA(KP923879532, T5F, T5C);
					     T5G = FNMS(KP923879532, T5F, T5C);
					     T5N = T5J + T5M;
					     T8K = T5M - T5J;
					     T8J = FMA(KP923879532, T8I, T8H);
					     T8L = FNMS(KP923879532, T8I, T8H);
					     Ip[WS(rs, 9)] = FMA(KP980785280, T8G, T8F);
					     Im[WS(rs, 6)] = FMS(KP980785280, T8G, T8F);
					     Rm[WS(rs, 2)] = FMA(KP831469612, T5N, T5G);
					     Rp[WS(rs, 13)] = FNMS(KP831469612, T5N, T5G);
					     T8M = T5P + T5Q;
					     T5R = T5P - T5Q;
					     Ip[WS(rs, 13)] = FNMS(KP831469612, T8M, T8L);
					     Im[WS(rs, 2)] = -(FMA(KP831469612, T8M, T8L));
					     Rp[WS(rs, 5)] = FMA(KP831469612, T5R, T5O);
					     Rm[WS(rs, 10)] = FNMS(KP831469612, T5R, T5O);
					}
				   }
			      }
			      {
				   E T6o, T5W, T8W, T63, T8V, T8P, T8Q, T6r, T67, T6u, T6y, T6C, T6m, T6i;
				   {
					E T6p, T5Z, T62, T6q;
					T6p = FNMS(KP414213562, T5X, T5Y);
					T5Z = FMA(KP414213562, T5Y, T5X);
					Ip[WS(rs, 5)] = FMA(KP831469612, T8K, T8J);
					Im[WS(rs, 10)] = FMS(KP831469612, T8K, T8J);
					T6o = FNMS(KP707106781, T5V, T5S);
					T5W = FMA(KP707106781, T5V, T5S);
					T62 = FNMS(KP414213562, T61, T60);
					T6q = FMA(KP414213562, T60, T61);
					T8W = T5Z + T62;
					T63 = T5Z - T62;
					T8V = FNMS(KP707106781, T8O, T8N);
					T8P = FMA(KP707106781, T8O, T8N);
					{
					     E T6x, T6e, T6w, T6h;
					     T8Q = T6q - T6p;
					     T6r = T6p + T6q;
					     T6x = FMA(KP707106781, T6d, T6c);
					     T6e = FNMS(KP707106781, T6d, T6c);
					     T6w = FMA(KP707106781, T6g, T6f);
					     T6h = FNMS(KP707106781, T6g, T6f);
					     T67 = FNMS(KP707106781, T66, T65);
					     T6u = FMA(KP707106781, T66, T65);
					     T6y = FMA(KP198912367, T6x, T6w);
					     T6C = FNMS(KP198912367, T6w, T6x);
					     T6m = FNMS(KP668178637, T6e, T6h);
					     T6i = FMA(KP668178637, T6h, T6e);
					}
				   }
				   {
					E T6k, T64, T8R, T8T, T6t, T6a;
					T6k = FNMS(KP923879532, T63, T5W);
					T64 = FMA(KP923879532, T63, T5W);
					T8R = FMA(KP923879532, T8Q, T8P);
					T8T = FNMS(KP923879532, T8Q, T8P);
					T6t = FMA(KP707106781, T69, T68);
					T6a = FNMS(KP707106781, T69, T68);
					{
					     E T6A, T8X, T8Y, T6D;
					     {
						  E T6s, T6B, T6l, T6b, T6z, T6v;
						  T6A = FMA(KP923879532, T6r, T6o);
						  T6s = FNMS(KP923879532, T6r, T6o);
						  T6v = FMA(KP198912367, T6u, T6t);
						  T6B = FNMS(KP198912367, T6t, T6u);
						  T6l = FNMS(KP668178637, T67, T6a);
						  T6b = FMA(KP668178637, T6a, T67);
						  T6z = T6v + T6y;
						  T90 = T6y - T6v;
						  T8Z = FMA(KP923879532, T8W, T8V);
						  T8X = FNMS(KP923879532, T8W, T8V);
						  {
						       E T6n, T8S, T8U, T6j;
						       T6n = T6l + T6m;
						       T8S = T6l - T6m;
						       T8U = T6i - T6b;
						       T6j = T6b + T6i;
						       Rp[WS(rs, 7)] = FMA(KP980785280, T6z, T6s);
						       Rm[WS(rs, 8)] = FNMS(KP980785280, T6z, T6s);
						       Rp[WS(rs, 11)] = FMA(KP831469612, T6n, T6k);
						       Rm[WS(rs, 4)] = FNMS(KP831469612, T6n, T6k);
						       Ip[WS(rs, 3)] = FMA(KP831469612, T8S, T8R);
						       Im[WS(rs, 12)] = FMS(KP831469612, T8S, T8R);
						       Ip[WS(rs, 11)] = FMA(KP831469612, T8U, T8T);
						       Im[WS(rs, 4)] = FMS(KP831469612, T8U, T8T);
						       Rp[WS(rs, 3)] = FMA(KP831469612, T6j, T64);
						       Rm[WS(rs, 12)] = FNMS(KP831469612, T6j, T64);
						       T8Y = T6C - T6B;
						       T6D = T6B + T6C;
						  }
					     }
					     Ip[WS(rs, 7)] = FMA(KP980785280, T8Y, T8X);
					     Im[WS(rs, 8)] = FMS(KP980785280, T8Y, T8X);
					     Rm[0] = FMA(KP980785280, T6D, T6A);
					     Rp[WS(rs, 15)] = FNMS(KP980785280, T6D, T6A);
					}
				   }
			      }
			 }
		    }
	       }
	       Ip[WS(rs, 15)] = FMA(KP980785280, T90, T8Z);
	       Im[0] = FMS(KP980785280, T90, T8Z);
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 32},
     {TW_NEXT, 1, 0}
};

static const hc2c_desc desc = { 32, "hc2cf_32", twinstr, &GENUS, {236, 62, 198, 0} };

void X(codelet_hc2cf_32) (planner *p) {
     X(khc2c_register) (p, hc2cf_32, &desc, HC2C_VIA_RDFT);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2c.native -compact -variables 4 -pipeline-latency 4 -n 32 -dit -name hc2cf_32 -include hc2cf.h */

/*
 * This function contains 434 FP additions, 208 FP multiplications,
 * (or, 340 additions, 114 multiplications, 94 fused multiply/add),
 * 96 stack variables, 7 constants, and 128 memory accesses
 */
#include "hc2cf.h"

static void hc2cf_32(R *Rp, R *Ip, R *Rm, R *Im, const R *W, stride rs, INT mb, INT me, INT ms)
{
     DK(KP195090322, +0.195090322016128267848284868477022240927691618);
     DK(KP980785280, +0.980785280403230449126182236134239036973933731);
     DK(KP555570233, +0.555570233019602224742830813948532874374937191);
     DK(KP831469612, +0.831469612302545237078788377617905756738560812);
     DK(KP382683432, +0.382683432365089771728459984030398866761344562);
     DK(KP923879532, +0.923879532511286756128183189396788286822416626);
     DK(KP707106781, +0.707106781186547524400844362104849039284835938);
     {
	  INT m;
	  for (m = mb, W = W + ((mb - 1) * 62); m < me; m = m + 1, Rp = Rp + ms, Ip = Ip + ms, Rm = Rm - ms, Im = Im - ms, W = W + 62, MAKE_VOLATILE_STRIDE(rs)) {
	       E Tj, T5F, T7C, T7Q, T35, T4T, T78, T7m, T1Q, T61, T5Y, T6J, T3K, T59, T41;
	       E T56, T2B, T67, T6e, T6O, T4b, T5d, T4s, T5g, TG, T7l, T5I, T73, T3a, T4U;
	       E T3f, T4V, T14, T5N, T5M, T6E, T3m, T4Y, T3r, T4Z, T1r, T5P, T5S, T6F, T3x;
	       E T51, T3C, T52, T2d, T5Z, T64, T6K, T3V, T57, T44, T5a, T2Y, T6f, T6a, T6P;
	       E T4m, T5h, T4v, T5e;
	       {
		    E T1, T76, T6, T75, Tc, T32, Th, T33;
		    T1 = Rp[0];
		    T76 = Rm[0];
		    {
			 E T3, T5, T2, T4;
			 T3 = Rp[WS(rs, 8)];
			 T5 = Rm[WS(rs, 8)];
			 T2 = W[30];
			 T4 = W[31];
			 T6 = FMA(T2, T3, T4 * T5);
			 T75 = FNMS(T4, T3, T2 * T5);
		    }
		    {
			 E T9, Tb, T8, Ta;
			 T9 = Rp[WS(rs, 4)];
			 Tb = Rm[WS(rs, 4)];
			 T8 = W[14];
			 Ta = W[15];
			 Tc = FMA(T8, T9, Ta * Tb);
			 T32 = FNMS(Ta, T9, T8 * Tb);
		    }
		    {
			 E Te, Tg, Td, Tf;
			 Te = Rp[WS(rs, 12)];
			 Tg = Rm[WS(rs, 12)];
			 Td = W[46];
			 Tf = W[47];
			 Th = FMA(Td, Te, Tf * Tg);
			 T33 = FNMS(Tf, Te, Td * Tg);
		    }
		    {
			 E T7, Ti, T7A, T7B;
			 T7 = T1 + T6;
			 Ti = Tc + Th;
			 Tj = T7 + Ti;
			 T5F = T7 - Ti;
			 T7A = T76 - T75;
			 T7B = Tc - Th;
			 T7C = T7A - T7B;
			 T7Q = T7B + T7A;
		    }
		    {
			 E T31, T34, T74, T77;
			 T31 = T1 - T6;
			 T34 = T32 - T33;
			 T35 = T31 - T34;
			 T4T = T31 + T34;
			 T74 = T32 + T33;
			 T77 = T75 + T76;
			 T78 = T74 + T77;
			 T7m = T77 - T74;
		    }
	       }
	       {
		    E T1y, T3G, T1O, T3Z, T1D, T3H, T1J, T3Y;
		    {
			 E T1v, T1x, T1u, T1w;
			 T1v = Ip[0];
			 T1x = Im[0];
			 T1u = W[0];
			 T1w = W[1];
			 T1y = FMA(T1u, T1v, T1w * T1x);
			 T3G = FNMS(T1w, T1v, T1u * T1x);
		    }
		    {
			 E T1L, T1N, T1K, T1M;
			 T1L = Ip[WS(rs, 12)];
			 T1N = Im[WS(rs, 12)];
			 T1K = W[48];
			 T1M = W[49];
			 T1O = FMA(T1K, T1L, T1M * T1N);
			 T3Z = FNMS(T1M, T1L, T1K * T1N);
		    }
		    {
			 E T1A, T1C, T1z, T1B;
			 T1A = Ip[WS(rs, 8)];
			 T1C = Im[WS(rs, 8)];
			 T1z = W[32];
			 T1B = W[33];
			 T1D = FMA(T1z, T1A, T1B * T1C);
			 T3H = FNMS(T1B, T1A, T1z * T1C);
		    }
		    {
			 E T1G, T1I, T1F, T1H;
			 T1G = Ip[WS(rs, 4)];
			 T1I = Im[WS(rs, 4)];
			 T1F = W[16];
			 T1H = W[17];
			 T1J = FMA(T1F, T1G, T1H * T1I);
			 T3Y = FNMS(T1H, T1G, T1F * T1I);
		    }
		    {
			 E T1E, T1P, T5W, T5X;
			 T1E = T1y + T1D;
			 T1P = T1J + T1O;
			 T1Q = T1E + T1P;
			 T61 = T1E - T1P;
			 T5W = T3G + T3H;
			 T5X = T3Y + T3Z;
			 T5Y = T5W - T5X;
			 T6J = T5W + T5X;
		    }
		    {
			 E T3I, T3J, T3X, T40;
			 T3I = T3G - T3H;
			 T3J = T1J - T1O;
			 T3K = T3I + T3J;
			 T59 = T3I - T3J;
			 T3X = T1y - T1D;
			 T40 = T3Y - T3Z;
			 T41 = T3X - T40;
			 T56 = T3X + T40;
		    }
	       }
	       {
		    E T2j, T4o, T2z, T49, T2o, T4p, T2u, T48;
		    {
			 E T2g, T2i, T2f, T2h;
			 T2g = Ip[WS(rs, 15)];
			 T2i = Im[WS(rs, 15)];
			 T2f = W[60];
			 T2h = W[61];
			 T2j = FMA(T2f, T2g, T2h * T2i);
			 T4o = FNMS(T2h, T2g, T2f * T2i);
		    }
		    {
			 E T2w, T2y, T2v, T2x;
			 T2w = Ip[WS(rs, 11)];
			 T2y = Im[WS(rs, 11)];
			 T2v = W[44];
			 T2x = W[45];
			 T2z = FMA(T2v, T2w, T2x * T2y);
			 T49 = FNMS(T2x, T2w, T2v * T2y);
		    }
		    {
			 E T2l, T2n, T2k, T2m;
			 T2l = Ip[WS(rs, 7)];
			 T2n = Im[WS(rs, 7)];
			 T2k = W[28];
			 T2m = W[29];
			 T2o = FMA(T2k, T2l, T2m * T2n);
			 T4p = FNMS(T2m, T2l, T2k * T2n);
		    }
		    {
			 E T2r, T2t, T2q, T2s;
			 T2r = Ip[WS(rs, 3)];
			 T2t = Im[WS(rs, 3)];
			 T2q = W[12];
			 T2s = W[13];
			 T2u = FMA(T2q, T2r, T2s * T2t);
			 T48 = FNMS(T2s, T2r, T2q * T2t);
		    }
		    {
			 E T2p, T2A, T6c, T6d;
			 T2p = T2j + T2o;
			 T2A = T2u + T2z;
			 T2B = T2p + T2A;
			 T67 = T2p - T2A;
			 T6c = T4o + T4p;
			 T6d = T48 + T49;
			 T6e = T6c - T6d;
			 T6O = T6c + T6d;
		    }
		    {
			 E T47, T4a, T4q, T4r;
			 T47 = T2j - T2o;
			 T4a = T48 - T49;
			 T4b = T47 - T4a;
			 T5d = T47 + T4a;
			 T4q = T4o - T4p;
			 T4r = T2u - T2z;
			 T4s = T4q + T4r;
			 T5g = T4q - T4r;
		    }
	       }
	       {
		    E To, T36, TE, T3d, Tt, T37, Tz, T3c;
		    {
			 E Tl, Tn, Tk, Tm;
			 Tl = Rp[WS(rs, 2)];
			 Tn = Rm[WS(rs, 2)];
			 Tk = W[6];
			 Tm = W[7];
			 To = FMA(Tk, Tl, Tm * Tn);
			 T36 = FNMS(Tm, Tl, Tk * Tn);
		    }
		    {
			 E TB, TD, TA, TC;
			 TB = Rp[WS(rs, 6)];
			 TD = Rm[WS(rs, 6)];
			 TA = W[22];
			 TC = W[23];
			 TE = FMA(TA, TB, TC * TD);
			 T3d = FNMS(TC, TB, TA * TD);
		    }
		    {
			 E Tq, Ts, Tp, Tr;
			 Tq = Rp[WS(rs, 10)];
			 Ts = Rm[WS(rs, 10)];
			 Tp = W[38];
			 Tr = W[39];
			 Tt = FMA(Tp, Tq, Tr * Ts);
			 T37 = FNMS(Tr, Tq, Tp * Ts);
		    }
		    {
			 E Tw, Ty, Tv, Tx;
			 Tw = Rp[WS(rs, 14)];
			 Ty = Rm[WS(rs, 14)];
			 Tv = W[54];
			 Tx = W[55];
			 Tz = FMA(Tv, Tw, Tx * Ty);
			 T3c = FNMS(Tx, Tw, Tv * Ty);
		    }
		    {
			 E Tu, TF, T5G, T5H;
			 Tu = To + Tt;
			 TF = Tz + TE;
			 TG = Tu + TF;
			 T7l = TF - Tu;
			 T5G = T36 + T37;
			 T5H = T3c + T3d;
			 T5I = T5G - T5H;
			 T73 = T5G + T5H;
		    }
		    {
			 E T38, T39, T3b, T3e;
			 T38 = T36 - T37;
			 T39 = To - Tt;
			 T3a = T38 - T39;
			 T4U = T39 + T38;
			 T3b = Tz - TE;
			 T3e = T3c - T3d;
			 T3f = T3b + T3e;
			 T4V = T3b - T3e;
		    }
	       }
	       {
		    E TM, T3i, T12, T3p, TR, T3j, TX, T3o;
		    {
			 E TJ, TL, TI, TK;
			 TJ = Rp[WS(rs, 1)];
			 TL = Rm[WS(rs, 1)];
			 TI = W[2];
			 TK = W[3];
			 TM = FMA(TI, TJ, TK * TL);
			 T3i = FNMS(TK, TJ, TI * TL);
		    }
		    {
			 E TZ, T11, TY, T10;
			 TZ = Rp[WS(rs, 13)];
			 T11 = Rm[WS(rs, 13)];
			 TY = W[50];
			 T10 = W[51];
			 T12 = FMA(TY, TZ, T10 * T11);
			 T3p = FNMS(T10, TZ, TY * T11);
		    }
		    {
			 E TO, TQ, TN, TP;
			 TO = Rp[WS(rs, 9)];
			 TQ = Rm[WS(rs, 9)];
			 TN = W[34];
			 TP = W[35];
			 TR = FMA(TN, TO, TP * TQ);
			 T3j = FNMS(TP, TO, TN * TQ);
		    }
		    {
			 E TU, TW, TT, TV;
			 TU = Rp[WS(rs, 5)];
			 TW = Rm[WS(rs, 5)];
			 TT = W[18];
			 TV = W[19];
			 TX = FMA(TT, TU, TV * TW);
			 T3o = FNMS(TV, TU, TT * TW);
		    }
		    {
			 E TS, T13, T5K, T5L;
			 TS = TM + TR;
			 T13 = TX + T12;
			 T14 = TS + T13;
			 T5N = TS - T13;
			 T5K = T3i + T3j;
			 T5L = T3o + T3p;
			 T5M = T5K - T5L;
			 T6E = T5K + T5L;
		    }
		    {
			 E T3k, T3l, T3n, T3q;
			 T3k = T3i - T3j;
			 T3l = TX - T12;
			 T3m = T3k + T3l;
			 T4Y = T3k - T3l;
			 T3n = TM - TR;
			 T3q = T3o - T3p;
			 T3r = T3n - T3q;
			 T4Z = T3n + T3q;
		    }
	       }
	       {
		    E T19, T3t, T1p, T3A, T1e, T3u, T1k, T3z;
		    {
			 E T16, T18, T15, T17;
			 T16 = Rp[WS(rs, 15)];
			 T18 = Rm[WS(rs, 15)];
			 T15 = W[58];
			 T17 = W[59];
			 T19 = FMA(T15, T16, T17 * T18);
			 T3t = FNMS(T17, T16, T15 * T18);
		    }
		    {
			 E T1m, T1o, T1l, T1n;
			 T1m = Rp[WS(rs, 11)];
			 T1o = Rm[WS(rs, 11)];
			 T1l = W[42];
			 T1n = W[43];
			 T1p = FMA(T1l, T1m, T1n * T1o);
			 T3A = FNMS(T1n, T1m, T1l * T1o);
		    }
		    {
			 E T1b, T1d, T1a, T1c;
			 T1b = Rp[WS(rs, 7)];
			 T1d = Rm[WS(rs, 7)];
			 T1a = W[26];
			 T1c = W[27];
			 T1e = FMA(T1a, T1b, T1c * T1d);
			 T3u = FNMS(T1c, T1b, T1a * T1d);
		    }
		    {
			 E T1h, T1j, T1g, T1i;
			 T1h = Rp[WS(rs, 3)];
			 T1j = Rm[WS(rs, 3)];
			 T1g = W[10];
			 T1i = W[11];
			 T1k = FMA(T1g, T1h, T1i * T1j);
			 T3z = FNMS(T1i, T1h, T1g * T1j);
		    }
		    {
			 E T1f, T1q, T5Q, T5R;
			 T1f = T19 + T1e;
			 T1q = T1k + T1p;
			 T1r = T1f + T1q;
			 T5P = T1f - T1q;
			 T5Q = T3t + T3u;
			 T5R = T3z + T3A;
			 T5S = T5Q - T5R;
			 T6F = T5Q + T5R;
		    }
		    {
			 E T3v, T3w, T3y, T3B;
			 T3v = T3t - T3u;
			 T3w = T1k - T1p;
			 T3x = T3v + T3w;
			 T51 = T3v - T3w;
			 T3y = T19 - T1e;
			 T3B = T3z - T3A;
			 T3C = T3y - T3B;
			 T52 = T3y + T3B;
		    }
	       }
	       {
		    E T1V, T3R, T20, T3S, T3Q, T3T, T26, T3M, T2b, T3N, T3L, T3O;
		    {
			 E T1S, T1U, T1R, T1T;
			 T1S = Ip[WS(rs, 2)];
			 T1U = Im[WS(rs, 2)];
			 T1R = W[8];
			 T1T = W[9];
			 T1V = FMA(T1R, T1S, T1T * T1U);
			 T3R = FNMS(T1T, T1S, T1R * T1U);
		    }
		    {
			 E T1X, T1Z, T1W, T1Y;
			 T1X = Ip[WS(rs, 10)];
			 T1Z = Im[WS(rs, 10)];
			 T1W = W[40];
			 T1Y = W[41];
			 T20 = FMA(T1W, T1X, T1Y * T1Z);
			 T3S = FNMS(T1Y, T1X, T1W * T1Z);
		    }
		    T3Q = T1V - T20;
		    T3T = T3R - T3S;
		    {
			 E T23, T25, T22, T24;
			 T23 = Ip[WS(rs, 14)];
			 T25 = Im[WS(rs, 14)];
			 T22 = W[56];
			 T24 = W[57];
			 T26 = FMA(T22, T23, T24 * T25);
			 T3M = FNMS(T24, T23, T22 * T25);
		    }
		    {
			 E T28, T2a, T27, T29;
			 T28 = Ip[WS(rs, 6)];
			 T2a = Im[WS(rs, 6)];
			 T27 = W[24];
			 T29 = W[25];
			 T2b = FMA(T27, T28, T29 * T2a);
			 T3N = FNMS(T29, T28, T27 * T2a);
		    }
		    T3L = T26 - T2b;
		    T3O = T3M - T3N;
		    {
			 E T21, T2c, T62, T63;
			 T21 = T1V + T20;
			 T2c = T26 + T2b;
			 T2d = T21 + T2c;
			 T5Z = T2c - T21;
			 T62 = T3R + T3S;
			 T63 = T3M + T3N;
			 T64 = T62 - T63;
			 T6K = T62 + T63;
		    }
		    {
			 E T3P, T3U, T42, T43;
			 T3P = T3L - T3O;
			 T3U = T3Q + T3T;
			 T3V = KP707106781 * (T3P - T3U);
			 T57 = KP707106781 * (T3U + T3P);
			 T42 = T3T - T3Q;
			 T43 = T3L + T3O;
			 T44 = KP707106781 * (T42 - T43);
			 T5a = KP707106781 * (T42 + T43);
		    }
	       }
	       {
		    E T2G, T4c, T2L, T4d, T4e, T4f, T2R, T4i, T2W, T4j, T4h, T4k;
		    {
			 E T2D, T2F, T2C, T2E;
			 T2D = Ip[WS(rs, 1)];
			 T2F = Im[WS(rs, 1)];
			 T2C = W[4];
			 T2E = W[5];
			 T2G = FMA(T2C, T2D, T2E * T2F);
			 T4c = FNMS(T2E, T2D, T2C * T2F);
		    }
		    {
			 E T2I, T2K, T2H, T2J;
			 T2I = Ip[WS(rs, 9)];
			 T2K = Im[WS(rs, 9)];
			 T2H = W[36];
			 T2J = W[37];
			 T2L = FMA(T2H, T2I, T2J * T2K);
			 T4d = FNMS(T2J, T2I, T2H * T2K);
		    }
		    T4e = T4c - T4d;
		    T4f = T2G - T2L;
		    {
			 E T2O, T2Q, T2N, T2P;
			 T2O = Ip[WS(rs, 13)];
			 T2Q = Im[WS(rs, 13)];
			 T2N = W[52];
			 T2P = W[53];
			 T2R = FMA(T2N, T2O, T2P * T2Q);
			 T4i = FNMS(T2P, T2O, T2N * T2Q);
		    }
		    {
			 E T2T, T2V, T2S, T2U;
			 T2T = Ip[WS(rs, 5)];
			 T2V = Im[WS(rs, 5)];
			 T2S = W[20];
			 T2U = W[21];
			 T2W = FMA(T2S, T2T, T2U * T2V);
			 T4j = FNMS(T2U, T2T, T2S * T2V);
		    }
		    T4h = T2R - T2W;
		    T4k = T4i - T4j;
		    {
			 E T2M, T2X, T68, T69;
			 T2M = T2G + T2L;
			 T2X = T2R + T2W;
			 T2Y = T2M + T2X;
			 T6f = T2X - T2M;
			 T68 = T4c + T4d;
			 T69 = T4i + T4j;
			 T6a = T68 - T69;
			 T6P = T68 + T69;
		    }
		    {
			 E T4g, T4l, T4t, T4u;
			 T4g = T4e - T4f;
			 T4l = T4h + T4k;
			 T4m = KP707106781 * (T4g - T4l);
			 T5h = KP707106781 * (T4g + T4l);
			 T4t = T4h - T4k;
			 T4u = T4f + T4e;
			 T4v = KP707106781 * (T4t - T4u);
			 T5e = KP707106781 * (T4u + T4t);
		    }
	       }
	       {
		    E T1t, T6X, T7a, T7c, T30, T7b, T70, T71;
		    {
			 E TH, T1s, T72, T79;
			 TH = Tj + TG;
			 T1s = T14 + T1r;
			 T1t = TH + T1s;
			 T6X = TH - T1s;
			 T72 = T6E + T6F;
			 T79 = T73 + T78;
			 T7a = T72 + T79;
			 T7c = T79 - T72;
		    }
		    {
			 E T2e, T2Z, T6Y, T6Z;
			 T2e = T1Q + T2d;
			 T2Z = T2B + T2Y;
			 T30 = T2e + T2Z;
			 T7b = T2Z - T2e;
			 T6Y = T6J + T6K;
			 T6Z = T6O + T6P;
			 T70 = T6Y - T6Z;
			 T71 = T6Y + T6Z;
		    }
		    Rm[WS(rs, 15)] = T1t - T30;
		    Im[WS(rs, 15)] = T71 - T7a;
		    Rp[0] = T1t + T30;
		    Ip[0] = T71 + T7a;
		    Rm[WS(rs, 7)] = T6X - T70;
		    Im[WS(rs, 7)] = T7b - T7c;
		    Rp[WS(rs, 8)] = T6X + T70;
		    Ip[WS(rs, 8)] = T7b + T7c;
	       }
	       {
		    E T6H, T6T, T7g, T7i, T6M, T6U, T6R, T6V;
		    {
			 E T6D, T6G, T7e, T7f;
			 T6D = Tj - TG;
			 T6G = T6E - T6F;
			 T6H = T6D + T6G;
			 T6T = T6D - T6G;
			 T7e = T1r - T14;
			 T7f = T78 - T73;
			 T7g = T7e + T7f;
			 T7i = T7f - T7e;
		    }
		    {
			 E T6I, T6L, T6N, T6Q;
			 T6I = T1Q - T2d;
			 T6L = T6J - T6K;
			 T6M = T6I + T6L;
			 T6U = T6L - T6I;
			 T6N = T2B - T2Y;
			 T6Q = T6O - T6P;
			 T6R = T6N - T6Q;
			 T6V = T6N + T6Q;
		    }
		    {
			 E T6S, T7d, T6W, T7h;
			 T6S = KP707106781 * (T6M + T6R);
			 Rm[WS(rs, 11)] = T6H - T6S;
			 Rp[WS(rs, 4)] = T6H + T6S;
			 T7d = KP707106781 * (T6U + T6V);
			 Im[WS(rs, 11)] = T7d - T7g;
			 Ip[WS(rs, 4)] = T7d + T7g;
			 T6W = KP707106781 * (T6U - T6V);
			 Rm[WS(rs, 3)] = T6T - T6W;
			 Rp[WS(rs, 12)] = T6T + T6W;
			 T7h = KP707106781 * (T6R - T6M);
			 Im[WS(rs, 3)] = T7h - T7i;
			 Ip[WS(rs, 12)] = T7h + T7i;
		    }
	       }
	       {
		    E T5J, T7n, T7t, T6n, T5U, T7k, T6x, T6B, T6q, T7s, T66, T6k, T6u, T6A, T6h;
		    E T6l;
		    {
			 E T5O, T5T, T60, T65;
			 T5J = T5F - T5I;
			 T7n = T7l + T7m;
			 T7t = T7m - T7l;
			 T6n = T5F + T5I;
			 T5O = T5M - T5N;
			 T5T = T5P + T5S;
			 T5U = KP707106781 * (T5O - T5T);
			 T7k = KP707106781 * (T5O + T5T);
			 {
			      E T6v, T6w, T6o, T6p;
			      T6v = T67 + T6a;
			      T6w = T6e + T6f;
			      T6x = FNMS(KP382683432, T6w, KP923879532 * T6v);
			      T6B = FMA(KP923879532, T6w, KP382683432 * T6v);
			      T6o = T5N + T5M;
			      T6p = T5P - T5S;
			      T6q = KP707106781 * (T6o + T6p);
			      T7s = KP707106781 * (T6p - T6o);
			 }
			 T60 = T5Y - T5Z;
			 T65 = T61 - T64;
			 T66 = FMA(KP923879532, T60, KP382683432 * T65);
			 T6k = FNMS(KP923879532, T65, KP382683432 * T60);
			 {
			      E T6s, T6t, T6b, T6g;
			      T6s = T5Y + T5Z;
			      T6t = T61 + T64;
			      T6u = FMA(KP382683432, T6s, KP923879532 * T6t);
			      T6A = FNMS(KP382683432, T6t, KP923879532 * T6s);
			      T6b = T67 - T6a;
			      T6g = T6e - T6f;
			      T6h = FNMS(KP923879532, T6g, KP382683432 * T6b);
			      T6l = FMA(KP382683432, T6g, KP923879532 * T6b);
			 }
		    }
		    {
			 E T5V, T6i, T7r, T7u;
			 T5V = T5J + T5U;
			 T6i = T66 + T6h;
			 Rm[WS(rs, 9)] = T5V - T6i;
			 Rp[WS(rs, 6)] = T5V + T6i;
			 T7r = T6k + T6l;
			 T7u = T7s + T7t;
			 Im[WS(rs, 9)] = T7r - T7u;
			 Ip[WS(rs, 6)] = T7r + T7u;
		    }
		    {
			 E T6j, T6m, T7v, T7w;
			 T6j = T5J - T5U;
			 T6m = T6k - T6l;
			 Rm[WS(rs, 1)] = T6j - T6m;
			 Rp[WS(rs, 14)] = T6j + T6m;
			 T7v = T6h - T66;
			 T7w = T7t - T7s;
			 Im[WS(rs, 1)] = T7v - T7w;
			 Ip[WS(rs, 14)] = T7v + T7w;
		    }
		    {
			 E T6r, T6y, T7j, T7o;
			 T6r = T6n + T6q;
			 T6y = T6u + T6x;
			 Rm[WS(rs, 13)] = T6r - T6y;
			 Rp[WS(rs, 2)] = T6r + T6y;
			 T7j = T6A + T6B;
			 T7o = T7k + T7n;
			 Im[WS(rs, 13)] = T7j - T7o;
			 Ip[WS(rs, 2)] = T7j + T7o;
		    }
		    {
			 E T6z, T6C, T7p, T7q;
			 T6z = T6n - T6q;
			 T6C = T6A - T6B;
			 Rm[WS(rs, 5)] = T6z - T6C;
			 Rp[WS(rs, 10)] = T6z + T6C;
			 T7p = T6x - T6u;
			 T7q = T7n - T7k;
			 Im[WS(rs, 5)] = T7p - T7q;
			 Ip[WS(rs, 10)] = T7p + T7q;
		    }
	       }
	       {
		    E T3h, T4D, T7R, T7X, T3E, T7O, T4N, T4R, T46, T4A, T4G, T7W, T4K, T4Q, T4x;
		    E T4B, T3g, T7P;
		    T3g = KP707106781 * (T3a - T3f);
		    T3h = T35 - T3g;
		    T4D = T35 + T3g;
		    T7P = KP707106781 * (T4V - T4U);
		    T7R = T7P + T7Q;
		    T7X = T7Q - T7P;
		    {
			 E T3s, T3D, T4L, T4M;
			 T3s = FNMS(KP923879532, T3r, KP382683432 * T3m);
			 T3D = FMA(KP382683432, T3x, KP923879532 * T3C);
			 T3E = T3s - T3D;
			 T7O = T3s + T3D;
			 T4L = T4b + T4m;
			 T4M = T4s + T4v;
			 T4N = FNMS(KP555570233, T4M, KP831469612 * T4L);
			 T4R = FMA(KP831469612, T4M, KP555570233 * T4L);
		    }
		    {
			 E T3W, T45, T4E, T4F;
			 T3W = T3K - T3V;
			 T45 = T41 - T44;
			 T46 = FMA(KP980785280, T3W, KP195090322 * T45);
			 T4A = FNMS(KP980785280, T45, KP195090322 * T3W);
			 T4E = FMA(KP923879532, T3m, KP382683432 * T3r);
			 T4F = FNMS(KP923879532, T3x, KP382683432 * T3C);
			 T4G = T4E + T4F;
			 T7W = T4F - T4E;
		    }
		    {
			 E T4I, T4J, T4n, T4w;
			 T4I = T3K + T3V;
			 T4J = T41 + T44;
			 T4K = FMA(KP555570233, T4I, KP831469612 * T4J);
			 T4Q = FNMS(KP555570233, T4J, KP831469612 * T4I);
			 T4n = T4b - T4m;
			 T4w = T4s - T4v;
			 T4x = FNMS(KP980785280, T4w, KP195090322 * T4n);
			 T4B = FMA(KP195090322, T4w, KP980785280 * T4n);
		    }
		    {
			 E T3F, T4y, T7V, T7Y;
			 T3F = T3h + T3E;
			 T4y = T46 + T4x;
			 Rm[WS(rs, 8)] = T3F - T4y;
			 Rp[WS(rs, 7)] = T3F + T4y;
			 T7V = T4A + T4B;
			 T7Y = T7W + T7X;
			 Im[WS(rs, 8)] = T7V - T7Y;
			 Ip[WS(rs, 7)] = T7V + T7Y;
		    }
		    {
			 E T4z, T4C, T7Z, T80;
			 T4z = T3h - T3E;
			 T4C = T4A - T4B;
			 Rm[0] = T4z - T4C;
			 Rp[WS(rs, 15)] = T4z + T4C;
			 T7Z = T4x - T46;
			 T80 = T7X - T7W;
			 Im[0] = T7Z - T80;
			 Ip[WS(rs, 15)] = T7Z + T80;
		    }
		    {
			 E T4H, T4O, T7N, T7S;
			 T4H = T4D + T4G;
			 T4O = T4K + T4N;
			 Rm[WS(rs, 12)] = T4H - T4O;
			 Rp[WS(rs, 3)] = T4H + T4O;
			 T7N = T4Q + T4R;
			 T7S = T7O + T7R;
			 Im[WS(rs, 12)] = T7N - T7S;
			 Ip[WS(rs, 3)] = T7N + T7S;
		    }
		    {
			 E T4P, T4S, T7T, T7U;
			 T4P = T4D - T4G;
			 T4S = T4Q - T4R;
			 Rm[WS(rs, 4)] = T4P - T4S;
			 Rp[WS(rs, 11)] = T4P + T4S;
			 T7T = T4N - T4K;
			 T7U = T7R - T7O;
			 Im[WS(rs, 4)] = T7T - T7U;
			 Ip[WS(rs, 11)] = T7T + T7U;
		    }
	       }
	       {
		    E T4X, T5p, T7D, T7J, T54, T7y, T5z, T5D, T5c, T5m, T5s, T7I, T5w, T5C, T5j;
		    E T5n, T4W, T7z;
		    T4W = KP707106781 * (T4U + T4V);
		    T4X = T4T - T4W;
		    T5p = T4T + T4W;
		    T7z = KP707106781 * (T3a + T3f);
		    T7D = T7z + T7C;
		    T7J = T7C - T7z;
		    {
			 E T50, T53, T5x, T5y;
			 T50 = FNMS(KP382683432, T4Z, KP923879532 * T4Y);
			 T53 = FMA(KP923879532, T51, KP382683432 * T52);
			 T54 = T50 - T53;
			 T7y = T50 + T53;
			 T5x = T5d + T5e;
			 T5y = T5g + T5h;
			 T5z = FNMS(KP195090322, T5y, KP980785280 * T5x);
			 T5D = FMA(KP195090322, T5x, KP980785280 * T5y);
		    }
		    {
			 E T58, T5b, T5q, T5r;
			 T58 = T56 - T57;
			 T5b = T59 - T5a;
			 T5c = FMA(KP555570233, T58, KP831469612 * T5b);
			 T5m = FNMS(KP831469612, T58, KP555570233 * T5b);
			 T5q = FMA(KP382683432, T4Y, KP923879532 * T4Z);
			 T5r = FNMS(KP382683432, T51, KP923879532 * T52);
			 T5s = T5q + T5r;
			 T7I = T5r - T5q;
		    }
		    {
			 E T5u, T5v, T5f, T5i;
			 T5u = T56 + T57;
			 T5v = T59 + T5a;
			 T5w = FMA(KP980785280, T5u, KP195090322 * T5v);
			 T5C = FNMS(KP195090322, T5u, KP980785280 * T5v);
			 T5f = T5d - T5e;
			 T5i = T5g - T5h;
			 T5j = FNMS(KP831469612, T5i, KP555570233 * T5f);
			 T5n = FMA(KP831469612, T5f, KP555570233 * T5i);
		    }
		    {
			 E T55, T5k, T7H, T7K;
			 T55 = T4X + T54;
			 T5k = T5c + T5j;
			 Rm[WS(rs, 10)] = T55 - T5k;
			 Rp[WS(rs, 5)] = T55 + T5k;
			 T7H = T5m + T5n;
			 T7K = T7I + T7J;
			 Im[WS(rs, 10)] = T7H - T7K;
			 Ip[WS(rs, 5)] = T7H + T7K;
		    }
		    {
			 E T5l, T5o, T7L, T7M;
			 T5l = T4X - T54;
			 T5o = T5m - T5n;
			 Rm[WS(rs, 2)] = T5l - T5o;
			 Rp[WS(rs, 13)] = T5l + T5o;
			 T7L = T5j - T5c;
			 T7M = T7J - T7I;
			 Im[WS(rs, 2)] = T7L - T7M;
			 Ip[WS(rs, 13)] = T7L + T7M;
		    }
		    {
			 E T5t, T5A, T7x, T7E;
			 T5t = T5p + T5s;
			 T5A = T5w + T5z;
			 Rm[WS(rs, 14)] = T5t - T5A;
			 Rp[WS(rs, 1)] = T5t + T5A;
			 T7x = T5C + T5D;
			 T7E = T7y + T7D;
			 Im[WS(rs, 14)] = T7x - T7E;
			 Ip[WS(rs, 1)] = T7x + T7E;
		    }
		    {
			 E T5B, T5E, T7F, T7G;
			 T5B = T5p - T5s;
			 T5E = T5C - T5D;
			 Rm[WS(rs, 6)] = T5B - T5E;
			 Rp[WS(rs, 9)] = T5B + T5E;
			 T7F = T5z - T5w;
			 T7G = T7D - T7y;
			 Im[WS(rs, 6)] = T7F - T7G;
			 Ip[WS(rs, 9)] = T7F + T7G;
		    }
	       }
	  }
     }
}

static const tw_instr twinstr[] = {
     {TW_FULL, 1, 32},
     {TW_NEXT, 1, 0}
};

static const hc2c_desc desc = { 32, "hc2cf_32", twinstr, &GENUS, {340, 114, 94, 0} };

void X(codelet_hc2cf_32) (planner *p) {
     X(khc2c_register) (p, hc2cf_32, &desc, HC2C_VIA_RDFT);
}
#endif				/* HAVE_FMA */
