#! /bin/sh
#
# ffproxy       This init.d script is used to start ffproxy
#

### BEGIN INIT INFO
# Provides:          ffproxy
# Required-Start:    $remote_fs $network $syslog
# Required-Stop:     $remote_fs $network $syslog
# Should-Start:      $named
# Should-Stop:       $named
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: A light and customizable http(s) proxy server
### END INIT INFO

# Edit /etc/default/ffproxy to change this.
FFPROXY_START=yes
FFPROXY_USECHROOT=yes
FFPROXY_USER=nobody
FFPROXY_GROUP=nogroup
FFPROXY_OPTS=

# Do not edit vars below
FFPROXY_CHROOT=/var/lib/ffproxy
FFPROXY_DBPATH=/etc/ffproxy
FFPROXY_PID=/var/run/ffproxy.pid

PATH=/sbin:/bin:/usr/sbin:/usr/bin
FFPROXY=/usr/bin/ffproxy
NAME=ffproxy
DESC="http(s) proxy server"
VERBOSE=no

[ -x $FFPROXY ] || exit 0

# loading lsb functions
. /lib/lsb/init-functions

# Override root's umask while invoking this script
umask 0022

# Include ffproxy defaults if available
[ -f /etc/default/ffproxy ] && . /etc/default/ffproxy

# Include rcS defaults
[ -f /etc/default/rcS ] && . /etc/default/rcS

if [ "$FFPROXY_START" = "no" -a "$1" != "stop" ]; then
    [ "$VERBOSE" != "no" ] && \
	log_daemon_msg "Not starting ffproxy - edit /etc/default/ffproxy and change FFPROXY_START to be 'yes'.";
    exit 0;
fi

update_chroot() {
    
    [ ! -d "$FFPROXY_CHROOT" ] && mkdir -p $FFPROXY_CHROOT
    
    for f in $FFPROXY_DBPATH/*/* /etc/localtime /etc/hosts \
	/etc/resolv.conf /etc/nsswitch.conf /lib/libns*so* /lib/libresolv*so* ; do
      d=$(dirname $f)
      [ ! -d "$FFPROXY_CHROOT/$d" ] && mkdir -p $FFPROXY_CHROOT/$d
      [ -e "$FFPROXY_CHROOT/$f" ] && rm -f $FFPROXY_CHROOT/$f
      cp $f $FFPROXY_CHROOT/$f
    done
    
    [ -n "$FFPROXY_USER" -a -n "$FFPROXY_GROUP" ] && chown -R $FFPROXY_USER:$FFPROXY_GROUP $FFPROXY_CHROOT/*
}

delete_chroot() {
    rm -rf "$FFPROXY_CHROOT"
}

actions_start () {
    if [ "$FFPROXY_USECHROOT" = "yes" ]; then
	update_chroot
	FFPROXY_OPTS="$FFPROXY_OPTS -r $FFPROXY_CHROOT -D $FFPROXY_DBPATH"
    else
	FFPROXY_OPTS="$FFPROXY_OPTS -D $FFPROXY_DBPATH"
    fi
    if [ -n "$FFPROXY_USER" -a -n "$FFPROXY_GROUP" ]; then 
	FFPROXY_OPTS="$FFPROXY_OPTS -u $FFPROXY_USER -g $FFPROXY_GROUP"
    fi
}

actions_update () {
    [ "$FFPROXY_USECHROOT" = "yes" ] && update_chroot
}

actions_stop () {
    [ -d "$FFPROXY_CHROOT" ] && delete_chroot
}


case "$1" in
    start)
	actions_start
	log_daemon_msg "Starting $DESC"
	log_progress_msg "$NAME"
	start_daemon -p $FFPROXY_PID $FFPROXY $FFPROXY_OPTS
	log_end_msg "$?"
	;;

    stop)
	log_daemon_msg "Stopping $DESC"
	log_progress_msg "$NAME"
	#killproc -p $FFPROXY_PID $FFPROXY
	start-stop-daemon --stop --quiet --oknodo --pidfile $FFPROXY_PID
	actions_stop
	log_end_msg "$?"
	;;

    reload)
	log_daemon_msg "Reloading $DESC"
	log_progress_msg "$NAME"
	actions_update
	killproc -p $FFPROXY_PID $FFPROXY SIGHUP
	log_end_msg "$?"
	;;

    restart|force-reload)
	$0 stop
	sleep 1
	$0 start
	;;

    *)
	N=/etc/init.d/$NAME
	echo "Usage: $N {start|stop|restart|reload|force-reload}" >&2
	exit 1
	;;
esac

exit 0
