/*
 * Decompiled with CFR 0.152.
 */
package fix;

import fix.ErrorWindow;
import fix.Sender;
import fix.ZipFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.RepaintManager;

public class AppletFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private JPanel dataPanel = null;
    private JPanel bottomPanel = null;
    private JPanel recPanel = null;
    private JPanel filePanel = null;
    private JLabel recLabel = null;
    private JTextField recField = null;
    private JLabel fileLabel = null;
    private JTextField fileField = null;
    private JButton fileButton = null;
    private JMenuBar mainMenuBar = null;
    private JMenu fileMenu = null;
    private JMenuItem resetItem = null;
    private JMenuItem exitItem = null;
    private JPanel commentPanel = null;
    private JLabel commentLabel = null;
    private JTextField commentField = null;
    private JMenu optionMenu = null;
    private JPanel buttonPanel = null;
    private JButton sendButton = null;
    private JPanel statusBarPanel = null;
    private JLabel statusLabel = null;
    private ImageIcon sendImg = null;
    private ImageIcon exitImg = null;
    private ImageIcon infoImg = null;
    private ImageIcon reseImg = null;
    private JFileChooser browser = null;
    private Sender s = null;
    private JMenuItem infoItem = null;
    private JFrame infoFrame = null;
    private JPanel infoPanel = null;
    private JButton infoCloseButton = null;
    private JMenuItem quotaItem = null;
    private JFrame quotaFrame = null;
    private JPanel quotaPanel = null;
    private JButton quotaCloseButton = null;
    private JPanel sizePanel = null;
    private JLabel sizeLabel = null;
    private JRadioButtonMenuItem downCheck = null;
    private JRadioButtonMenuItem viewCheck = null;
    public JProgressBar progressBar = null;
    private String sizeUnit = "";
    private String host = "";
    private String use = "";
    private String auth = "";
    private String touser = "";
    private String akey = "";
    private String skey = "";
    private ErrorWindow er = null;
    private boolean debug = false;
    private String versionNumber = "$Revision: 30 $";
    private File homeDir;
    private File tempFile = null;

    public AppletFrame(String string, String string2, String string3, String string4, String string5, String string6, ErrorWindow errorWindow, boolean bl) {
        this.host = string;
        this.use = string2;
        this.auth = string3;
        this.touser = string4;
        this.akey = string5;
        this.skey = string6;
        this.er = errorWindow;
        this.debug = bl;
        this.versionNumber = "Revision " + this.versionNumber.split("\\$")[1].split(": ")[1];
        System.setProperty("javax.net.ssl.trustStore ", "fix.NaiveTrustManager");
        this.initialize();
    }

    private void initialize() {
        this.setSize(500, 260);
        int n = (int)Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2;
        int n2 = (int)Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2;
        this.setBounds(n -= this.getWidth() / 2, n2 -= this.getHeight() / 2, this.getWidth(), this.getHeight());
        this.setJMenuBar(this.getMainMenuBar());
        this.browser = new JFileChooser();
        this.homeDir = this.browser.getCurrentDirectory();
        this.setContentPane(this.getJContentPane());
        this.setTitle("F*IX");
        this.setVisible(true);
        this.setResizable(false);
        if (!this.host.startsWith("http://") && !this.host.startsWith("https://")) {
            this.er.setMess("Server protocol has to be http or https.", null);
        }
        this.resetAllGUIElements();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (AppletFrame.this.tempFile != null && AppletFrame.this.tempFile.exists()) {
                    AppletFrame.this.tempFile.delete();
                }
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getDataPanel(), "North");
            this.jContentPane.add((Component)this.getBottomPanel(), "Center");
            this.jContentPane.add((Component)this.getStatusPanel(), "South");
        }
        return this.jContentPane;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("reset")) {
            this.resetAllGUIElements();
            if (this.tempFile != null && this.tempFile.exists()) {
                this.tempFile.delete();
            }
        } else if (string.equals("exit")) {
            if (this.tempFile != null && this.tempFile.exists()) {
                this.tempFile.delete();
            }
            this.dispose();
        } else if (string.equals("browse")) {
            this.browser.setDialogTitle("Open - Use Ctrl/Strg key to select multiple files/dirs");
            this.browser.setFileSelectionMode(2);
            this.browser.setMultiSelectionEnabled(true);
            this.browser.setCurrentDirectory(this.homeDir);
            this.browser.setSelectedFile(new File(""));
            int n = this.browser.showOpenDialog(this);
            if (n == 0) {
                if (this.tempFile != null && this.tempFile.exists()) {
                    this.tempFile.delete();
                }
                this.homeDir = this.browser.getCurrentDirectory();
                File[] fileArray = this.browser.getSelectedFiles();
                if (fileArray.length == 1 && fileArray[0].isFile()) {
                    this.setFileText(fileArray[0].getAbsolutePath());
                    this.setStatusLabel("ready to send");
                    this.sendButton.setEnabled(true);
                } else {
                    if (this.tempFile == null) {
                        this.tempFile = new File(System.getProperty("user.home") + File.separator + "fex.zip");
                        this.tempFile.deleteOnExit();
                    }
                    this.browser.setDialogTitle("Multiple files selected, where shall I save the ZIP archive?");
                    this.browser.setFileSelectionMode(0);
                    this.browser.setMultiSelectionEnabled(false);
                    this.browser.setSelectedFile(this.tempFile);
                    while (this.browser.showDialog(this, "Save & Send") == 0) {
                        this.tempFile = this.browser.getSelectedFile();
                        int n2 = 0;
                        if (this.tempFile.exists()) {
                            n2 = 1;
                            n2 = JOptionPane.showConfirmDialog(null, this.tempFile.toString() + " already exists." + System.getProperty("line.separator") + "Do you want to replace it?", "File Already Exists", 0, 2);
                        }
                        if (n2 != 0) continue;
                        this.setStatusLabel("creating ZIP file, please wait");
                        this.setFileText("...");
                        RepaintManager.currentManager(this).markCompletelyDirty(this.jContentPane);
                        RepaintManager.currentManager(this).markCompletelyDirty(this.mainMenuBar);
                        RepaintManager.currentManager(this).paintDirtyRegions();
                        try {
                            ZipFactory zipFactory = new ZipFactory(this.progressBar);
                            for (int i = 0; i < fileArray.length; ++i) {
                                zipFactory.add(fileArray[i]);
                            }
                            if (zipFactory.updateSum(fileArray) >= 0x100000000L) {
                                this.resetAllGUIElements();
                                this.er.setMess("Sorry ZIP files larger than 4 GB cannot be created. We have to wait for Java 1.7...", null);
                                break;
                            }
                            this.progressBar.setValue(0);
                            this.progressBar.setVisible(true);
                            zipFactory.create(new FileOutputStream(this.tempFile));
                            this.progressBar.setVisible(false);
                            this.progressBar.setValue(0);
                            this.setFileText(this.tempFile.getAbsolutePath());
                            this.setStatusLabel("ZIP created, ready to send");
                            RepaintManager.currentManager(this.dataPanel).paintDirtyRegions();
                            this.sendButton.setEnabled(true);
                            this.sendButton.doClick(2);
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            this.er.setMess("Unable to add a file to the temporary ZIP archive.", null);
                            if (this.tempFile != null && this.tempFile.exists()) {
                                this.tempFile.delete();
                            }
                            break;
                        }
                        catch (IOException iOException) {
                            this.er.setMess("Unable to create temporary ZIP file: " + iOException.getMessage(), null);
                            if (this.tempFile != null && this.tempFile.exists()) {
                                this.tempFile.delete();
                            }
                            break;
                        }
                    }
                }
            }
        } else if (string.equals("send")) {
            if (this.isFieldSet(this.recField)) {
                if (this.isFieldSet(this.fileField)) {
                    if (new File(this.fileField.getText()).length() > 0L) {
                        this.setStatusLabel("sending");
                        this.s = new Sender(this.recField.getText(), this.fileField.getText(), this.commentField.getText(), this.viewCheck.isSelected(), this.host, this.use, this.auth, this.akey, this.skey, this.er, this.debug);
                        if (this.s.send(this.progressBar, this.statusLabel)) {
                            if (this.tempFile != null && this.tempFile.exists()) {
                                this.tempFile.delete();
                            }
                            this.resetAllGUIElements();
                        } else {
                            this.setStatusLabel("error...");
                        }
                    } else {
                        this.er.setMess("Your file is empty.", null);
                    }
                } else {
                    this.er.setMess("Enter or choose file please.", null);
                }
            } else {
                this.er.setMess("Enter recipients E-Mail please.", null);
            }
        } else if (string.equals("info")) {
            this.getInfoFrame();
        } else if (string.equals("change")) {
            File file = new File(this.fileField.getText());
            this.updateFileSize(file.length());
        } else if (string.equals("closeinfo")) {
            this.infoFrame.dispose();
        } else if (string.equals("quota")) {
            this.getQuotaFrame();
        } else if (string.equals("closequota")) {
            this.quotaFrame.dispose();
        } else {
            System.out.println(string);
        }
    }

    private JPanel getDataPanel() {
        if (this.dataPanel == null) {
            this.dataPanel = new JPanel();
            this.dataPanel.setLayout(new BorderLayout());
            this.dataPanel.add((Component)this.getRecPanel(), "North");
            this.dataPanel.add((Component)this.getFilePanel(), "Center");
            this.dataPanel.add((Component)this.getSizePanel(), "South");
        }
        return this.dataPanel;
    }

    private JPanel getFilePanel() {
        if (this.filePanel == null) {
            this.fileLabel = new JLabel();
            this.fileLabel.setText("File");
            this.filePanel = new JPanel(new FlowLayout(2));
            this.filePanel.add((Component)this.getFileButton(), null);
            this.filePanel.add((Component)this.fileLabel, null);
            this.filePanel.add((Component)this.getFileField(), null);
            this.filePanel.add((Component)this.getFileButton(), null);
        }
        return this.filePanel;
    }

    private JPanel getRecPanel() {
        if (this.recPanel == null) {
            this.recPanel = new JPanel(new FlowLayout(2));
            this.recLabel = new JLabel("Recipient");
            this.recPanel.add(this.recLabel);
            this.recPanel.add(this.getRecField());
        }
        return this.recPanel;
    }

    private JPanel getBottomPanel() {
        if (this.bottomPanel == null) {
            this.bottomPanel = new JPanel();
            this.bottomPanel.setLayout(new BorderLayout());
            this.bottomPanel.add((Component)this.getButtonPanel(), "Center");
            this.bottomPanel.add((Component)this.getProgressBar(), "South");
            this.bottomPanel.add((Component)this.getCommentPanel(), "North");
        }
        return this.bottomPanel;
    }

    public JTextField getRecField() {
        if (this.recField == null) {
            this.recField = new JTextField();
            this.recField.setColumns(35);
        }
        return this.recField;
    }

    public JTextField getFileField() {
        if (this.fileField == null) {
            this.fileField = new JTextField();
            this.fileField.setColumns(30);
            this.fileField.setActionCommand("change");
            this.fileField.addActionListener(this);
        }
        return this.fileField;
    }

    private JButton getFileButton() {
        if (this.fileButton == null) {
            this.fileButton = new JButton();
            this.fileButton.setText("Browse...");
            this.fileButton.setActionCommand("browse");
            this.fileButton.addActionListener(this);
            this.fileButton.setMnemonic('B');
        }
        return this.fileButton;
    }

    private JMenuBar getMainMenuBar() {
        if (this.mainMenuBar == null) {
            this.exitImg = this.createImageIcon("/icons/exit.png", "Exit Icon");
            this.reseImg = this.createImageIcon("/icons/rese.png", "Reset Icon");
            this.infoImg = this.createImageIcon("/icons/info.png", "Info Icon");
            this.mainMenuBar = new JMenuBar();
            this.mainMenuBar.add(this.getFileMenu());
            this.mainMenuBar.add(this.getOptionMenu());
            this.mainMenuBar.add(this.getFileMenu());
            this.mainMenuBar.add(this.getOptionMenu());
        }
        return this.mainMenuBar;
    }

    private JMenu getFileMenu() {
        if (this.fileMenu == null) {
            this.fileMenu = new JMenu();
            this.fileMenu.setText("File");
            this.fileMenu.setMnemonic('F');
            this.fileMenu.add(this.getResetItem());
            this.fileMenu.add(this.getExitItem());
        }
        return this.fileMenu;
    }

    private JMenuItem getResetItem() {
        if (this.resetItem == null) {
            this.resetItem = new JMenuItem();
            this.resetItem.setText("Reset");
            this.resetItem.setMnemonic('R');
            this.resetItem.setIcon(this.reseImg);
            this.resetItem.setActionCommand("reset");
            this.resetItem.addActionListener(this);
        }
        return this.resetItem;
    }

    private JMenuItem getExitItem() {
        if (this.exitItem == null) {
            this.exitItem = new JMenuItem();
            this.exitItem.setText("Quit");
            this.exitItem.setMnemonic('Q');
            this.exitItem.setIcon(this.exitImg);
            this.exitItem.setActionCommand("exit");
            this.exitItem.addActionListener(this);
        }
        return this.exitItem;
    }

    private JPanel getCommentPanel() {
        if (this.commentPanel == null) {
            this.commentLabel = new JLabel();
            this.commentLabel.setText("Comment (optional)");
            this.commentPanel = new JPanel(new FlowLayout(2));
            this.commentPanel.add((Component)this.commentLabel, this.commentLabel.getName());
            this.commentPanel.add((Component)this.getCommentField(), null);
        }
        return this.commentPanel;
    }

    private JTextField getCommentField() {
        if (this.commentField == null) {
            this.commentField = new JTextField();
            this.commentField.setColumns(30);
        }
        return this.commentField;
    }

    private JMenu getOptionMenu() {
        if (this.optionMenu == null) {
            this.optionMenu = new JMenu();
            this.optionMenu.setText("Options");
            this.optionMenu.setMnemonic('O');
            this.optionMenu.add("Send File for...");
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.getDownCheck());
            buttonGroup.add(this.getViewCheck());
            this.optionMenu.add(this.getDownCheck());
            this.optionMenu.add(this.getViewCheck());
            this.optionMenu.addSeparator();
            this.optionMenu.add(this.getQuotaItem());
            this.optionMenu.addSeparator();
            this.optionMenu.add(this.getInfoItem());
        }
        return this.optionMenu;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel();
            this.buttonPanel.setLayout(new FlowLayout(1));
            this.buttonPanel.add((Component)this.getSendButton(), null);
        }
        return this.buttonPanel;
    }

    private JButton getSendButton() {
        if (this.sendButton == null) {
            this.sendButton = new JButton();
            this.sendImg = this.createImageIcon("/icons/send.png", "Preference Icon");
            this.sendButton.setText("Send");
            this.sendButton.setIcon(this.sendImg);
            this.sendButton.setMnemonic('S');
            this.sendButton.setActionCommand("send");
            this.sendButton.addActionListener(this);
        }
        return this.sendButton;
    }

    public JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar(0, 200);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
        }
        return this.progressBar;
    }

    public JPanel getStatusPanel() {
        if (this.statusBarPanel == null) {
            this.statusBarPanel = new JPanel(new GridLayout());
            this.statusBarPanel.setBorder(BorderFactory.createEtchedBorder());
            this.statusBarPanel.add(this.getStatusLabel());
            this.statusBarPanel.add(this.getProgressBar());
        }
        return this.statusBarPanel;
    }

    public JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel();
        }
        return this.statusLabel;
    }

    private ImageIcon createImageIcon(String string, String string2) {
        URL uRL = this.getClass().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL, string2);
        }
        this.er.setMess("Couldn't find file: " + string, null);
        return null;
    }

    private JMenuItem getInfoItem() {
        if (this.infoItem == null) {
            this.infoItem = new JMenuItem();
            this.infoItem.setText("Info...");
            this.infoItem.setActionCommand("info");
            this.infoItem.addActionListener(this);
            this.infoItem.setIcon(this.infoImg);
        }
        return this.infoItem;
    }

    private JMenuItem getQuotaItem() {
        if (this.quotaItem == null) {
            this.quotaItem = new JMenuItem();
            this.quotaItem.setText("Check quota");
            this.quotaItem.setActionCommand("quota");
            this.quotaItem.addActionListener(this);
        }
        return this.quotaItem;
    }

    private JFrame getInfoFrame() {
        if (this.infoFrame == null || !this.infoFrame.isVisible()) {
            this.infoFrame = new JFrame();
            this.infoFrame.setContentPane(this.getInfoPanel());
            this.infoFrame.setTitle("Info");
            this.infoFrame.setResizable(false);
            this.infoFrame.setDefaultCloseOperation(2);
            this.infoFrame.setVisible(true);
            int n = 350;
            int n2 = 173;
            int n3 = this.getBounds().x + this.getWidth() / 2 - n / 2;
            int n4 = this.getBounds().y + this.getHeight() / 2 - n2 / 2;
            this.infoFrame.setBounds(n3, n4, n, n2);
            this.infoFrame.setResizable(false);
        }
        return this.infoFrame;
    }

    private JFrame getQuotaFrame() {
        if (this.quotaFrame == null || !this.quotaFrame.isVisible()) {
            this.quotaFrame = new JFrame();
            this.quotaFrame.setContentPane(this.getQuotaPanel());
            this.quotaFrame.setTitle("Quota");
            this.quotaFrame.setResizable(false);
            this.quotaFrame.setDefaultCloseOperation(2);
            this.quotaFrame.setVisible(true);
            int n = 238;
            int n2 = 148;
            int n3 = this.getBounds().x + this.getWidth() / 2 - n / 2;
            int n4 = this.getBounds().y + this.getHeight() / 2 - n2 / 2;
            this.quotaFrame.setBounds(n3, n4, n, n2);
            this.quotaFrame.setResizable(false);
        }
        return this.quotaFrame;
    }

    private JButton getInfoCloseButton() {
        if (this.infoCloseButton == null) {
            this.infoCloseButton = new JButton();
            this.infoCloseButton.setText("Close");
            this.infoCloseButton.setActionCommand("closeinfo");
            this.infoCloseButton.addActionListener(this);
            this.infoCloseButton.setMnemonic('C');
        }
        return this.infoCloseButton;
    }

    private JButton getQuotaCloseButton() {
        if (this.quotaCloseButton == null) {
            this.quotaCloseButton = new JButton();
            this.quotaCloseButton.setText("Close");
            this.quotaCloseButton.setActionCommand("closequota");
            this.quotaCloseButton.addActionListener(this);
            this.quotaCloseButton.setMnemonic('C');
        }
        return this.quotaCloseButton;
    }

    private JPanel getInfoPanel() {
        JTextPane jTextPane = new JTextPane();
        String string = "F*IX (F*EX Interface Xtra) - " + this.versionNumber + "\r\n\r\n" + "Author: \u00a9 2009 Dominik Greibl <dgreibl@gmx.de>" + "\r\n\r\n" + "Maintainer: Sebastian Roth <fix@fex.rus.uni-stuttgart.de>" + "\r\n\r\n" + "Current User: " + this.use;
        jTextPane.setText(string);
        jTextPane.setEditable(false);
        if (this.infoPanel == null) {
            this.infoPanel = new JPanel();
            this.infoPanel.setLayout(new FlowLayout());
            this.infoPanel.add(jTextPane);
            this.infoPanel.add(this.getInfoCloseButton());
        }
        return this.infoPanel;
    }

    private JPanel getQuotaPanel() {
        JTextPane jTextPane = new JTextPane();
        String string = "sender quota (used):                    \r\n49152 (54) MB\r\n\r\nrecipient quota (used):                    \r\n49152 (18) MB";
        jTextPane.setText(string);
        jTextPane.setEditable(false);
        if (this.quotaPanel == null) {
            this.quotaPanel = new JPanel();
            this.quotaPanel.setLayout(new FlowLayout());
            this.quotaPanel.add(jTextPane);
            this.quotaPanel.add(this.getQuotaCloseButton());
        }
        return this.quotaPanel;
    }

    private JPanel getSizePanel() {
        if (this.sizePanel == null) {
            this.sizeLabel = new JLabel();
            this.sizePanel = new JPanel();
            this.sizePanel.setLayout(new FlowLayout());
            this.sizePanel.add((Component)this.sizeLabel, new GridBagConstraints());
        }
        return this.sizePanel;
    }

    public void resetAllGUIElements() {
        this.setFileText("");
        this.setStatusLabel("please select a file");
        this.commentField.setText("");
        if (this.touser.equals("") || this.touser == null) {
            this.recField.setEnabled(true);
            this.recField.requestFocus();
        } else {
            this.recField.setText(this.touser);
            this.recField.setEnabled(false);
            this.fileField.requestFocus();
        }
        this.sendButton.setText("Send");
        this.sendButton.setEnabled(false);
        this.sendButton.setActionCommand("send");
        this.progressBar.setVisible(false);
        this.progressBar.setValue(0);
    }

    public void updateFileSize(double d) {
        this.sizeUnit = " B";
        if (d > 2097152.0) {
            d /= 1048576.0;
            this.sizeUnit = " MB";
        } else if (d > 2048.0) {
            d /= 1024.0;
            this.sizeUnit = " kB";
        }
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(0);
        String string = "Size: " + numberFormat.format(d) + this.sizeUnit;
        FontMetrics fontMetrics = this.getFontMetrics(this.sizeLabel.getFont());
        this.sizeLabel.setText(string);
        this.sizeLabel.setSize(fontMetrics.stringWidth(string), this.sizeLabel.getHeight());
        RepaintManager.currentManager(this.dataPanel).paintDirtyRegions();
    }

    public void setFileText(String string) {
        this.fileField.setText(string);
        this.updateFileSize(new File(string).length());
    }

    public void setStatusLabel(String string) {
        this.statusLabel.setText(string);
    }

    public boolean isFieldSet(JTextField jTextField) {
        return jTextField.getText() != null && jTextField.getText().length() > 0;
    }

    private JRadioButtonMenuItem getDownCheck() {
        if (this.downCheck == null) {
            this.downCheck = new JRadioButtonMenuItem("Download", true);
        }
        return this.downCheck;
    }

    private JRadioButtonMenuItem getViewCheck() {
        if (this.viewCheck == null) {
            this.viewCheck = new JRadioButtonMenuItem("View in Browser");
        }
        return this.viewCheck;
    }
}

