package fix;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

import javax.swing.JProgressBar;
import javax.swing.RepaintManager;

/**
 * Factory class for packing files into a ZIP archive.
 * 
 * $Date: 2009-06-26 18:38:43 +0200 (Fri, 26 Jun 2009) $
 * $Revision: 15 $
 * $Author: roth $
 * 
 * Copyright (C) 2009 Sebastian Roth
 * 
 * All Rights Reserved
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


public class ZipFactory {

	private List<File> files = new ArrayList<File>();

	private ZipOutputStream zipOutput;
	
	private CRC32 crc = null;
	
	private long sum = 0;
	
	private long done = 0;
	
	private JProgressBar progressBar = null;
	
	public ZipFactory(JProgressBar progressBar) {
		crc = new CRC32();
		crc.reset();
		this.progressBar = progressBar;
		
	}

	public void create(OutputStream out) throws IOException {
		zipOutput = new ZipOutputStream(out);
		zipOutput.setLevel(0);
		for (File file : files) {
			String name = file.getName();
			add(file, name);
		}
		zipOutput.close();
	}

	public void add(File file) throws FileNotFoundException {
		if (!file.exists()) {
			throw new FileNotFoundException();
		}
		else {
			files.add(file);
		}
	}
	
	public void remove(File file) {
		files.remove(file);
	}

	private void add(File file, String name) throws IOException {
		if (file.isFile()) {
			ZipEntry entry = new ZipEntry(name);
			entry.setTime(file.lastModified());
			FileInputStream fin = new FileInputStream(file);
			byte[] buffer = new byte[1024];
			int length = 0;
			zipOutput.putNextEntry(entry);
			while ((length = fin.read(buffer)) > 0) {
				zipOutput.write(buffer, 0, length);
				done += length;
				progressBar.setValue((int)((done * progressBar.getMaximum()) / sum));
				RepaintManager.currentManager(progressBar).paintDirtyRegions();
			}

			
			fin.close();
			zipOutput.closeEntry();
		}
		if (file.isDirectory()) {
			File[] files = file.listFiles();
			for (File file2 : files) {
				add(file2, name + "/" + file2.getName());
			}
		}
	}
	
	public long updateSum(File []fileList) {
		for (File file : fileList) {
			if (file.isDirectory()) {
					updateSum(file.listFiles());
			}
			if (file.isFile()) {
				sum = sum + file.length();
			}
		}
		return sum;
	}
}
